/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.quo.service.IQuoFilterService;

public class QuoFilterServiceImp
implements IQuoFilterService {
    private static final Log log = LogFactory.getLog(QuoFilterServiceImp.class);

    public List<QFilter> getNoticeListFilter() {
        ArrayList<QFilter> arrayList = new ArrayList<QFilter>(1);
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
        qFilter.and(new QFilter("cfmstatus", "=", (Object)"A"));
        try {
            List supplierByUserOfBizPartner = BizPartnerUtil.getSupplierByUserOfBizPartner();
            qFilter.and(new QFilter("supscope", "=", (Object)"2").and(new QFilter("entryentity.supplier", "in", (Object)supplierByUserOfBizPartner)).or(new QFilter("supscope", "=", (Object)"1")));
        }
        catch (KDBizException e) {
            qFilter.and(new QFilter("supscope", "=", (Object)"1"));
            log.error("\u672a\u83b7\u53d6\u5230\u5546\u52a1\u4f19\u4f34\u7528\u6237", (Throwable)e);
        }
        arrayList.add(qFilter);
        return arrayList;
    }

    public List<QFilter> getBidbillFilters() {
        ArrayList<QFilter> arrayList = new ArrayList<QFilter>(1);
        Map supplierMap = BizPartnerUtil.getSupplierWithEnableStatusByUserOfBizPartner();
        ArrayList enableSupplier = new ArrayList(supplierMap.size());
        for (Map.Entry entry : supplierMap.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            enableSupplier.add(entry.getKey());
        }
        arrayList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        if (enableSupplier.isEmpty()) {
            arrayList.add(new QFilter("supquoentry.entrysupplier", "in", new HashSet(supplierMap.keySet())));
        } else {
            arrayList.add(new QFilter("biztype", "=", (Object)"1").or(new QFilter("biztype", "!=", (Object)"1").and("supquoentry.entrysupplier", "in", new HashSet(supplierMap.keySet()))));
        }
        return arrayList;
    }
}

