/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.filter.PermissionFilterUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.filter.FilterServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.quo.common.QuoCommonUtil;
import kd.scm.quo.common.QuoInquiryUtil;
import kd.scm.quo.service.IQuoInquiryService;

public class QuoInquiryServiceImp
implements IQuoInquiryService {
    public List<QFilter> getFilters() {
        ArrayList<QFilter> arrayList = new ArrayList<QFilter>(1);
        Map supplierMap = BizPartnerUtil.getSupplierWithEnableStatusByUserOfBizPartner();
        arrayList.add(new QFilter("supscope", "=", (Object)"1").or(new QFilter("supscope", "!=", (Object)"1").and("entryentity.supplier", "in", new HashSet(supplierMap.keySet())).and("entryentity.canshow", "=", (Object)"1")));
        arrayList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        return arrayList;
    }

    public QFilter getInquiryTodoFilter() {
        List<QFilter> filters = this.getFilters();
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        for (QFilter filter : filters) {
            if (filter.getProperty().equals("billstatus")) continue;
            qFilter.and(filter);
        }
        HasPermOrgResult permOrgsResult = PermissionServiceHelper.getAllPermOrgs((Long)Long.valueOf(RequestContext.get().getUserId()), null, (String)"quo_inquiry", (String)"47150e89000000ac");
        List orgIdList = permOrgsResult.getHasPermOrgs();
        qFilter = qFilter.and(new QFilter("bizstatus", "=", (Object)"A").or("bizstatus", "=", (Object)"B").or("bizstatus", "=", (Object)"C"));
        if (!permOrgsResult.hasAllOrgPerm()) {
            qFilter = qFilter.and(new QFilter("org.id", "in", (Object)orgIdList));
        }
        List permissionFilters = PermissionFilterUtil.getListPermissionFilters((MainEntityType)EntityMetadataCache.getDataEntityType((String)"quo_inquiry"), (boolean)true, (String)"SE7/UZFDVIE", null, (IUserService)new UserService());
        for (QFilter permissionFilter : permissionFilters) {
            qFilter.and(permissionFilter);
        }
        return qFilter;
    }

    public Map<String, Set> getInquiryTodoInfos() {
        QFilter qFilter = this.getInquiryTodoFilter();
        List schemeList = FilterServiceHelper.getSchemeList((String)"quo_inquiry");
        FilterScheme defaultScheme = null;
        if (schemeList != null && schemeList.size() > 0) {
            for (int i = schemeList.size() - 1; i >= 0; --i) {
                if (!((FilterScheme)schemeList.get(i)).isDefault()) continue;
                defaultScheme = (FilterScheme)schemeList.get(i);
                break;
            }
        }
        if (defaultScheme != null) {
            qFilter = FilterServiceHelper.getQFilterByFilterScheme(defaultScheme, (String)"quo_inquiry", (QFilter)qFilter);
        }
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"quo_inquiry", (String)"id,bizstatus,supplierstatus,enddate,billno,turns,supplierprostatus", (QFilter[])new QFilter[]{qFilter});
        QuoCommonUtil.setInquiryStatus((DynamicObjectCollection)rows);
        HashSet ids1 = new HashSet();
        HashSet ids2 = new HashSet();
        HashSet ids3 = new HashSet();
        QuoCommonUtil.getInqMyStatusIds((DynamicObjectCollection)rows, ids1, ids2, ids3);
        HashMap<String, Set> resultMap = new HashMap<String, Set>(3);
        resultMap.put("ids1", ids1);
        resultMap.put("ids2", ids2);
        resultMap.put("ids3", ids3);
        return resultMap;
    }

    public boolean confirmUnquote(Object pkValue) {
        if (pkValue instanceof Long) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", pkValue)};
            String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_inquiry", (boolean)false);
            selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_inquiry", (String)"entryentity", (boolean)false);
            DynamicObject[] inquiryBillcols = BusinessDataServiceHelper.load((String)"sou_inquiry", (String)(selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_inquiry", (String)"materialentry", (boolean)false)), (QFilter[])filters);
            if (inquiryBillcols == null) {
                return false;
            }
            QuoInquiryUtil.confirmUnquote((DynamicObject)inquiryBillcols[0]);
            return true;
        }
        return false;
    }

    public Map<String, Object> verifyUnQuote(Object pkValue) {
        Map<String, Object> checkMap = new HashMap<String, Object>(1);
        if (pkValue instanceof Long) {
            DynamicObject inquiryBill = BusinessDataServiceHelper.loadSingle((String)"quo_inquiry", (String)"id,billno,bizstatus,turns,enddate,entryentity.supentrystatus,entryentity.supplier,entryentity.canshow,entryentity.supentrystatus,entryentity.quoter,entryentity.deadline,entryentity.entryturns", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
            if (inquiryBill == null) {
                return checkMap;
            }
            checkMap = QuoInquiryUtil.verifyUnquote((DynamicObject)inquiryBill);
        }
        return checkMap;
    }

    public Map<String, Object> verifyQuote(Object pkValue, List<Long> supplierIds) {
        Map<String, Object> checkMap = new HashMap<String, Object>(1);
        if (pkValue instanceof Long) {
            DynamicObject inquiryBill = BusinessDataServiceHelper.loadSingle((String)"quo_inquiry", (String)"id,billno,bizstatus,turns,enddate,entryentity.supentrystatus,entryentity.supplier,entryentity.canshow,entryentity.supentrystatus,entryentity.quoter,entryentity.deadline,entryentity.entryturns", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
            if (inquiryBill == null) {
                return checkMap;
            }
            checkMap = QuoInquiryUtil.verifyQuote((DynamicObject)inquiryBill, supplierIds);
        }
        return checkMap;
    }
}

