/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.cal.Cal4MultCurrencyObj;
import kd.scm.quo.common.QuoCommonUtil;
import kd.scm.quo.service.IQuoteAutoFillService;

public class QuoteAutoFillServiceImp
implements IQuoteAutoFillService {
    private static final String QUO_TURNS = "quoturns";

    public List<DynamicObject> autoFillLastPrice(List<DynamicObject> infos, List<String> autoFillNos) {
        if (autoFillNos == null) {
            return Collections.emptyList();
        }
        HashMap<String, String> autoBillNoMap = new HashMap<String, String>(autoFillNos.size());
        for (String autoFillNo : autoFillNos) {
            autoBillNoMap.put(autoFillNo, "1");
        }
        return this.autoFillLastPriceMap(infos, autoBillNoMap);
    }

    @Deprecated
    public List<DynamicObject> autoFillLastPriceMap(List<DynamicObject> infos, Map<String, String> autoBillNoMap) {
        return this.autoFillLastPriceMap(infos, autoBillNoMap, null);
    }

    public List<DynamicObject> autoFillLastPriceMap(List<DynamicObject> infos, Map<String, String> autoBillNoMap, Long supplierId) {
        if (infos == null || autoBillNoMap == null) {
            return infos;
        }
        if (autoBillNoMap.size() > 0) {
            String[] objects = autoBillNoMap.keySet().toArray(new String[0]);
            Map<String, Map<String, Object>> wrapInfoMap = this.getPriceInfoMap(Arrays.asList(objects), supplierId);
            this.dealPriceInfo(infos, wrapInfoMap, autoBillNoMap, supplierId);
        }
        return infos;
    }

    public Map<String, Map<String, Object>> getPriceInfoMap(List<String> inquiryNos) {
        return this.getPriceInfoMap(inquiryNos, null);
    }

    public Map<String, Map<String, Object>> getPriceInfoMap(List<String> inquiryNos, Long supplierId) {
        QFilter[] qFilters = null;
        qFilters = supplierId == null ? new QFilter[]{new QFilter("inquiryno", "in", inquiryNos), new QFilter("billstatus", "=", (Object)"C"), new QFilter("materialentry.entrystatus", "=", (Object)"A"), new QFilter("bizpartner", "in", (Object)BizPartnerUtil.getBizPartnerIds())} : new QFilter[]{new QFilter("inquiryno", "in", inquiryNos), new QFilter("billstatus", "=", (Object)"C"), new QFilter("materialentry.entrystatus", "=", (Object)"A"), new QFilter("supplier", "=", (Object)supplierId)};
        DynamicObject[] quoteBillsDyns = BusinessDataServiceHelper.load((String)"quo_quote", (String)"id,curr,exchtype,materialentry.srcentryid,materialentry.taxrateid,materialentry.taxrate,materialentry.price,materialentry.taxprice,materialentry.quotecurr,materialentry.exrate,materialentry.entryquotation,materialentry.quoturns", (QFilter[])qFilters, (String)"inquiryno,billdate desc");
        if (quoteBillsDyns == null) {
            return new HashMap<String, Map<String, Object>>();
        }
        return this.fillWrapInfoMap(quoteBillsDyns);
    }

    private Map<String, Map<String, Object>> fillWrapInfoMap(DynamicObject[] quoteBillsDyns) {
        HashMap<String, Map<String, Object>> wrapInfoMap = new HashMap<String, Map<String, Object>>();
        HashMap<String, BigDecimal> exrateMap = new HashMap<String, BigDecimal>();
        for (DynamicObject dynamicObject : quoteBillsDyns) {
            DynamicObjectCollection materialentry = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : materialentry) {
                DynamicObject quotecurr = entry.getDynamicObject("quotecurr");
                if (quotecurr == null || !quotecurr.getBoolean("enable")) {
                    return wrapInfoMap;
                }
                BigDecimal exrate = this.dealExrateInfo(entry, dynamicObject, exrateMap);
                if (exrate == null) {
                    return wrapInfoMap;
                }
                if (!this.validateTaxrate(entry)) continue;
                wrapInfoMap.put(entry.getString("srcentryid"), this.wrapInfoMap(entry));
            }
        }
        return wrapInfoMap;
    }

    protected Map<String, Object> wrapInfoMap(DynamicObject entry) {
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        infoMap.put("taxrateid", entry.getDynamicObject("taxrateid"));
        infoMap.put("taxrate", entry.getBigDecimal("taxrate"));
        infoMap.put("price", entry.getBigDecimal("price"));
        infoMap.put("taxprice", entry.getBigDecimal("taxprice"));
        infoMap.put("quotecurr", entry.getDynamicObject("quotecurr"));
        infoMap.put("exrate", entry.getBigDecimal("exrate"));
        String quotation = entry.getString("entryquotation");
        infoMap.put("entryquotation", StringUtils.isBlank((CharSequence)quotation) ? "0" : quotation);
        infoMap.put(QUO_TURNS, entry.getString(QUO_TURNS));
        return infoMap;
    }

    @Deprecated
    protected void dealPriceInfo(List<DynamicObject> infos, Map<String, Map<String, Object>> wrapInfoMap) {
        this.dealPriceInfo(infos, wrapInfoMap, new HashMap<String, String>(), null);
    }

    protected void dealPriceInfo(List<DynamicObject> infos, Map<String, Map<String, Object>> wrapInfoMap, Map<String, String> autoBillNoMap, Long supplierId) {
        if (wrapInfoMap == null || wrapInfoMap.size() <= 0) {
            DynamicObject supplierDO = this.getSupplier(supplierId);
            for (DynamicObject info : infos) {
                DynamicObjectCollection materialentry = info.getDynamicObjectCollection("materialentry");
                info.set("sumamount", (Object)BigDecimal.ZERO);
                info.set("sumtaxamount", (Object)BigDecimal.ZERO);
                info.set("sumtax", (Object)BigDecimal.ZERO);
                for (DynamicObject row : materialentry) {
                    row.set(QUO_TURNS, info.get("turnscount"));
                    this.setDefaultRowValue(row);
                    if (supplierDO == null) continue;
                    row.set("taxrateid_id", supplierDO.get("taxrate.id"));
                    row.set("taxrate", supplierDO.get("taxrate.taxrate"));
                }
            }
        } else {
            this.fillPriceInfo(infos, wrapInfoMap, autoBillNoMap, supplierId);
        }
    }

    protected void setDefaultRowValue(DynamicObject row) {
        if (row != null) {
            row.set("taxamount", (Object)BigDecimal.ZERO);
            row.set("amount", (Object)BigDecimal.ZERO);
            row.set("tax", (Object)BigDecimal.ZERO);
            row.set("taxrate", (Object)BigDecimal.ZERO);
            row.set("taxrateid", null);
            row.set("price", (Object)BigDecimal.ZERO);
            row.set("taxprice", (Object)BigDecimal.ZERO);
            row.set("tax", (Object)BigDecimal.ZERO);
            row.set("taxamount", (Object)BigDecimal.ZERO);
            row.set("amount", (Object)BigDecimal.ZERO);
            row.set("entryquotation", (Object)"0");
        }
    }

    private DynamicObject getSupplier(Long supplierId) {
        QFilter idfilter = null;
        if (supplierId != null) {
            idfilter = new QFilter("id", "=", (Object)supplierId);
        } else {
            List supList = BizPartnerUtil.getSupplierByUserOfBizPartner();
            if (!supList.isEmpty()) {
                idfilter = new QFilter("id", "=", supList.get(0));
            }
        }
        if (idfilter != null) {
            DynamicObject supplierDO = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id,group.id,taxrate.id,taxrate.taxrate,paymentcurrency", (QFilter[])new QFilter[]{idfilter});
            return supplierDO;
        }
        return null;
    }

    private void fillPriceInfo(List<DynamicObject> infos, Map<String, Map<String, Object>> wrapInfoMap, Map<String, String> autoBillNoMap, Long supplierId) {
        Cal4MultCurrencyObj obj = new Cal4MultCurrencyObj();
        DynamicObject supplierDO = this.getSupplier(supplierId);
        for (DynamicObject info : infos) {
            DynamicObjectCollection materialentry = info.getDynamicObjectCollection("materialentry");
            String turns = info.getString("turns");
            for (DynamicObject row : materialentry) {
                String newestturns = row.getString("newestturns");
                String value = autoBillNoMap.get(info.getString("inquiryno"));
                if (StringUtils.isNotBlank((CharSequence)newestturns) && StringUtils.equals((CharSequence)turns, (CharSequence)newestturns) && !"1".equals(value)) {
                    row.set(QUO_TURNS, info.get("turnscount"));
                    if (supplierDO == null) continue;
                    row.set("taxrateid_id", supplierDO.get("taxrate.id"));
                    row.set("taxrate", supplierDO.get("taxrate.taxrate"));
                    continue;
                }
                String srcentryid = row.getString("srcentryid");
                Map<String, Object> valueMap = wrapInfoMap.get(srcentryid);
                if (valueMap == null) continue;
                this.dealQuoRowInfo(row, info, valueMap);
                BigDecimal price = (BigDecimal)valueMap.get("price");
                if (price != null && price.compareTo(BigDecimal.ZERO) != 0 || supplierDO == null) continue;
                row.set("taxrateid_id", supplierDO.get("taxrate.id"));
                row.set("taxrate", supplierDO.get("taxrate.taxrate"));
            }
            obj.reCalBill(info, "materialentry");
            Cal4MultCurrencyObj.calCost((DynamicObject)info, (String)"materialentry");
        }
    }

    protected void dealQuoRowInfo(DynamicObject row, DynamicObject info, Map<String, Object> valueMap) {
        if (row != null && info != null && valueMap != null) {
            String newestturns = row.getString("newestturns");
            String turns = info.getString("turns");
            row.set("taxrateid", valueMap.get("taxrateid"));
            row.set("taxrate", valueMap.get("taxrate"));
            row.set("price", valueMap.get("price"));
            row.set("taxprice", valueMap.get("taxprice"));
            Object value = valueMap.get("quotecurr");
            if (value != null) {
                row.set("quotecurr", valueMap.get("quotecurr"));
            }
            valueMap.get("exrate");
            row.set("exrate", valueMap.get("exrate"));
            row.set("entryquotation", valueMap.get("entryquotation"));
            if (StringUtils.isNotBlank((CharSequence)newestturns) && StringUtils.equals((CharSequence)turns, (CharSequence)newestturns)) {
                row.set(QUO_TURNS, info.get("turnscount"));
            } else {
                row.set(QUO_TURNS, valueMap.get(QUO_TURNS));
            }
        }
    }

    protected boolean validateTaxrate(DynamicObject entry) {
        long aLong;
        DynamicObject taxrateid = entry.getDynamicObject("taxrateid");
        return taxrateid == null || (aLong = taxrateid.getLong("id")) == 0L || taxrateid.getBoolean("enable");
    }

    public BigDecimal dealExrateInfo(DynamicObject entry, DynamicObject info, Map<String, BigDecimal> exrateMap) {
        StringBuilder str = new StringBuilder();
        BigDecimal exrate = null;
        if (entry != null && exrateMap != null) {
            long quoCurrId = entry.getLong("quotecurr_id");
            long currId = info.getLong("curr_id");
            long exchtype = info.getLong("exchtype_id");
            if (0L != currId && 0L != quoCurrId) {
                if (currId == quoCurrId) {
                    return BigDecimal.ONE;
                }
                String rowKey = str.append(quoCurrId).append("--").append(exchtype).append("--").append(currId).toString();
                exrate = exrateMap.computeIfAbsent(rowKey, key -> {
                    BigDecimal rate = BaseDataServiceHelper.getExchangeRate((Long)exchtype, (Long)quoCurrId, (Long)currId, (Date)TimeServiceHelper.now());
                    if (null == rate || rate.compareTo(BigDecimal.ZERO) == 0) {
                        rate = null;
                    }
                    return rate;
                });
            }
        }
        return exrate;
    }

    public Map<String, String> getAutoFillNoMap(List<DynamicObject> bills) {
        HashMap<String, String> autoBillNoMap = new HashMap<String, String>();
        for (DynamicObject bill : bills) {
            QuoCommonUtil.getAutoFillNoMap(autoBillNoMap, (DynamicObject)bill);
        }
        return autoBillNoMap;
    }
}

