/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.enums.SouOpenTypeEnum;
import kd.scm.common.enums.SupInquiryStatusEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.InquirySupParticipateUtils;
import kd.scm.common.util.InquiryUtil;
import kd.scm.quo.service.IQuoteOperateService;

public class QuoteOperateServiceImp
implements IQuoteOperateService {
    public void afterQuoteUnAuditOp(List<DynamicObject> quoteBillObs) throws Exception {
        ArrayList<String> inquiryBillNoList = new ArrayList<String>();
        for (DynamicObject quoteBill : quoteBillObs) {
            String inquiryBillNo = quoteBill.getString("inquiryno");
            if (inquiryBillNoList.contains(inquiryBillNo)) continue;
            inquiryBillNoList.add(inquiryBillNo);
        }
        Object[] quoInquiryObjs = InquiryUtil.getInquiryBillByBillNo(inquiryBillNoList);
        for (DynamicObject quoteBill : quoteBillObs) {
            String inquiryBillNo = quoteBill.getString("inquiryno");
            for (Object quoInquiry : quoInquiryObjs) {
                String inquiryNo = quoInquiry.getString("billno");
                if (!inquiryBillNo.equals(inquiryNo)) continue;
                this.setQuoSupEntry(quoteBill, (DynamicObject)quoInquiry);
            }
        }
        InquiryUtil.updateInquiryQuoResult((DynamicObject[])quoInquiryObjs, inquiryBillNoList);
        if (quoInquiryObjs.length > 0) {
            SaveServiceHelper.save((IDataEntityType)quoInquiryObjs[0].getDynamicObjectType(), (Object[])quoInquiryObjs);
        }
    }

    public void afterQuoteAuditOp(List<DynamicObject> quoteBillObs) {
        ArrayList<String> inquiryBillNoList = new ArrayList<String>();
        for (DynamicObject quoteBill : quoteBillObs) {
            String inquiryBillNo = quoteBill.getString("inquiryno");
            if (inquiryBillNoList.contains(inquiryBillNo)) continue;
            inquiryBillNoList.add(inquiryBillNo);
        }
        Object[] quoInquiryObjs = InquiryUtil.getInquiryBillByBillNo(inquiryBillNoList);
        HashMap<String, String> inquiryMap = new HashMap<String, String>();
        for (DynamicObject quoteBill : quoteBillObs) {
            String inquiryBillNo = quoteBill.getString("inquiryno");
            for (Object quoInquiry : quoInquiryObjs) {
                String inquiryNo = quoInquiry.getString("billno");
                if (!inquiryBillNo.equals(inquiryNo)) continue;
                this.setQuoAuditSupEntry(quoteBill, (DynamicObject)quoInquiry);
                DynamicObjectUtil.setBillEntrySeq((DynamicObject)quoInquiry, (String)"entryentity");
            }
            if (inquiryMap.containsKey(inquiryBillNo)) continue;
            this.updatequote(inquiryBillNo, quoteBill);
            inquiryMap.put(inquiryBillNo, "");
        }
        InquiryUtil.updateInquiryQuoResult((DynamicObject[])quoInquiryObjs, inquiryBillNoList);
        if (quoInquiryObjs.length > 0) {
            SaveServiceHelper.save((IDataEntityType)quoInquiryObjs[0].getDynamicObjectType(), (Object[])quoInquiryObjs);
        }
    }

    private void setQuoSupEntry(DynamicObject quoteBill, DynamicObject quoInquiry) {
        DynamicObjectCollection quoSupEntrys = quoInquiry.getDynamicObjectCollection("entryentity");
        DynamicObject supplier = quoteBill.getDynamicObject("supplier");
        String supplierUniqueKey = supplier.getPkValue().toString();
        int removeIndex = -1;
        for (int i = quoSupEntrys.size() - 1; i >= 0; --i) {
            String quoSupKey;
            DynamicObject quoSupEntry = (DynamicObject)quoSupEntrys.get(i);
            if (!InquirySupParticipateUtils.isShowSelect((DynamicObject)quoSupEntry) || !supplierUniqueKey.equals(quoSupKey = quoSupEntry.getDynamicObject("supplier").getPkValue().toString())) continue;
            quoSupEntry.set("supentrystatus", (Object)SupInquiryStatusEnum.UNKNOW.getVal());
            quoSupEntry.set("quoter", (Object)0L);
            quoSupEntry.set("quotedate", null);
            if (quoSupEntry.getBoolean("canshow")) {
                quoSupEntry.set("supplierbizstatus", (Object)SupInquiryStatusEnum.UNKNOW.getVal());
            }
            removeIndex = i;
        }
        String supScope = quoInquiry.getString("supscope");
        if (removeIndex > -1 && "1".equals(supScope) && "1".equals(quoInquiry.get("turns"))) {
            quoSupEntrys.remove(removeIndex);
        }
    }

    private void updatequote(String inquiryBillNo, DynamicObject quoteBill) {
        Object[] hisquoteBills;
        String billno = quoteBill.getString("billno");
        DynamicObjectCollection quoteentryCols = quoteBill.getDynamicObjectCollection("materialentry");
        ArrayList<Long> materialList = new ArrayList<Long>();
        for (DynamicObject materialentry : quoteentryCols) {
            if (materialentry.getBigDecimal("taxamount") == null || BigDecimal.ZERO.compareTo(materialentry.getBigDecimal("taxamount")) > 0) continue;
            materialList.add(Long.valueOf(materialentry.getDynamicObject("material").getPkValue().toString()));
        }
        HashMap params = new HashMap(3);
        HashMap<String, String> inquiryBillNoMap = new HashMap<String, String>(1);
        inquiryBillNoMap.put("=", inquiryBillNo);
        params.put("inquiryno", inquiryBillNoMap);
        HashMap<String, String> billNoMap = new HashMap<String, String>(1);
        billNoMap.put("!=", billno);
        params.put("billno", billNoMap);
        HashMap<String, ArrayList<Long>> materialMap = new HashMap<String, ArrayList<Long>>(1);
        materialMap.put("in", materialList);
        params.put("materialentry.material", materialMap);
        HashMap<String, String> entryStatusMap = new HashMap<String, String>(1);
        entryStatusMap.put("=", "A");
        params.put("materialentry.entrystatus", entryStatusMap);
        HashMap<String, Object> supplierMap = new HashMap<String, Object>(1);
        supplierMap.put("=", quoteBill.getDynamicObject("supplier").getPkValue());
        params.put("supplier", supplierMap);
        String selectFields = "inquiryno,materialentry.entrystatus";
        for (DynamicObject dynamicObject : hisquoteBills = ORMUtil.load((String)"quo_quote", (String)selectFields, params)) {
            DynamicObjectCollection materialentrys = dynamicObject.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : materialentrys) {
                entry.set("entrystatus", (Object)"B");
            }
        }
        if (hisquoteBills.length > 0) {
            SaveServiceHelper.save((IDataEntityType)hisquoteBills[0].getDynamicObjectType(), (Object[])hisquoteBills);
        }
    }

    private void setQuoAuditSupEntry(DynamicObject quoteBill, DynamicObject quoInquiry) {
        DynamicObjectCollection quoSupEntrys = quoInquiry.getDynamicObjectCollection("entryentity");
        boolean isMatched = false;
        DynamicObject supplier = quoteBill.getDynamicObject("supplier");
        String supplierUniqueKey = supplier.getPkValue().toString();
        String openType = quoInquiry.getString("opentype");
        for (DynamicObject quoSupEntry : quoSupEntrys) {
            Object quoSupplier = quoSupEntry.get("supplier");
            String quoSupKey = null;
            quoSupKey = quoSupplier instanceof Long ? String.valueOf(quoSupplier) : ((DynamicObject)quoSupplier).getPkValue().toString();
            if (!supplierUniqueKey.equals(quoSupKey) || !InquirySupParticipateUtils.isShowSelect((DynamicObject)quoSupEntry)) continue;
            if (openType.equals(SouOpenTypeEnum.VISIBLE_AUTOOPEN.getVal())) {
                quoSupEntry.set("supentrystatus", (Object)SupInquiryStatusEnum.OPENEDTHEBID.getVal());
            } else {
                quoSupEntry.set("supentrystatus", (Object)SupInquiryStatusEnum.QUOTEDPRICE.getVal());
            }
            InquirySupParticipateUtils.setSupProjectStatus((DynamicObject)quoSupEntry, (BizStatusEnum)BizStatusEnum.OPENEDTHEBID);
            String entrycount = quoSupEntry.getString("entrycount");
            if (StringUtils.isBlank((CharSequence)entrycount)) {
                quoSupEntry.set("entrycount", (Object)"1");
            }
            quoSupEntry.set("quoter", (Object)RequestContext.get().getUserId());
            quoSupEntry.set("quotedate", (Object)TimeServiceHelper.now());
            isMatched = true;
        }
        if (!isMatched) {
            DynamicObject newQuoSupEntry = ORMUtil.newDynamicObject((DynamicObjectType)quoSupEntrys.getDynamicObjectType());
            if (openType.equals(SouOpenTypeEnum.VISIBLE_AUTOOPEN.getVal())) {
                newQuoSupEntry.set("supentrystatus", (Object)SupInquiryStatusEnum.OPENEDTHEBID.getVal());
            } else {
                newQuoSupEntry.set("supentrystatus", (Object)SupInquiryStatusEnum.QUOTEDPRICE.getVal());
            }
            InquirySupParticipateUtils.setSupEntryShowSelect((DynamicObject)newQuoSupEntry, (Boolean)Boolean.TRUE);
            InquirySupParticipateUtils.setSupProjectStatus((DynamicObject)newQuoSupEntry, (BizStatusEnum)BizStatusEnum.OPENEDTHEBID);
            InquirySupParticipateUtils.setSupEntryDeadLine((DynamicObject)newQuoSupEntry, (Date)quoInquiry.getDate("enddate"));
            newQuoSupEntry.set("entryturns", quoInquiry.get("turns"));
            newQuoSupEntry.set("entrycount", (Object)"1");
            newQuoSupEntry.set("supplier", supplier.getPkValue());
            newQuoSupEntry.set("quoter", (Object)RequestContext.get().getUserId());
            newQuoSupEntry.set("quotedate", (Object)TimeServiceHelper.now());
            quoSupEntrys.add((Object)newQuoSupEntry);
        }
    }
}

