/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.constant.CalConstant;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.plugin.AbstractBidHall;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SouBidHallUtil;
import kd.scm.quo.formplugin.QuoBidHallByEntryPlugin;

public abstract class AbstractQuoBidHall
extends AbstractBidHall
implements CellClickListener {
    protected static final String ENTRYENTITY = "entryentity";
    protected static final String SUPQUOENTRY = "supquoentry";
    protected static final String QUOENTRY = "quoentry";
    protected static final String ADD = "add";
    protected static final String REDUCE = "reduce";
    protected static final String COMMIT = "commit";
    protected static final String REFRESH = "refresh";

    public void registerListener(EventObject e) {
        EntryGrid currquoentity = (EntryGrid)this.getView().getControl("currquoentity");
        currquoentity.addCellClickListener((CellClickListener)this);
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String key = cellClickEvent.getFieldKey();
        if (ADD.equals(key) || REDUCE.equals(key)) {
            Object bidstatusval = this.getModel().getValue("bidstatusval");
            if (BidStatusEnum.BIDDING.getVal().equals(bidstatusval)) {
                int index = cellClickEvent.getRow();
                if (index < 0) {
                    return;
                }
                this.setQuotePriceInfo(key, index);
            }
        }
    }

    protected void bindData(DynamicObject quoBidBill) {
        if (Objects.isNull(quoBidBill)) {
            return;
        }
        this.setTitle(quoBidBill);
        this.setRestOfTime(quoBidBill);
        this.setCurrencyAndExchange(quoBidBill);
        this.setBidRuleInfo(quoBidBill);
        Map<String, Object> resultMap = this.setSupQuoInfo(quoBidBill);
        this.setCurrQuoInfo(quoBidBill, resultMap);
    }

    protected abstract Map<String, Object> setSupQuoInfo(DynamicObject var1);

    protected abstract void setCurrQuoInfo(DynamicObject var1, Map<String, Object> var2);

    protected void setBidRuleInfo(DynamicObject quoBidBill) {
        super.setBidRuleInfo(quoBidBill);
        IFormView view = this.getView();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        int lastTime = quoBidBill.getInt("lasttime");
        int delayTime = quoBidBill.getInt("delaytime");
        this.setDelayRuleInfo(lastTime, delayTime);
        Date openDate = dataEntity.getDate("opendate");
        if (openDate != null) {
            return;
        }
        openDate = quoBidBill.getDate("opendate");
        this.getModel().setValue("opendate", (Object)openDate);
        int bidTime = quoBidBill.getInt("bidtime");
        Label bidtimeLable = (Label)view.getControl("bidtime");
        bidtimeLable.setText(MessageFormat.format(ResManager.loadKDString((String)"{0}\u5206\u949f", (String)"QuoBidHallPlugin_2", (String)"scm-quo-formplugin", (Object[])new Object[0]), bidTime));
        String sumTaxamount = String.valueOf(quoBidBill.get("sumtaxamount"));
        this.getModel().setValue("sumtaxamount", (Object)sumTaxamount);
        Label reducetypeLable = (Label)view.getControl("reducetype");
        String reduceType = quoBidBill.getString("reducetype");
        DynamicObject curr = quoBidBill.getDynamicObject("curr");
        String sign = "";
        if (curr != null) {
            sign = curr.getString("sign");
            this.getModel().setValue("curr", curr.getPkValue());
        }
        if ("A".equals(reduceType)) {
            reducetypeLable.setText(ResManager.loadKDString((String)"\u6309\u6bd4\u4f8b(%)", (String)"QuoBidHallPlugin_4", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        } else if ("B".equals(reduceType)) {
            reducetypeLable.setText(MessageFormat.format(ResManager.loadKDString((String)"\u6309\u91d1\u989d({0})", (String)"QuoBidHallPlugin_5", (String)"scm-quo-formplugin", (Object[])new Object[0]), sign));
        }
        String reducePct = String.valueOf(quoBidBill.get("reducepct"));
        this.getModel().setValue("reducepct", (Object)reducePct);
        Label bidcountLable = (Label)view.getControl("bidcount");
        int bidCount = quoBidBill.getInt("bidcount");
        if (bidCount > 0) {
            bidcountLable.setText(MessageFormat.format(ResManager.loadKDString((String)"{0}\u6b21", (String)"QuoBidHallPlugin_6", (String)"scm-quo-formplugin", (Object[])new Object[0]), bidCount));
        } else {
            bidcountLable.setText(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"QuoBidHallPlugin_7", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
        String minamount = String.valueOf(quoBidBill.get("minamount"));
        this.getModel().setValue("minamount", quoBidBill.get("minamount"));
        Label open2Lable = (Label)view.getControl("open2");
        boolean isOpen = quoBidBill.getBoolean("open2");
        if (isOpen) {
            open2Lable.setText(ResManager.loadKDString((String)"\u516c\u5f00\u6392\u540d", (String)"QuoBidHallPlugin_9", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        } else {
            open2Lable.setText(ResManager.loadKDString((String)"\u4e0d\u516c\u5f00\u6392\u540d", (String)"QuoBidHallPlugin_10", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
        Label quoteMode = (Label)view.getControl("quotemode");
        if ("1".equals(quoBidBill.getString("quotemode"))) {
            quoteMode.setText(ResManager.loadKDString((String)"\u6309\u603b\u989d", (String)"AbstractQuoBidHall_2", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        } else {
            quoteMode.setText(ResManager.loadKDString((String)"\u6309\u884c\u9879\u76ee", (String)"AbstractQuoBidHall_3", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
        Label addRemark = (Label)view.getControl("addremark");
        addRemark.setText(quoBidBill.getString("addremark"));
        Label taxTypeLbl = (Label)view.getControl("taxtype");
        String taxType = quoBidBill.getString("taxtype");
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType)) {
            taxTypeLbl.setText(TaxTypeEnum.TAXSEXPRICE_INTAX.getName());
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            taxTypeLbl.setText(TaxTypeEnum.TAXSEXPRICE_EXTAX.getName());
        } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            taxTypeLbl.setText(TaxTypeEnum.TAXSINPRICE_INTAX.getName());
        }
        IPageCache cache = this.getPageCache();
        cache.put("reduceType", reduceType);
        cache.put("reducePct", reducePct);
        cache.put("bidCount", String.valueOf(bidCount));
        cache.put("sumTaxamount", sumTaxamount);
        cache.put("minAmount", minamount);
    }

    protected void setDelayRuleInfo(int lasttime, int delaytime) {
        IFormView view = this.getView();
        if (lasttime > 0) {
            Label lasttimeLabel = (Label)view.getControl("lasttime");
            lasttimeLabel.setText(MessageFormat.format(ResManager.loadKDString((String)"\u5012\u8ba1\u65f6{0}\u5206\u949f\u5185\u6709\u62a5\u4ef7\uff0c\u5ef6\u65f6{1}\u5206\u949f", (String)"AbstractQuoBidHall_1", (String)"scm-quo-formplugin", (Object[])new Object[0]), lasttime, delaytime));
            view.setVisible(Boolean.TRUE, new String[]{"delayflexpanelap1"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"delayflexpanelap1"});
        }
    }

    private void setTitle(DynamicObject quoBidBill) {
        IFormView view = this.getView();
        DynamicObject org = quoBidBill.getDynamicObject("org");
        String name = quoBidBill.getString("name");
        Label titleLable = (Label)view.getControl("title");
        StringBuilder titleSb = new StringBuilder();
        titleSb.append(MessageFormat.format(ResManager.loadKDString((String)"{0}(\u53d1\u8d77\u65b9\uff1a{1}--\u4f9b\u5e94\u5546\uff1a", (String)"QuoBidHallPlugin_0", (String)"scm-quo-formplugin", (Object[])new Object[0]), name, org.getString("name")));
        DynamicObject supplier = this.getSupplierByCurrentUser(quoBidBill);
        if (supplier != null) {
            titleSb.append(supplier.getString("name"));
        }
        titleSb.append(')');
        titleLable.setText(titleSb.toString());
    }

    protected DynamicObject getSupplierByCurrentUser(DynamicObject quoBidBill) {
        List suppliers = BizPartnerUtil.getSupplierByUserOfBizPartner();
        DynamicObjectCollection cols = quoBidBill.getDynamicObjectCollection(SUPQUOENTRY);
        for (DynamicObject col : cols) {
            DynamicObject supEnroll = col.getDynamicObject("supenroll");
            DynamicObject entrysupplier = col.getDynamicObject("entrysupplier");
            if (supEnroll == null || suppliers == null || entrysupplier == null || !suppliers.contains(Long.parseLong(entrysupplier.getPkValue().toString()))) continue;
            return entrysupplier;
        }
        return null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String operateKey = ((AbstractOperate)event.getSource()).getOperateKey();
        if (event.getOperationResult() != null && event.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "commit": {
                    this.commit();
                    break;
                }
                case "refresh": {
                    this.refresh(null, true);
                    break;
                }
            }
        }
    }

    protected abstract void commit();

    protected void delay(DynamicObject quoBidBill) {
        long lastTime = quoBidBill.getLong("lasttime") * 60L * 1000L;
        long delayTime = quoBidBill.getLong("delaytime") * 60L * 1000L;
        long restOfTime = SouBidHallUtil.getRestOfTime((DynamicObject)quoBidBill);
        Date currDate = TimeServiceHelper.now();
        if (restOfTime < lastTime) {
            quoBidBill.set("bidrestoftime", (Object)(restOfTime += delayTime));
            quoBidBill.set("pausetime", (Object)currDate);
            quoBidBill.set("pausestarttime", (Object)currDate);
        }
    }

    protected void refresh(DynamicObject quoBidBill, boolean force) {
        if (Objects.isNull(quoBidBill)) {
            quoBidBill = this.needFresh(force);
        }
        if (Objects.nonNull(quoBidBill)) {
            this.bindData(quoBidBill);
        }
    }

    protected void changeBtnEnable(DynamicObject quoBidBill, AbstractBidHall plugin) {
        String bidStatus = quoBidBill.getString("bidstatus");
        boolean isfreequote = quoBidBill.getBoolean("isfreequote");
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Label bidStatusLbl = (Label)this.getView().getControl("bidstatus");
        bidStatusLbl.setText(MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u72b6\u6001\uff1a{0}", (String)"QuoBidHallPlugin_1", (String)"scm-quo-formplugin", (Object[])new Object[0]), BidStatusEnum.fromVal((String)bidStatus).getName()));
        model.setValue("bidstatusval", (Object)bidStatus);
        model.setValue("isfreequote", (Object)isfreequote);
        long restOfTime = SouBidHallUtil.getRestOfTime((DynamicObject)quoBidBill);
        if (bidStatus.equals(BidStatusEnum.BIDDING.getVal()) && restOfTime > 0L) {
            view.setEnable(Boolean.TRUE, new String[]{"tblcommit"});
            if (plugin instanceof QuoBidHallByEntryPlugin) {
                this.enableOrDisableEntry(model, isfreequote, Boolean.TRUE);
            }
        } else {
            if (bidStatus.equals(BidStatusEnum.BIDDING.getVal()) && restOfTime <= 0L) {
                quoBidBill.set("bidstatus", (Object)BidStatusEnum.EVALUATING.getVal());
            }
            view.setEnable(Boolean.FALSE, new String[]{"tblcommit"});
            if (plugin instanceof QuoBidHallByEntryPlugin) {
                this.enableOrDisableEntry(model, isfreequote, Boolean.FALSE);
            }
        }
        if (!bidStatus.equals(BidStatusEnum.BIDDING.getVal()) && !bidStatus.equals(BidStatusEnum.EVALUATING.getVal())) {
            view.setEnable(Boolean.FALSE, new String[]{"tblattach"});
        } else {
            view.setEnable(Boolean.TRUE, new String[]{"tblattach"});
        }
    }

    protected void enableOrDisableEntry(IDataModel model, boolean isfreequote, Boolean aTrue) {
        DynamicObjectCollection currquoentity = model.getEntryEntity("currquoentity");
        IFormView view = this.getView();
        if (aTrue.booleanValue()) {
            aTrue = isfreequote;
        }
        for (int i = 0; i < currquoentity.size(); ++i) {
            view.setEnable(aTrue, i, new String[]{"quoteprice", ADD, REDUCE});
        }
    }

    protected DynamicObject getSouBidBill() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object bidBillIdObj = param.get("bidBillId");
        if (bidBillIdObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7ade\u4ef7\u5355\u636e\u4fe1\u606f\u5931\u8d25\u3002", (String)"QuoBidHallPlugin_24", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
        long bidBillIdLong = Long.parseLong(bidBillIdObj.toString());
        String selectFields = this.getSelectFields();
        selectFields = selectFields + ",curr.sign,curr.amtprecision";
        DynamicObject objs = BusinessDataServiceHelper.loadSingle((String)"quo_bidbill", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidBillIdLong)});
        if (objs == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7ade\u4ef7\u5355\u636e\u4fe1\u606f\u5931\u8d25\u3002", (String)"QuoBidHallPlugin_24", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
        return objs;
    }

    protected String getSelectFields() {
        String selectFields = DynamicObjectUtil.getSelectfields((String)"quo_bidbill", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"quo_bidbill", (String)SUPQUOENTRY, (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"quo_bidbill", (String)QUOENTRY, (boolean)false);
        return selectFields;
    }

    protected String getSupplierPkByCurrentUser(DynamicObject quoBidBill) {
        IPageCache cache = this.getPageCache();
        String supplierPk = cache.get("supplierPk");
        if (supplierPk != null) {
            return supplierPk;
        }
        DynamicObject supplier = this.getSupplierByCurrentUser(quoBidBill);
        if (supplier != null) {
            supplierPk = supplier.getPkValue().toString();
            cache.put("supplierPk", supplierPk);
        }
        return supplierPk;
    }

    protected void setCurrencyAndExchange(DynamicObject quoBidBill) {
        DynamicObject currency = null;
        BigDecimal exchangerate = BigDecimal.ONE;
        DynamicObjectCollection quoCols = quoBidBill.getDynamicObjectCollection(QUOENTRY);
        String supplierPk = this.getSupplierPkByCurrentUser(quoBidBill);
        for (DynamicObject quoCol : quoCols) {
            Object quoSupObj = quoCol.get("quotesupplier");
            Object quoSupplierPk = null;
            quoSupplierPk = quoSupObj instanceof DynamicObject ? ((DynamicObject)quoSupObj).getPkValue() : quoSupObj;
            if (supplierPk == null || quoSupplierPk == null || !quoSupplierPk.toString().equals(supplierPk)) continue;
            currency = quoCol.getDynamicObject("quocurrency");
            exchangerate = quoCol.getBigDecimal("exchange");
            this.getView().setEnable(Boolean.FALSE, new String[]{"currency"});
            break;
        }
        if (currency == null) {
            currency = quoBidBill.getDynamicObject("curr");
        }
        if (currency != null) {
            this.getPageCache().put("quoamtprecision", currency.getInt("amtprecision") + "");
            this.getPageCache().put("priceprecision", currency.getInt("priceprecision") + "");
        }
        if (exchangerate == null || exchangerate.compareTo(BigDecimal.ZERO) == 0) {
            exchangerate = BigDecimal.ONE;
        }
        if (currency != null) {
            this.getModel().setValue("quocurrency", currency.getPkValue());
        }
        this.getModel().setValue("exchangerate", (Object)exchangerate);
    }

    protected int getQuoamtprecision(String precision) {
        int quoamtprecision = 0;
        String quoamtprecisionstr = this.getPageCache().get(precision);
        if (quoamtprecisionstr != null) {
            quoamtprecision = Integer.parseInt(quoamtprecisionstr);
        }
        return quoamtprecision;
    }

    protected abstract void setQuotePriceInfo(String var1, int var2);

    protected BigDecimal addOrReducePrice(String type, BigDecimal baseInfo, BigDecimal beCommitQuo) {
        if (baseInfo == null || beCommitQuo == null) {
            return beCommitQuo;
        }
        IPageCache cache = this.getPageCache();
        String reduceType = cache.get("reduceType");
        String reducePct = cache.get("reducePct");
        BigDecimal exchangeRate = new BigDecimal(this.getModel().getValue("exchangerate").toString());
        int priceprecision = this.getQuoamtprecision("priceprecision");
        BigDecimal reduceAmt = BigDecimal.ZERO;
        if ("A".equals(reduceType)) {
            reduceAmt = baseInfo.multiply(CommonUtil.getBigDecimalPro((Object)reducePct).divide(CalConstant.BIGDECIMAL_ONEHUNDRED));
        } else if ("B".equals(reduceType)) {
            reduceAmt = CommonUtil.getBigDecimalPro((Object)reducePct);
        }
        reduceAmt = reduceAmt.divide(exchangeRate, priceprecision, RoundingMode.HALF_UP);
        if (type.equals(ADD)) {
            beCommitQuo = beCommitQuo.add(reduceAmt);
        } else if (type.equals(REDUCE)) {
            beCommitQuo = beCommitQuo.subtract(reduceAmt);
        }
        return beCommitQuo;
    }
}

