/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DynamicObjectUtil;

public class QuoAnnouncementReplyPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String REPLYENTRY = "replyentity";
    private static final String ENTTYENTITY = "entryentity";
    private static final String REPLYTIME = "replytime";
    private static final String REPLYNAME = "replyname";
    private static final String REPLYTEXT = "replytext";
    private static final String SYSTEMTYPE = "scm-quo-formplugin";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject bill = this.getNoticeBill();
        if (bill == null) {
            return;
        }
        IDataModel model = this.getModel();
        List<Long> supplierList = this.getSupplierScope(bill);
        if (!supplierList.isEmpty()) {
            model.setValue("supplier", (Object)supplierList.get(0));
        }
        Date now = TimeServiceHelper.now();
        model.setValue(REPLYTIME, (Object)now);
        model.setValue(REPLYNAME, (Object)RequestContext.get().getUserId());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplier = (BasedataEdit)this.getView().getControl("supplier");
        if (supplier != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject bill = this.getNoticeBill();
        if (bill == null) {
            return;
        }
        List<Long> supplierList = this.getSupplierScope(bill);
        if (!supplierList.isEmpty()) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", supplierList));
        }
    }

    private List<Long> getSupplierScope(DynamicObject noticeBill) {
        DynamicObjectCollection supEntrys = noticeBill.getDynamicObjectCollection(ENTTYENTITY);
        ArrayList<Long> supplierListForFilter = new ArrayList<Long>(supEntrys.size());
        for (Object supEntry : supEntrys) {
            DynamicObject supplier2 = supEntry.getDynamicObject("supplier");
            Long pkValue = (Long)supplier2.getPkValue();
            supplierListForFilter.add(pkValue);
        }
        DynamicObjectCollection replyEntrys = noticeBill.getDynamicObjectCollection(REPLYENTRY);
        for (DynamicObject replyEntry : replyEntrys) {
            DynamicObject supplier1 = replyEntry.getDynamicObject("supplier1");
            if (supplier1 == null) continue;
            Long supplier1PkValue = (Long)supplier1.getPkValue();
            supplierListForFilter.remove(supplier1PkValue);
        }
        List supplierList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        supplierListForFilter.removeIf(supplier -> !supplierList.contains(supplier));
        return supplierListForFilter;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        super.beforeDoOperation(event);
        String operateKey = ((AbstractOperate)event.getSource()).getOperateKey();
        if ("affirm".equals(operateKey)) {
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            String uploadingAttJson = cache.get("UploadingAtt" + this.getView().getPageId());
            boolean notBlank = StringUtils.isNotBlank((CharSequence)uploadingAttJson);
            if (notBlank) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"QuoAnnouncementReplyPlugin_4", (String)SYSTEMTYPE, (Object[])new Object[0]));
                return;
            }
            IFormView view = this.getView();
            DynamicObject bill = this.getNoticeBill();
            IDataModel model = this.getModel();
            Object supplier = model.getValue("supplier");
            if (supplier == null) {
                view.showMessage(ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QuoAnnouncementReplyPlugin_1", (String)SYSTEMTYPE, (Object[])new Object[0]));
                return;
            }
            if ("".equals(model.getValue(REPLYTEXT).toString().trim())) {
                view.showMessage(ResManager.loadKDString((String)"\u7b54\u590d\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QuoAnnouncementReplyPlugin_2", (String)SYSTEMTYPE, (Object[])new Object[0]));
                return;
            }
            if (bill != null) {
                this.setReplyInfo(bill, supplier, model);
                SaveServiceHelper.save((IDataEntityType)bill.getDynamicObjectType(), (Object[])new Object[]{bill});
            }
            view.showMessage(ResManager.loadKDString((String)"\u7b54\u590d\u6210\u529f\u3002", (String)"QuoAnnouncementReplyPlugin_3", (String)SYSTEMTYPE, (Object[])new Object[0]));
            view.close();
        }
    }

    private void setReplyInfo(DynamicObject bill, Object supplier, IDataModel model) {
        DynamicObjectCollection replyEntrys = bill.getDynamicObjectCollection(REPLYENTRY);
        DynamicObject dynamicObject = replyEntrys.addNew();
        dynamicObject.set("supplier1", supplier);
        dynamicObject.set(REPLYNAME, model.getValue(REPLYNAME));
        dynamicObject.set(REPLYTEXT, model.getValue(REPLYTEXT));
        dynamicObject.set(REPLYTIME, model.getValue(REPLYTIME));
        dynamicObject.set("seq", (Object)replyEntrys.size());
        DynamicObjectCollection attachment = (DynamicObjectCollection)this.getModel().getValue("attachment");
        dynamicObject.set("attachment", (Object)attachment);
    }

    private DynamicObject getNoticeBill() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object billId = param.get("billId");
        if (billId == null) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "=", billId);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"quo_notice", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"quo_notice", (String)REPLYENTRY, (boolean)false);
        selectFields = selectFields + DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"quo_notice", (String)ENTTYENTITY, (boolean)false);
        return BusinessDataServiceHelper.loadSingle((String)"quo_notice", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }
}

