/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SupBidStatusEnum;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DynamicObjectUtil;

public class QuoBidEnrollPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String SUPQUOENTRY = "supquoentry";

    public void propertyChanged(PropertyChangedArgs e) {
    }

    public void afterCreateNewData(EventObject e) {
        this.bindData();
    }

    private void bindData() {
        List<Long> supplierList;
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        IDataModel model = this.getModel();
        model.setValue("billname", param.get("bidName"));
        model.setValue("enrollor", (Object)RequestContext.get().getUserId());
        DynamicObject bidBill = this.getQuoBidBill();
        if (bidBill == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7ade\u4ef7\u5355\u4e0d\u7b26\u5408\u62a5\u540d\u6761\u4ef6\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"QuoBidEnrollPlugin_0", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            return;
        }
        String bizType = bidBill.getString("biztype");
        if (bizType.equals("1")) {
            List supplierList2 = BizPartnerUtil.getSupplierByUserOfBizPartner();
            if (supplierList2 != null && supplierList2.size() > 0) {
                model.setValue("supplier", supplierList2.get(0));
            }
        } else if (bizType.equals("2") && (supplierList = this.getSupplierScope(bidBill)).size() > 0) {
            model.setValue("supplier", (Object)supplierList.get(0));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit quotecurr = (BasedataEdit)this.getView().getControl("supplier");
        if (quotecurr != null) {
            quotecurr.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        List<Long> supplierList;
        DynamicObject bidBill = this.getQuoBidBill();
        if (bidBill == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7ade\u4ef7\u5355\u4e0d\u7b26\u5408\u62a5\u540d\u6761\u4ef6\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"QuoBidEnrollPlugin_0", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            return;
        }
        String bizType = bidBill.getString("biztype");
        if (bizType.equals("1")) {
            List supplierList2 = BizPartnerUtil.getSupplierByUserOfBizPartner();
            if (supplierList2 != null && !supplierList2.isEmpty()) {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", (Object)supplierList2));
            }
        } else if (bizType.equals("2") && !(supplierList = this.getSupplierScope(bidBill)).isEmpty()) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", supplierList));
        }
    }

    private List<Long> getSupplierScope(DynamicObject bidBill) {
        DynamicObjectCollection supEntrys = bidBill.getDynamicObjectCollection(SUPQUOENTRY);
        ArrayList<Long> supplierListForFilter = new ArrayList<Long>();
        List supplierList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        for (DynamicObject supEntry : supEntrys) {
            DynamicObject supplier = supEntry.getDynamicObject("entrysupplier");
            long suppierPk = Long.parseLong(supplier.getPkValue().toString());
            if (!supplierList.contains(suppierPk)) continue;
            supplierListForFilter.add(suppierPk);
        }
        return supplierListForFilter;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs event) {
        String operateKey;
        super.beforeDoOperation(event);
        switch (operateKey = ((AbstractOperate)event.getSource()).getOperateKey()) {
            case "confirm": {
                this.enroll();
            }
        }
    }

    private void enroll() {
        IFormView view = this.getView();
        DynamicObject bidBill = this.getQuoBidBill();
        if (bidBill == null) {
            view.showMessage(ResManager.loadKDString((String)"\u7ade\u4ef7\u5355\u4e0d\u7b26\u5408\u62a5\u540d\u6761\u4ef6\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"QuoBidEnrollPlugin_0", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection supEntrys = bidBill.getDynamicObjectCollection(SUPQUOENTRY);
        IDataModel model = this.getModel();
        Object supplier = model.getValue("supplier");
        if (supplier == null) {
            view.showMessage(ResManager.loadKDString((String)"\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QuoBidEnrollPlugin_1", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            return;
        }
        Object supplierPk = ((DynamicObject)supplier).getPkValue();
        DynamicObject supEntry = this.getQuoSupEntry(supEntrys, supplierPk);
        if (supEntry == null) {
            supEntry = ORMUtil.newDynamicObject((DynamicObjectType)supEntrys.getDynamicObjectType());
            this.setSupplierEntryData(bidBill, supEntry, supplierPk);
            supEntrys.add((Object)supEntry);
        } else {
            DynamicObject supEnroll = supEntry.getDynamicObject("supenroll");
            if (supEnroll != null) {
                view.showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u4f01\u4e1a\u5df2\u7ecf\u62a5\u540d\uff0c\u65e0\u9700\u518d\u6b21\u62a5\u540d\u3002", (String)"QuoBidEnrollPlugin_2", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setSupplierEntryData(bidBill, supEntry, supplierPk);
        }
        DynamicObjectUtil.setBillEntrySeq((DynamicObject)bidBill, (String)SUPQUOENTRY);
        int enrollnum = 0;
        if (bidBill.get("enrollnum") != null) {
            enrollnum = bidBill.getInt("enrollnum");
        }
        bidBill.set("enrollnum", (Object)(enrollnum + 1));
        SaveServiceHelper.save((IDataEntityType)bidBill.getDynamicObjectType(), (Object[])new Object[]{bidBill});
        view.showMessage(ResManager.loadKDString((String)"\u62a5\u540d\u6210\u529f\u3002", (String)"QuoBidEnrollPlugin_3", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        view.close();
    }

    private void setSupplierEntryData(DynamicObject bidBill, DynamicObject entry, Object supplierPk) {
        entry.set("entrysupplier", supplierPk);
        String checkType = bidBill.getString("checktype");
        if (checkType.equals("3")) {
            entry.set("supentrystatus", (Object)SupBidStatusEnum.BEENEXAMINED);
        } else {
            entry.set("supentrystatus", (Object)SupBidStatusEnum.BEEXAMINING);
        }
        IDataModel model = this.getModel();
        entry.set("supnote", (Object)String.valueOf(model.getValue("note")));
        entry.set("supenroll", (Object)Long.valueOf(RequestContext.get().getUserId()));
        entry.set("supenrolldate", (Object)TimeServiceHelper.now());
    }

    private DynamicObject getQuoSupEntry(DynamicObjectCollection supEntrys, Object supplierPk) {
        for (DynamicObject supEntry : supEntrys) {
            DynamicObject supplier = supEntry.getDynamicObject("entrysupplier");
            if (!supplier.getPkValue().toString().equals(String.valueOf(supplierPk))) continue;
            return supEntry;
        }
        return null;
    }

    private DynamicObject getQuoBidBill() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object bidBillIdObj = param.get("bidBillId");
        if (bidBillIdObj == null) {
            return null;
        }
        HashMap params = new HashMap(2);
        HashMap<String, Long> idMap = new HashMap<String, Long>(1);
        idMap.put("=", Long.parseLong(bidBillIdObj.toString()));
        params.put("id", idMap);
        HashMap<String, String> statusMap = new HashMap<String, String>(1);
        statusMap.put("=", BillStatusEnum.AUDIT.getVal());
        params.put("billstatus", statusMap);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"quo_bidbill", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"quo_bidbill", (String)SUPQUOENTRY, (boolean)false);
        DynamicObject[] objs = ORMUtil.load((String)"quo_bidbill", (String)selectFields, params);
        return objs.length == 0 ? null : objs[0];
    }
}

