/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SouBidHallUtil;
import kd.scm.common.util.cal.MultCurrencyCalImpl;
import kd.scm.quo.formplugin.AbstractQuoBidHall;
import kd.scm.quo.formplugin.QuoQuotePrice;
import kd.scm.quo.service.QuoteToolServiceImp;

public class QuoBidHallByEntryPlugin
extends AbstractQuoBidHall {
    private static final String CURRQUOENTITY = "currquoentity";
    private static final String PASTQUOENTITY = "pastquoentity";

    @Override
    protected void commit() {
        IFormView view = this.getView();
        EntryGrid grid = (EntryGrid)view.getControl(CURRQUOENTITY);
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u62a5\u4ef7\u7684\u7269\u6599\u3002", (String)"QuoBidHallPlugin_21", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject quoBidBill = this.getSouBidBill();
        String bidStatus = quoBidBill.getString("bidstatus");
        long restOfTime = SouBidHallUtil.getRestOfTime((DynamicObject)quoBidBill);
        if (!bidStatus.equals(BidStatusEnum.BIDDING.getVal()) || restOfTime <= 0L) {
            view.showMessage(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u88ab\u91c7\u8d2d\u65b9\u6682\u505c/\u7ed3\u675f/\u7ec8\u6b62\uff0c\u5982\u6709\u95ee\u9898\u8bf7\u4e0e\u91c7\u8d2d\u65b9\u6c9f\u901a\u3002", (String)"QuoBidHallPlugin_13", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            this.setRestOfTime(quoBidBill);
            if (restOfTime <= 0L) {
                quoBidBill.set("bidstatus", (Object)BidStatusEnum.EVALUATING.getVal());
                SaveServiceHelper.save((IDataEntityType)quoBidBill.getDataEntityType(), (Object[])new Object[]{quoBidBill});
            }
            return;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection quoEntrys = quoBidBill.getDynamicObjectCollection("quoentry");
        String taxType = quoBidBill.getString("taxtype");
        DynamicObjectCollection currQuocols = model.getEntryEntity(CURRQUOENTITY);
        String supplierPk = this.getSupplierPkByCurrentUser(quoBidBill);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("quocurrency");
        BigDecimal exchangerate = new BigDecimal(this.getModel().getValue("exchangerate").toString());
        Date quotedate = TimeServiceHelper.now();
        Map allcachMap = this.getPageCache().getAll();
        ArrayList currKey = new ArrayList(allcachMap.size());
        allcachMap.forEach((key, info) -> {
            if (key.startsWith(CURRQUOENTITY)) {
                currKey.add(key);
            }
        });
        for (String s : currKey) {
            this.getPageCache().put(s, "2");
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"quo_bidbill");
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        for (int row : selectRows) {
            BigDecimal amount;
            DynamicObject newEntry;
            DynamicObject object = (DynamicObject)currQuocols.get(row);
            BigDecimal inputPrice = object.getBigDecimal("quoteprice");
            QuoQuotePrice quotePrice = new QuoQuotePrice(inputPrice, taxType, BigDecimal.ZERO, object, object.getBoolean("currislarge"));
            if (quotePrice.isLegal()) {
                DynamicObject quoRow = entryentity.addNew();
                BigDecimal price = quotePrice.getPrice();
                BigDecimal taxPrice = quotePrice.getTaxPrice();
                newEntry = quoEntrys.addNew();
                newEntry.set("quotematerial", object.get("currmaterial"));
                newEntry.set("quotesupplier_id", (Object)Long.valueOf(supplierPk));
                newEntry.set("quotematerial_id", object.get("currmaterial_id"));
                newEntry.set("quotematerialnametext", object.get("currmaterialnametext"));
                newEntry.set("quoteprice", (Object)price);
                newEntry.set("quotetaxprice", (Object)taxPrice);
                newEntry.set("quotedate", (Object)quotedate);
                quoRow.set("qty", (Object)object.getBigDecimal("currqty"));
                quoRow.set("price", (Object)price);
                quoRow.set("taxprice", (Object)taxPrice);
                quoRow.set("taxrate", (Object)object.getBigDecimal("currtaxrateid.taxrate"));
                amount = MultCurrencyCalImpl.calAmount((DynamicObject)quoRow, (String)taxType, (String)"", (int)currency.getInt("amtprecision"));
                if (amount.compareTo(QuoteToolServiceImp.MAX_QUOTE_PRICE) >= 0) {
                    view.showMessage(ResManager.loadKDString((String)"\u62a5\u4ef7\u5408\u8ba1\u9ad8\u4e8e9999999999999\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"QuoBidHallByEntryPlugin_1", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                view.showMessage(quotePrice.getErrorMessage());
                return;
            }
            newEntry.set("quosuppamount", (Object)amount);
            newEntry.set("quoteamount", (Object)amount);
            newEntry.set("quocurrency", (Object)currency);
            newEntry.set("materialrowid", (Object)object.getString("currrowid"));
            newEntry.set("exchange", (Object)exchangerate);
            newEntry.set("quotaxrateid", (Object)object.getDynamicObject("currtaxrateid"));
            newEntry.set("quotaxrate", (Object)object.getBigDecimal("currtaxrate"));
        }
        this.delay(quoBidBill);
        DynamicObjectUtil.setBillEntrySeq((DynamicObject)quoBidBill, (String)"quoentry");
        SaveServiceHelper.save((IDataEntityType)quoBidBill.getDataEntityType(), (Object[])new Object[]{quoBidBill});
        this.getAppCache().put(String.valueOf(quoBidBill.getPkValue()), (Object)TimeServiceHelper.now().toString());
        this.refresh(quoBidBill, true);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject souBidBill = this.getSouBidBill();
        this.signin(souBidBill);
    }

    private void signin(DynamicObject quoBidBill) {
        DynamicObjectCollection supquoentry = quoBidBill.getDynamicObjectCollection("supquoentry");
        DynamicObject supplierByCurrentUser = this.getSupplierByCurrentUser(quoBidBill);
        if (supplierByCurrentUser == null) {
            return;
        }
        boolean needSignFlag = false;
        for (DynamicObject entry : supquoentry) {
            boolean signin = entry.getBoolean("signin");
            if (signin || supplierByCurrentUser.getLong("id") != entry.getLong("entrysupplier.id")) continue;
            needSignFlag = true;
            entry.set("signin", (Object)"1");
            entry.set("signuser", (Object)RequestContext.get().getCurrUserId());
            entry.set("signtime", (Object)TimeServiceHelper.now());
        }
        if (needSignFlag) {
            SaveServiceHelper.save((IDataEntityType)quoBidBill.getDataEntityType(), (Object[])new Object[]{quoBidBill});
        }
    }

    @Override
    protected Map<String, Object> setSupQuoInfo(DynamicObject quoBidBill) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        model.deleteEntryData(PASTQUOENTITY);
        DynamicObject curr = quoBidBill.getDynamicObject("curr");
        DynamicObjectCollection quoteCols = quoBidBill.getDynamicObjectCollection("quoentry");
        String supplierPk = this.getSupplierPkByCurrentUser(quoBidBill);
        SouBidHallUtil.sortByQuoteDate((DynamicObjectCollection)quoteCols, (int)-1);
        LinkedHashMap<Long, BigDecimal> newestPriceMap = new LinkedHashMap<Long, BigDecimal>();
        LinkedHashMap<Long, Map<String, BigDecimal>> supplierDataMap = new LinkedHashMap<Long, Map<String, BigDecimal>>();
        int index = 0;
        for (int i = 0; i < quoteCols.size(); ++i) {
            DynamicObject object = (DynamicObject)quoteCols.get(i);
            this.dealRangeInfo(newestPriceMap, object, supplierDataMap);
            Object quoSupObj = object.get("quotesupplier");
            Object quoSupplierPk = null;
            quoSupplierPk = quoSupObj instanceof DynamicObject ? ((DynamicObject)quoSupObj).getPkValue() : quoSupObj;
            if (supplierPk != null && quoSupplierPk != null && !quoSupplierPk.toString().equals(supplierPk)) continue;
            this.createPastQuoteInfo(ts, object, curr, index);
            ++index;
        }
        model.batchCreateNewEntryRow(PASTQUOENTITY, ts);
        resultMap.put("newestPriceMap", newestPriceMap);
        resultMap.put("supplierDataMap", supplierDataMap);
        return resultMap;
    }

    private void createPastQuoteInfo(TableValueSetter ts, DynamicObject object, DynamicObject curr, int i) {
        DynamicObject parent = (DynamicObject)object.getParent();
        String taxtype = parent.getString("taxtype");
        ts.set("pastmaterial", (Object)object.getLong("quotematerial_id"), i);
        String nameText = object.getString("quotematerialnametext");
        if (StringUtils.isBlank((CharSequence)nameText)) {
            ts.set("pastmaterialnametext", (Object)object.getString("quotematerial.name"), i);
        } else {
            ts.set("pastmaterialnametext", (Object)nameText, i);
        }
        ts.set("pastsupplier", (Object)object.getLong("quotesupplier_id"), i);
        ts.set("passcurrency", curr == null ? Long.valueOf(0L) : curr.getPkValue(), i);
        ts.set("passtaxrateid", (Object)object.getLong("quotaxrateid_id"), i);
        ts.set("passprice", (Object)object.getBigDecimal("quoteprice"), i);
        ts.set("passtaxprice", (Object)object.getBigDecimal("quotetaxprice"), i);
        if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxtype)) {
            ts.set("pastlatestprice", (Object)object.getBigDecimal("quoteprice"), i);
        } else {
            ts.set("pastlatestprice", (Object)object.getBigDecimal("quotetaxprice"), i);
        }
        ts.set("pastquotetime", object.get("quotedate"), i);
    }

    protected void dealRangeInfo(Map<Long, BigDecimal> newestPriceMap, DynamicObject object, Map<Long, Map<String, BigDecimal>> supplierDataMap) {
        Long materialrowid = object.getLong("materialrowid");
        DynamicObject parent = (DynamicObject)object.getParent();
        String taxtype = parent.getString("taxtype");
        BigDecimal quoteprice = object.getBigDecimal("quotetaxprice");
        if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxtype)) {
            quoteprice = object.getBigDecimal("quoteprice");
        }
        String quotesupplierId = object.getString("quotesupplier_id");
        BigDecimal newestPrice = newestPriceMap.get(materialrowid);
        Map<String, BigDecimal> supplierPriceMap = supplierDataMap.get(materialrowid);
        if (newestPrice == null) {
            newestPriceMap.put(materialrowid, quoteprice);
        }
        if (supplierPriceMap == null) {
            supplierPriceMap = new LinkedHashMap<String, BigDecimal>();
            supplierPriceMap.put(quotesupplierId, quoteprice);
            supplierDataMap.put(materialrowid, supplierPriceMap);
        } else if (!supplierPriceMap.containsKey(quotesupplierId)) {
            supplierPriceMap.put(quotesupplierId, quoteprice);
        }
    }

    @Override
    protected void setCurrQuoInfo(DynamicObject quoBidBill, Map<String, Object> resultMap) {
        Map newestPriceMap = (Map)resultMap.get("newestPriceMap");
        Map supplierDataMap = (Map)resultMap.get("supplierDataMap");
        String supplierPk = this.getSupplierPkByCurrentUser(quoBidBill);
        DynamicObjectCollection materialCols = quoBidBill.getDynamicObjectCollection("entryentity");
        String hasCache = this.getPageCache().get("hasCache");
        Map<String, Integer> rangIndexMap = StringUtils.isBlank((CharSequence)hasCache) ? this.createCurrQuoteRow(quoBidBill, materialCols, supplierDataMap, newestPriceMap, supplierPk) : this.updateCurrQuoteRow(quoBidBill, materialCols, supplierDataMap, newestPriceMap, supplierPk);
        String rank = ResManager.loadKDString((String)"\u7b2c{0}\u4f4d", (String)"QuoBidHallPlugin_20", (String)"scm-quo-formplugin", (Object[])new Object[0]);
        Boolean open2 = quoBidBill.getBoolean("open2");
        supplierDataMap.forEach((key, value) -> {
            ArrayList<Map.Entry<String, BigDecimal>> supQuoAmtList = new ArrayList<Map.Entry<String, BigDecimal>>(value.entrySet());
            this.sortQuoAmtInfo(supQuoAmtList);
            int i = 1;
            for (Map.Entry entry : supQuoAmtList) {
                if (StringUtils.equals((CharSequence)(key + "-" + supplierPk), (CharSequence)(key + "-" + (String)entry.getKey()))) {
                    Integer index = (Integer)rangIndexMap.get(key + "-" + supplierPk);
                    String flag = this.getPageCache().get(CURRQUOENTITY + index);
                    if (index != null) {
                        this.getModel().setValue("currranking", (Object)MessageFormat.format(rank, open2 == null || open2 == false ? "*" : Integer.valueOf(i)), index.intValue());
                        this.getModel().setValue("currmyprice", entry.getValue(), index.intValue());
                        if ("1".equals(flag)) break;
                        this.getModel().setValue("quoteprice", entry.getValue(), index.intValue());
                        break;
                    }
                }
                ++i;
            }
        });
    }

    private Map<String, Integer> createCurrQuoteRow(DynamicObject quoBill, DynamicObjectCollection materialCols, Map<Long, Map<String, BigDecimal>> supplierDataMap, Map<Long, BigDecimal> newestPriceMap, String supplierPk) {
        HashMap<String, Integer> rangIndexMap = new HashMap<String, Integer>();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(CURRQUOENTITY);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        String taxType = quoBill.getString("taxtype");
        for (int i = 0; i < materialCols.size(); ++i) {
            DynamicObject material = (DynamicObject)materialCols.get(i);
            DynamicObject material1 = material.getDynamicObject("material");
            if (material1 == null) continue;
            DynamicObject unit = material.getDynamicObject("unit");
            ts.set("currmaterial", material1.getPkValue(), i);
            ts.set("currunit", unit == null ? null : unit.getPkValue(), i);
            ts.set("currqty", (Object)material.getBigDecimal("qty"), i);
            String materialnametext = material.getString("materialnametext");
            if (StringUtils.isBlank((CharSequence)materialnametext)) {
                ts.set("currmaterialnametext", (Object)material1.getLocaleString("name").getLocaleValue(), i);
            } else {
                ts.set("currmaterialnametext", (Object)materialnametext, i);
            }
            ts.set("currprice", (Object)material.getBigDecimal("price"), i);
            ts.set("currtaxprice", (Object)material.getBigDecimal("taxprice"), i);
            ts.set("currtaxrateid", (Object)material.getLong("taxrateid_id"), i);
            ts.set("currtaxrate", (Object)material.getBigDecimal("taxrate"), i);
            ts.set("currrowid", material.getPkValue(), i);
            ts.set("currislarge", (Object)material.getBoolean("islarge"), i);
            Map<String, BigDecimal> supplierData = supplierDataMap.get(material.getPkValue());
            ts.set("currlatestprice", (Object)newestPriceMap.get(material.getPkValue()), i);
            ts.set("taxtype1", (Object)taxType, i);
            String flag = this.getPageCache().get(CURRQUOENTITY + i);
            if ("1".equals(flag) || StringUtils.isBlank((CharSequence)flag)) {
                if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
                    ts.set("quoteprice", (Object)material.getBigDecimal("taxprice"), i);
                } else {
                    ts.set("quoteprice", (Object)material.getBigDecimal("price"), i);
                }
            }
            if (supplierData == null || !supplierData.containsKey(supplierPk)) continue;
            rangIndexMap.put(material.getPkValue() + "-" + supplierPk, i);
        }
        model.batchCreateNewEntryRow(CURRQUOENTITY, ts);
        this.enableOrDisableEntry(this.getModel(), "true".equals(this.getModel().getValue("isfreequote")), Boolean.TRUE);
        return rangIndexMap;
    }

    private Map<String, Integer> updateCurrQuoteRow(DynamicObject quoBill, DynamicObjectCollection materialCols, Map<Long, Map<String, BigDecimal>> supplierDataMap, Map<Long, BigDecimal> newestPriceMap, String supplierPk) {
        HashMap<String, Integer> rangIndexMap = new HashMap<String, Integer>();
        int[] selectedrows = this.getSelect(CURRQUOENTITY);
        this.getModel().beginInit();
        IDataModel model = this.getModel();
        DynamicObjectCollection currquoentity = model.getEntryEntity(CURRQUOENTITY);
        DynamicObject currquorow = null;
        for (int i = 0; i < materialCols.size(); ++i) {
            DynamicObject material = (DynamicObject)materialCols.get(i);
            Map<String, BigDecimal> supplierData = supplierDataMap.get(material.getPkValue());
            currquorow = (DynamicObject)currquoentity.get(i);
            currquorow.set("currlatestprice", (Object)newestPriceMap.get(material.getPkValue()));
            String taxType = quoBill.getString("taxtype");
            String flag = this.getPageCache().get(CURRQUOENTITY + i);
            if (supplierData == null || !supplierData.containsKey(supplierPk)) continue;
            rangIndexMap.put(material.getPkValue() + "-" + supplierPk, i);
        }
        this.getModel().endInit();
        this.getView().updateView(CURRQUOENTITY);
        this.setSelect(selectedrows, CURRQUOENTITY);
        return rangIndexMap;
    }

    public int[] getSelect(String entryKey) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryKey);
        return grid.getSelectRows();
    }

    public void setSelect(int[] selectedrows, String entryKey) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryKey);
        if (selectedrows != null && selectedrows.length > 0) {
            grid.selectRows(selectedrows, 1);
        }
    }

    protected void sortQuoAmtInfo(List<Map.Entry<String, BigDecimal>> supQuoAmtList) {
        Collections.reverse(supQuoAmtList);
        Collections.sort(supQuoAmtList, new Comparator<Map.Entry<String, BigDecimal>>(){

            @Override
            public int compare(Map.Entry<String, BigDecimal> o1, Map.Entry<String, BigDecimal> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
    }

    @Override
    protected String getSelectFields() {
        return DynamicObjectUtil.getEntrySelectfields((String)super.getSelectFields(), (String)"quo_bidbill", (String)"entryentity", (boolean)false);
    }

    @Override
    protected void setQuotePriceInfo(String type, int index) {
        BigDecimal quoteprice = (BigDecimal)this.getModel().getValue("quoteprice", index);
        BigDecimal currtaxprice = (BigDecimal)this.getModel().getValue("currtaxprice", index);
        BigDecimal currprice = (BigDecimal)this.getModel().getValue("currprice", index);
        String taxtype = (String)this.getModel().getValue("taxtype1", index);
        BigDecimal bigDecimal = null;
        bigDecimal = TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxtype) ? super.addOrReducePrice(type, currprice, quoteprice) : super.addOrReducePrice(type, currtaxprice, quoteprice);
        if (bigDecimal != null && quoteprice.compareTo(bigDecimal) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56e0\u7cbe\u5ea6\u5f71\u54cd\u62a5\u4ef7\u672a\u53d8\u52a8\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u5e01\u79cd\u7cbe\u5ea6\u3002", (String)"QuoBidHallByEntryPlugin_0", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue("quoteprice", (Object)bigDecimal, index);
        this.getPageCache().put(CURRQUOENTITY + index, "1");
    }

    protected int getRefreshTime() {
        return 5;
    }
}

