/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.constant.CalConstant;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.plugin.AbstractQuoFormPlugin;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExchangeHelper;
import kd.scm.common.util.SouBidHallUtil;

public class QuoBidHallPlugin
extends AbstractQuoFormPlugin
implements CountDownListener {
    private static Log log = LogFactory.getLog(QuoBidHallPlugin.class);
    private static final String SUPQUOENTRY = "supquoentry";
    private static final String QUOENTRY = "quoentry";
    private static final String ADD = "add";
    private static final String REDUCE = "reduce";
    private static final String COMMIT = "commit";
    private static final String REFRESH = "refresh";

    public void registerListener(EventObject e) {
        CountDown autorefresh_cd;
        super.registerListener(e);
        CountDown countdown = (CountDown)this.getControl("countdownap");
        if (countdown != null) {
            countdown.addCountDownListener((CountDownListener)this);
        }
        if ((autorefresh_cd = (CountDown)this.getControl("autorefresh_cd")) != null) {
            autorefresh_cd.addCountDownListener((CountDownListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.bindDataAndSignIn();
        this.setAutoRefreshTime(1);
    }

    private void bindDataAndSignIn() {
        DynamicObject quoBidBill = this.getQuoBidBill();
        if (quoBidBill == null) {
            return;
        }
        this.setTitle(quoBidBill);
        this.setCurrencySign(quoBidBill);
        this.setBidStatus(quoBidBill);
        this.setRestOfTime(quoBidBill);
        this.setBidRuleInfo(quoBidBill);
        this.setSupQuoInfo(quoBidBill);
        this.setCurrencyAndExchange(quoBidBill);
        this.setQuoInfo(quoBidBill);
        this.setFreeQuote(quoBidBill);
        DynamicObject currency = quoBidBill.getDynamicObject("curr");
        this.getPageCache().put("settCurrency", currency.getPkValue().toString());
        DynamicObject purorg = quoBidBill.getDynamicObject("org");
        this.getPageCache().put("purorg", purorg.getPkValue().toString());
        this.getPageCache().put("maxamount", quoBidBill.get("maxamount").toString());
        this.signIn(quoBidBill);
    }

    private void signIn(DynamicObject quoBidBill) {
        DynamicObjectCollection supquoentry = quoBidBill.getDynamicObjectCollection(SUPQUOENTRY);
        DynamicObject supplierByCurrentUser = this.getSupplierByCurrentUser(quoBidBill);
        if (supplierByCurrentUser == null) {
            return;
        }
        boolean needSignFlag = false;
        for (DynamicObject entry : supquoentry) {
            boolean signin = entry.getBoolean("signin");
            if (signin || supplierByCurrentUser.getLong("id") != entry.getLong("entrysupplier.id")) continue;
            needSignFlag = true;
            entry.set("signin", (Object)"1");
            entry.set("signuser", (Object)RequestContext.get().getCurrUserId());
            entry.set("signtime", (Object)TimeServiceHelper.now());
        }
        if (needSignFlag) {
            SaveServiceHelper.save((IDataEntityType)quoBidBill.getDataEntityType(), (Object[])new Object[]{quoBidBill});
        }
    }

    private void setFreeQuote(DynamicObject quoBidBill) {
        if (BidStatusEnum.BIDDING.getVal().equals(quoBidBill.getString("bidstatus"))) {
            this.getView().setEnable(Boolean.valueOf(quoBidBill.getBoolean("isfreequote")), new String[]{"becommitquo"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"becommitquo"});
        }
    }

    public void onCountDownEnd(CountDownEvent countDownEvt) {
        IPageCache cache = this.getPageCache();
        String first = cache.get("firstEnd");
        CountDown countDown = (CountDown)countDownEvt.getSource();
        if ("autorefresh_cd".equals(countDown.getKey())) {
            DynamicObject bidBill;
            String bidStatus = (String)this.getModel().getValue("bidstatusval");
            if ((bidStatus.equals(BidStatusEnum.BIDDING.getVal()) || bidStatus.equals(BidStatusEnum.PAUSED.getVal()) || bidStatus.equals(BidStatusEnum.END.getVal())) && this.isRefresh() && null != (bidBill = this.getQuoBidBill())) {
                this.setBidStatus(bidBill);
                this.dealNewestQuoInfo(bidBill);
                this.setRestOfTime(bidBill);
            }
            countDown.setDuration(1);
        } else {
            DynamicObject bidBill = this.getQuoBidBill();
            if (first == null && bidBill != null) {
                this.setSupQuoInfo(bidBill);
                this.setQuoInfo(bidBill);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    log.error((Throwable)e);
                }
                this.setRestOfTime(bidBill);
                cache.put("firstEnd", "1");
            }
        }
    }

    public boolean isRefresh() {
        DynamicObject bidBill = this.getQuoBidBill();
        String curBidStatus = this.getPageCache().get("bidstatus");
        if (null == bidBill) {
            return false;
        }
        String newBidStatus = bidBill.getString("bidstatus");
        if (!StringUtils.equals((CharSequence)curBidStatus, (CharSequence)newBidStatus)) {
            this.getPageCache().put("bidstatus", newBidStatus);
            return true;
        }
        String curSecond = this.getPageCache().get("curSecond");
        if (null != curSecond) {
            int curSecondInt = Integer.parseInt(curSecond);
            if (curSecondInt % 4 == 0) {
                curSecondInt = 1;
                this.getPageCache().put("curSecond", String.valueOf(curSecondInt));
                return true;
            }
            this.getPageCache().put("curSecond", String.valueOf(++curSecondInt));
        } else {
            this.getPageCache().put("curSecond", "1");
        }
        String delaytimeStr = this.getPageCache().get("delaytime");
        long delaytime = delaytimeStr == null ? 0L : Long.parseLong(delaytimeStr);
        Date pausetime = bidBill.getDate("pausetime");
        Date pausestarttime = bidBill.getDate("pausestarttime");
        if (null != pausetime && null != pausestarttime && pausetime.getTime() == pausestarttime.getTime() && delaytime != pausetime.getTime()) {
            this.getPageCache().put("delaytime", String.valueOf(pausetime.getTime()));
            return true;
        }
        return false;
    }

    private void setTitle(DynamicObject quoBidBill) {
        IFormView view = this.getView();
        DynamicObject org = quoBidBill.getDynamicObject("org");
        String name = quoBidBill.getString("name");
        Label titleLable = (Label)view.getControl("title");
        StringBuilder titleSb = new StringBuilder();
        titleSb.append(MessageFormat.format(ResManager.loadKDString((String)"{0}(\u53d1\u8d77\u65b9\uff1a{1}--\u4f9b\u5e94\u5546\uff1a", (String)"QuoBidHallPlugin_0", (String)"scm-quo-formplugin", (Object[])new Object[0]), name, org.getString("name")));
        DynamicObject supplier = this.getSupplierByCurrentUser(quoBidBill);
        if (supplier != null) {
            titleSb.append(supplier.getString("name"));
        }
        titleSb.append(')');
        titleLable.setText(titleSb.toString());
    }

    private void setCurrencySign(DynamicObject quoBidBill) {
        Label myNewQuoteCurrSignLabel;
        DynamicObject currency = quoBidBill.getDynamicObject("curr");
        Label newQuoteCurrSignLabel = (Label)this.getView().getControl("newquotecurrsign");
        String currSign = currency.getString("sign");
        if (null != newQuoteCurrSignLabel) {
            newQuoteCurrSignLabel.setText(currSign);
        }
        if (null != (myNewQuoteCurrSignLabel = (Label)this.getView().getControl("mynewquotecurrsign"))) {
            myNewQuoteCurrSignLabel.setText(currSign);
        }
        this.getPageCache().put("settamtprecision", currency.getInt("amtprecision") + "");
    }

    private DynamicObject getQuoBidBill() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        Object bidBillIdObj = param.get("bidBillId");
        if (bidBillIdObj == null) {
            return null;
        }
        HashMap params = new HashMap(2);
        HashMap<String, Long> idMap = new HashMap<String, Long>(1);
        idMap.put("=", Long.parseLong(bidBillIdObj.toString()));
        params.put("id", idMap);
        String selectFields = DynamicObjectUtil.getSelectfields((String)"quo_bidbill", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"quo_bidbill", (String)SUPQUOENTRY, (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"quo_bidbill", (String)QUOENTRY, (boolean)false);
        selectFields = selectFields + ",curr.sign,curr.amtprecision,bidrestoftime";
        DynamicObject[] objs = ORMUtil.load((String)"quo_bidbill", (String)selectFields, params);
        return objs.length == 0 ? null : objs[0];
    }

    private String getSupplierPkByCurrentUser(DynamicObject quoBidBill) {
        IPageCache cache = this.getPageCache();
        String supplierPk = cache.get("supplierPk");
        if (supplierPk != null) {
            return supplierPk;
        }
        DynamicObject supplier = this.getSupplierByCurrentUser(quoBidBill);
        if (supplier != null) {
            supplierPk = supplier.getPkValue().toString();
            cache.put("supplierPk", supplierPk);
        }
        return supplierPk;
    }

    private DynamicObject getSupplierByCurrentUser(DynamicObject quoBidBill) {
        List suppliers = BizPartnerUtil.getSupplierByUserOfBizPartner();
        DynamicObjectCollection cols = quoBidBill.getDynamicObjectCollection(SUPQUOENTRY);
        for (DynamicObject col : cols) {
            DynamicObject supEnroll = col.getDynamicObject("supenroll");
            DynamicObject entrysupplier = col.getDynamicObject("entrysupplier");
            if (supEnroll == null || suppliers == null || entrysupplier == null || !suppliers.contains(Long.parseLong(entrysupplier.getPkValue().toString()))) continue;
            return entrysupplier;
        }
        return null;
    }

    private void setRestOfTime(DynamicObject quoBidBill) {
        Label secondsLable;
        Label minutesLable;
        IFormView view = this.getView();
        String bidStatus = quoBidBill.getString("bidstatus");
        CountDown countdown = (CountDown)this.getControl("countdownap");
        long restOfTime = SouBidHallUtil.getRestOfTime((DynamicObject)quoBidBill);
        long days = restOfTime / 86400000L;
        long hours = (restOfTime - days * 86400000L) / 3600000L;
        long minutes = (restOfTime - days * 86400000L - hours * 3600000L) / 60000L;
        long second = restOfTime / 1000L - days * 24L * 60L * 60L - hours * 60L * 60L - minutes * 60L;
        Label hoursLable = (Label)view.getControl("hours");
        if (hoursLable != null) {
            hoursLable.setText(String.valueOf(hours));
        }
        if ((minutesLable = (Label)view.getControl("minutes")) != null) {
            minutesLable.setText(String.valueOf(minutes));
        }
        if ((secondsLable = (Label)view.getControl("seconds")) != null) {
            secondsLable.setText(String.valueOf(second));
        }
        if (countdown != null) {
            countdown.setDuration((int)(restOfTime / 1000L));
            if (restOfTime == 0L) {
                countdown.pause();
            }
        }
        if (countdown != null && bidStatus.equals(BidStatusEnum.PAUSED.getVal())) {
            countdown.setDuration((int)(restOfTime / 1000L));
            countdown.pause();
        }
        if (!bidStatus.equals(BidStatusEnum.BIDDING.getVal()) && !bidStatus.equals(BidStatusEnum.PAUSED.getVal()) || restOfTime <= 0L) {
            view.setEnable(Boolean.FALSE, new String[]{"tbladd", "tblreduce", "tblcommit"});
        }
        if (!bidStatus.equals(BidStatusEnum.BIDDING.getVal()) && !bidStatus.equals(BidStatusEnum.EVALUATING.getVal())) {
            view.setEnable(Boolean.FALSE, new String[]{"tblattach"});
        } else {
            view.setEnable(Boolean.TRUE, new String[]{"tblattach"});
        }
    }

    private void setBidStatus(DynamicObject quoBidBill) {
        String bidStatus = quoBidBill.getString("bidstatus");
        BidStatusEnum bidStatusEnum = BidStatusEnum.fromVal((String)bidStatus);
        Label bidStatusLable = (Label)this.getView().getControl("bidstatus");
        bidStatusLable.setText(MessageFormat.format(ResManager.loadKDString((String)"\u5f53\u524d\u72b6\u6001\uff1a{0}", (String)"QuoBidHallPlugin_1", (String)"scm-quo-formplugin", (Object[])new Object[0]), bidStatusEnum.getName()));
        this.getModel().setValue("bidstatusval", (Object)bidStatus);
        IFormView view = this.getView();
        if (bidStatusEnum.equals((Object)BidStatusEnum.BIDDING)) {
            view.setEnable(Boolean.TRUE, new String[]{"tbladd", "tblreduce", "tblcommit"});
        } else {
            view.setEnable(Boolean.FALSE, new String[]{"tbladd", "tblreduce", "tblcommit"});
        }
    }

    private void setBidRuleInfo(DynamicObject quoBidBill) {
        IPageCache cache = this.getPageCache();
        IFormView view = this.getView();
        Date openDate = quoBidBill.getDate("opendate");
        this.getModel().setValue("opendate", (Object)openDate);
        int bidTime = quoBidBill.getInt("bidtime");
        log.info("\u7ade\u4ef7\u65f6\u957f" + bidTime);
        Label bidtimeLable = (Label)view.getControl("bidtime");
        bidtimeLable.setText(MessageFormat.format(ResManager.loadKDString((String)"{0}\u5206\u949f", (String)"QuoBidHallPlugin_2", (String)"scm-quo-formplugin", (Object[])new Object[0]), bidTime));
        int lasttime = quoBidBill.getInt("lasttime");
        if (lasttime > 0) {
            Label lasttimeLabel = (Label)view.getControl("lasttime");
            lasttimeLabel.setText(String.valueOf(lasttime));
            Label delaytimeLable = (Label)view.getControl("delaytime");
            delaytimeLable.setText(quoBidBill.getString("delaytime"));
            this.getView().setVisible(Boolean.TRUE, new String[]{"delayflexpanelap1"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"delayflexpanelap1"});
        }
        DynamicObject curr = quoBidBill.getDynamicObject("curr");
        BigDecimal bid = new BigDecimal(0);
        String sumTaxamount = String.valueOf(quoBidBill.get("sumtaxamount"));
        String sign = "";
        if (curr != null) {
            sign = curr.getString("sign");
            int precision = (Integer)curr.get("amtprecision");
            bid = new BigDecimal(sumTaxamount).setScale(precision, 4);
        } else {
            bid = new BigDecimal(sumTaxamount);
        }
        this.getModel().setValue("sumtaxamount", (Object)bid);
        Label reducetypeLable = (Label)view.getControl("reducetype");
        String reduceType = quoBidBill.getString("reducetype");
        if (reduceType.equals("A")) {
            reducetypeLable.setText(ResManager.loadKDString((String)"\u6309\u6bd4\u4f8b(%)", (String)"QuoBidHallPlugin_4", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        } else if (reduceType.equals("B")) {
            reducetypeLable.setText(MessageFormat.format(ResManager.loadKDString((String)"\u6309\u91d1\u989d({0})", (String)"QuoBidHallPlugin_5", (String)"scm-quo-formplugin", (Object[])new Object[0]), sign));
        }
        String reducePct = String.valueOf(quoBidBill.get("reducepct"));
        this.getModel().setValue("reducepct", quoBidBill.get("reducepct"));
        Label bidcountLable = (Label)view.getControl("bidcount");
        int bidCount = quoBidBill.getInt("bidcount");
        if (bidCount > 0) {
            bidcountLable.setText(MessageFormat.format(ResManager.loadKDString((String)"{0}\u6b21", (String)"QuoBidHallPlugin_6", (String)"scm-quo-formplugin", (Object[])new Object[0]), String.valueOf(quoBidBill.get("bidcount"))));
        } else {
            bidcountLable.setText(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"QuoBidHallPlugin_7", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
        String minAmount = String.valueOf(quoBidBill.get("minamount"));
        this.getModel().setValue("minamount", quoBidBill.get("minamount"));
        log.info("\u62a5\u4ef7\u6700\u4f4e\u9650\u989d" + minAmount);
        Label open2Lable = (Label)view.getControl("open2");
        boolean isOpen = quoBidBill.getBoolean("open2");
        if (isOpen) {
            open2Lable.setText(ResManager.loadKDString((String)"\u516c\u5f00\u6392\u540d", (String)"QuoBidHallPlugin_9", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        } else {
            open2Lable.setText(ResManager.loadKDString((String)"\u4e0d\u516c\u5f00\u6392\u540d", (String)"QuoBidHallPlugin_10", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
        DynamicProperty quotationtrend1 = quoBidBill.getDynamicObjectType().getProperty("quotationtrend");
        if (quotationtrend1 instanceof ComboProp) {
            String trend = quoBidBill.getString("quotationtrend");
            Label quotationtrend = (Label)view.getControl("quotationtrend");
            String itemByName = ((ComboProp)quotationtrend1).getItemByName(trend);
            if (quotationtrend != null) {
                quotationtrend.setText(itemByName);
            }
        }
        cache.put("reduceType", reduceType);
        cache.put("reducePct", reducePct);
        cache.put("bidCount", String.valueOf(bidCount));
        cache.put("sumTaxamount", sumTaxamount);
        cache.put("minAmount", minAmount);
        this.setIsLargeBaseInfo(quoBidBill);
    }

    private void setIsLargeBaseInfo(DynamicObject quoBidBill) {
        Label islargebaseLabel = (Label)this.getView().getControl("islargebase");
        boolean islargebase = quoBidBill.getBoolean("islargebase");
        if (islargebase) {
            islargebaseLabel.setText(ResManager.loadKDString((String)"\u662f", (String)"QuoBidHallPlugin_22", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        } else {
            islargebaseLabel.setText(ResManager.loadKDString((String)"\u5426", (String)"QuoBidHallPlugin_23", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
    }

    private void setSupQuoInfo(DynamicObject quoBidBill) {
        DynamicObjectCollection quoCols = quoBidBill.getDynamicObjectCollection(QUOENTRY);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        model.deleteEntryData("entryentity");
        String supplierPk = this.getSupplierPkByCurrentUser(quoBidBill);
        int quoSize = quoCols.size();
        for (int j = quoSize - 1; j >= 0; --j) {
            DynamicObject quoCol = (DynamicObject)quoCols.get(j);
            Object quoSupObj = quoCol.get("quotesupplier");
            Object quoSupplierPk = null;
            quoSupplierPk = quoSupObj instanceof DynamicObject ? ((DynamicObject)quoSupObj).getPkValue() : quoSupObj;
            if (supplierPk != null && quoSupplierPk != null && !quoSupplierPk.toString().equals(supplierPk)) continue;
            ts.set("amount", quoCol.get("quoteamount"), i);
            ts.set("reduceamt", quoCol.get("reduceamt"), i);
            ts.set("quotetime", quoCol.get("quotedate"), i);
            ts.set("suppamount", quoCol.get("quosuppamount"), i);
            ts.set("suppreduceamt", quoCol.get("suppreduceamt"), i);
            if (quoCol.get("quocurrency") != null && quoCol.get("quocurrency") instanceof DynamicObject) {
                ts.set("quocurrency", ((DynamicObject)quoCol.get("quocurrency")).getPkValue(), i);
            } else {
                ts.set("quocurrency", quoCol.get("quocurrency"), i);
            }
            ts.set("exchange", quoCol.get("exchange"), i);
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
        IFormView view = this.getView();
        int bidCount = quoBidBill.getInt("bidcount");
        StringBuilder bidCountSb = new StringBuilder();
        int restOfBidCount = 0;
        if (bidCount > 0) {
            restOfBidCount = bidCount - i;
            if (restOfBidCount < 0) {
                restOfBidCount = 0;
            }
            bidCountSb.append(MessageFormat.format(ResManager.loadKDString((String)"\uff08\u62a5\u4ef7\u6b21\u6570\u8fd8\u5269{0}\u6b21\uff09", (String)"QuoBidHallPlugin_11", (String)"scm-quo-formplugin", (Object[])new Object[0]), restOfBidCount));
        } else {
            bidCountSb.append(ResManager.loadKDString((String)"\u62a5\u4ef7\u6b21\u6570\u4e0d\u9650", (String)"QuoBidHallPlugin_12", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
        IPageCache cache = this.getPageCache();
        cache.put("restOfBidCount", String.valueOf(restOfBidCount));
        Label quotenumLable = (Label)view.getControl("quotenum");
        quotenumLable.setText(bidCountSb.toString());
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        String operateKey = ((AbstractOperate)event.getSource()).getOperateKey();
        if (event.getOperationResult() != null && event.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "add": {
                    this.add();
                    break;
                }
                case "reduce": {
                    this.reduce();
                    break;
                }
                case "commit": {
                    this.commit();
                    break;
                }
                case "refresh": {
                    this.refresh();
                    break;
                }
            }
        }
    }

    private void add() {
        this.calCommitQuoAmt(ADD);
    }

    private void reduce() {
        this.calCommitQuoAmt(REDUCE);
    }

    private void calCommitQuoAmt(String type) {
        IDataModel model = this.getModel();
        IPageCache cache = this.getPageCache();
        String reduceType = cache.get("reduceType");
        String reducePct = cache.get("reducePct");
        BigDecimal sumTaxAmount = CommonUtil.getBigDecimalPro((Object)cache.get("sumTaxamount"));
        BigDecimal beCommitQuo = CommonUtil.getBigDecimalPro((Object)model.getValue("becommitquo"));
        BigDecimal exchangerate = new BigDecimal(this.getModel().getValue("exchangerate").toString());
        int quoamtprecision = this.getQuoamtprecision("quoamtprecision");
        BigDecimal commitQuo = null;
        if (reduceType.equals("A")) {
            BigDecimal reduceAmt = sumTaxAmount.multiply(CommonUtil.getBigDecimalPro((Object)reducePct).divide(CalConstant.BIGDECIMAL_ONEHUNDRED));
            reduceAmt = reduceAmt.divide(exchangerate, quoamtprecision, RoundingMode.HALF_UP);
            if (type.equals(ADD)) {
                commitQuo = beCommitQuo.add(reduceAmt);
            } else if (type.equals(REDUCE)) {
                commitQuo = beCommitQuo.subtract(reduceAmt);
            }
        } else if (reduceType.equals("B")) {
            BigDecimal reduceAmt = CommonUtil.getBigDecimalPro((Object)reducePct);
            reduceAmt = reduceAmt.divide(exchangerate, quoamtprecision, RoundingMode.HALF_UP);
            if (type.equals(ADD)) {
                commitQuo = beCommitQuo.add(reduceAmt);
            } else if (type.equals(REDUCE)) {
                commitQuo = beCommitQuo.subtract(reduceAmt);
            }
        }
        if (commitQuo != null && commitQuo.compareTo(beCommitQuo) == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u56e0\u7cbe\u5ea6\u5f71\u54cd\u62a5\u4ef7\u672a\u53d8\u52a8\uff0c\u8bf7\u786e\u8ba4\u5bf9\u5e94\u5e01\u79cd\u7cbe\u5ea6\u3002", (String)"QuoBidHallByEntryPlugin_0", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue("becommitquo", (Object)commitQuo);
    }

    private int getQuoamtprecision(String precision) {
        int quoamtprecision = 0;
        String quoamtprecisionstr = this.getPageCache().get(precision);
        if (quoamtprecisionstr != null) {
            quoamtprecision = Integer.parseInt(quoamtprecisionstr);
        }
        return quoamtprecision;
    }

    private void commit() {
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        IDataModel model = this.getModel();
        DynamicObject bidBill = this.getQuoBidBill();
        if (bidBill == null) {
            log.info("\u83b7\u53d6\u7ade\u4ef7\u5355\u636e\u4fe1\u606f\u5931\u8d25\u3002");
            return;
        }
        String bidStatus = bidBill.getString("bidstatus");
        long restOfTime = SouBidHallUtil.getRestOfTime((DynamicObject)bidBill);
        if (!bidStatus.equals(BidStatusEnum.BIDDING.getVal()) || restOfTime <= 0L) {
            view.showMessage(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u88ab\u91c7\u8d2d\u65b9\u6682\u505c/\u7ed3\u675f/\u7ec8\u6b62\uff0c\u5982\u6709\u95ee\u9898\u8bf7\u4e0e\u91c7\u8d2d\u65b9\u6c9f\u901a\u3002", (String)"QuoBidHallPlugin_13", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            this.setRestOfTime(bidBill);
            if (restOfTime <= 0L) {
                bidBill.set("bidstatus", (Object)BidStatusEnum.EVALUATING.getVal());
                SaveServiceHelper.save((IDataEntityType)bidBill.getDataEntityType(), (Object[])new Object[]{bidBill});
            }
            return;
        }
        String bidCountStr = cache.get("bidCount");
        String restOfBidCountStr = cache.get("restOfBidCount");
        int bidCount = Integer.parseInt(bidCountStr);
        int restOfBidCount = Integer.parseInt(restOfBidCountStr);
        if (bidCount > 0 && restOfBidCount <= 0) {
            view.showMessage(ResManager.loadKDString((String)"\u60a8\u7684\u5269\u4f59\u6b21\u6570\u5df2\u7ecf\u7528\u5b8c\uff0c\u65e0\u6cd5\u518d\u6b21\u62a5\u4ef7\u4e86\u3002", (String)"QuoBidHallPlugin_14", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        BigDecimal exchangerate = new BigDecimal(this.getModel().getValue("exchangerate").toString());
        int amtprecision = this.getQuoamtprecision("settamtprecision");
        String minAmountStr = cache.get("minAmount");
        BigDecimal minAmount = CommonUtil.getBigDecimalPro((Object)minAmountStr);
        BigDecimal beCommitQuo = CommonUtil.getBigDecimalPro((Object)model.getValue("becommitquo")).setScale(amtprecision, RoundingMode.DOWN);
        BigDecimal quoteamount = beCommitQuo.multiply(exchangerate).setScale(amtprecision, RoundingMode.DOWN);
        if (minAmount.compareTo(BigDecimal.ZERO) > 0 && minAmount.compareTo(quoteamount.setScale(0, RoundingMode.DOWN)) > 0) {
            view.showMessage(ResManager.loadKDString((String)"\u60a8\u7684\u62a5\u4ef7\u4f4e\u4e8e\u6700\u4f4e\u4ef7\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"QuoBidHallPlugin_19", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            return;
        }
        if (quoteamount.compareTo(BigDecimal.ZERO) <= 0) {
            view.showMessage(ResManager.loadKDString((String)"\u60a8\u7684\u62a5\u4ef7\u4f4e\u4e8e0\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"QuoBidHallPlugin_15", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            return;
        }
        BigDecimal sumTaxamount = CommonUtil.getBigDecimalPro((Object)cache.get("sumTaxamount"));
        boolean islargebase = bidBill.getBoolean("islargebase");
        if (!islargebase && quoteamount.compareTo(sumTaxamount) > 0) {
            view.showMessage(ResManager.loadKDString((String)"\u60a8\u7684\u62a5\u4ef7\u9ad8\u4e8e\u57fa\u51c6\u62a5\u4ef7\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"QuoBidHallPlugin_16", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection quoEntrys = bidBill.getDynamicObjectCollection(QUOENTRY);
        DynamicObject entry = ORMUtil.newDynamicObject((DynamicObjectType)quoEntrys.getDynamicObjectType());
        String supplierPk = this.getSupplierPkByCurrentUser(bidBill);
        entry.set("quotesupplier", (Object)(StringUtils.isEmpty((CharSequence)supplierPk) ? 0L : Long.parseLong(supplierPk)));
        entry.set("quosuppamount", (Object)beCommitQuo);
        entry.set("quotedate", (Object)TimeServiceHelper.now());
        BigDecimal suppreduceamt = sumTaxamount.divide(exchangerate, 8, RoundingMode.HALF_UP).subtract(beCommitQuo).abs().setScale(amtprecision, RoundingMode.HALF_UP);
        entry.set("suppreduceamt", (Object)suppreduceamt);
        entry.set("quoteamount", (Object)quoteamount);
        entry.set("reduceamt", (Object)sumTaxamount.subtract(quoteamount).abs());
        entry.set("quocurrency", (Object)currency);
        entry.set("exchange", (Object)exchangerate);
        quoEntrys.add((Object)entry);
        DynamicObjectUtil.setBillEntrySeq((DynamicObject)bidBill, (String)QUOENTRY);
        this.delay(bidBill);
        SaveServiceHelper.save((IDataEntityType)bidBill.getDynamicObjectType(), (Object[])new Object[]{bidBill});
        this.setRestOfTime(bidBill);
        this.setSupQuoInfo(bidBill);
        this.setQuoInfo(bidBill);
        this.getView().setEnable(Boolean.FALSE, new String[]{"currency"});
    }

    public void delay(DynamicObject bidBill) {
        long lastTime = bidBill.getLong("lasttime") * 60L * 1000L;
        long delayTime = bidBill.getLong("delaytime") * 60L * 1000L;
        long restOfTime = SouBidHallUtil.getRestOfTime((DynamicObject)bidBill);
        Date currDate = TimeServiceHelper.now();
        if (restOfTime < lastTime) {
            bidBill.set("bidrestoftime", (Object)(restOfTime += delayTime));
            bidBill.set("pausetime", (Object)currDate);
            bidBill.set("pausestarttime", (Object)currDate);
            this.setRestOfTime(bidBill);
        }
    }

    private void setQuoInfo(DynamicObject bidBill) {
        BigDecimal beCommitQuo = this.dealNewestQuoInfo(bidBill);
        if (beCommitQuo.compareTo(BigDecimal.ZERO) == 0) {
            beCommitQuo = CommonUtil.getBigDecimalPro((Object)bidBill.get("maxamount"));
            BigDecimal exchangerate = new BigDecimal(this.getModel().getValue("exchangerate").toString());
            int quoamtprecision = this.getQuoamtprecision("quoamtprecision");
            beCommitQuo = beCommitQuo.divide(exchangerate, quoamtprecision, RoundingMode.DOWN);
        }
        this.getModel().setValue("becommitquo", (Object)beCommitQuo);
    }

    protected BigDecimal dealNewestQuoInfo(DynamicObject bidBill) {
        BigDecimal exchangerate = new BigDecimal(this.getModel().getValue("exchangerate").toString());
        int quoamtprecision = this.getQuoamtprecision("quoamtprecision");
        Map<String, BigDecimal> supQuoAmtMap = this.getSupQuoAmtMap(bidBill);
        BigDecimal newestPrice = supQuoAmtMap.remove("newestPrice");
        List<Map.Entry<String, BigDecimal>> supQuoAmtList = this.rankSupQuoAmt(supQuoAmtMap);
        int i = 1;
        IDataModel model = this.getModel();
        String supplierPk = this.getSupplierPkByCurrentUser(bidBill);
        BigDecimal beCommitQuo = BigDecimal.ZERO;
        BigDecimal currentamt = BigDecimal.ZERO;
        if (newestPrice != null) {
            currentamt = newestPrice.divide(exchangerate, quoamtprecision, RoundingMode.HALF_UP);
            model.setValue("currentamt", (Object)currentamt);
            this.getPageCache().put("currentamt", newestPrice.toString());
        }
        for (Map.Entry<String, BigDecimal> mapping : supQuoAmtList) {
            if (mapping.getKey().equals(supplierPk)) {
                beCommitQuo = mapping.getValue().divide(exchangerate, quoamtprecision, RoundingMode.HALF_UP);
                model.setValue("myamt", (Object)beCommitQuo);
                Label myorderLable = (Label)this.getView().getControl("myorder");
                boolean open2 = bidBill.getBoolean("open2");
                if (open2) {
                    myorderLable.setText(MessageFormat.format(ResManager.loadKDString((String)"\uff08\u5f53\u524d\u6392\u540d\u7b2c{0}\u4f4d\uff09", (String)"QuoBidHallPlugin_17", (String)"scm-quo-formplugin", (Object[])new Object[0]), i));
                } else {
                    myorderLable.setText(ResManager.loadKDString((String)"\uff08\u5f53\u524d\u6392\u540d\u7b2c*\u4f4d\uff09", (String)"QuoBidHallPlugin_18", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                }
            }
            ++i;
        }
        return beCommitQuo;
    }

    private void setCurrencyAndExchange(DynamicObject quoBidBill) {
        DynamicObject currency = null;
        BigDecimal exchangerate = BigDecimal.ONE;
        DynamicObjectCollection quoCols = quoBidBill.getDynamicObjectCollection(QUOENTRY);
        String supplierPk = this.getSupplierPkByCurrentUser(quoBidBill);
        for (DynamicObject quoCol : quoCols) {
            Object quoSupObj = quoCol.get("quotesupplier");
            Object quoSupplierPk = null;
            quoSupplierPk = quoSupObj instanceof DynamicObject ? ((DynamicObject)quoSupObj).getPkValue() : quoSupObj;
            if (supplierPk == null || quoSupplierPk == null || !quoSupplierPk.toString().equals(supplierPk)) continue;
            currency = quoCol.getDynamicObject("quocurrency");
            exchangerate = quoCol.getBigDecimal("exchange");
            this.getView().setEnable(Boolean.FALSE, new String[]{"currency"});
            break;
        }
        if (currency == null) {
            currency = quoBidBill.getDynamicObject("curr");
        }
        if (currency != null) {
            this.getPageCache().put("quoamtprecision", currency.getInt("amtprecision") + "");
        }
        if (exchangerate == null || exchangerate.compareTo(BigDecimal.ZERO) == 0) {
            exchangerate = BigDecimal.ONE;
        }
        if (currency != null) {
            this.getModel().setValue("currency", currency.getPkValue());
        }
        this.getModel().setValue("exchangerate", (Object)exchangerate);
    }

    private Map<String, BigDecimal> getSupQuoAmtMap(DynamicObject bidBill) {
        DynamicObjectCollection quoCols = bidBill.getDynamicObjectCollection(QUOENTRY);
        LinkedHashMap<String, BigDecimal> supQuoAmtMap = new LinkedHashMap<String, BigDecimal>();
        HashMap<String, Date> quoteDatMap = new HashMap<String, Date>();
        BigDecimal newQuoAmt = BigDecimal.ZERO;
        Date newQuoteDate = new Date();
        Date newestDate = null;
        BigDecimal newestPrice = BigDecimal.ZERO;
        for (DynamicObject quoCol : quoCols) {
            Object quoSupObj = quoCol.get("quotesupplier");
            Long quoSupplierPk = null;
            quoSupplierPk = quoSupObj instanceof DynamicObject ? (Long)((DynamicObject)quoSupObj).getPkValue() : (Long)quoSupObj;
            newQuoteDate = quoCol.getDate("quotedate");
            newQuoAmt = quoCol.getBigDecimal("quoteamount");
            if (newestDate == null) {
                newestDate = newQuoteDate;
                newestPrice = newQuoAmt;
            } else if (newestDate.compareTo(newQuoteDate) < 0) {
                newestPrice = newQuoAmt;
            }
            Date supNewQuoDate = (Date)quoteDatMap.get(String.valueOf(quoSupplierPk));
            if (supNewQuoDate == null) {
                quoteDatMap.put(String.valueOf(quoSupplierPk), newQuoteDate);
                supQuoAmtMap.put(String.valueOf(quoSupplierPk), newQuoAmt);
                continue;
            }
            if (!newQuoteDate.after(supNewQuoDate)) continue;
            quoteDatMap.put(String.valueOf(quoSupplierPk), newQuoteDate);
            supQuoAmtMap.remove(String.valueOf(quoSupplierPk));
            supQuoAmtMap.put(String.valueOf(quoSupplierPk), newQuoAmt);
        }
        supQuoAmtMap.put("newestPrice", newestPrice);
        return supQuoAmtMap;
    }

    private List<Map.Entry<String, BigDecimal>> rankSupQuoAmt(Map<String, BigDecimal> supQuoAmtMap) {
        ArrayList<Map.Entry<String, BigDecimal>> supQuoAmtList = new ArrayList<Map.Entry<String, BigDecimal>>(supQuoAmtMap.entrySet());
        Collections.sort(supQuoAmtList, new Comparator<Map.Entry<String, BigDecimal>>(){

            @Override
            public int compare(Map.Entry<String, BigDecimal> o1, Map.Entry<String, BigDecimal> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        return supQuoAmtList;
    }

    private void refresh() {
        DynamicObject bidBill = this.getQuoBidBill();
        if (null != bidBill) {
            this.setBidStatus(bidBill);
            this.setRestOfTime(bidBill);
            this.setSupQuoInfo(bidBill);
            this.setQuoInfo(bidBill);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if ("currency".equals(fieldKey)) {
            Long settCurrency = Long.valueOf(this.getPageCache().get("settCurrency"));
            IDataModel model = this.getModel();
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            if (currency != null) {
                this.setCurrency(currency);
            }
            int quoamtprecision = 0;
            if (currency != null) {
                this.getPageCache().put("quoamtprecision", currency.getInt("amtprecision") + "");
            }
            if (currency != null && settCurrency.toString().equals(currency.getPkValue().toString())) {
                model.setValue("exchangerate", (Object)BigDecimal.ONE);
                DynamicObject quoBidBill = this.getQuoBidBill();
                if (quoBidBill != null) {
                    this.setQuoInfo(quoBidBill);
                }
                return;
            }
            Long purorgpk = Long.valueOf(this.getPageCache().get("purorg"));
            if (currency != null) {
                BigDecimal currentamt;
                BigDecimal myamt;
                Object obj;
                BigDecimal exchange = BigDecimal.ONE;
                Map result = OrgUnitServiceHelper.getCompanyByOrg((Long)purorgpk);
                if (!result.isEmpty()) {
                    exchange = ExchangeHelper.getExChangeRateByOrg((Long)settCurrency, (Long)Long.valueOf(currency.getPkValue().toString()), (Long)Long.valueOf(result.get("id").toString()));
                    if (exchange == null || exchange.compareTo(BigDecimal.ZERO) == 0) {
                        exchange = BigDecimal.ONE;
                    }
                    model.setValue("exchangerate", (Object)exchange);
                }
                if ((obj = model.getValue("myamt")) != null && (myamt = new BigDecimal(obj.toString())).compareTo(BigDecimal.ZERO) == 0) {
                    quoamtprecision = currency.getInt("amtprecision");
                    BigDecimal beCommitQuo = new BigDecimal(this.getPageCache().get("maxamount"));
                    beCommitQuo = beCommitQuo.divide(exchange, quoamtprecision, RoundingMode.DOWN);
                    model.setValue("becommitquo", (Object)beCommitQuo);
                }
                if ((obj = this.getPageCache().get("currentamt")) != null && (currentamt = new BigDecimal(obj.toString())).compareTo(BigDecimal.ZERO) != 0) {
                    currentamt = currentamt.divide(exchange, quoamtprecision, RoundingMode.HALF_UP);
                    model.setValue("currentamt", (Object)currentamt);
                }
            }
        }
    }

    protected void setAutoRefreshTime(int second) {
        CountDown autorefresh_cd = (CountDown)this.getControl("autorefresh_cd");
        autorefresh_cd.setDuration(second);
    }

    protected void setCurrency(DynamicObject currency) {
        Label newquotecurrsign = (Label)this.getControl("newquotecurrsign");
        Label mynewquotecurrsign = (Label)this.getControl("mynewquotecurrsign");
        if (currency.getBoolean("isshowsign")) {
            newquotecurrsign.setText(currency.getString("sign"));
            mynewquotecurrsign.setText(currency.getString("sign"));
        } else {
            DynamicObject bdCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)currency.getPkValue(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_currency"));
            newquotecurrsign.setText(bdCurrency.getString("sign"));
            mynewquotecurrsign.setText(bdCurrency.getString("sign"));
        }
    }
}

