/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.quo.service.IQuoteToolService;
import kd.scm.quo.service.QuoteToolServiceImp;

public class QuoBidHallTrendPlugin
extends AbstractFormPlugin {
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        String name = e.getProperty().getName();
        IQuoteToolService service = this.getQuoteToolService();
        if ("quoteprice".equals(name) || "becommitquo".equals(name)) {
            String[] resultInfo = this.getSouBidBillProValue(new String[]{"taxtype", "quotationtrend", "islargebase"});
            for (ChangeData changeData : changeSet) {
                BigDecimal mid;
                BigDecimal[] result = null;
                String taxType = resultInfo[0];
                String quotationtrend = resultInfo[1];
                String islargebase = null;
                if ("becommitquo".equals(name)) {
                    islargebase = resultInfo[2];
                    result = this.dealBecommitQuoteInfo(changeData, name, islargebase);
                    if (result == null) {
                        continue;
                    }
                } else {
                    islargebase = String.valueOf(this.getModel().getValue("currislarge", changeData.getRowIndex()));
                    result = this.dealQuotePriceInfo(taxType, changeData);
                }
                BigDecimal[] prices = new BigDecimal[]{(BigDecimal)changeData.getNewValue(), result[0], result[1]};
                int vResult = service.validateQuoteTrend(prices, quotationtrend, islargebase);
                if (result.length >= 3 && (mid = result[2]) != null && mid.compareTo(BigDecimal.ONE) == 0 && vResult == 1) {
                    vResult = 2;
                }
                this.dealValidateResult(vResult, result, changeData, quotationtrend);
            }
            if ("becommitquo".equals(name)) {
                this.getView().updateView("becommitquo");
            }
        }
    }

    private BigDecimal[] dealBecommitQuoteInfo(ChangeData changeData, String name, String islargebase) {
        BigDecimal currMyPrice = (BigDecimal)this.getModel().getValue("myamt");
        BigDecimal basePrice = this.getModel().getDataEntity().getBigDecimal("sumtaxamount");
        BigDecimal[] result = new BigDecimal[3];
        if (currMyPrice == null || currMyPrice.compareTo(BigDecimal.ZERO) <= 0) {
            currMyPrice = basePrice;
            result[2] = BigDecimal.ONE;
            if (changeData.getNewValue() != null && ((BigDecimal)changeData.getNewValue()).compareTo(currMyPrice) > 0 && StringUtils.equals((CharSequence)islargebase, (CharSequence)"false")) {
                this.getModel().setValue(name, changeData.getOldValue());
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u7684\u62a5\u4ef7\u9ad8\u4e8e\u57fa\u51c6\u62a5\u4ef7\u3002", (String)"QuoBidHallTrendPlugin_1", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                return null;
            }
            if ((changeData.getNewValue() != null || changeData.getOldValue() != null) && ((BigDecimal)changeData.getOldValue()).compareTo((BigDecimal)changeData.getNewValue()) >= 0) {
                return null;
            }
        }
        result[0] = currMyPrice;
        result[1] = basePrice;
        return result;
    }

    protected BigDecimal[] dealQuotePriceInfo(String taxType, ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        BigDecimal currMyPrice = (BigDecimal)this.getModel().getValue("currmyprice", rowIndex);
        BigDecimal basePrice = null;
        BigDecimal[] result = new BigDecimal[4];
        result[2] = BigDecimal.ZERO;
        basePrice = TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType) ? (BigDecimal)this.getModel().getValue("currprice", rowIndex) : (BigDecimal)this.getModel().getValue("currtaxprice", rowIndex);
        if (currMyPrice == null || currMyPrice.compareTo(BigDecimal.ZERO) == 0) {
            currMyPrice = basePrice;
            result[2] = BigDecimal.ONE;
        }
        result[0] = currMyPrice;
        result[1] = basePrice;
        return result;
    }

    protected BigDecimal[] dealBecommitQuoteInfo(ChangeData changeData, String name) {
        return this.dealBecommitQuoteInfo(changeData, name, "false");
    }

    protected void dealValidateResult(int vResult, BigDecimal[] priceInfos, ChangeData changeData, String quotationtrend) {
        if (2 != vResult) {
            if (priceInfos.length != 4) {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                dataEntity.beginInit();
                dataEntity.set("becommitquo", changeData.getOldValue());
                dataEntity.beginInit();
            } else if (priceInfos[2].compareTo(BigDecimal.ONE) == 0) {
                this.getModel().setValue("quoteprice", (Object)priceInfos[0], changeData.getRowIndex());
            } else {
                this.getModel().setValue("quoteprice", changeData.getOldValue(), changeData.getRowIndex());
            }
            if (3 == vResult) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u7684\u62a5\u4ef7\u9ad8\u4e8e\u57fa\u51c6\u62a5\u4ef7\u3002", (String)"QuoBidHallTrendPlugin_1", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            } else if (4 == vResult) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u4ef7\u9ad8\u4e8e9999999999999\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"QuoBidHallTrendPlugin_4", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            } else if ("2".equals(quotationtrend)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u7684\u62a5\u4ef7\u4e0d\u80fd\u9ad8\u4e8e\u4e0a\u4e00\u8f6e\u62a5\u4ef7\uff0c\u8bf7\u60a8\u91cd\u65b0\u62a5\u4ef7\u3002", (String)"QuoBidHallTrendPlugin_2", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u4ef7\u4e0d\u80fd\u4f4e\u4e8e\u4e0a\u4e00\u8f6e\u62a5\u4ef7\uff0c\u8bf7\u91cd\u65b0\u62a5\u4ef7\u3002", (String)"QuoBidHallTrendPlugin_3", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected IQuoteToolService getQuoteToolService() {
        return new QuoteToolServiceImp();
    }

    protected String[] getSouBidBillProValue(String[] propertys) {
        String[] result;
        block3: {
            int i;
            block2: {
                result = new String[propertys.length];
                String value = this.getView().getPageCache().get(propertys[0]);
                i = 0;
                if (!StringUtils.isBlank((CharSequence)value)) break block2;
                FormShowParameter parameter = this.getView().getFormShowParameter();
                Map param = parameter.getCustomParams();
                Object bidBillIdObj = param.get("bidBillId");
                if (bidBillIdObj == null) break block3;
                long bidBillIdLong = Long.parseLong(bidBillIdObj.toString());
                DynamicObject objs = BusinessDataServiceHelper.loadSingle((String)"quo_bidbill", (String)StringUtils.join((Object[])propertys, (String)","), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bidBillIdLong)});
                for (String s : propertys) {
                    if (objs == null || !objs.getDynamicObjectType().getProperties().containsKey((Object)s)) continue;
                    this.getView().getPageCache().put(s, objs.getString(s));
                    result[i] = objs.getString(s);
                    ++i;
                }
                break block3;
            }
            for (String s : propertys) {
                result[i] = this.getView().getPageCache().get(s);
                ++i;
            }
        }
        return result;
    }
}

