/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.metadata.form.ControlAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.service.ExcelDataEntityServiceImp;
import kd.scm.common.service.IExcelDataEntityService;
import kd.scm.common.util.excel.ExcelDataEntity;
import kd.scm.common.util.excel.ExcelUtil;
import kd.scm.quo.formplugin.QuoToolBatchDataSheetHandler;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class QuoExport {
    private static final String PARTITION = "#";
    private IDataModel model;
    private IFormView view;
    private String entryentity;
    private String taxType;

    public QuoExport(IDataModel model, IFormView view, String entryentity, String taxType) {
        this.model = model;
        this.view = view;
        this.entryentity = entryentity;
        this.taxType = taxType;
    }

    public void export() {
        int rowcount = this.model.getEntryRowCount(this.entryentity);
        DynamicObjectCollection rows = this.model.getDataEntity().getDynamicObjectCollection(this.entryentity);
        int[] selectRows = new int[rowcount];
        for (int i = 0; i < rowcount; ++i) {
            selectRows[i] = i;
        }
        try {
            ArrayList<String> mustInputsPros = new ArrayList<String>(2);
            mustInputsPros.add("taxprice");
            mustInputsPros.add("price");
            Set<String> noNeedExportProps = this.getNoNeedExportProps();
            if ("1".equals(this.taxType) || "3".equals(this.taxType)) {
                noNeedExportProps.add("price");
            }
            if ("2".equals(this.taxType)) {
                noNeedExportProps.add("taxprice");
            }
            IExcelDataEntityService service = this.getExcelDataEntityService();
            ExcelDataEntity excelDataEntity = service.wrapExcelDataEntity(rows, items -> {
                Iterator iterator = items.iterator();
                ControlAp[] endList = new ControlAp[2];
                while (iterator.hasNext()) {
                    boolean isNotNeed;
                    ControlAp item = (ControlAp)iterator.next();
                    boolean bl = isNotNeed = noNeedExportProps.contains(item.getKey()) || item.getKey() == null || item.getKey().split("_").length > 1 && "id".equals(item.getKey().split("_")[1]);
                    if (isNotNeed) {
                        if ("note".equals(item.getKey())) {
                            item.setName(new LocaleString(MessageFormat.format("{0}{1}#{2}", item.getName().getLocaleValue(), "", item.getKey())));
                            endList[0] = item;
                        } else if ("entryid".equals(item.getKey())) {
                            item.setName(new LocaleString(MessageFormat.format("{0}{1}#{2}", item.getName().getLocaleValue(), ResManager.loadKDString((String)"(\u4e0d\u5141\u8bb8\u4fee\u6539)", (String)"QuoToolBatchImportPlugin_4", (String)"scm-quo-formplugin", (Object[])new Object[0]), item.getKey())));
                            endList[1] = item;
                        }
                        iterator.remove();
                        continue;
                    }
                    item.setName(new LocaleString(MessageFormat.format("{0}{1}#{2}", item.getName().getLocaleValue(), "", item.getKey())));
                }
                for (ControlAp entityItem : endList) {
                    if (entityItem == null) continue;
                    items.add(entityItem);
                }
                return null;
            });
            excelDataEntity.setFileName(ResManager.loadKDString((String)"\u6211\u8981\u62a5\u4ef7.xlsx", (String)"QuoToolBatchImportPlugin_2", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            ExcelUtil.exportExcel((IFormView)this.view, (ExcelDataEntity)excelDataEntity);
        }
        catch (Exception e) {
            this.view.showMessage(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002%1$s", (String)"QuoToolBatchImportPlugin_3", (String)"scm-quo-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private Set<String> getNoNeedExportProps() {
        HashSet<String> noNeedExportProps = new HashSet<String>(32);
        noNeedExportProps.add("quotecurr");
        noNeedExportProps.add("minorderqty");
        noNeedExportProps.add("purleadday");
        noNeedExportProps.add("newprice");
        noNeedExportProps.add("minprice");
        noNeedExportProps.add("maxprice");
        noNeedExportProps.add("refprice");
        noNeedExportProps.add("taxtype");
        noNeedExportProps.add("materialname");
        noNeedExportProps.add("goods");
        noNeedExportProps.add("goodsname");
        noNeedExportProps.add("goodsmodel");
        noNeedExportProps.add("goodsdesc");
        noNeedExportProps.add("quoteqty");
        noNeedExportProps.add("id");
        noNeedExportProps.add("srcentryid");
        noNeedExportProps.add("taxrateid");
        noNeedExportProps.add("taxrate");
        noNeedExportProps.add("note");
        noNeedExportProps.add("entryid");
        noNeedExportProps.add("exrate");
        noNeedExportProps.add("material");
        return noNeedExportProps;
    }

    private IExcelDataEntityService getExcelDataEntityService() {
        return new ExcelDataEntityServiceImp();
    }

    protected JSONArray parseImportData(QuoToolBatchDataSheetHandler handler) {
        JSONArray ja = new JSONArray();
        Map<Integer, Map<Integer, String>> rows = handler.getRows();
        if (rows.size() > 1) {
            ArrayList<Long> entryIds = new ArrayList<Long>();
            int entryIdInx = -1;
            int priceInx = -1;
            int noteInx = -1;
            int seqIdx = -1;
            Map<Integer, String> titleRow = rows.get(0);
            for (Map.Entry<Integer, String> entry : titleRow.entrySet()) {
                if (entry.getValue() == null || entry.getValue().split(PARTITION).length <= 1) continue;
                String colName = entry.getValue().split(PARTITION)[1];
                if ("entryid".equals(colName)) {
                    entryIdInx = entry.getKey();
                }
                if ("price".equals(colName)) {
                    priceInx = entry.getKey();
                }
                if ("taxprice".equals(colName)) {
                    priceInx = entry.getKey();
                }
                if ("note".equals(colName)) {
                    noteInx = entry.getKey();
                }
                if (!"seq".equals(colName)) continue;
                seqIdx = entry.getKey();
            }
            if (entryIdInx == -1 || priceInx == -1) {
                this.view.showErrorNotification(ResManager.loadKDString((String)"\u5f15\u5165\u6587\u4ef6\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"QuoToolBatchImportPlugin_6", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                return ja;
            }
            for (Map.Entry<Integer, Object> entry : rows.entrySet()) {
                String val;
                if (entry.getKey() <= 0 || entryIdInx <= -1 || (val = (String)((Map)entry.getValue()).get(entryIdInx)) == null) continue;
                entryIds.add(Long.valueOf(val));
            }
            DynamicObject quoteDyn = QueryServiceHelper.queryOne((String)"quo_inquiry", (String)"billno", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", entryIds)});
            if (quoteDyn != null) {
                String string = quoteDyn.getString("billno");
                for (int i = 1; i < rows.size(); ++i) {
                    JSONObject jo = new JSONObject();
                    Map<Integer, String> row = rows.get(i);
                    if (row == null) continue;
                    String price = row.get(priceInx);
                    String entryid = row.get(entryIdInx);
                    if (null == entryid) continue;
                    jo.put((Object)"inquiryNo", (Object)string);
                    jo.put((Object)"quoprice", (Object)(price == null ? "" : price));
                    jo.put((Object)"entryid", (Object)entryid);
                    jo.put((Object)"seq", (Object)row.get(seqIdx));
                    jo.put((Object)"note", (Object)row.get(noteInx));
                    ja.add((Object)jo);
                }
            }
        }
        return ja;
    }
}

