/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.CommonUtil;

public class QuoNoticeQueryPlugin
extends AbstractFormPlugin {
    public static final String JUMP_NOTICEID = "noticeId";
    public static final String formId = "sou_notice";
    public static final String JUMP_BIZTYPE = "biztype";

    public void afterBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String id = (String)customParams.get(JUMP_NOTICEID);
        if (StringUtils.isBlank((CharSequence)id) && formShowParameter instanceof BillShowParameter) {
            Object pkId = ((BillShowParameter)formShowParameter).getPkId();
            id = String.valueOf(pkId);
        }
        String noticeName = (String)customParams.get("noticeName");
        if (id != null && !"null".equals(id)) {
            String selectFields = "noticetitle,billdate,duedate,supscope,biztype,billstatus,content,id,billno,remark,org,srcbillno,srcbilltype";
            long noticeId = Long.parseLong(id);
            QFilter filter = new QFilter("id", "=", (Object)noticeId);
            DynamicObject o = QueryServiceHelper.queryOne((String)formId, (String)selectFields, (QFilter[])new QFilter[]{filter});
            if (o != null) {
                String biztype = o.getString(JUMP_BIZTYPE);
                this.getView().getPageCache().put(JUMP_BIZTYPE, o.getString(JUMP_BIZTYPE));
                this.getView().getPageCache().put("srcbillno", o.getString("srcbillno"));
                this.getView().getPageCache().put("srcbilltype", o.getString("srcbilltype"));
                String billFormId = this.getBillFormId(noticeName, biztype);
                if (StringUtils.isBlank((CharSequence)billFormId) && !"C".equals(biztype)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"srcbaritemap"});
                } else if ("C".equals(biztype)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"srcbaritemap"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"baritemap"});
                    this.getView().setVisible(Boolean.FALSE, new String[]{"srcbaritemap"});
                }
                this.getModel().setValue("noticetitle", (Object)o.getString("noticetitle"));
                this.getModel().setValue("billno", (Object)o.getString("billno"));
                this.getModel().setValue("billdate", (Object)o.getString("billdate"));
                this.getModel().setValue("duedate", (Object)o.getString("duedate"));
                this.getModel().setValue("supscope", (Object)o.getString("supscope"));
                this.getModel().setValue(JUMP_BIZTYPE, (Object)o.getString(JUMP_BIZTYPE));
                this.getModel().setValue("billstatus", (Object)o.getString("billstatus"));
                this.getModel().setValue("remark", (Object)o.getString("remark"));
                this.getModel().setValue("org", (Object)o.getString("org"));
                RichTextEditor html = (RichTextEditor)this.getView().getControl("richtexteditor");
                html.setText(o.getString("content"));
                String pkId = o.getString("id");
                String attachKey = "attachmentpanel";
                AttachmentPanel attach = (AttachmentPanel)this.getView().getControl("attachmentpanel");
                boolean enableTempAccess = false;
                attach.bindData(AttachmentServiceHelper.getAttachments((String)formId, (Object)pkId, (String)attachKey, (boolean)enableTempAccess));
                this.getView().setStatus(OperationStatus.VIEW);
                this.getModel().setDataChanged(false);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"QuoNoticeQueryPlugin_0", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            }
        } else {
            super.afterBindData(e);
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap"});
            RichTextEditor html = (RichTextEditor)this.getView().getControl("richtexteditor");
            html.setText(this.getModel().getDataEntity().getString("content"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String operateKey = ((AbstractOperate)e.getSource()).getOperateKey();
        Map customParams = this.getView().getFormShowParameter().getShowParameter().getCustomParams();
        switch (operateKey) {
            case "donothing": {
                String noticeName = (String)customParams.get("noticeName");
                String biztype = this.getView().getPageCache().get(JUMP_BIZTYPE);
                String srcBillNo = this.getView().getPageCache().get("srcbillno");
                ListShowParameter parameter = new ListShowParameter();
                String billFormId = this.getBillFormId(noticeName, biztype);
                if (!StringUtils.isNotBlank((CharSequence)billFormId)) break;
                long userId = RequestContext.get().getCurrUserId();
                QFilter qFilter = new QFilter("id", "=", (Object)userId).and(new QFilter("usertype", "=", (Object)"3"));
                DynamicObjectCollection Dynamic = QueryServiceHelper.query((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{qFilter});
                if (Dynamic.size() == 0) {
                    String url = CommonUtil.getDomainUrlWidthouSlash() + "/login.html";
                    this.getView().openUrl(url);
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)srcBillNo)) {
                    parameter.getCustomParams().put("srcbillno", srcBillNo);
                    if (!"3".equals(biztype) && !"1".equals(biztype)) {
                        parameter.getListFilterParameter().getQFilters().add(new QFilter("billno", "=", (Object)srcBillNo));
                    }
                }
                parameter.setBillFormId(billFormId);
                parameter.getOpenStyle().setTargetKey("_submaintab_");
                parameter.getOpenStyle().setShowType(ShowType.NewWindow);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
        }
    }

    private String getBillFormId(String noticeName, String biztype) {
        String billFormId = "";
        if ("quo_inquiry".equals(noticeName) || StringUtils.equals((CharSequence)"1", (CharSequence)biztype)) {
            billFormId = "quo_inquiry";
        } else if ("quo_bidbill".equals(noticeName) || StringUtils.equals((CharSequence)"3", (CharSequence)biztype)) {
            billFormId = "quo_bidbill";
        } else if (StringUtils.equals((CharSequence)"C", (CharSequence)biztype)) {
            billFormId = "tnd_project";
        } else if (StringUtils.isBlank((CharSequence)noticeName)) {
            billFormId = "";
        }
        return billFormId;
    }
}

