/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DynamicObjectUtil;

public class QuoNoticeReplyPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(QuoNoticeReplyPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        String supscope = (String)model.getValue("supscope");
        if (!"2".equals(supscope) || "tnd".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"replybutton"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"reply_info"});
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        this.updateReplyStatus();
        this.setSupplierInfo();
        this.setReplyInfo();
        this.judgeReply();
    }

    private void judgeReply() {
        DynamicObjectCollection replyEntrys = this.getModel().getDataEntity().getDynamicObjectCollection("replyentity");
        DynamicObjectCollection supplierEntrys = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
        boolean replyFlag = true;
        if (replyEntrys.size() != 0) {
            HashSet<Long> supplierIdSet = new HashSet<Long>();
            for (DynamicObject supEntry : replyEntrys) {
                DynamicObject supplier = supEntry.getDynamicObject("supplier1");
                Long supplierId = (Long)supplier.getPkValue();
                supplierIdSet.add(supplierId);
            }
            if (supplierIdSet.size() < supplierEntrys.size()) {
                replyFlag = false;
            }
        } else {
            replyFlag = false;
        }
        if (replyFlag) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"replybutton"});
        }
    }

    private void updateReplyStatus() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
        List<Long> supIdList = this.getSupplierIds();
        if (supIdList.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"replybutton"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"reply_info"});
        }
        this.getTargetSupIdList(supIdList);
        for (DynamicObject dynamicObject : entryentity) {
            DynamicObject supplier = dynamicObject.getDynamicObject("supplier");
            if (!supIdList.contains(supplier.getLong("id"))) continue;
            dynamicObject.set("replystatus", (Object)"3");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
    }

    private List<Long> getSupplierIds() {
        ArrayList<Long> supIdList = new ArrayList();
        try {
            supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        }
        catch (Exception e) {
            logger.error("notice reply error info : " + e.getMessage());
        }
        return supIdList;
    }

    private void getTargetSupIdList(List<Long> supIdList) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        QFilter qFilter = new QFilter("id", "=", (Object)dataEntity.getLong("id"));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"quo_notice", (String)"entryentity,entryentity.supplier", (QFilter[])new QFilter[]{qFilter});
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        ArrayList<Long> idList = new ArrayList<Long>(entryentity.size());
        for (DynamicObject supEntry : entryentity) {
            DynamicObject supplier = supEntry.getDynamicObject("supplier");
            idList.add(supplier.getLong("id"));
        }
        supIdList.removeIf(id -> !idList.contains(id));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String operateKey = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("reply".equals(operateKey)) {
            String currentStatus = this.queryStatus();
            if (!"C".equalsIgnoreCase(currentStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u516c\u544a\u76ee\u524d\u4e0d\u662f\u53ef\u7b54\u590d\u72b6\u6001\u3002", (String)"QuoNoticeReplyPlugin_0", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
            paramMap.put("billId", this.getModel().getDataEntity().getPkValue());
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"quo_notice_reply", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "noticeReply"), (ShowType)ShowType.Modal));
        }
    }

    private String queryStatus() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long billid = dataEntity.getLong("id");
        QFilter qFilter = new QFilter("id", "=", (Object)billid);
        DynamicObject quoNotice = BusinessDataServiceHelper.loadSingle((String)"quo_notice", (String)"billstatus", (QFilter[])new QFilter[]{qFilter});
        return quoNotice == null ? null : quoNotice.getString("billstatus");
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        IFormView view = this.getView();
        BillModel model = (BillModel)this.getModel();
        model.load(model.getPKValue());
        String actionId = closedCallBackEvent.getActionId();
        if ("noticeReply".equals(actionId)) {
            this.setSupplierInfo();
            this.setReplyInfo();
            view.updateView("replyentity");
        }
        this.judgeReply();
    }

    private void setSupplierInfo() {
        this.setEntryBySpplier("entryentity", "supplier");
    }

    private void setReplyInfo() {
        this.setEntryBySpplier("replyentity", "supplier1");
    }

    private void setEntryBySpplier(String entyrName, String supplierName) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject bill = model.getDataEntity(true);
        DynamicObjectCollection cols = bill.getDynamicObjectCollection(entyrName);
        TableValueSetter ts = new TableValueSetter(new String[0]);
        List<Long> supIdList = this.getSupplierIds();
        if (!cols.isEmpty()) {
            List propertiesEntity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)((EntryProp)model.getDataEntityType().findProperty(entyrName)).getDynamicCollectionItemPropertyType());
            int i = 0;
            DataEntityPropertyCollection properties = cols.getDynamicObjectType().getProperties();
            for (DynamicObject col : cols) {
                DynamicObject supplier = col.getDynamicObject(supplierName);
                if (supplier == null || supIdList.isEmpty() || !supIdList.contains(supplier.getPkValue())) continue;
                for (IDataEntityProperty entityType : properties) {
                    String proName = entityType.getName().toLowerCase();
                    Object value = entityType.getValue((Object)col);
                    if (!propertiesEntity.contains(proName)) continue;
                    ts.set(proName, value, i);
                }
                ts.set("seq", (Object)(i + 1), i);
                ts.set(supplierName, supplier.getPkValue(), i);
                ++i;
            }
        }
        model.deleteEntryData(entyrName);
        model.batchCreateNewEntryRow(entyrName, ts);
        model.setDataChanged(false);
    }
}

