/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin;

import java.math.BigDecimal;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.common.enums.TaxTypeEnum;

public class QuoQuotePrice {
    private static BigDecimal HUNDRED = new BigDecimal(100);
    private BigDecimal inputPrice;
    private String taxType;
    private BigDecimal taxRate;
    private boolean isLegal;
    private String errorMessage;
    private boolean isLarge = false;

    public void setLarge(boolean large) {
        this.isLarge = large;
    }

    public QuoQuotePrice(BigDecimal inputPrice, String taxType, BigDecimal zero, DynamicObject object) {
        this.init(inputPrice, taxType, zero, object);
    }

    public QuoQuotePrice(BigDecimal inputPrice, String taxType, BigDecimal zero, DynamicObject object, Boolean isLarge) {
        this.isLarge = isLarge;
        this.init(inputPrice, taxType, zero, object);
    }

    private final void init(BigDecimal inputPrice, String taxType, BigDecimal zero, DynamicObject object) {
        this.inputPrice = inputPrice;
        this.taxType = taxType;
        if (Objects.isNull(object)) {
            this.isLegal = false;
            this.taxRate = BigDecimal.ZERO;
            this.errorMessage = null;
            return;
        }
        DynamicObjectType dynamicType = object.getDynamicObjectType();
        DataEntityPropertyCollection properties = dynamicType.getProperties();
        BigDecimal taxrate = null;
        if (properties.containsKey((Object)"currtaxrate")) {
            taxrate = object.getBigDecimal("currtaxrate");
        }
        BigDecimal currPrice = null;
        currPrice = !this.intax() ? object.getBigDecimal("currprice") : object.getBigDecimal("currtaxprice");
        BigDecimal bigDecimal = this.taxRate = taxrate == null ? BigDecimal.ZERO : taxrate.divide(HUNDRED, 4);
        if (inputPrice.compareTo(BigDecimal.ZERO) <= 0) {
            this.isLegal = false;
            this.errorMessage = ResManager.loadKDString((String)"\u60a8\u7684\u62a5\u4ef7\u4f4e\u4e8e0\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"QuoBidHallPlugin_15", (String)"scm-quo-formplugin", (Object[])new Object[0]);
        } else if (inputPrice.compareTo(zero) < 0) {
            this.isLegal = false;
            this.errorMessage = ResManager.loadKDString((String)"\u60a8\u7684\u62a5\u4ef7\u4f4e\u4e8e\u6700\u4f4e\u4ef7\u65e0\u6cd5\u63d0\u4ea4\u3002", (String)"QuoBidHallPlugin_19", (String)"scm-quo-formplugin", (Object[])new Object[0]);
        } else if (!this.isLarge && inputPrice.compareTo(currPrice) > 0) {
            this.isLegal = false;
            this.errorMessage = ResManager.loadKDString((String)"\u60a8\u7684\u62a5\u4ef7\u9ad8\u4e8e\u57fa\u51c6\u62a5\u4ef7\u4e0d\u80fd\u63d0\u4ea4\u3002", (String)"QuoBidHallPlugin_16", (String)"scm-quo-formplugin", (Object[])new Object[0]);
        } else {
            this.isLegal = true;
            this.errorMessage = null;
        }
    }

    public BigDecimal getPrice() {
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(this.taxType)) {
            return this.inputPrice.divide(BigDecimal.ONE.add(this.taxRate), 4);
        }
        if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(this.taxType)) {
            return this.inputPrice;
        }
        if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(this.taxType)) {
            return this.inputPrice.setScale(this.inputPrice.scale(), 4).multiply(BigDecimal.ONE.subtract(this.taxRate));
        }
        return this.inputPrice;
    }

    public boolean isIntax() {
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(this.taxType)) {
            return true;
        }
        if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(this.taxType)) {
            return false;
        }
        if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(this.taxType)) {
            return true;
        }
        return true;
    }

    private boolean intax() {
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(this.taxType)) {
            return true;
        }
        if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(this.taxType)) {
            return false;
        }
        if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(this.taxType)) {
            return true;
        }
        return true;
    }

    public BigDecimal getTaxPrice() {
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(this.taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(this.taxType)) {
            return this.inputPrice;
        }
        if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(this.taxType)) {
            return this.inputPrice.setScale(this.inputPrice.scale(), 4).multiply(BigDecimal.ONE.add(this.taxRate));
        }
        return this.inputPrice;
    }

    public boolean isLegal() {
        return this.isLegal;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

