/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.SupBidStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DynamicObjectUtil;

public class QuoSelectBidBillPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String SUPQUOENTRY = "supquoentry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IFormView view = this.getView();
        EntryGrid checkSumGrid = (EntryGrid)view.getControl("entryentity");
        checkSumGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection bidBillObjs = this.getBidBillData();
        this.setBidBillInfo(bidBillObjs);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        switch (operateKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "refresh": {
                AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
                model.deleteEntryData("entryentity");
                DynamicObjectCollection bidBillObjs = this.getBidBillData();
                this.setBidBillInfo(bidBillObjs);
                break;
            }
        }
    }

    private DynamicObjectCollection getBidBillData() {
        Map supplierMap = BizPartnerUtil.getSupplierWithEnableStatusByUserOfBizPartner();
        ArrayList enableSupplier = new ArrayList(supplierMap.size());
        for (Map.Entry entry : supplierMap.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            enableSupplier.add(entry.getKey());
        }
        QFilter status = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        QFilter bidstatus = new QFilter("bidstatus", "!=", (Object)BidStatusEnum.ENROLMENT.getVal());
        QFilter bidstatus2 = new QFilter("bidstatus", "!=", (Object)" ");
        QFilter entrysupplier = null;
        entrysupplier = enableSupplier.isEmpty() ? new QFilter("supquoentry.entrysupplier", "in", new HashSet(supplierMap.keySet())) : new QFilter("biztype", "=", (Object)"1").or(new QFilter("biztype", "!=", (Object)"1").and(new QFilter("supquoentry.entrysupplier", "in", new HashSet(supplierMap.keySet()))));
        List orgIdList = PermissionServiceHelper.getAllPermissionOrgs((Long)Long.valueOf(RequestContext.get().getUserId()), null, (String)"quo_bidbill", (String)"47150e89000000ac");
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"quo_bidbill", (String)"billno,name,opendate,id,bidstatus", (QFilter[])new QFilter[]{status, bidstatus, bidstatus2, entrysupplier, new QFilter("org", "in", (Object)orgIdList)}, (String)"opendate desc,billno");
        return objs;
    }

    private void setBidBillInfo(DynamicObjectCollection bidBillObjs) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter ts = new TableValueSetter(new String[0]);
        int i = 0;
        model.deleteEntryData("entryentity");
        if (bidBillObjs.size() == 0) {
            return;
        }
        DynamicObject row = (DynamicObject)bidBillObjs.get(0);
        IDataEntityProperty bidBillNameProperty = (IDataEntityProperty)row.getDynamicObjectType().getProperties().get((Object)"name");
        IDataEntityProperty openDateProperty = (IDataEntityProperty)row.getDynamicObjectType().getProperties().get((Object)"opendate");
        IDataEntityProperty bidStatusProperty = (IDataEntityProperty)row.getDynamicObjectType().getProperties().get((Object)"bidstatus");
        String lastBillno = null;
        String billno = null;
        for (DynamicObject bidBillObj : bidBillObjs) {
            billno = bidBillObj.getString("billno");
            if (billno != null && billno.equals(lastBillno)) continue;
            Object bidStatus = bidStatusProperty.getValueFast((Object)bidBillObj);
            BidStatusEnum bidStatusEnum = BidStatusEnum.fromVal((String)bidStatus.toString());
            ts.set("billno", (Object)billno, i);
            ts.set("billname", bidBillNameProperty.getValueFast((Object)bidBillObj), i);
            ts.set("opendate", openDateProperty.getValueFast((Object)bidBillObj), i);
            ts.set("bidstatus", (Object)bidStatusEnum.getName(), i);
            ts.set("bidbillid", (Object)bidBillObj.getLong("id"), i);
            lastBillno = billno;
            ++i;
        }
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    public void hyperLinkClick(HyperLinkClickEvent heperLinkEvent) {
        EntryGrid grid = (EntryGrid)heperLinkEvent.getSource();
        String gridKey = grid.getKey();
        DynamicObject selectedObj = grid.getModel().getEntryRowEntity(gridKey, heperLinkEvent.getRowIndex());
        IFormView view = this.getView();
        if (selectedObj != null) {
            long billBidId = selectedObj.getLong("bidbillid");
            String selectFields = DynamicObjectUtil.getSelectfields((String)"sou_bidbill", (boolean)false);
            DynamicObjectCollection souBidHallDC = QueryServiceHelper.query((String)"sou_bidbill", (String)(selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"sou_bidbill", (String)SUPQUOENTRY, (boolean)false)), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billBidId)});
            DynamicObject supplierDO = this.getCurrUserQuoSupEntry(souBidHallDC);
            if (!this.checkUserIsEnroll(supplierDO)) {
                view.showMessage(ResManager.loadKDString((String)"\u60a8\u5c1a\u672a\u62a5\u540d\u53c2\u4e0e\u8be5\u9879\u76ee\u7684\u7ade\u4ef7\uff0c\u8bf7\u5230\u201c\u7ade\u4ef7\u67e5\u8be2\u201d\u4e2d\u8fdb\u884c\u62a5\u540d\u3002", (String)"QuoSelectBidBillPlugin_0", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.checkHasOrgPerm(supplierDO)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u8bf7\u9009\u62e9\u7ade\u4ef7\u9879\u76ee\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"QuoSelectBidBillPlugin_4", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.isQualify(supplierDO)) {
                view.showMessage(ResManager.loadKDString((String)"\u8d44\u5ba1\u672a\u901a\u8fc7\u65e0\u6cd5\u8fdb\u5165\u7ade\u4ef7\u5927\u5385\u3002", (String)"QuoSelectBidBillPlugin_1", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.checkIsRecDeposit(supplierDO)) {
                view.showMessage(ResManager.loadKDString((String)"\u5f88\u9057\u61be\uff0c\u672a\u7f34\u7eb3\u4fdd\u8bc1\u91d1\u65e0\u6cd5\u8fdb\u5165\u7ade\u4ef7\u5927\u5385\u3002", (String)"QuoSelectBidBillPlugin_2", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                return;
            }
            String bidStatus = supplierDO.getString("bidstatus");
            if (BidStatusEnum.ENROLMENT.getVal().equals(bidStatus) || BidStatusEnum.BEENEXAMINED.getVal().equals(bidStatus) || BidStatusEnum.DEADLINE.getVal().equals(bidStatus)) {
                view.showMessage(ResManager.loadKDString((String)"\u9879\u76ee\u72b6\u6001\u4e3a\u62a5\u540d\u4e2d\uff0c\u62a5\u540d\u622a\u6b62\u6216\u5df2\u8d44\u5ba1\u7684\u65e0\u6cd5\u8fdb\u5165\u7ade\u4ef7\u5927\u5385\u3002", (String)"QuoSelectBidBillPlugin_3", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Long> paramMap = new HashMap<String, Long>();
            paramMap.put("bidBillId", billBidId);
            String quotemode = supplierDO.getString("quotemode");
            if (StringUtils.equals((CharSequence)quotemode, (CharSequence)"2")) {
                view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"quo_bidhallbyentry", paramMap, null, (ShowType)ShowType.MainNewTabPage));
            } else {
                view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"quo_bidhall", paramMap, null, (ShowType)ShowType.MainNewTabPage));
            }
        }
    }

    private boolean checkHasOrgPerm(DynamicObject obj) {
        if (obj == null) {
            return false;
        }
        List orgIdList = PermissionServiceHelper.getAllPermissionOrgs((Long)RequestContext.get().getCurrUserId(), null, (String)"quo_itemselect", (String)"47150e89000000ac");
        long org = obj.getLong("org.id");
        return orgIdList.contains(org);
    }

    private boolean checkIsRecDeposit(DynamicObject obj) {
        if (obj == null) {
            return false;
        }
        BigDecimal cashDeposit = obj.getBigDecimal("cashdeposit");
        if (cashDeposit.compareTo(BigDecimal.ZERO) == 0) {
            return true;
        }
        Object suppaydate = obj.get("supquoentry.suppaydate");
        return suppaydate != null;
    }

    private boolean isQualify(DynamicObject obj) {
        if (obj == null) {
            return false;
        }
        String checkType = obj.getString("checktype");
        if (checkType != null && "3".equals(checkType.toString())) {
            return true;
        }
        Object supEntryStatus = obj.get("supquoentry.supentrystatus");
        return supEntryStatus == null || !supEntryStatus.equals(SupBidStatusEnum.HAVEREFUSED.getVal());
    }

    private boolean checkUserIsEnroll(DynamicObject obj) {
        return obj != null;
    }

    private DynamicObject getCurrUserQuoSupEntry(DynamicObjectCollection objs) {
        List suppliers = BizPartnerUtil.getSupplierByUserOfBizPartner();
        for (DynamicObject col : objs) {
            long supEnroll = col.getLong("supquoentry.supenroll");
            long entrysupplier = col.getLong("supquoentry.entrysupplier");
            if (entrysupplier == 0L || supEnroll == 0L || suppliers == null || !suppliers.contains(entrysupplier)) continue;
            return col;
        }
        return null;
    }
}

