/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.plugin.AbstractQuoFormPlugin;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.quo.formplugin.QuoExport;
import kd.scm.quo.formplugin.QuoToolBatchDataSheetHandler;
import net.sf.json.JSONArray;

public class QuoToolBatchImportPlugin
extends AbstractQuoFormPlugin
implements UploadListener {
    private static final String IMPORTDATA = "importData";
    private Log log = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolBar = (Toolbar)this.getControl("tbmain");
        toolBar.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
        super.upload(evt);
        if ("barimport".equals(evt.getCallbackKey())) {
            QuoToolBatchDataSheetHandler handler = this.getQuoToolBatchDataSheetHandler(evt);
            this.importData(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QuoToolBatchDataSheetHandler getQuoToolBatchDataSheetHandler(UploadEvent evt) {
        String url = (String)evt.getUrls()[0];
        this.log.info("@@uplaodurl:" + url);
        ExcelReader reader = new ExcelReader();
        QuoToolBatchDataSheetHandler handler = new QuoToolBatchDataSheetHandler();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            fileService.download(url, (OutputStream)outStream, "httpclient");
            ByteArrayInputStream input = new ByteArrayInputStream(outStream.toByteArray());
            reader.read((InputStream)input, (SheetHandler)handler);
        }
        catch (Exception e) {
            this.log.info(e.toString());
        }
        finally {
            try {
                ((OutputStream)outStream).close();
            }
            catch (IOException e) {
                this.log.info(e.getMessage());
            }
        }
        return handler;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result == null || !result.isSuccess()) {
            return;
        }
        if ("quoexport".equals(afterDoOperationEventArgs.getOperateKey())) {
            try {
                this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5f15\u51fa\u4e2d", (String)"QuoToolBatchImportPlugin_0", (String)"scm-quo-formplugin", (Object[])new Object[0])));
                String taxTpye = (String)this.getModel().getValue("taxtype1");
                new QuoExport(this.getModel(), this.getView(), "detail_entryentity", taxTpye).export();
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    public void importData(QuoToolBatchDataSheetHandler handler) {
        Map<Integer, Map<Integer, String>> rows = handler.getRows();
        try {
            if (rows.size() > 1) {
                String taxTpye = (String)this.getModel().getValue("taxtype1");
                JSONArray ja = new QuoExport(this.getModel(), this.getView(), "detail_entryentity", taxTpye).parseImportData(handler);
                this.getPageCache().put(IMPORTDATA, ja.toString());
            } else {
                this.getPageCache().remove(IMPORTDATA);
            }
        }
        catch (Exception e) {
            this.getPageCache().remove(IMPORTDATA);
            this.log.error(ExceptionUtil.getStackTrace((Throwable)e));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f15\u5165\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"QuoToolBatchImportPlugin_1", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
    }
}

