/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillEntryStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.enums.BizStatusEnum;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.plugin.AbstractQuoFormPlugin;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BillPushAssistUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.InquiryUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.ValidateMatchUtil;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.quo.common.QuoInquiryUtil;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class QuoToolBatchPlugin
extends AbstractQuoFormPlugin
implements TreeNodeClickListener,
HyperLinkClickListener,
RowClickEventListener,
UploadListener,
TabSelectListener {
    private static final String HEAD_ENTRY_ENTITY = "head_entryentity";
    private static final String DETAIL_ENTRY_ENTITY = "detail_entryentity";
    private static final String RECENT_PRICE_ENTITY = "recentprice_entry";
    private static final String QUOTE_PRICE_PRICE_ENTITY = "quoteprice_entry";
    private static final String IS_TREE_NODE_CLICK = "isTreeNodeClick";
    private static final String CURRENCY_QUO_BILL_NO = "currencybillno";
    private static final String STATUS_TAB = "tabap2";
    private static final String STATUS_ALL = "tabpageap1";
    private static final String STATUS_QUOTED = "tabpageap5";
    private static final String STATUS_HAVENOT_QUOTE = "tabpageap6";
    private static Log log = LogFactory.getLog(QuoToolBatchPlugin.class);
    private static final String MATERIAL_CODE = "materialcode";
    private static final String MATIRIAL_MODEL = "materielmodel";
    private static final String QUOTE_QTY = "quoteqty";
    private static final String LATEST_PRICE = "latestprice";
    private static final String REF_PRICE = "refprice";
    private static final String GOODS_NAME = "goodsname";
    private static final String GOODS_MODEL = "goodsmodel";
    private static final String GOODS_DESC = "goodsdesc";
    private static final String PRI_BILLNO = "prbillno";
    public static final String MIN_PRICE = "minprice";
    public static final String MAX_PRICE = "maxprice";
    public static final String NEW_PRICE = "newprice";

    public void initialize() {
        super.initialize();
        this.getView().getPageCache().put("BOS.setRowDataByNumberAutoAddRow", "false");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        EntryGrid grid = (EntryGrid)this.getView().getControl(DETAIL_ENTRY_ENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Toolbar toolBar = (Toolbar)this.getControl("tbmain");
        toolBar.addUploadListener((UploadListener)this);
        EntryGrid materialentry = (EntryGrid)this.getControl(DETAIL_ENTRY_ENTITY);
        materialentry.addHyperClickListener((HyperLinkClickListener)this);
        Tab tab = (Tab)this.getView().getControl(STATUS_TAB);
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String isNode = this.getPageCache().get(IS_TREE_NODE_CLICK);
        if (null == isNode || isNode.equals("0")) {
            this.initAllTreeNodes();
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        IPageCache cache = this.getPageCache();
        Object inquiryBillNo = param.get("inquiryBillNo");
        if (inquiryBillNo != null) {
            cache.put("billno", inquiryBillNo.toString());
            cache.put("statusFilter", "false");
            this.allotDynamicData(inquiryBillNo.toString());
        } else {
            cache.put("newToolPage", "true");
            this.getView().setEnable(Boolean.FALSE, new String[]{"barexport"});
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        if (null != nodeId) {
            String nodeIdStr = nodeId.toString();
            IPageCache cache = this.getPageCache();
            cache.put(IS_TREE_NODE_CLICK, "1");
            if ("0".equals(nodeIdStr)) {
                cache.remove(CURRENCY_QUO_BILL_NO);
                this.clearData();
                this.getView().setEnable(Boolean.FALSE, new String[]{"barexport"});
            } else {
                cache.put(CURRENCY_QUO_BILL_NO, nodeIdStr);
                cache.put("statusFilter", "false");
                this.allotDynamicData(nodeIdStr);
            }
        }
    }

    private void clearData() {
        IDataModel model = this.getModel();
        model.deleteEntryData(RECENT_PRICE_ENTITY);
        model.deleteEntryData(QUOTE_PRICE_PRICE_ENTITY);
        model.deleteEntryData(DETAIL_ENTRY_ENTITY);
        Container headContainer = (Container)this.getControl(HEAD_ENTRY_ENTITY);
        List inquirybaseList = DynamicObjectUtil.getContainerProperties((Container)headContainer);
        for (int i = 0; i < inquirybaseList.size(); ++i) {
            model.setValue((String)inquirybaseList.get(i), null);
        }
    }

    private void initAllTreeNodes() {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        Tab tab = (Tab)this.getView().getControl(STATUS_TAB);
        String currentTab = tab.getCurrentTab();
        String nodeRemark = "";
        if (STATUS_QUOTED.equals(currentTab)) {
            nodeRemark = ResManager.loadKDString((String)"\uff08\u5f53\u524d\u8f6e\u6b21\u672a\u62a5\u4ef7\uff09", (String)"QuoToolBatchPlugin_24", (String)"scm-quo-formplugin", (Object[])new Object[0]);
        } else if (STATUS_HAVENOT_QUOTE.equals(currentTab)) {
            nodeRemark = ResManager.loadKDString((String)"\uff08\u5f53\u524d\u8f6e\u6b21\u5df2\u62a5\u4ef7\u4f46\u672a\u622a\u6b62\uff09", (String)"QuoToolBatchPlugin_25", (String)"scm-quo-formplugin", (Object[])new Object[0]);
        }
        TreeNode node = new TreeNode("", "0", String.format(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u53f7%1$s", (String)"QuoToolBatchPlugin_0", (String)"scm-quo-formplugin", (Object[])new Object[0]), nodeRemark));
        treeView.deleteAllNodes();
        treeView.addNode(node);
        treeView.focusNode(node);
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushToQuoBill(String billNo, DynamicObjectCollection coll) {
        HashMap<Long, HashMap<String, Object>> priceMaps = new HashMap<Long, HashMap<String, Object>>();
        HashMap<String, Long> supplierMap = new HashMap<String, Long>();
        Long supplier = (Long)this.getModel().getValue("supplier_id");
        supplierMap.put("supplier", supplier);
        for (DynamicObject dynamicObject : coll) {
            long materialEntryId = dynamicObject.getLong("entryid");
            if (0L == materialEntryId) continue;
            String taxType = dynamicObject.getString("taxtype");
            BigDecimal price = dynamicObject.getBigDecimal("price");
            BigDecimal taxPrice = dynamicObject.getBigDecimal("taxprice");
            BigDecimal taxRate = dynamicObject.getBigDecimal("taxrate");
            DynamicObject taxRateObj = dynamicObject.getDynamicObject("taxrateid");
            Object taxRateId = null == taxRateObj ? null : taxRateObj.getPkValue();
            BigDecimal quoteQty = dynamicObject.getBigDecimal(QUOTE_QTY);
            String note = dynamicObject.getString("note");
            Object minorderqty = dynamicObject.get("minorderqty");
            Object purleadday = dynamicObject.get("purleadday");
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("price", price);
            dataMap.put("taxprice", taxPrice);
            dataMap.put("taxrate", taxRate);
            dataMap.put("taxrateid", taxRateId);
            dataMap.put("note", note);
            dataMap.put("qty", quoteQty);
            dataMap.put("taxtype", taxType);
            dataMap.put("minorderqty", minorderqty);
            dataMap.put("purleadday", purleadday);
            Set<String> standardProps = QuoToolBatchPlugin.initStandardProp();
            DataEntityPropertyCollection properties = dynamicObject.getDynamicObjectType().getProperties();
            for (IDataEntityProperty property : properties) {
                String propertyName = property.getName();
                if (standardProps.contains(propertyName)) continue;
                dataMap.put(propertyName, dynamicObject.get(propertyName));
            }
            this.putMultCurrencyInfo(dataMap, dynamicObject);
            priceMaps.put(materialEntryId, dataMap);
        }
        Map resultMap = null;
        IFormView view = this.getView();
        boolean flag = false;
        try {
            resultMap = BillPushAssistUtil.pushBill((String)billNo, (String)"sou_inquiry", (String)"sou_quote", priceMaps, supplierMap);
            flag = true;
        }
        catch (KDException e) {
            view.showMessage(ResManager.loadKDString((String)"\u751f\u6210\u62a5\u4ef7\u5355\u5931\u8d25\u3002", (String)"QuoToolBatchPlugin_1", (String)"scm-quo-formplugin", (Object[])new Object[0]), "KDException,unknown error" + e.getMessage() + e.getLocalizedMessage() + e.getStackTraceMessage(), MessageTypes.Business);
            log.info("KDException" + ExceptionUtil.getStackTrace((Throwable)e));
        }
        catch (Exception e) {
            log.info("Exception" + ExceptionUtil.getStackTrace((Throwable)e));
            view.showMessage(ResManager.loadKDString((String)"\u751f\u6210\u62a5\u4ef7\u5355\u5931\u8d25\u3002", (String)"QuoToolBatchPlugin_1", (String)"scm-quo-formplugin", (Object[])new Object[0]), "Exception,unknown error" + e.getMessage() + e.getLocalizedMessage(), MessageTypes.Business);
        }
        finally {
            if (!flag) {
                log.info("finally\u751f\u6210\u62a5\u4ef7\u5355\u5931\u8d25");
                view.showMessage(ResManager.loadKDString((String)"\u751f\u6210\u62a5\u4ef7\u5355\u5931\u8d25\u3002", (String)"QuoToolBatchPlugin_1", (String)"scm-quo-formplugin", (Object[])new Object[0]), "finally,unknown error", MessageTypes.Business);
            }
        }
        if (null != resultMap && !resultMap.isEmpty()) {
            Object value = resultMap.get(billNo);
            if (value instanceof String) {
                view.showMessage("", billNo + ":" + value, MessageTypes.Permission);
            } else if (value instanceof Long) {
                BillShowParameter billShowParameter = BillFormUtil.assembleShowBillFormParam((String)"quo_quote", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)((Long)value), null, null);
                view.showForm((FormShowParameter)billShowParameter);
            }
        }
    }

    private void putMultCurrencyInfo(HashMap<String, Object> dataMap, DynamicObject dynamicObject) {
        dataMap.put("quotecurr", dynamicObject.get("quotecurr"));
        dataMap.put("quotecurr_id", dynamicObject.get("quotecurr_id"));
        dataMap.put("exrate", dynamicObject.get("exrate"));
    }

    private void quote() {
        IDataModel model = this.getModel();
        boolean totalinquiry = Boolean.parseBoolean(model.getValue("totalinquiry1").toString());
        String currBillBo = this.getPageCache().get(CURRENCY_QUO_BILL_NO);
        if (null != currBillBo) {
            String content;
            DynamicObjectCollection coll = this.getModel().getEntryEntity(DETAIL_ENTRY_ENTITY);
            String supcurrtype1 = String.valueOf(this.getModel().getValue("supcurrtype1"));
            if ("2".equals(supcurrtype1)) {
                for (int i = 0; i < coll.size(); ++i) {
                    DynamicObject dynamicObject = (DynamicObject)coll.get(i);
                    BigDecimal price = dynamicObject.getBigDecimal("price");
                    if (dynamicObject.get("quotecurr") != null || BigDecimal.ZERO.compareTo(price) >= 0) continue;
                    this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u62a5\u4ef7\u5e01\u522b\u3002", (String)"QuoToolBatchPlugin_23", (String)"scm-quo-formplugin", (Object[])new Object[0]), i + 1));
                    return;
                }
            }
            if ((content = this.fitNullValue(coll)).length() == 0) {
                this.toQuote();
                return;
            }
            if (totalinquiry) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u662f\u6574\u5355\u8be2\u4ef7\uff0c\u5fc5\u987b\u5bf9\u5168\u90e8\u5546\u54c1\u8fdb\u884c\u62a5\u4ef7\u3002", (String)"QuoToolBatchPlugin_3", (String)"scm-quo-formplugin", (Object[])new Object[0]), content, MessageTypes.Default);
            } else {
                boolean isQuo = this.checkQuo(coll);
                if (!isQuo) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u5bf9\u4e00\u4e2a\u5546\u54c1\u8fdb\u884c\u6709\u6548\u62a5\u4ef7\u3002", (String)"QuoToolBatchPlugin_2", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6211\u8981\u62a5\u4ef7\u9875\u7b7e\u6570\u636e\u5b58\u5728\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"QuoToolBatchPlugin_4", (String)"scm-quo-formplugin", (Object[])new Object[0]), content, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("quoconfirm"));
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u6761\u62a5\u4ef7\u5355\u3002", (String)"QuoToolBatchPlugin_5", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "quote": {
                Long org = (Long)this.getModel().getValue("org1_id");
                if (org == null || org == 0L) {
                    return;
                }
                List suppliers = BizPartnerUtil.getSupplierByUserAndOrgOfBizPartner((Long)org);
                if (suppliers.size() != 0) break;
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u8be2\u4ef7\u65b9\u7684\u62a5\u4ef7\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u8be2\u4ef7\u65b9\u7ef4\u62a4\u540e\u518d\u62a5\u4ef7\u3002", (String)"QuoToolBatchPlugin_27", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            IPageCache pageCache = this.getPageCache();
            switch (operateKey) {
                case "quoquery": {
                    HashMap objectMap = new HashMap();
                    pageCache.remove(IS_TREE_NODE_CLICK);
                    pageCache.put(IS_TREE_NODE_CLICK, "0");
                    FormShowParameter param = BillFormUtil.assembleShowDynamicFormParam((String)"quo_quotequery", objectMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "quoquery"), (ShowType)ShowType.NonModal);
                    this.openQuoQuery(param);
                    break;
                }
                case "quote": {
                    this.quote();
                    break;
                }
                case "reload": {
                    if ("true".equals(pageCache.get("newToolPage"))) break;
                    pageCache.put("reload", "true");
                    pageCache.put(IS_TREE_NODE_CLICK, "0");
                    this.allotDynamicData(null);
                }
            }
        }
    }

    private boolean checkQuo(DynamicObjectCollection dynamicObjectsParam) {
        boolean isQuo = false;
        Object taxtype = this.getModel().getValue("taxtype1");
        if (taxtype != null && "2".equals(taxtype.toString())) {
            for (DynamicObject dynamicObject : dynamicObjectsParam) {
                BigDecimal price = dynamicObject.getBigDecimal("price");
                if (price == null || BigDecimal.ZERO.compareTo(price) >= 0) continue;
                isQuo = true;
            }
        } else {
            for (DynamicObject dynamicObject : dynamicObjectsParam) {
                BigDecimal taxPrice = dynamicObject.getBigDecimal("taxprice");
                if (taxPrice == null || BigDecimal.ZERO.compareTo(taxPrice) >= 0) continue;
                isQuo = true;
            }
        }
        return isQuo;
    }

    public String fitNullValue(DynamicObjectCollection dynamicObjectsParam) {
        int rowCount = 1;
        DataEntityPropertyCollection properties = dynamicObjectsParam.getDynamicObjectType().getProperties();
        StringBuilder content = new StringBuilder(ResManager.loadKDString((String)"\u6211\u8981\u62a5\u4ef7\u9875\u7b7e\uff1a", (String)"QuoToolBatchPlugin_6", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        String original = content.toString();
        StringBuilder contentRow = new StringBuilder();
        for (DynamicObject dynamicObject : dynamicObjectsParam) {
            Object quoteQty;
            Object price;
            Object taxPrice;
            contentRow.setLength(0);
            String headTitle = MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c", (String)"QuoToolBatchPlugin_7", (String)"scm-quo-formplugin", (Object[])new Object[0]), rowCount);
            contentRow.append(headTitle);
            DynamicProperty taxTypePro = (DynamicProperty)properties.get((Object)"taxtype");
            DynamicProperty taxPricePro = (DynamicProperty)properties.get((Object)"taxprice");
            DynamicProperty pricePro = (DynamicProperty)properties.get((Object)"price");
            DynamicProperty quoteQtyPro = (DynamicProperty)properties.get((Object)QUOTE_QTY);
            Object taxType = taxTypePro.getValue((Object)dynamicObject);
            if (("1".equals(taxType) || "3".equals(taxType)) && ((taxPrice = taxPricePro.getValue((Object)dynamicObject)) == null || BigDecimal.ZERO.compareTo((BigDecimal)taxPrice) >= 0)) {
                contentRow.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\u4e3a\u7a7a\uff1b", (String)"QuoToolBatchPlugin_8", (String)"scm-quo-formplugin", (Object[])new Object[0]), taxPricePro.getDisplayName()));
            }
            if ("2".equals(taxType) && ((price = pricePro.getValue((Object)dynamicObject)) == null || BigDecimal.ZERO.compareTo((BigDecimal)price) >= 0)) {
                contentRow.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\u4e3a\u7a7a\uff1b", (String)"QuoToolBatchPlugin_8", (String)"scm-quo-formplugin", (Object[])new Object[0]), pricePro.getDisplayName()));
            }
            if ((quoteQty = quoteQtyPro.getValue((Object)dynamicObject)) == null) {
                contentRow.append(MessageFormat.format(ResManager.loadKDString((String)"{0}\u4e3a\u7a7a\uff1b", (String)"QuoToolBatchPlugin_8", (String)"scm-quo-formplugin", (Object[])new Object[0]), quoteQtyPro.getDisplayName()));
            }
            if (!contentRow.toString().trim().equalsIgnoreCase(headTitle)) {
                content.append((CharSequence)contentRow.replace(contentRow.length() - 1, contentRow.length(), "\n"));
            }
            ++rowCount;
        }
        if (original.equals(content.toString())) {
            content.setLength(0);
        }
        return content.toString();
    }

    public void toQuote() {
        IDataModel model = this.getModel();
        String currBillNo = this.getPageCache().get(CURRENCY_QUO_BILL_NO);
        if (currBillNo != null) {
            DynamicObject inquiryBill = BusinessDataServiceHelper.loadSingle((String)"quo_inquiry", (String)"id,billno,bizstatus,turns,auditdate,enddate,entryentity.supentrystatus,entryentity.supplier,entryentity.canshow,entryentity.supentrystatus,entryentity.quoter,entryentity.deadline,entryentity.entryturns", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)currBillNo)});
            if (inquiryBill == null) {
                return;
            }
            Map checkMap = QuoInquiryUtil.verifyQuote((DynamicObject)inquiryBill);
            if ("false".equals(checkMap.get("succed"))) {
                this.getView().showErrorNotification(checkMap.get("message").toString());
                return;
            }
            Date auditDate = (Date)this.getModel().getValue("auditdate1");
            Date newAuditDate = inquiryBill.getDate("auditdate");
            if (newAuditDate == null || auditDate != null && newAuditDate != null && auditDate.compareTo(newAuditDate) < 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8be2\u4ef7\u5355\u5df2\u88ab\u4fee\u6539\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u8be5\u8be2\u4ef7\u5355\u62a5\u4ef7\u4fe1\u606f\u6216\u91cd\u65b0\u6253\u5f00\u62a5\u4ef7\u52a9\u624b\u3002", (String)"QuoToolBatchPlugin_26", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection coll = model.getEntryEntity(DETAIL_ENTRY_ENTITY);
            this.pushToQuoBill(currBillNo.toString(), coll);
            Tab tab = (Tab)this.getView().getControl(STATUS_TAB);
            if (tab != null) {
                tab.activeTab(STATUS_ALL);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("quoconfirm".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.toQuote();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "quoquery": {
                this.quoQuery(closedCallBackEvent);
                break;
            }
        }
    }

    private void quoQuery(ClosedCallBackEvent closedCallBackEvent) {
        IPageCache cache = this.getPageCache();
        Object returnData = closedCallBackEvent.getReturnData();
        if (null != returnData && returnData instanceof Map) {
            for (Map.Entry entry : ((Map)returnData).entrySet()) {
                cache.remove((String)entry.getKey());
                cache.put((String)entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
            }
        } else {
            return;
        }
        cache.remove(CURRENCY_QUO_BILL_NO);
        cache.remove("newToolPage");
        this.focusAllStatusTab();
    }

    private void openQuoQuery(FormShowParameter param) {
        this.getView().showForm(param);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        Object id;
        List idList;
        EntryGrid grid = (EntryGrid)e.getSource();
        String gridKey = grid.getKey();
        int index = e.getRowIndex();
        String property = e.getFieldName();
        if (DETAIL_ENTRY_ENTITY.equals(gridKey) && "billno".equals(property) && !(idList = QueryServiceHelper.queryPrimaryKeys((String)"quo_inquiry", (QFilter[])new QFilter[]{new QFilter("id", "=", id = this.getModel().getValue("id", index))}, (String)"id", (int)1)).isEmpty()) {
            OpenFormUtil.openBillPage((IFormView)this.getView(), (String)"quo_inquiry", idList.get(0), (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
        }
    }

    protected StringBuilder assembleInquirySelectFields() {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"quo_quotetool");
        Map allEntities = dataEntityType.getAllEntities();
        EntityType detailEntryentity = (EntityType)allEntities.get(DETAIL_ENTRY_ENTITY);
        MainEntityType quoInquiryEntity = EntityMetadataCache.getDataEntityType((String)"quo_inquiry");
        Map allEntities1 = quoInquiryEntity.getAllEntities();
        EntityType entityType = (EntityType)allEntities1.get("materialentry");
        EntityType entryEntityType = (EntityType)allEntities1.get("entryentity");
        HashSet<String> selects = new HashSet<String>();
        Map<String, String> extMap = this.getExtMap();
        Map<String, Character> blackListMap = this.getBlackListMap();
        InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)dataEntityType.getProperties(), selects, extMap, blackListMap, (DataEntityPropertyCollection)quoInquiryEntity.getProperties(), (String)"1");
        InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)dataEntityType.getProperties(), selects, extMap, blackListMap, (DataEntityPropertyCollection)entityType.getProperties(), (String)"1");
        InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)dataEntityType.getProperties(), selects, extMap, blackListMap, (DataEntityPropertyCollection)entryEntityType.getProperties(), (String)"1");
        InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)detailEntryentity.getProperties(), selects, extMap, blackListMap, (DataEntityPropertyCollection)quoInquiryEntity.getProperties(), (String)"");
        InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)detailEntryentity.getProperties(), selects, extMap, blackListMap, (DataEntityPropertyCollection)entityType.getProperties(), (String)"");
        InquiryUtil.wrapSelectsByEntryPro((DataEntityPropertyCollection)detailEntryentity.getProperties(), selects, extMap, blackListMap, (DataEntityPropertyCollection)entryEntityType.getProperties(), (String)"");
        selects.add("turns");
        selects.add("supscope");
        selects.add("isautofillprice");
        selects.add("entryentity.entryturns entryturns");
        selects.add("entryentity.canshow canshow");
        selects.add("entryentity.id supentryid");
        selects.add("materialentry.material.taxrate.id taxrateid");
        selects.add("materialentry.material.taxrate.taxrate taxrate");
        selects.add("materialentry.material.isdisposable isdisposable");
        selects.add("materialentry.materialnametext materialnametext");
        selects.add("materialentry.material.name materialname");
        selects.add("materialentry.id entryid");
        String select = StringUtils.join((Object[])selects.toArray(), (String)",");
        return new StringBuilder().append(select);
    }

    protected Map<String, String> getExtMap() {
        return new HashMap<String, String>();
    }

    protected Map<String, Character> getBlackListMap() {
        HashMap<String, Character> blackListMap = new HashMap<String, Character>(16);
        blackListMap.put("quotecurr", Character.valueOf('1'));
        blackListMap.put(QUOTE_QTY, Character.valueOf('1'));
        blackListMap.put("price", Character.valueOf('1'));
        blackListMap.put("taxprice", Character.valueOf('1'));
        blackListMap.put("minorderqty", Character.valueOf('1'));
        blackListMap.put("purleadday", Character.valueOf('1'));
        blackListMap.put(LATEST_PRICE, Character.valueOf('1'));
        blackListMap.put(NEW_PRICE, Character.valueOf('1'));
        blackListMap.put(MIN_PRICE, Character.valueOf('1'));
        blackListMap.put(MAX_PRICE, Character.valueOf('1'));
        blackListMap.put(REF_PRICE, Character.valueOf('1'));
        blackListMap.put("goods", Character.valueOf('1'));
        blackListMap.put(GOODS_DESC, Character.valueOf('1'));
        blackListMap.put("taxrate", Character.valueOf('1'));
        return blackListMap;
    }

    public void allotDynamicHeadData(DynamicObject dynamicObject) {
        Map dynMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)dynamicObject);
        String supscope = dynamicObject.getString("supscope");
        Container container = (Container)this.getControl(HEAD_ENTRY_ENTITY);
        IDataModel model = this.getModel();
        List proHeadEntity = DynamicObjectUtil.getContainerProperties((Container)container);
        for (Map.Entry entry : dynMap.entrySet()) {
            String key = (String)entry.getKey() + "1";
            Object value = entry.getValue();
            if (proHeadEntity.contains(key)) {
                model.setValue(key, value);
            }
            if (!"2".equals(supscope) || !key.equals("supplier1")) continue;
            model.setValue("supplier", value);
        }
    }

    protected void allotDynamicEntryData(ArrayList<DynamicObject> currDynamics) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        EntryGrid grid = (EntryGrid)this.getView().getControl(DETAIL_ENTRY_ENTITY);
        model.deleteEntryData(DETAIL_ENTRY_ENTITY);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        DynamicObject curr = (DynamicObject)this.getModel().getValue("curr1");
        if (curr == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u62a5\u4ef7\u3002", (String)"QuoToolBatchPlugin_12", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
        List proEntity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity(DETAIL_ENTRY_ENTITY).getDynamicObjectType());
        int rowCount = 0;
        for (DynamicObject dynamicObject : currDynamics) {
            Map dynMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)dynamicObject);
            for (Map.Entry entry : dynMap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (proEntity.contains(key)) {
                    vs.set(key, value, rowCount);
                }
                if (proEntity.contains(QUOTE_QTY) && key.equals("qty")) {
                    vs.set(QUOTE_QTY, value, rowCount);
                }
                if (!proEntity.contains("entryid") || !key.equals("materialentry")) continue;
                vs.set("entryid", value, rowCount);
            }
            boolean isdisposable = dynamicObject.getBoolean("isdisposable");
            if (isdisposable && StringUtils.isBlank((CharSequence)dynamicObject.getString("materialnametext")) || !isdisposable) {
                vs.set("materialnametext", (Object)dynamicObject.getString("materialname"), rowCount);
            }
            vs.set("quotecurr_id", (Object)curr.getLong("id"), rowCount);
            vs.set("exrate", (Object)1L, rowCount);
            ++rowCount;
        }
        if (!currDynamics.isEmpty()) {
            String inquiryBillno = currDynamics.get(0).getString("billno");
            ArrayList<String> billno = new ArrayList<String>();
            billno.add(inquiryBillno);
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"quo", (String)"IQuoteAutoFillService", (String)"getPriceInfoMap", (Object[])new Object[]{billno});
            boolean isAutoFillPrice = currDynamics.get(0).getBoolean("isautofillprice");
            this.autoFillLatestTaxAndPrice(vs, isAutoFillPrice, result);
        }
        this.processImportData(vs);
        grid.selectRows(0);
        model.batchCreateNewEntryRow(DETAIL_ENTRY_ENTITY, vs);
    }

    private void autoFillLatestTaxAndPrice(TableValueSetter vs, boolean isAutoFillPrice, Map<String, Map<String, Object>> result) {
        String turns = String.valueOf(this.getModel().getValue("turns1"));
        for (int i = 0; i < vs.getCount(); ++i) {
            String srcentryid = (String)vs.get("srcentryid", i);
            if (StringUtils.isEmpty((CharSequence)srcentryid)) {
                srcentryid = String.valueOf(vs.get("entryid", i));
            }
            String newestturns = String.valueOf(vs.get("newestturns", i));
            Map<String, Object> map = result.get(srcentryid);
            if (map == null || StringUtils.isNotBlank((CharSequence)newestturns) && StringUtils.equals((CharSequence)turns, (CharSequence)newestturns) && !isAutoFillPrice) continue;
            vs.set("taxrateid_id", this.getValue(map.get("taxrateid")), i);
            vs.set("taxrate", this.getValue(map.get("taxrate")), i);
            vs.set("price", this.getValue(map.get("price")), i);
            vs.set("taxprice", this.getValue(map.get("taxprice")), i);
            vs.set("quotecurr_id", this.getValue(map.get("quotecurr")), i);
            vs.set("exrate", this.getValue(map.get("exrate")), i);
        }
    }

    private Object getValue(Object value) {
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getLong("id");
        }
        return value;
    }

    protected void allotDynamicData(String billNoPar) {
        String isNodeClick;
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"QuoToolBatchPlugin", (String)"quo_inquiry", (String)this.assembleInquirySelectFields().toString(), (QFilter[])this.assembleQueryFilter(billNoPar), (String)"billno, entryentity.supplier, materialentry.seq asc");
        DynamicObjectCollection billColl = ORM.create().toPlainDynamicObjectCollection(dataSet);
        HashSet<Long> unquoteBills = new HashSet<Long>((int)((double)billColl.size() / 0.75));
        Map supplierMap = BizPartnerUtil.getSupplierWithEnableStatusByUserOfBizPartner();
        for (DynamicObject dynamicObject : billColl) {
            if (!"1".equals(dynamicObject.getString("supscope")) || !supplierMap.containsKey(dynamicObject.getLong("supplier")) || !"F".equals(dynamicObject.getString("supentrystatus")) && !"false".equals(dynamicObject.getString("canshow"))) continue;
            unquoteBills.add(dynamicObject.getLong("id"));
        }
        Boolean isturnsfilter = (Boolean)this.getModel().getValue("isturnsfilter");
        billColl.removeIf(bill -> unquoteBills.contains(bill.getLong("id")) || isturnsfilter != false && StringUtils.isNotBlank((CharSequence)bill.getString("newestturns")) && !StringUtils.equals((CharSequence)bill.getString("turns"), (CharSequence)bill.getString("newestturns")));
        IPageCache pageCache = this.getPageCache();
        String statusFilter = pageCache.get("statusFilter");
        if ("false".equals(statusFilter)) {
            pageCache.put("statusFilter", "true");
        } else {
            Tab tab = (Tab)this.getView().getControl(STATUS_TAB);
            String currentTab = tab.getCurrentTab();
            if (STATUS_QUOTED.equals(currentTab) || STATUS_HAVENOT_QUOTE.equals(currentTab)) {
                HashSet<Long> quotedBills = new HashSet<Long>((int)((double)billColl.size() / 0.75));
                for (DynamicObject dynamicObject : billColl) {
                    String supentrystatus = dynamicObject.getString("supentrystatus");
                    String turns = dynamicObject.getString("turns");
                    String entryturns = dynamicObject.getString("entryturns");
                    if (!supplierMap.containsKey(dynamicObject.getLong("supplier")) || !"A".equals(supentrystatus) && !"B".equals(supentrystatus) || !turns.equals(entryturns)) continue;
                    quotedBills.add(dynamicObject.getLong("id"));
                }
                if (STATUS_QUOTED.equals(currentTab)) {
                    billColl.removeIf(bill -> quotedBills.contains(bill.getLong("id")));
                } else {
                    billColl.removeIf(bill -> !quotedBills.contains(bill.getLong("id")));
                }
            }
        }
        if (billColl.size() == 0) {
            this.clearData();
            this.initAllTreeNodes();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u5230\u76f8\u5173\u6570\u636e\u3002", (String)"QuoToolBatchPlugin_10", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.FALSE, new String[]{"barexport"});
            this.getPageCache().remove(CURRENCY_QUO_BILL_NO);
            return;
        }
        this.getView().setEnable(Boolean.TRUE, new String[]{"barexport"});
        List supList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        if (!supList.isEmpty()) {
            QFilter idfilter = new QFilter("id", "=", supList.get(0));
            DynamicObject supplierDO = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id,group.id,taxrate.id,taxrate.taxrate,paymentcurrency", (QFilter[])new QFilter[]{idfilter});
            for (DynamicObject bill2 : billColl) {
                if (bill2.getLong("taxrateid") != 0L || supList.isEmpty() || supplierDO == null) continue;
                bill2.set("taxrateid", supplierDO.get("taxrate.id"));
                bill2.set("taxrate", supplierDO.get("taxrate.taxrate"));
            }
        }
        ArrayList<String> billNoSet = new ArrayList<String>();
        String currBillNo = null;
        ArrayList<Object> firstMaterialId = new ArrayList<Object>();
        if (!billColl.isEmpty()) {
            DynamicObject detailObj = (DynamicObject)billColl.get(0);
            String currentBillNo = pageCache.get(CURRENCY_QUO_BILL_NO);
            if ("true".equals(pageCache.get("reload")) && StringUtils.isNotEmpty((CharSequence)currentBillNo)) {
                for (DynamicObject dynamicObject : billColl) {
                    if (!dynamicObject.getString("billno").equals(currentBillNo)) continue;
                    detailObj = dynamicObject;
                    break;
                }
            }
            this.allotDynamicHeadData(detailObj);
            currBillNo = detailObj.getString("billno");
            boolean isdisposable = detailObj.getBoolean("isdisposable");
            if (!isdisposable) {
                firstMaterialId.add(detailObj.getLong("material"));
            }
            for (DynamicObject dynamicObject : billColl) {
                String billNoTree = dynamicObject.getString("billno");
                if (null == billNoTree || billNoSet.contains(billNoTree)) continue;
                billNoSet.add(billNoTree);
            }
        }
        if (null == (isNodeClick = pageCache.get(IS_TREE_NODE_CLICK)) || isNodeClick.equals("0")) {
            this.allotDynamicTreeData(billNoSet);
            pageCache.remove("reload");
        }
        ArrayList<DynamicObject> currDynamics = new ArrayList<DynamicObject>();
        HashSet<Long> materialSetIds = new HashSet<Long>();
        if (currBillNo != null) {
            for (DynamicObject dynamicObject : billColl) {
                Long materId = dynamicObject.getLong("entryid");
                if (!currBillNo.equals(dynamicObject.getString("billno")) || materialSetIds.contains(materId)) continue;
                currDynamics.add(dynamicObject);
                materialSetIds.add(materId);
            }
        }
        this.allotDynamicEntryData(currDynamics);
        this.deletePriceEntry();
        this.allotDynamicQuoPriceData(firstMaterialId);
        this.allotDynamicRecPriceData(firstMaterialId);
        this.allotPreviousTurnPrice(currDynamics);
    }

    protected void allotPreviousTurnPrice(ArrayList<DynamicObject> currDynamics) {
        if (currDynamics.isEmpty()) {
            return;
        }
        IDataModel model = this.getModel();
        String turns = currDynamics.get(0).getString("turns");
        if ("".equals(turns) || "1".equals(turns)) {
            return;
        }
        String inquiryBillNo = currDynamics.get(0).getString("billno");
        QFilter filter = new QFilter("inquiryno", "=", (Object)inquiryBillNo);
        filter.and("bizpartner", "in", (Object)BizPartnerUtil.getBizPartnerIds());
        filter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        filter.and("materialentry.entrystatus", "=", (Object)BillEntryStatusEnum.COMMON.getVal());
        StringBuilder selectFieldsSb = new StringBuilder();
        selectFieldsSb.append("billno,inquiryno,turns,billdate");
        selectFieldsSb.append(',').append("materialentry.srcentryid srcentryid");
        selectFieldsSb.append(',').append("materialentry.taxprice taxprice");
        String orderBys = "materialentry.seq asc,materialentry.srcentryid";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"quo_quote", (String)selectFieldsSb.toString(), (QFilter[])new QFilter[]{filter}, (String)orderBys);){
            HashMap<String, Object> srcEntryId_taxPriceMap = new HashMap<String, Object>();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String srcEntryId = row.getString("srcentryid");
                Object taxPrice = row.get("taxprice");
                if (null != srcEntryId_taxPriceMap.get(srcEntryId)) continue;
                srcEntryId_taxPriceMap.put(srcEntryId, taxPrice);
            }
            int rowCount = model.getEntryRowCount(DETAIL_ENTRY_ENTITY);
            for (int i = 0; i < rowCount; ++i) {
                String detailSrcEntryId = (String)model.getValue("srcentryid", i);
                String entryId = "";
                if (null != detailSrcEntryId && detailSrcEntryId.trim().length() > 0) {
                    entryId = detailSrcEntryId;
                } else {
                    Object entryIdObj = model.getValue("entryid", i);
                    if (null != entryIdObj) {
                        entryId = entryIdObj.toString();
                    }
                }
                model.setValue(LATEST_PRICE, srcEntryId_taxPriceMap.get(entryId), i);
            }
        }
    }

    protected void allotDynamicTreeData(ArrayList<String> billNoSet) {
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        this.initAllTreeNodes();
        IPageCache cache = this.getPageCache();
        String currentBillNo = cache.get(CURRENCY_QUO_BILL_NO);
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(billNoSet.size());
        int currentIndex = -1;
        for (int i = 0; i < billNoSet.size(); ++i) {
            String number = billNoSet.get(i);
            treeNodes.add(new TreeNode("0", number, number));
            if (!number.equals(currentBillNo)) continue;
            currentIndex = i;
        }
        treeView.addNodes(treeNodes);
        if (treeNodes.size() > 0) {
            TreeNode treeNode = "true".equals(cache.get("reload")) && currentIndex != -1 ? (TreeNode)treeNodes.get(currentIndex) : (TreeNode)treeNodes.get(0);
            treeView.focusNode(treeNode);
            cache.put(CURRENCY_QUO_BILL_NO, treeNode.getId());
        } else {
            cache.remove(CURRENCY_QUO_BILL_NO);
        }
        treeView.expand("0");
    }

    protected void allotDynamicRecPriceData(ArrayList<Object> materialIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Date date = TimeServiceHelper.now();
        String monthNum = this.getPageCache().get("monthnum");
        QFilter orderFilter = new QFilter("supplier", "in", (Object)BizPartnerUtil.getSupplierByUserOfBizPartner());
        QFilter commonFilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        commonFilter.and(new QFilter("materialentry.material", "in", materialIds));
        if (null != monthNum && !monthNum.trim().isEmpty()) {
            commonFilter.and(new QFilter("billdate", ">=", (Object)DateUtil.getPreviousSomeMonthStingDate((Date)date, (int)(Integer.parseInt(monthNum) - 1))));
        } else {
            commonFilter.and(new QFilter("billdate", ">=", (Object)DateUtil.getPreviousSomeMonthStingDate((Date)date, (int)5)));
        }
        orderFilter.and(commonFilter);
        StringBuilder SelectFields = new StringBuilder().append("id").append(',').append("billno").append(',').append("billdate").append(',').append("curr").append(',').append("supplier").append(',').append("materialentry").append('.').append("material").append(" material").append(',').append("materialentry").append('.').append("materialdesc").append(" materialdesc").append(',').append("materialentry").append('.').append("taxrate").append(" taxrate").append(',').append("materialentry").append('.').append("price").append(" price").append(',').append("materialentry").append('.').append("taxprice").append(" taxprice").append(',').append("materialentry").append('.').append("qty").append(" qty").append(',').append("materialentry").append('.').append("unit").append(" unit").append(',').append("materialentry").append('.').append("taxamount").append(" taxamount").append(',').append("materialentry").append('.').append("taxrateid").append(" taxrateid");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int rowCount = 0;
        DataEntityPropertyCollection properties = model.getEntryEntity(RECENT_PRICE_ENTITY).getDynamicObjectType().getProperties();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"pur_order", (String)SelectFields.toString(), (QFilter[])new QFilter[]{orderFilter}, (String)"billdate desc,billno", (int)20);){
            String[] fieldNames = dataSet.getRowMeta().getFieldNames();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                for (String field : fieldNames) {
                    String proKey = field + "3";
                    if (!properties.containsKey((Object)proKey)) continue;
                    vs.set(proKey, row.get(field), rowCount);
                }
                ++rowCount;
            }
        }
        model.batchCreateNewEntryRow(RECENT_PRICE_ENTITY, vs);
    }

    protected void allotDynamicQuoPriceData(ArrayList<Object> materialIds) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Date date = TimeServiceHelper.now();
        String monthNum = this.getPageCache().get("monthnum");
        QFilter qFilter = new QFilter("supplier", "in", (Object)BizPartnerUtil.getSupplierByUserOfBizPartner());
        qFilter.and(new QFilter("materialentry.material", "in", materialIds));
        if (null != monthNum && !monthNum.trim().isEmpty()) {
            qFilter.and(new QFilter("billdate", ">=", (Object)DateUtil.getPreviousSomeMonthStingDate((Date)date, (int)(Integer.parseInt(monthNum) - 1))));
        } else {
            qFilter.and(new QFilter("billdate", ">=", (Object)DateUtil.getPreviousSomeMonthStingDate((Date)date, (int)5)));
        }
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        StringBuilder selectFields = new StringBuilder().append("id").append(',').append("billno").append(',').append("billdate").append(',').append("curr").append(',').append("supplier").append(',').append("turnscount turns").append(',').append("materialentry").append('.').append("material").append(" material").append(',').append("materialentry").append('.').append("materialdesc").append(" materialdesc").append(',').append("materialentry").append('.').append("taxrate").append(" taxrate").append(',').append("materialentry").append('.').append("price").append(" price").append(',').append("materialentry").append('.').append("taxprice").append(" taxprice").append(',').append("materialentry").append('.').append("qty").append(" qty").append(',').append("materialentry").append('.').append("result").append(" result").append(',').append("materialentry").append('.').append("unit").append(" unit").append(',').append("materialentry").append('.').append("taxamount").append(" taxamount").append(',').append("materialentry").append('.').append("taxrateid").append(" taxrateid");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        DataEntityPropertyCollection properties = model.getEntryEntity(QUOTE_PRICE_PRICE_ENTITY).getDynamicObjectType().getProperties();
        int rowCount = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"quo_quote", (String)selectFields.toString(), (QFilter[])new QFilter[]{qFilter}, (String)"billdate desc,billno", (int)20);){
            String[] fieldNames = dataSet.getRowMeta().getFieldNames();
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                for (String field : fieldNames) {
                    String proKey = field + "4";
                    if (!properties.containsKey((Object)proKey)) continue;
                    vs.set(proKey, row.get(field), rowCount);
                }
                ++rowCount;
            }
        }
        model.batchCreateNewEntryRow(QUOTE_PRICE_PRICE_ENTITY, vs);
    }

    protected QFilter[] assembleQueryFilter(String inquiryBillNo) {
        String inquiryTitle;
        String billNo;
        String material;
        IPageCache cache;
        String purOrg;
        QFilter[] qFilters = new QFilter[1];
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal());
        filter.and("bizstatus", "=", (Object)BizStatusEnum.ENROLMENT.getVal());
        List quoInquiryPermissionOrgs = OrgUtil.getAllPurViewPermissionOrgs((String)"quo_inquiry");
        if (Objects.nonNull(quoInquiryPermissionOrgs)) {
            filter.and("org", "in", (Object)quoInquiryPermissionOrgs);
        }
        if (null != (purOrg = (cache = this.getPageCache()).get("org")) && !purOrg.isEmpty()) {
            filter.and("org", "=", (Object)Long.valueOf(purOrg));
        }
        String endDate = cache.get("enddate");
        Date endTime = null;
        if (null != endDate && !endDate.isEmpty()) {
            endTime = DateUtil.string2date((String)endDate, null);
        }
        if (null != (material = cache.get("material")) && !material.isEmpty()) {
            filter.and("materialentry.material", "=", (Object)Long.valueOf(material));
        }
        if (null != (billNo = cache.get("billno")) && !billNo.trim().isEmpty()) {
            filter.and("billno", "like", (Object)billNo);
        }
        if (null != (inquiryTitle = cache.get("inquirytitle")) && !inquiryTitle.trim().isEmpty()) {
            filter.and("quotetitle", "like", (Object)('%' + inquiryTitle + '%'));
        }
        Map supplierMap = BizPartnerUtil.getSupplierWithEnableStatusByUserOfBizPartner();
        ArrayList enableSupplier = new ArrayList(supplierMap.size());
        for (Map.Entry entry : supplierMap.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            enableSupplier.add(entry.getKey());
        }
        Date sysDate = TimeServiceHelper.now();
        if (enableSupplier.isEmpty()) {
            filter.and(new QFilter("entryentity.supplier", "in", new ArrayList(supplierMap.keySet())).and("entryentity.supentrystatus", "!=", (Object)"F"));
        } else {
            filter.and(new QFilter("supscope", "=", (Object)"1").and(this.getSupplierFilter(sysDate, endTime, supplierMap, true).or(this.getSupplierFilter(sysDate, endTime, supplierMap, false))).or(new QFilter("supscope", "=", (Object)"2").and("entryentity.supplier", "in", supplierMap.keySet()).and("entryentity.supentrystatus", "!=", (Object)"F").and("entryentity.canshow", "=", (Object)Boolean.TRUE).and(this.getAbleQuoteEntryFilter(supplierMap, sysDate, endTime))));
        }
        if (inquiryBillNo != null) {
            filter.and("billno", "=", (Object)inquiryBillNo);
        }
        qFilters[0] = filter;
        return qFilters;
    }

    private QFilter getSupplierFilter(Date sysDate, Date endDate, Map<Long, Integer> supplierMap, boolean firstTrun) {
        QFilter qFilter = null;
        if (firstTrun) {
            qFilter = new QFilter("turns", "=", (Object)"1");
            qFilter.and(this.getAbleQuoteEntryFilter(supplierMap, sysDate, endDate).or(this.getAbleQuoteWithoutEntryFilter(supplierMap, sysDate, endDate)));
        } else {
            qFilter = new QFilter("turns", "!=", (Object)"1");
            qFilter.and(this.getAbleQuoteEntryFilter(supplierMap, sysDate, endDate));
        }
        return qFilter;
    }

    private QFilter getAbleQuoteEntryFilter(Map<Long, Integer> supplierMap, Date sysDate, Date endDate) {
        QFilter qFilter = new QFilter("entryentity.supplier", "in", new ArrayList<Long>(supplierMap.keySet()));
        qFilter.and("entryentity.deadline", ">", (Object)sysDate);
        qFilter.and("entryentity.deadline", ">", (Object)sysDate);
        if (endDate != null) {
            qFilter.and("entryentity.deadline", "<=", (Object)endDate);
        }
        return qFilter;
    }

    private QFilter getAbleQuoteWithoutEntryFilter(Map<Long, Integer> supplierMap, Date sysDate, Date endDate) {
        QFilter qFilter = new QFilter("enddate", ">", (Object)sysDate);
        if (endDate != null) {
            qFilter.and("enddate", "<=", (Object)endDate);
        }
        qFilter.and(new QFilter("entryentity.supplier", "not in", new ArrayList<Long>(supplierMap.keySet())).or(QFilter.isNull((String)"entryentity.supentrystatus")));
        return qFilter;
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int rowIndex = evt.getRow();
        EntryGrid inquiryGrid = (EntryGrid)evt.getSource();
        if (DETAIL_ENTRY_ENTITY.equals(inquiryGrid.getEntryKey())) {
            DynamicObject material;
            DynamicObject row = this.getModel().getEntryRowEntity(DETAIL_ENTRY_ENTITY, rowIndex);
            DynamicObject dynamicObject = material = row != null ? row.getDynamicObject("material") : null;
            if (null != material) {
                ArrayList<Object> materialIds = new ArrayList<Object>(1);
                boolean isdisposable = material.getBoolean("isdisposable");
                this.deletePriceEntry();
                if (!isdisposable) {
                    materialIds.add(material.getPkValue());
                    this.allotDynamicRecPriceData(materialIds);
                    this.allotDynamicQuoPriceData(materialIds);
                }
            }
        }
    }

    private void deletePriceEntry() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(RECENT_PRICE_ENTITY);
        model.deleteEntryData(QUOTE_PRICE_PRICE_ENTITY);
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        super.entryRowClick(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterUpload(UploadEvent evt) {
        try {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5f15\u5165\u4e2d", (String)"QuoToolBatchPlugin_11", (String)"scm-quo-formplugin", (Object[])new Object[0])));
            IPageCache pageCache = this.getPageCache();
            String importDataStr = pageCache.get("importData");
            if (StringUtils.isEmpty((CharSequence)importDataStr)) {
                log.error("\u5f15\u5165\u6570\u636e\u4e3a\u7a7a");
                return;
            }
            JSONArray importDataJa = JSONArray.fromObject((Object)importDataStr);
            if (importDataJa.size() > 0) {
                String inquiryNo = JSONObject.fromObject((Object)importDataJa.get(0)).getString("inquiryNo");
                pageCache.put(IS_TREE_NODE_CLICK, "0");
                pageCache.put("billno", inquiryNo);
                pageCache.remove("newToolPage");
                this.focusAllStatusTab();
            }
        }
        finally {
            this.getView().hideLoading();
        }
    }

    public void processImportData(TableValueSetter vs) {
        String importDataStr = this.getPageCache().get("importData");
        HashMap<String, JSONObject> entryIdJoMap = new HashMap<String, JSONObject>();
        if (!StringUtils.isEmpty((CharSequence)importDataStr)) {
            JSONArray importDataJa = JSONArray.fromObject((Object)importDataStr);
            if (importDataJa == null || importDataJa.isEmpty()) {
                return;
            }
            String currInquiryNo = (String)this.getModel().getValue("billno1");
            String importInquiryNo = "";
            for (int i = 0; i < importDataJa.size(); ++i) {
                JSONObject jo2 = importDataJa.getJSONObject(i);
                if (StringUtils.isEmpty((CharSequence)importInquiryNo)) {
                    importInquiryNo = jo2.getString("inquiryNo");
                }
                entryIdJoMap.put(jo2.getString("entryid"), jo2);
            }
            if (!importInquiryNo.equals(currInquiryNo)) {
                return;
            }
            String taxTpye = (String)this.getModel().getValue("taxtype1");
            DynamicObject curr = (DynamicObject)this.getModel().getValue("curr1");
            if (curr == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u62a5\u4ef7\u3002", (String)"QuoToolBatchPlugin_12", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < vs.getCount(); ++i) {
                String entryid = String.valueOf(vs.get("entryid", i));
                JSONObject importDataJo = (JSONObject)entryIdJoMap.get(entryid);
                if (importDataJo == null) continue;
                if (importDataJo.containsKey((Object)"quoprice")) {
                    String quoprice = importDataJo.getString("quoprice");
                    if (this.validateQuoPrice(quoprice, curr, i, sb)) {
                        BigDecimal price;
                        Object taxrate = vs.get("taxrate", i);
                        BigDecimal rate = BigDecimal.ZERO;
                        if (taxrate != null) {
                            rate = new BigDecimal(taxrate.toString());
                        }
                        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxTpye)) {
                            price = CalculateUtils.calPrice((BigDecimal)new BigDecimal(quoprice), (BigDecimal)rate, (int)curr.getInt("priceprecision"));
                            vs.set("price", (Object)price, i);
                            vs.set("taxprice", (Object)quoprice, i);
                        } else if (TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxTpye)) {
                            price = CalculateUtils.calPriceIsPriceInTax((BigDecimal)new BigDecimal(quoprice), (BigDecimal)rate, (int)curr.getInt("priceprecision"));
                            vs.set("price", (Object)price, i);
                            vs.set("taxprice", (Object)quoprice, i);
                        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxTpye)) {
                            BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)new BigDecimal(quoprice), (BigDecimal)rate, (int)curr.getInt("priceprecision"));
                            vs.set("price", (Object)quoprice, i);
                            vs.set("taxprice", (Object)taxPrice, i);
                        }
                    } else {
                        importDataJa.remove((Object)importDataJo);
                    }
                }
                if (importDataJo.containsKey((Object)"note")) {
                    String note = importDataJo.getString("note");
                    if (this.validateNote(note, i, sb)) {
                        vs.set("note", (Object)note, i);
                    } else {
                        importDataJa.remove((Object)importDataJo);
                    }
                }
                entryIdJoMap.remove(entryid);
            }
            importDataJa.removeAll(entryIdJoMap.values());
            if (entryIdJoMap.size() > 0) {
                HashSet rowSet = new HashSet();
                entryIdJoMap.forEach((key, jo) -> rowSet.add(jo.getString("seq")));
                sb.append(String.format(ResManager.loadKDString((String)"Excel\u4e2d\u7b2c%s\u884c\u6ca1\u5339\u914d\u5230\u6570\u636e\u3002", (String)"QuoToolBatchPlugin_20", (String)"scm-quo-formplugin", (Object[])new Object[0]) + "\r\n", rowSet));
            }
            if (sb.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u5f15\u5165\u6709\u8bef", (String)"QuoToolBatchPlugin_13", (String)"scm-quo-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
                this.getPageCache().put("importData", importDataJa.toString());
            }
        }
    }

    protected boolean validateNote(String note, int i, StringBuilder sb) {
        if (note != null && note.length() > 255) {
            sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u5907\u6ce8\u957f\u5ea6\u8d85\u8fc7\u6700\u5927\u957f\u5ea6255\u3002", (String)"QuoToolBatchPlugin_14", (String)"scm-quo-formplugin", (Object[])new Object[0]) + "\r\n", i + 1));
            return false;
        }
        return true;
    }

    protected boolean validateQuoPrice(String quoprice, DynamicObject curr, int i, StringBuilder sb) {
        if (StringUtils.isEmpty((CharSequence)quoprice)) {
            sb.append(String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c%2$s\u4e3a\u7a7a\u3002%3$s", (String)"QuoToolBatchPlugin_17", (String)"scm-quo-formplugin", (Object[])new Object[0]), i + 1, this.getQuoPriceName(), "\r\n"));
            return false;
        }
        if (ValidateMatchUtil.isDouble((String)quoprice)) {
            if (quoprice.split("\\.").length == 2) {
                int currPrecision = curr.getInt("priceprecision");
                if (quoprice.split("\\.")[1].length() > currPrecision) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u3010%3$s\u3011\u8d85\u8fc7\u7ed3\u7b97\u5e01\u522b\u7684\u7cbe\u5ea6\u3010%4$s\u3011\u3002%5$s", (String)"QuoToolBatchPlugin_15", (String)"scm-quo-formplugin", (Object[])new Object[0]), i + 1, this.getQuoPriceName(), quoprice, currPrecision, "\r\n"));
                }
            }
        } else {
            sb.append(String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c%2$s\u3010%3$s\u3011\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u3001\u7a7a\u683c\u3001\u82f1\u6587\u6216\u6c49\u5b57\u3002%4$s", (String)"QuoToolBatchPlugin_16", (String)"scm-quo-formplugin", (Object[])new Object[0]), i + 1, this.getQuoPriceName(), quoprice, "\r\n"));
            return false;
        }
        return true;
    }

    protected String getQuoPriceName() {
        Object taxtype = this.getModel().getValue("taxtype1");
        if (taxtype != null && "2".equals(taxtype.toString())) {
            return ResManager.loadKDString((String)"\u62a5\u4ef7", (String)"QuoToolBatchPlugin_18", (String)"scm-quo-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u542b\u7a0e\u62a5\u4ef7", (String)"QuoToolBatchPlugin_19", (String)"scm-quo-formplugin", (Object[])new Object[0]);
    }

    public void tabSelected(TabSelectEvent e) {
        IPageCache pageCache = this.getPageCache();
        if (!"true".equals(pageCache.get("newToolPage"))) {
            pageCache.put(IS_TREE_NODE_CLICK, "0");
            this.allotDynamicData(null);
        }
    }

    private void focusAllStatusTab() {
        Tab tab = (Tab)this.getView().getControl(STATUS_TAB);
        if (tab != null) {
            if (STATUS_ALL.equals(tab.getCurrentTab())) {
                this.allotDynamicData(null);
            } else {
                tab.activeTab(STATUS_ALL);
            }
        }
    }

    private static Set<String> initStandardProp() {
        HashSet<String> set = new HashSet<String>(64);
        set.add("billno");
        set.add("material");
        set.add("materialnametext");
        set.add(MATERIAL_CODE);
        set.add(MATIRIAL_MODEL);
        set.add("materialdesc");
        set.add("unit");
        set.add("qty");
        set.add("quotecurr");
        set.add(QUOTE_QTY);
        set.add("taxrateid");
        set.add("taxrate");
        set.add("price");
        set.add("exrate");
        set.add("taxprice");
        set.add("minorderqty");
        set.add("purleadday");
        set.add("note");
        set.add("entryrcvorg");
        set.add(LATEST_PRICE);
        set.add(NEW_PRICE);
        set.add(MIN_PRICE);
        set.add(MAX_PRICE);
        set.add(REF_PRICE);
        set.add("taxtype");
        set.add("materialname");
        set.add("goods");
        set.add(GOODS_NAME);
        set.add(GOODS_MODEL);
        set.add(GOODS_DESC);
        set.add("id");
        set.add("entryid");
        set.add(PRI_BILLNO);
        set.add("srcentryid");
        return set;
    }
}

