/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.util.BizPartnerUtil;

public class QuoBidBillAttachPlugin
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        String name = e.getProperty().getName();
        for (ChangeData changeData : changeSet = e.getChangeSet()) {
            if (!"attachment".equals(name)) continue;
            int rowIndex = changeData.getRowIndex();
            Object newValue = changeData.getNewValue();
            DynamicObjectCollection attachments = (DynamicObjectCollection)newValue;
            if (attachments.isEmpty()) {
                this.getModel().setValue("filename", null, rowIndex);
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (DynamicObject object : attachments) {
                String fileName = object.getString("fbasedataid.name");
                stringBuilder.append(fileName).append(";");
            }
            this.getModel().setValue("filename", (Object)stringBuilder.toString(), rowIndex);
            this.getModel().setValue("filename_tag", (Object)stringBuilder.toString(), rowIndex);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object billId = this.getView().getFormShowParameter().getCustomParam("bidBillId");
        List supplierId = BizPartnerUtil.getSupplierByUserOfBizPartner();
        this.getModel().deleteEntryData("entryentity");
        DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"quo_bidbill", (String)"id,supquoentry.entrysupplier,supquoentry.supremark,supquoentry.attachment");
        if (info != null) {
            DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            DynamicObjectCollection supquoentry = info.getDynamicObjectCollection("supquoentry");
            int i = 0;
            for (DynamicObject dynamicObject : supquoentry) {
                if (!supplierId.contains(dynamicObject.getLong("entrysupplier_id"))) continue;
                DynamicObject dynamicObject1 = entryentity.addNew();
                dynamicObject1.set("supplier", dynamicObject.get("entrysupplier"));
                dynamicObject1.set("attachment", dynamicObject.get("attachment"));
                dynamicObject1.set("remark", dynamicObject.get("supremark"));
                DynamicObjectCollection attachments = dynamicObject.getDynamicObjectCollection("attachment");
                if (!attachments.isEmpty()) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"attachment"});
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"remark"});
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnok"});
                    StringBuilder stringBuilder = new StringBuilder();
                    for (DynamicObject object : attachments) {
                        String fileName = object.getString("fbasedataid.name");
                        stringBuilder.append(fileName).append(";");
                    }
                    dynamicObject1.set("filename", (Object)stringBuilder.toString());
                    dynamicObject1.set("filename_tag", (Object)stringBuilder.toString());
                } else {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"btnok"});
                }
                ++i;
            }
            this.getView().updateView();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        Object billId;
        DynamicObject info;
        AbstractOperate source = (AbstractOperate)e.getSource();
        String operateKey = source.getOperateKey();
        if (("btcancel".equals(operateKey) || "submit".equals(operateKey)) && (info = BusinessDataServiceHelper.loadSingle((Object)(billId = this.getView().getFormShowParameter().getCustomParam("bidBillId")), (String)"quo_bidbill", (String)"id,bidstatus,supquoentry.entrysupplier,supquoentry.supremark,supquoentry.attachment")) != null) {
            String bidstatus = info.getString("bidstatus");
            if (!BidStatusEnum.BIDDING.getVal().equals(bidstatus) && !BidStatusEnum.EVALUATING.getVal().equals(bidstatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ade\u4ef7\u53d1\u5e03\u5355\u4e0d\u662f\u7ade\u4ef7\u4e2d\u6216\u8bc4\u6807\u4e2d\u65e0\u6cd5\u8fdb\u884c\u9644\u4ef6\u63d0\u4ea4\u6216\u64a4\u9500\u64cd\u4f5c\u3002", (String)"QuoBidBillAttachPlugin_0", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>();
            DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryentity) {
                DynamicObject entry = (DynamicObject)map.get(dynamicObject.getLong("supplier_id"));
                if (entry != null) continue;
                map.put(dynamicObject.getLong("supplier_id"), dynamicObject);
            }
            DynamicObjectCollection supquoentry = info.getDynamicObjectCollection("supquoentry");
            boolean flag = false;
            if (supquoentry != null && !supquoentry.isEmpty()) {
                ArrayList<Object> attachIds = new ArrayList<Object>();
                for (DynamicObject entry : supquoentry) {
                    DynamicObjectCollection attachment;
                    DynamicObject dynamicObject = (DynamicObject)map.get(entry.getLong("entrysupplier_id"));
                    if (dynamicObject == null) continue;
                    if ("submit".equals(operateKey)) {
                        attachment = dynamicObject.getDynamicObjectCollection("attachment");
                        entry.set("attachment", (Object)attachment);
                        entry.set("supremark", dynamicObject.get("remark"));
                        if (!attachment.isEmpty()) {
                            flag = true;
                        }
                        this.getView().getParentView().setReturnData((Object)"submit");
                        continue;
                    }
                    if (!"btcancel".equals(operateKey)) continue;
                    attachment = entry.getDynamicObjectCollection("attachment");
                    for (DynamicObject object : attachment) {
                        attachIds.add(object.getPkValue());
                    }
                    entry.set("supremark", (Object)"");
                    entry.set("attachment", null);
                    flag = true;
                    this.getView().getParentView().setReturnData((Object)"btcancel");
                }
                if (attachIds.size() > 0) {
                    AttachmentFieldServiceHelper.removeAttachmentsByAttPkIds((String)"quo_bidbill", (String)"t_pur_bidbillsupplier_att", (Object[])attachIds.toArray());
                } else if ("btcancel".equals(operateKey)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u9644\u4ef6\u6210\u529f\u540e\u624d\u5141\u8bb8\u64a4\u56de\u3002", (String)"QuoBidBillAttachPlugin_1", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (flag) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{info});
            } else if ("submit".equals(operateKey)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u9644\u4ef6\u540e\u518d\u63d0\u4ea4\u3002", (String)"QuoBidBillAttachPlugin_2", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.getView().close();
    }
}

