/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin.edit;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.quo.common.QuoBidBillUtil;
import kd.scm.quo.formplugin.edit.QuoCoreEditPlugin;

public class QuoBidBillEditPlugin
extends QuoCoreEditPlugin {
    private static final String SUPQUOENTRY = "supquoentry";
    private static final String QUOENTRY = "quoentry";

    public void beforeItemClick(BeforeItemClickEvent evt) {
    }

    @Override
    protected String getStatusTabVal() {
        DynamicObject inquiryObject = this.getModel().getDataEntity();
        String bidStatus = inquiryObject.getString("bidstatus");
        return bidStatus == null ? "" : bidStatus.toLowerCase();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "bidhall": {
                    this.joinBidHall();
                    break;
                }
                case "enroll": {
                    this.enrollConfirm();
                }
            }
        }
    }

    private void refreshModelAndView() {
        BillModel model = (BillModel)this.getModel();
        IFormView view = this.getView();
        model.load(model.getPKValue());
        view.updateView("bidstatus");
    }

    private void joinBidHall() {
        this.refreshModelAndView();
        IFormView view = this.getView();
        DynamicObject bidBillObj = this.getModel().getDataEntity(true);
        Map checkMap = QuoBidBillUtil.verifyJoinBidHall((DynamicObject)bidBillObj);
        if ("false".equals(checkMap.get("succed"))) {
            view.showMessage(checkMap.get("message").toString());
            return;
        }
        if ("true".equals(checkMap.get("succed"))) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("bidBillId", this.getModel().getDataEntity().getPkValue());
            if ("1".equals(bidBillObj.getString("quotemode"))) {
                view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"quo_bidhall", paramMap, (CloseCallBack)new CloseCallBack(this.getPluginName(), "bidHallClose"), (ShowType)ShowType.MainNewTabPage));
            } else {
                view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"quo_bidhallbyentry", paramMap, (CloseCallBack)new CloseCallBack(this.getPluginName(), "bidHallClose"), (ShowType)ShowType.MainNewTabPage));
            }
        }
    }

    private void enrollConfirm() {
        this.refreshModelAndView();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Object enrollDate = model.getValue("enrolldate");
        Date date = TimeServiceHelper.now();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", model.getValue("id"))};
        DynamicObject curStatus = QueryServiceHelper.queryOne((String)"quo_bidbill", (String)"bidstatus", (QFilter[])qFilters);
        if ("G".equals(curStatus.getString("bidstatus"))) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u7ec8\u6b62\uff0c\u4e0d\u5141\u8bb8\u62a5\u540d\u3002", (String)"QuoBidBillEditPlugin_2", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            view.invokeOperation("refresh");
            return;
        }
        if (enrollDate instanceof Date && ((Date)enrollDate).before(date)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u62a5\u540d\u65f6\u95f4\u5df2\u8fc7", (String)"QuoBidBillEditPlugin_0", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            return;
        }
        if (QuoBidBillUtil.checkUserIsEnroll((DynamicObject)this.getModel().getDataEntity())) {
            view.showMessage(ResManager.loadKDString((String)"\u60a8\u5df2\u62a5\u540d\uff0c\u65e0\u9700\u518d\u6b21\u62a5\u540d\u3002", (String)"QuoBidBillEditPlugin_1", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject bidBill = this.getModel().getDataEntity();
        HashMap<String, Object> enrollParamMap = new HashMap<String, Object>(4);
        enrollParamMap.put("bidBillId", bidBill.getPkValue());
        enrollParamMap.put("bidName", bidBill.getString("name"));
        view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"quo_bidenroll", enrollParamMap, (CloseCallBack)new CloseCallBack(this.getPluginName(), "bidEnrollClose"), (ShowType)ShowType.Modal));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        IFormView view = this.getView();
        BillModel model = (BillModel)this.getModel();
        model.load(model.getPKValue());
        view.updateView(QUOENTRY);
        view.updateView(SUPQUOENTRY);
        this.setSupplierInfo(SUPQUOENTRY, "entrysupplier");
        this.setSupplierInfo(QUOENTRY, "quotesupplier");
    }

    private boolean checkUserIsEnroll() {
        DynamicObject currUserQuoSupEntry = this.getCurrUserQuoSupEntry();
        return currUserQuoSupEntry != null;
    }

    private DynamicObject getCurrUserQuoSupEntry() {
        IDataModel model = this.getModel();
        DynamicObjectCollection cols = model.getEntryEntity(SUPQUOENTRY);
        List suppliers = BizPartnerUtil.getSupplierByUserOfBizPartner();
        for (DynamicObject col : cols) {
            DynamicObject supEnroll = col.getDynamicObject("supenroll");
            DynamicObject entrysupplier = col.getDynamicObject("entrysupplier");
            if (entrysupplier == null || supEnroll == null || suppliers == null || !suppliers.contains(Long.parseLong(entrysupplier.getPkValue().toString()))) continue;
            return col;
        }
        return null;
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setSupplierInfo(SUPQUOENTRY, "entrysupplier");
        this.setSupplierInfo(QUOENTRY, "quotesupplier");
        this.setWinSupplierInfo();
    }

    private void setWinSupplierInfo() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        String bidstatus = dataEntity.getString("bidstatus");
        if (!BidStatusEnum.CONFIRMED.getVal().equals(bidstatus)) {
            return;
        }
        boolean open3 = dataEntity.getBoolean("open3");
        boolean open4 = dataEntity.getBoolean("open4");
        DynamicObjectCollection entryentity = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        for (int i = 0; i < entryentity.size(); ++i) {
            DynamicObject info = (DynamicObject)entryentity.get(i);
            long supplierId = info.getLong("winsupplier_id");
            if (supIdList.contains(supplierId)) continue;
            if (!open3) {
                this.getModel().setValue("winsupplier", null, i);
            }
            if (open4) continue;
            this.getModel().setValue("winamount", null, i);
        }
    }

    private void setSupplierInfo(String supEntryKey, String supProName) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject bidBill = model.getDataEntity(true);
        DynamicObjectCollection cols = bidBill.getDynamicObjectCollection(supEntryKey);
        if (cols.isEmpty()) {
            return;
        }
        DataEntityPropertyCollection entryProp = cols.getDynamicObjectType().getProperties();
        HashSet allBaseFields = new HashSet(16);
        allBaseFields.addAll(entryProp.getComplexProperties(false).stream().map(x -> x.getName()).collect(Collectors.toList()));
        Map colMap = DynamicObjectUtil.plainObject2Map((DynamicObject)((DynamicObject)cols.get(0)));
        TableValueSetter ts = new TableValueSetter(new String[0]);
        List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        int i = 0;
        for (DynamicObject col : cols) {
            DynamicObject supplier = col.getDynamicObject(supProName);
            if (supplier == null || supIdList == null || !supIdList.contains(supplier.getPkValue())) continue;
            for (Map.Entry entry : colMap.entrySet()) {
                if (!entryProp.containsKey(entry.getKey())) continue;
                if (allBaseFields.contains(entry.getKey())) {
                    ts.set((String)entry.getKey(), col.get((String)entry.getKey() + "_id"), i);
                    continue;
                }
                ts.set((String)entry.getKey(), col.get((String)entry.getKey()), i);
            }
            ts.set("seq", (Object)(i + 1), i);
            ts.set(supProName, supplier.getPkValue(), i);
            ++i;
        }
        model.deleteEntryData(supEntryKey);
        model.batchCreateNewEntryRow(supEntryKey, ts);
        model.setDataChanged(false);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
    }
}

