/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin.edit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.InquirySupParticipateUtils;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.quo.common.QuoInquiryUtil;
import kd.scm.quo.formplugin.edit.QuoCoreEditPlugin;
import kd.scm.quo.service.QuoInquiryServiceImp;

public class QuoInquiryEdit
extends QuoCoreEditPlugin {
    private static Log log = LogFactory.getLog(QuoInquiryEdit.class);
    private Date today = new Date();
    private Calendar calendar = Calendar.getInstance();

    public void initialize() {
        super.initialize();
    }

    @Override
    public void afterCreateNewData(EventObject eventobject) {
        super.afterCreateNewData(eventobject);
        IDataModel datamodel = this.getModel();
        this.calendar.setTime(this.today);
        this.calendar.add(2, 1);
        datamodel.setValue("enddate", (Object)this.calendar.getTime());
    }

    public void afterLoadData(EventObject e) {
        if (QuoInquiryUtil.hasQuotedInCurrTurns((DynamicObject)this.getModel().getDataEntity())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_unquote"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bar_unquote"});
        }
    }

    @Override
    protected String getStatusTabVal() {
        DynamicObject inquiryObject = this.getModel().getDataEntity();
        String bizStatus = inquiryObject.getString("bizstatus");
        return bizStatus == null ? "" : bizStatus.toLowerCase();
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    private void quoteTool() {
        IFormView view = this.getView();
        DynamicObject inquiryBill = this.getModel().getDataEntity(true);
        if (inquiryBill == null) {
            return;
        }
        Long pkId = inquiryBill.getLong("id");
        if (pkId == null) {
            return;
        }
        inquiryBill = BusinessDataServiceHelper.loadSingle((String)"quo_inquiry", (String)"id,billno,bizstatus,turns,enddate,entryentity.supentrystatus,entryentity.supplier,entryentity.canshow,entryentity.supentrystatus,entryentity.quoter,entryentity.deadline,entryentity.entryturns", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkId)});
        if (inquiryBill == null) {
            return;
        }
        Map checkMap = QuoInquiryUtil.verifyQuote((DynamicObject)inquiryBill);
        if ("false".equals(checkMap.get("succed"))) {
            view.showTipNotification(checkMap.get("message").toString());
            this.getView().updateView();
            return;
        }
        if ("true".equals(checkMap.get("succed"))) {
            HashMap<String, String> paramMap = new HashMap<String, String>(1);
            paramMap.put("inquiryBillNo", inquiryBill.getString("billno"));
            view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"quo_quotetool", paramMap, (CloseCallBack)new CloseCallBack(this.getPluginName(), "quoteToolActionId"), (ShowType)ShowType.MainNewTabPage));
        }
        this.getView().updateView();
    }

    private void unquote() {
        IFormView view = this.getView();
        DynamicObject inquiryBill = this.getModel().getDataEntity(true);
        if (inquiryBill == null || inquiryBill.getPkValue() == null) {
            return;
        }
        QuoInquiryServiceImp service = new QuoInquiryServiceImp();
        Map checkMap = service.verifyUnQuote(inquiryBill.getPkValue());
        if ("false".equals(checkMap.get("succed"))) {
            view.showErrorNotification(checkMap.get("message").toString());
            this.getView().updateView();
            return;
        }
        if ("true".equals(checkMap.get("succed"))) {
            view.showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u4ee3\u8868\u4e0d\u53c2\u4e0e\u9879\u76ee\uff0c\u5982\u5df2\u6709\u62a5\u4ef7\u5c06\u4f5c\u5e9f\uff0c\u8bf7\u8c28\u614e\u5904\u7406\u3002", (String)"QuoInquiryEdit_0", (String)"scm-quo-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmUnquote"));
        }
        this.getView().updateView();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("confirmUnquote".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.confirmUnquote();
        }
    }

    private void confirmUnquote() {
        IFormView view = this.getView();
        DynamicObject inquiryobj = this.getModel().getDataEntity(true);
        if (inquiryobj != null) {
            QuoInquiryServiceImp serviceImp = new QuoInquiryServiceImp();
            if (serviceImp.confirmUnquote(inquiryobj.getPkValue())) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u4e0d\u62a5\u4ef7\u6210\u529f\u3002", (String)"QuoInquiryEdit_1", (String)"scm-quo-formplugin", (Object[])new Object[0]));
                BillModel model = (BillModel)this.getModel();
                model.load(model.getPKValue());
                view.updateView();
                model.setDataChanged(false);
            } else {
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "quote": {
                    this.quoteTool();
                    break;
                }
                case "unquote": {
                    this.unquote();
                    break;
                }
                case "quikquote": {
                    AbstractOperate source = (AbstractOperate)afterDoOperationEventArgs.getSource();
                    String targetBillIds = source.getOption().getVariableValue("targetBillIds");
                    try {
                        Set set = (Set)JacksonJsonUtil.fromJSON((String)targetBillIds, Set.class);
                        if (set == null || set.size() <= 0) break;
                        Object[] objects = set.toArray();
                        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"quo_quote", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)((Long)objects[0]), null, null));
                        break;
                    }
                    catch (IOException e) {
                        log.error("unable to translate targetBillIds from json", (Object)e.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplier = (BasedataEdit)this.getControl("supplier");
        supplier.setQFilter(BizPartnerUtil.assembleQFilterBizPartner());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        IFormView view = this.getView();
        BillModel model = (BillModel)this.getModel();
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "quoteToolActionId": {
                model.load(model.getPKValue());
                view.updateView();
                break;
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setSupplierInfo("entryentity", "supplier");
        this.setAttachmentInfo();
    }

    private void setAttachmentInfo() {
        DynamicObject bidBill = this.getModel().getDataEntity(true);
        DynamicObjectCollection entrylog = bidBill.getDynamicObjectCollection("entrylog");
        AttachmentPanel panel = (AttachmentPanel)this.getControl("attachmentpanel");
        List attachmentData = panel.getAttachmentData();
        if (entrylog != null && attachmentData != null) {
            DynamicObjectCollection entryEntity = bidBill.getDynamicObjectCollection("entryentity");
            Map itemMap = null;
            HashMap<String, Date> turnLogMap = new HashMap<String, Date>(entrylog.size());
            for (Object info : entrylog) {
                turnLogMap.put(info.getString("turns_log"), info.getDate("logdeadline"));
            }
            if (entryEntity != null && entryEntity.size() > 0) {
                HashMap<String, Date> entryMap = new HashMap<String, Date>(entryEntity.size());
                for (DynamicObject info : entryEntity) {
                    entryMap.put(info.getString("entryturns"), info.getDate("deadline"));
                }
                ArrayList dateMapList = new ArrayList();
                HashMap<String, Date> dataMap = null;
                Date date = null;
                String log = null;
                for (DynamicObject info : entrylog) {
                    log = info.getString("turns_log");
                    date = (Date)entryMap.get(log);
                    if (date == null || !StringUtils.isNotBlank((CharSequence)log)) continue;
                    dataMap = new HashMap<String, Date>(2);
                    dataMap.put("end", date);
                    dataMap.put("begin", (Date)turnLogMap.get(String.valueOf(Integer.parseInt(log) - 1)));
                    dateMapList.add(dataMap);
                }
                Iterator iterable = attachmentData.iterator();
                while (iterable.hasNext()) {
                    boolean flag = true;
                    itemMap = (Map)iterable.next();
                    for (Map map : dateMapList) {
                        Date begin = (Date)map.get("begin");
                        Date end = (Date)map.get("end");
                        Long createDate = (Long)itemMap.get("createdate");
                        if (createDate == null || end == null || createDate >= end.getTime() || !flag) continue;
                        if (begin != null && createDate < begin.getTime()) {
                            flag = true;
                            continue;
                        }
                        flag = false;
                    }
                    if (!flag) continue;
                    iterable.remove();
                }
            } else {
                Iterator iterable = attachmentData.iterator();
                Date date = (Date)turnLogMap.get("1");
                while (iterable.hasNext()) {
                    itemMap = (Map)iterable.next();
                    Long createDate = (Long)itemMap.get("createdate");
                    if (date != null && createDate != null && createDate <= date.getTime()) continue;
                    iterable.remove();
                }
            }
        }
        panel.bindData(attachmentData);
    }

    private void setSupplierInfo(String supEntryKey, String supProName) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        this.getView().setVisible(Boolean.FALSE, new String[]{"pl_supplierinfo"});
        String bizstatus = (String)model.getValue("bizstatus");
        DynamicObject bidBill = model.getDataEntity(true);
        DynamicObjectCollection cols = bidBill.getDynamicObjectCollection(supEntryKey);
        cols.sort(Comparator.comparingInt(o -> o.getInt("entryturns")));
        TableValueSetter ts = new TableValueSetter(new String[0]);
        List supIdList = BizPartnerUtil.getSupplierByUserOfBizPartner();
        if (!cols.isEmpty()) {
            Collection turns;
            List propertiesEntity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)((EntryProp)model.getDataEntityType().findProperty(supEntryKey)).getDynamicCollectionItemPropertyType());
            int i = 0;
            DataEntityPropertyCollection properties = cols.getDynamicObjectType().getProperties();
            HashMap entryTurnsCount = new HashMap();
            DynamicObject supColumn = null;
            for (DynamicObject col : cols) {
                DynamicObject supplier = col.getDynamicObject(supProName);
                if (supplier == null || supIdList.isEmpty() || !supIdList.contains(supplier.getPkValue())) continue;
                for (IDataEntityProperty entityType : properties) {
                    String proName = entityType.getName().toLowerCase();
                    Object value = entityType.getValue((Object)col);
                    if (!propertiesEntity.contains(proName)) continue;
                    ts.set(proName, value, i);
                }
                InquirySupParticipateUtils.calMaxTurnsMap(entryTurnsCount, (DynamicObject)col);
                Date deadLine = col.getDate("deadline");
                InquirySupParticipateUtils.setSupProStatus((DynamicObject)col, (Date)deadLine, (String)"supplierbizstatus", (String)col.getString("supplierbizstatus"));
                ts.set("seq", (Object)(i + 1), i);
                ts.set(supProName, supplier.getPkValue(), i);
                ts.set("supplierbizstatus", (Object)col.getString("supplierbizstatus"), i);
                String status = col.getString("supentrystatus");
                if (status == null || status.trim().equals("")) {
                    if ("A".equals(bizstatus) && (deadLine == null || !deadLine.before(TimeServiceHelper.now()))) {
                        ts.set("supentrystatus", (Object)"Z", i);
                    }
                } else {
                    ts.set("supentrystatus", (Object)status, i);
                }
                if (col != null && InquirySupParticipateUtils.isShowSelect((DynamicObject)col)) {
                    supColumn = col;
                }
                ++i;
            }
            if (supColumn != null) {
                model.setValue("supplierprostatus", (Object)supColumn.getString("supplierbizstatus"));
            }
            if ((turns = entryTurnsCount.values()).size() > 0) {
                model.setValue("turns", turns.toArray()[0]);
            } else {
                model.setValue("turns", (Object)"1");
            }
        }
        model.deleteEntryData(supEntryKey);
        model.batchCreateNewEntryRow(supEntryKey, ts);
        this.getView().setVisible(Boolean.TRUE, new String[]{"pl_supplierinfo"});
        model.setDataChanged(false);
    }
}

