/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin.list;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BidStatusEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.quo.common.QuoBidBillUtil;
import kd.scm.quo.formplugin.list.QuoBidListDataProvider;
import kd.scm.quo.formplugin.list.QuoCoreListPlugin;

public class QuoBidBillListPlugin
extends QuoCoreListPlugin {
    private static final String SUPQUOENTRY = "supquoentry";

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List arrayList = e.getQFilters();
        Map supplierMap = BizPartnerUtil.getSupplierWithEnableStatusByUserOfBizPartner();
        ArrayList enableSupplier = new ArrayList(supplierMap.size());
        for (Map.Entry entry : supplierMap.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            enableSupplier.add(entry.getKey());
        }
        arrayList.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getVal()));
        if (enableSupplier.isEmpty()) {
            arrayList.add(new QFilter("supquoentry.entrysupplier", "in", new HashSet(supplierMap.keySet())));
        } else {
            arrayList.add(new QFilter("biztype", "=", (Object)"1").or(new QFilter("biztype", "!=", (Object)"1").and(new QFilter("supquoentry.entrysupplier", "in", new HashSet(supplierMap.keySet())))));
        }
        e.setOrderBy("id desc");
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new QuoBidListDataProvider());
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "bidhall": {
                    this.joinBidHall();
                    break;
                }
                case "enroll": {
                    this.enrollConfirm();
                }
            }
        }
    }

    private void enrollConfirm() {
        IFormView view = this.getView();
        DynamicObject bidBillObj = this.getSelectData();
        if (bidBillObj == null) {
            return;
        }
        if ("G".equals(bidBillObj.getString("bidstatus"))) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u9879\u76ee\u5df2\u7ec8\u6b62\uff0c\u4e0d\u5141\u8bb8\u62a5\u540d\u3002", (String)"QuoBidBillListPlugin_3", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            view.invokeOperation("refresh");
            return;
        }
        Object enrollDate = bidBillObj.get("enrolldate");
        Date date = TimeServiceHelper.now();
        if (enrollDate instanceof Date && ((Date)enrollDate).before(date)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u62a5\u540d\u65f6\u95f4\u5df2\u8fc7", (String)"QuoBidBillListPlugin_0", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            return;
        }
        if (QuoBidBillUtil.checkUserIsEnroll((DynamicObject)bidBillObj)) {
            view.showMessage(ResManager.loadKDString((String)"\u60a8\u5df2\u62a5\u540d\uff0c\u65e0\u9700\u518d\u6b21\u62a5\u540d\u3002", (String)"QuoBidBillListPlugin_1", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> enrollParamMap = new HashMap<String, Object>(4);
        enrollParamMap.put("bidBillId", bidBillObj.getPkValue());
        enrollParamMap.put("bidName", bidBillObj.getString("name"));
        view.showForm(BillFormUtil.assembleShowDynamicFormParam((String)"quo_bidenroll", enrollParamMap, (CloseCallBack)new CloseCallBack(this.getPluginName(), "bidEnrollClose"), (ShowType)ShowType.Modal));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().invokeOperation("refresh");
    }

    private void joinBidHall() {
        IFormView view = this.getView();
        DynamicObject bidBillObj = this.getSelectData();
        if (bidBillObj == null) {
            return;
        }
        Map checkMap = QuoBidBillUtil.verifyJoinBidHall((DynamicObject)bidBillObj);
        if ("false".equals(checkMap.get("succed"))) {
            view.showMessage(checkMap.get("message").toString());
            return;
        }
        if ("true".equals(checkMap.get("succed"))) {
            String quotemode = bidBillObj.getString("quotemode");
            if ("2".equals(quotemode)) {
                this.openDealPage("quo_bidhallbyentry", bidBillObj.getPkValue());
            } else {
                this.openDealPage("quo_bidhall", bidBillObj.getPkValue());
            }
        }
    }

    private void openDealPage(String pageKey, Object pkVale) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("bidBillId", pkVale);
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)pageKey, paramMap, null, (ShowType)ShowType.MainNewTabPage));
    }

    private DynamicObject getSelectData() {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if (objects == null || objects.length != 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u5206\u5f55\u64cd\u4f5c\u3002", (String)"QuoBidBillListPlugin_2", (String)"scm-quo-formplugin", (Object[])new Object[0]));
            return null;
        }
        String selectFields = DynamicObjectUtil.getSelectfields((String)"quo_bidbill", (boolean)false);
        selectFields = DynamicObjectUtil.getEntrySelectfields((String)selectFields, (String)"quo_bidbill", (String)SUPQUOENTRY, (boolean)false);
        long id = Long.parseLong(objects[0].toString());
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"quo_bidbill", (String)selectFields, (QFilter[])new QFilter[]{filter});
        return dynObjs.length == 0 ? null : dynObjs[0];
    }

    public void afterBindData(EventObject e) {
        DynamicObject[] bidBills;
        super.afterBindData(e);
        QFilter bidStatus = new QFilter("bidstatus", "=", (Object)BidStatusEnum.ENROLMENT.getVal());
        QFilter openDateStatus = new QFilter("enrolldate", "<=", (Object)TimeServiceHelper.now());
        for (DynamicObject bidBill : bidBills = BusinessDataServiceHelper.load((String)"sou_bidbill", (String)"bidstatus", (QFilter[])new QFilter[]{bidStatus, openDateStatus})) {
            bidBill.set("bidstatus", (Object)BidStatusEnum.DEADLINE.getVal());
        }
        SaveServiceHelper.save((DynamicObject[])bidBills);
    }
}

