/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.formplugin.list;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.quo.common.QuoInquiryUtil;
import kd.scm.quo.formplugin.list.QuoCoreListPlugin;
import kd.scm.quo.formplugin.list.QuoInquiryListDataProvider;
import kd.scm.quo.service.QuoInquiryServiceImp;

public class QuoInquiryList
extends QuoCoreListPlugin {
    private static Log log = LogFactory.getLog(QuoInquiryList.class);

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List arrayList = e.getQFilters();
        List qFilters = new QuoInquiryServiceImp().getFilters();
        arrayList.addAll(qFilters);
        e.setOrderBy("id desc");
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setStatus(OperationStatus.VIEW);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        switch (operateKey = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "quikquote": {
                DynamicObject dynamicObject = this.validateSelected();
                if (dynamicObject != null) break;
                e.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "quote": {
                    this.quoteTool();
                    break;
                }
                case "unquote": {
                    this.unquote();
                    break;
                }
                case "quikquote": {
                    AbstractOperate source = (AbstractOperate)afterDoOperationEventArgs.getSource();
                    OperateOption variableValue = source.getOption();
                    if (!variableValue.containsVariable("targetBillIds")) break;
                    String targetBillIds = variableValue.getVariableValue("targetBillIds");
                    try {
                        Set set = (Set)JacksonJsonUtil.fromJSON((String)targetBillIds, Set.class);
                        if (set == null || set.size() <= 0) break;
                        Object[] objects = set.toArray();
                        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"quo_quote", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.EDIT, (long)((Long)objects[0]), null, null));
                        break;
                    }
                    catch (IOException e) {
                        log.error("unable to translate targetBillIds from json", (Object)e.getMessage());
                    }
                }
            }
        }
    }

    private void unquote() {
        IFormView view = this.getView();
        ArrayList<String> entryKeyList = new ArrayList<String>();
        entryKeyList.add("entryentity");
        DynamicObject inquiryBill = BillFormUtil.getSelectData((IFormView)view, (String)"quo_inquiry", entryKeyList);
        if (inquiryBill == null) {
            return;
        }
        QuoInquiryServiceImp service = new QuoInquiryServiceImp();
        Map checkMap = service.verifyUnQuote(inquiryBill.getPkValue());
        if ("false".equals(checkMap.get("succed"))) {
            view.showErrorNotification(checkMap.get("message").toString());
            return;
        }
        if ("true".equals(checkMap.get("succed"))) {
            view.showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u4ee3\u8868\u4e0d\u53c2\u4e0e\u9879\u76ee\uff0c\u5982\u5df2\u6709\u62a5\u4ef7\u5c06\u4f5c\u5e9f\uff0c\u8bf7\u8c28\u614e\u5904\u7406\u3002", (String)"QuoInquiryList_0", (String)"scm-quo-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmUnquote"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("confirmUnquote".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.confirmUnquote();
            this.getView().updateView();
        }
    }

    private void confirmUnquote() {
        IFormView view = this.getView();
        ArrayList<String> entryKeyList = new ArrayList<String>();
        entryKeyList.add("entryentity");
        entryKeyList.add("materialentry");
        DynamicObject inquiryBill = BillFormUtil.getSelectData((IFormView)view, (String)"sou_inquiry", entryKeyList);
        if (inquiryBill != null) {
            QuoInquiryUtil.confirmUnquote((DynamicObject)inquiryBill);
            view.showSuccessNotification(ResManager.loadKDString((String)"\u4e0d\u62a5\u4ef7\u6210\u529f\u3002", (String)"QuoInquiryList_1", (String)"scm-quo-formplugin", (Object[])new Object[0]));
        }
    }

    private void quoteTool() {
        IFormView view = this.getView();
        DynamicObject inquiryBill = this.validateSelected();
        if (inquiryBill == null) {
            return;
        }
        Map checkMap = QuoInquiryUtil.verifyQuote((DynamicObject)inquiryBill);
        if ("false".equals(checkMap.get("succed"))) {
            view.showTipNotification(checkMap.get("message").toString());
            return;
        }
        if ("true".equals(checkMap.get("succed"))) {
            this.openDealPage("quo_quotetool", inquiryBill.getString("billno"));
        }
    }

    protected DynamicObject validateSelected() {
        IFormView view = this.getView();
        ArrayList<String> entryKeyList = new ArrayList<String>();
        entryKeyList.add("entryentity");
        DynamicObject inquiryBill = BillFormUtil.getSelectData((IFormView)view, (String)"quo_inquiry", entryKeyList);
        return inquiryBill;
    }

    private void openDealPage(String pageKey, Object billNo) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
        paramMap.put("inquiryBillNo", billNo);
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)pageKey, paramMap, null, (ShowType)ShowType.MainNewTabPage));
    }

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new QuoInquiryListDataProvider());
    }
}

