/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.opplugin;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class QuoBillUpdateBaseQtyOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("materialentry.material");
        e.getFieldKeys().add("materialentry.material.masterid");
        e.getFieldKeys().add("materialentry.material.baseunit.*");
        e.getFieldKeys().add("materialentry.basicunit");
        e.getFieldKeys().add("materialentry.unit");
        e.getFieldKeys().add("materialentry.basicunit.precisionaccount");
        e.getFieldKeys().add("materialentry.basicunit.unitPrecision");
        e.getFieldKeys().add("materialentry.basicqty");
        e.getFieldKeys().add("materialentry.qty");
        if ("sou_quote".equals(this.billEntityType.getName()) || "quo_quote".equals(this.billEntityType.getName())) {
            e.getFieldKeys().add("materialentry.cfmqty");
            e.getFieldKeys().add("materialentry.cfmbaseqty");
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dyns = e.getDataEntities();
        this.doSaveBaseQty(dyns);
    }

    private void doSaveBaseQty(DynamicObject[] dyns) {
        DynamicObject material = null;
        DynamicObject baseunit = null;
        DynamicObject unit = null;
        for (DynamicObject bill : dyns) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entrys) {
                BigDecimal baseqty = entry.getBigDecimal("basicqty");
                boolean isimport = this.getOption().containsVariable("importtype");
                baseunit = entry.getDynamicObject("basicunit");
                if (!isimport && baseunit != null && BigDecimal.ZERO.compareTo(baseqty) != 0 && baseqty != null) continue;
                material = entry.getDynamicObject("material");
                if (baseunit == null && material != null) {
                    baseunit = material.getDynamicObject("baseunit");
                    entry.set("basicunit", (Object)baseunit);
                }
                unit = entry.getDynamicObject("unit");
                baseqty = QuoBillUpdateBaseQtyOp.getDesQtyConv(material, unit, entry.getBigDecimal("qty"), baseunit);
                entry.set("basicqty", (Object)baseqty);
                if (!"sou_quote".equals(this.billEntityType.getName()) && !"quo_quote".equals(this.billEntityType.getName())) continue;
                BigDecimal cfmbaseqty = QuoBillUpdateBaseQtyOp.getDesQtyConv(material, unit, entry.getBigDecimal("cfmqty"), baseunit);
                entry.set("cfmbaseqty", (Object)cfmbaseqty);
            }
        }
    }

    public static BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        BigDecimal qty = BigDecimal.ZERO;
        if (material == null || srcUnit == null || desUnit == null || srcQty == null) {
            qty = BigDecimal.ZERO;
        } else if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
            qty = srcQty;
        } else {
            Long materialId = material.getLong("masterid");
            qty = BaseDataServiceHelper.getDesmuCount((Long)materialId, (Long)srcUnit.getLong("id"), (BigDecimal)srcQty, (Long)desUnit.getLong("id"));
        }
        return qty;
    }
}

