/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.quo.opplugin.validator.QuoToQuoteValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QuoInquiryToQuoteOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(QuoInquiryToQuoteOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("id");
        fieldKeys.add("taxtype");
        fieldKeys.add("sumtax");
        fieldKeys.add("sumtaxamount");
        fieldKeys.add("sumamount");
        fieldKeys.add("bizstatus");
        fieldKeys.add("enddate");
        fieldKeys.add("org");
        fieldKeys.add("turns");
        fieldKeys.add("isautofillprice");
        fieldKeys.add("materialentry.quotecurr");
        fieldKeys.add("materialentry.taxrateid");
        fieldKeys.add("materialentry.taxrate");
        fieldKeys.add("materialentry.price");
        fieldKeys.add("materialentry.taxprice");
        fieldKeys.add("materialentry.exrate");
        fieldKeys.add("materialentry.curr");
        fieldKeys.add("materialentry.dctrate");
        fieldKeys.add("materialentry.qty");
        fieldKeys.add("materialentry.amount");
        fieldKeys.add("materialentry.tax");
        fieldKeys.add("materialentry.taxamount");
        fieldKeys.add("entryentity.supentrystatus");
        fieldKeys.add("entryentity.quoter");
        fieldKeys.add("entryentity.supplier");
        fieldKeys.add("entryentity.canshow");
        fieldKeys.add("entryentity.deadline");
        fieldKeys.add("entryentity.entryturns");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber("sou_inquiry");
        pushArgs.setTargetEntityNumber("sou_quote");
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> selectedRowList = new ArrayList<ListSelectedRow>(16);
        for (DynamicObject dataEntity : dataEntities) {
            ListSelectedRow listSelectedRow = new ListSelectedRow();
            listSelectedRow.setPrimaryKeyValue((Object)dataEntity.getLong("id"));
            selectedRowList.add(listSelectedRow);
        }
        pushArgs.setSelectedRows(selectedRowList);
        Map customParams = pushArgs.getCustomParams();
        OperateOption option = this.getOption();
        customParams.putAll(option.getVariables());
        ConvertOperationResult result = null;
        OperationResult operationResult = this.getOperationResult();
        List allErrorInfos = operationResult.getAllErrorInfo();
        try {
            result = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
            Set targetBillIds = result.getTargetBillIds();
            this.getOption().setVariableValue("targetBillIds", JacksonJsonUtil.toJSON((Object)targetBillIds));
            List billReports = result.getBillReports();
            for (SourceBillReport billReport : billReports) {
                if (billReport.isFullSuccess()) continue;
                this.addErrorInfo(billReport.getFailMessage(), allErrorInfos);
                e.setCancel(true);
            }
        }
        catch (Exception e1) {
            this.addErrorInfo(ResManager.loadKDString((String)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef\uff0c\u8bf7\u518d\u6b21\u6267\u884c", (String)"BillPushAssistUtil_0", (String)"scm-common", (Object[])new Object[0]), allErrorInfos);
            log.error((Object)"\u4e0b\u63a8\u53d1\u751f\u4e86\u9519\u8bef", (Throwable)e1);
        }
    }

    private void addErrorInfo(String failMessage, List<OperateErrorInfo> allErrorInfos) {
        OperateErrorInfo errorInfo = new OperateErrorInfo();
        errorInfo.setMessage(failMessage);
        errorInfo.setLevel(ErrorLevel.Info);
        allErrorInfos.add(errorInfo);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new QuoToQuoteValidator());
    }
}

