/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.opplugin.validator;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.BizPartnerUtil;

public class QuoQuoSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Set bizSpIds = BizPartnerUtil.getBizPartnerIds();
        HashMap<Long, Long> bizSpIdMap = new HashMap<Long, Long>(dataEntities.length);
        HashMap<String, ExtendedDataEntity> inquirynoMap = new HashMap<String, ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity rowDataEntity : dataEntities) {
            String inquiryno;
            DynamicObject model = rowDataEntity.getDataEntity();
            DynamicObject dyn = model.getDynamicObject("supplier");
            Long spId = dyn.getLong("id");
            Long bizSpId = (Long)bizSpIdMap.get(spId);
            if (bizSpId == null) {
                bizSpId = BizPartnerUtil.getBizPartnerBySupplier((Object)spId);
                if (bizSpId == null) {
                    bizSpId = 0L;
                }
                bizSpIdMap.put(spId, bizSpId);
            }
            if (bizSpId == null || !bizSpIds.contains(bizSpId)) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u5f15\u5165\u4e0d\u6210\u529f\u3002", (String)"QuoQuoSaveValidator_0", (String)"scm-quo-opplugin", (Object[])new Object[0]));
            }
            if (StringUtils.isEmpty((CharSequence)(inquiryno = model.getString("inquiryno")))) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QuoQuoSaveValidator_1", (String)"scm-quo-opplugin", (Object[])new Object[0]));
                continue;
            }
            inquirynoMap.put(inquiryno, rowDataEntity);
        }
        if (!inquirynoMap.isEmpty()) {
            DynamicObjectCollection inquiryList = QueryServiceHelper.query((String)"quo_inquiry", (String)"id,billno", (QFilter[])new QFilter("billno", "in", inquirynoMap.keySet()).toArray());
            for (DynamicObject dyn : inquiryList) {
                inquirynoMap.remove(dyn.getString("billno"));
            }
            for (Map.Entry entry : inquirynoMap.entrySet()) {
                this.addErrorMessage((ExtendedDataEntity)entry.getValue(), MessageFormat.format(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u53f7({0})\u4e0d\u5b58\u5728\u3002", (String)"QuoQuoSaveValidator_2", (String)"scm-quo-opplugin", (Object[])new Object[0]), entry.getKey()));
            }
        }
    }
}

