/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.quo.opplugin.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.quo.common.QuoInquiryUtil;

public class QuoToQuoteValidator
extends AbstractValidator {
    public void validate() {
        DynamicObject[] bills;
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<Object> pkIds = new ArrayList<Object>(16);
        HashMap<Object, ExtendedDataEntity> entityMap = new HashMap<Object, ExtendedDataEntity>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            entityMap.put(dataEntity.getBillPkId(), dataEntity);
            DynamicObject inquiryBill = dataEntity.getDataEntity();
            pkIds.add(inquiryBill.getPkValue());
        }
        for (DynamicObject bill : bills = this.loadBillFromDB(pkIds)) {
            ExtendedDataEntity entity;
            Map checkMap = QuoInquiryUtil.verifyQuote((DynamicObject)bill);
            if (!"false".equals(checkMap.get("succed")) || (entity = (ExtendedDataEntity)entityMap.get(bill.getPkValue())) == null) continue;
            this.addErrorMessage(entity, String.valueOf(checkMap.get("message")));
        }
        Map autoBillNoMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"quo", (String)"IQuoteAutoFillService", (String)"getAutoFillNoMap", (Object[])new Object[]{Arrays.asList(bills)});
        ValidateContext validateContext = this.getValidateContext();
        OperateOption option = validateContext.getOption();
        option.setVariableValue("autoBillNoMap", JacksonJsonUtil.toJSON((Object)autoBillNoMap));
    }

    protected DynamicObject[] loadBillFromDB(List<Object> pkIds) {
        return BusinessDataServiceHelper.load((String)"quo_inquiry", (String)"id,billno,isautofillprice,bizstatus,turns,auditdate,enddate,entryentity.supentrystatus,entryentity.supplier,entryentity.canshow,entryentity.supentrystatus,entryentity.quoter,entryentity.deadline,entryentity.entryturns,materialentry.newestturns", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
    }
}

