/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scc.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.AttachmentUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.scc.common.ContractServiceUtil;
import kd.scm.scc.service.ISCCBillService;

public class SccBillService
implements ISCCBillService {
    private static Log log = LogFactory.getLog(SccBillService.class);

    public Map<String, Object> updateContractStatus(Map<String, Object> paramMap) throws Exception {
        log.info("\u4f9b\u5e94\u94fe\u53c2\u6570" + paramMap);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(1024);
        HashMap errdataMap = new HashMap(1024);
        dataMap.put("status", "all");
        dataMap.put("errmsg", "");
        HashMap<String, String> entityMap = new HashMap<String, String>(1024);
        entityMap.put("conm_purcontract", "scc_purchase");
        entityMap.put("conm_xpurcontract", "scc_change");
        entityMap.put("conm_pursupagrt", "scc_supplement");
        entityMap.put("conm_purendagrt", "scc_termination");
        String optype = String.valueOf(paramMap.get("optype"));
        String entityname = String.valueOf(paramMap.get("entity"));
        long operator = Long.parseLong(String.valueOf(paramMap.get("operator")));
        Date optime = (Date)paramMap.get("time");
        List bills = (List)paramMap.get("bills");
        QFilter qFilter = null;
        if ("scc_supplement".equals(entityMap.get(entityname)) || "scc_termination".equals(entityMap.get(entityname))) {
            qFilter = new QFilter("srcbillid", "in", (Object)bills);
        } else {
            QFilter conQFilter = new QFilter("id", "in", (Object)bills);
            String conSelectors = "";
            conSelectors = "scc_purchase".equals(entityMap.get(entityname)) ? "billno" : "changebillno";
            DynamicObject[] cons = BusinessDataServiceHelper.load((String)entityname, (String)conSelectors, (QFilter[])conQFilter.toArray());
            HashSet<String> numberSet = new HashSet<String>(1024);
            for (DynamicObject con : cons) {
                if ("scc_purchase".equals(entityMap.get(entityname))) {
                    numberSet.add(con.getString("billno"));
                    continue;
                }
                numberSet.add(con.getString("changebillno"));
            }
            qFilter = new QFilter("billno", "in", numberSet);
        }
        String conselectors = null;
        if ("scc_change".equals(entityMap.get(entityname))) {
            String srcConSelectors = DynamicObjectUtil.getSelectfields((String)"scc_change", (boolean)false);
            String conBillentrySelectors = DynamicObjectUtil.getEntrySelectfields((String)srcConSelectors, (String)"scc_change", (String)"billentry", (boolean)false);
            String conPayentrySelectors = DynamicObjectUtil.getEntrySelectfields((String)conBillentrySelectors, (String)"scc_change", (String)"payentry", (boolean)false);
            conselectors = DynamicObjectUtil.getEntrySelectfields((String)conPayentrySelectors, (String)"scc_change", (String)"termentry", (boolean)false);
        } else {
            conselectors = "scc_purchase".equals(entityMap.get(entityname)) ? "id,billno,billstatus,conbillno,signstatus,signattachmentcount,validstatus,terminatestatus,signer,signdate,valider,validdate,terminator,terminatedate,reviewstatus,reviewdate,billentry.srcbillid" : "id,billno,billstatus,conbillno,signstatus,signattachmentcount,validstatus,terminatestatus,signer,signdate,valider,validdate,terminator,terminatedate,reviewstatus,reviewdate,srcbillid";
        }
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)((String)entityMap.get(entityname)), (String)conselectors, (QFilter[])qFilter.toArray());
        log.info("\u4f9b\u5e94\u94fe\u5bf9\u8c61" + objs.length);
        if ("unpublish".equals(optype)) {
            ContractServiceUtil.conUnpublish((DynamicObject[])objs, dataMap);
            return dataMap;
        }
        if ("bizvalid".equals(optype)) {
            ContractServiceUtil.conmBizvalid((DynamicObject[])objs, (Long)operator, (Date)optime, (String)((String)entityMap.get(entityname)), (List)bills);
        }
        if ("bizinvalid".equals(optype)) {
            ContractServiceUtil.conmBizinvalid((DynamicObject[])objs, (Long)operator, (Date)optime);
        }
        if ("bizterminate".equals(optype)) {
            ContractServiceUtil.conmBizterminate((DynamicObject[])objs, (Long)operator, (Date)optime, (String)((String)entityMap.get(entityname)));
        }
        if ("review_progress".equals(optype)) {
            ContractServiceUtil.conmReviewProgress((DynamicObject[])objs, (Long)operator, (Date)optime);
        }
        if ("review_passed".equals(optype)) {
            ContractServiceUtil.conmReviewPassed((DynamicObject[])objs, (Long)operator, (Date)optime);
        }
        if ("review_reject".equals(optype)) {
            ContractServiceUtil.conmReviewReject((DynamicObject[])objs, (Long)operator, (Date)optime);
        }
        if ("review_reset".equals(optype)) {
            ContractServiceUtil.conmReviewReset((DynamicObject[])objs, (Long)operator, (Date)optime);
        }
        if ("signconfirm".equals(optype)) {
            ContractServiceUtil.conmSignconfirm((DynamicObject[])objs, (Date)optime);
        }
        if ("sign-parta".equals(optype)) {
            ContractServiceUtil.conmSignPartA((DynamicObject[])objs, (Long)operator, (Date)optime);
        }
        if ("sign-partb".equals(optype)) {
            ContractServiceUtil.conmSignPartB((DynamicObject[])objs, (Long)operator, (Date)optime);
        }
        if ("sign-finish".equals(optype)) {
            ContractServiceUtil.conmSignFinish((DynamicObject[])objs, (Long)operator, (Date)optime, (String)entityname, (String)((String)entityMap.get(entityname)));
        }
        if ("sign-revoke".equals(optype)) {
            ContractServiceUtil.conmSignRevoke((DynamicObject[])objs, (Long)operator, (Date)optime);
        }
        if ("sign-upload".equals(optype)) {
            ContractServiceUtil.conmSignUpload((DynamicObject[])objs, (Long)operator, (Date)optime);
        }
        if ("audit".equals(optype) || "unaudit".equals(optype) || "submit".equals(optype) || "unsubmit".equals(optype)) {
            ContractServiceUtil.conmBillStatusChange((DynamicObject[])objs, (String)optype);
        }
        SaveServiceHelper.save((DynamicObject[])objs);
        dataMap.put("errdata", errdataMap);
        log.info("\u4f9b\u5e94\u94fe\u8fd4\u56de\u53c2\u6570" + dataMap);
        return dataMap;
    }

    public Map<String, String> getSCCSrm(Set<String> orgIdSet) throws Exception {
        Map paramObjByOrg = ParamUtil.getParam((String)"2AN7+R08B0/5", (String)"sccsrm", orgIdSet);
        return paramObjByOrg;
    }

    public HashMap<String, Object> changeOrderBillAttachment(HashMap<String, Object> parameter) throws Exception {
        log.info("\u91c7\u8d2d\u5408\u540c\u7b7e\u7ae0\u9644\u4ef6\u540c\u6b65\uff0c\u4f9b\u5e94\u94fe\u8bf7\u6c42\u53c2\u6570-->{}", parameter);
        try {
            Map<String, Object> checkParamMap = this.checkAttachmentParameter(parameter);
            if (checkParamMap.get("success") != null && checkParamMap.get("success").equals("false")) {
                return (HashMap)checkParamMap;
            }
        }
        catch (Exception e) {
            String expMsg = String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u5408\u540c\u540c\u6b65\u7b7e\u7ae0\u9644\u4ef6\u7684\u8bf7\u6c42\u53c2\u6570\u4e2d\uff0c\u5b58\u5728\u5982\u4e0b\u5f02\u5e38:%s", (String)"SccBillService_2", (String)"scm-scc-mservice", (Object[])new Object[0]), Arrays.toString(e.getStackTrace()));
            log.error(expMsg);
            return this.buildFailureResult(expMsg);
        }
        String billentity = parameter.get("billentity") == null ? "scc_purchase" : (String)parameter.get("billentity");
        Long contractBillId = (Long)parameter.get("pkId");
        DynamicObject sccContractBill = this.getSccContractBill(contractBillId, billentity);
        if (sccContractBill == null) {
            log.info(ResManager.loadKDString((String)"\u534f\u540c\u7aef\u4e0d\u5b58\u5728\u76f8\u5e94\u7684\u5355\u636e\u3002", (String)"SccBillService_1", (String)"scm-scc-mservice", (Object[])new Object[0]));
            return this.buildSuccessResult();
        }
        Map fileInfo = (Map)parameter.get("fileInfo");
        List attachs = new ArrayList();
        if (fileInfo != null) {
            attachs = (List)fileInfo.get("attachs");
        }
        String operate = (String)parameter.get("optype");
        String position = "";
        if (fileInfo != null) {
            position = (String)fileInfo.get("position");
        }
        long sccContractBillId = sccContractBill.getLong("id");
        DynamicObject sccBill = BusinessDataServiceHelper.loadSingle((Object)sccContractBillId, (String)billentity);
        try (TXHandle tx = TX.requiresNew((String)SccBillService.class.getName());){
            try {
                if ("add".equals(operate)) {
                    for (Map attachment : attachs) {
                        String uid = (String)attachment.get("uid");
                        String name = (String)attachment.get("name");
                        Integer size = (Integer)attachment.get("size");
                        String url = (String)attachment.get("url");
                        AttachmentUtil.bindAttachmentFileNew((String)billentity, (String)position, (Object)sccContractBillId, (String)uid, (String)name, (int)size, (String)url);
                    }
                } else if ("remove".equals(operate)) {
                    List uidList = attachs.stream().map(row -> row.get("uid")).collect(Collectors.toList());
                    List billentity1 = AttachmentUtil.getAttachmentFile((String)billentity, (Object)sccContractBillId, (String)position);
                    ArrayList uids = new ArrayList();
                    for (Map map : billentity1) {
                        Object uid = map.get("uid");
                        if (!uidList.contains(uid)) continue;
                        uids.add(uid);
                    }
                    AttachmentUtil.deleteAttachmentFile((String)billentity, (Object)sccContractBillId, uidList);
                    sccBill.set("signattachmentcount", (Object)(sccBill.getLong("signattachmentcount") - (long)uids.size()));
                }
            }
            catch (Exception e) {
                tx.markRollback();
                String expMsg = String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u53d8\u66f4\u65f6\uff0c\u51fa\u73b0\u5f02\u5e38:%s", (String)"SccBillService_3", (String)"scmc-pm-mservice", (Object[])new Object[0]), Arrays.toString(e.getStackTrace()));
                log.error(expMsg);
                HashMap<String, Object> hashMap = this.buildFailureResult(expMsg);
                if (tx != null) {
                    if (var13_14 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var13_14.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return hashMap;
            }
        }
        if ("add".equals(operate)) {
            List attachmentFile = AttachmentUtil.getAttachmentFile((String)billentity, (Object)sccBill.getPkValue(), (String)"signattachment");
            sccBill.set("signattachmentcount", (Object)attachmentFile.size());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sccBill});
        return this.buildSuccessResult();
    }

    private DynamicObject getSccContractBill(Long contractBillId, String billType) {
        String property = "";
        property = "scc_change".equalsIgnoreCase(billType) || "scc_purchase".equalsIgnoreCase(billType) ? "srcid" : "srcbillid";
        QFilter filter = new QFilter(property, "=", (Object)contractBillId);
        DynamicObject sccbill = QueryServiceHelper.queryOne((String)billType, (String)"id", (QFilter[])new QFilter[]{filter});
        String billNo = "";
        if (sccbill == null) {
            QFilter idFilter = new QFilter("id", "=", (Object)contractBillId);
            String billNoName = this.getBillNoName(billType);
            DynamicObject srcEntity = QueryServiceHelper.queryOne((String)this.getSrcBillType(billType), (String)billNoName, (QFilter[])idFilter.toArray());
            billNo = srcEntity.getString(billNoName);
            QFilter billnoFilter = new QFilter("billno", "=", (Object)billNo);
            sccbill = QueryServiceHelper.queryOne((String)billType, (String)"id", (QFilter[])new QFilter[]{billnoFilter});
        }
        return sccbill;
    }

    private String getBillNoName(String billType) {
        if ("scc_change".equals(billType)) {
            return "changebillno";
        }
        return "billno";
    }

    private String getSrcBillType(String billType) {
        switch (billType) {
            case "scc_purchase": {
                return "conm_purcontract";
            }
            case "scc_change": {
                return "conm_xpurcontract";
            }
            case "scc_supplement": {
                return "conm_pursupagrt";
            }
            case "scc_termination": {
                return "conm_purendagrt";
            }
        }
        return "scc_purchase";
    }

    private Map<String, Object> checkAttachmentParameter(HashMap<String, Object> parameter) {
        if (parameter == null || parameter.size() == 0) {
            return this.buildFailureResult(ResManager.loadKDString((String)"\u91c7\u8d2d\u5408\u540c\u540c\u6b65\u7b7e\u7ae0\u9644\u4ef6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u60a8\u6309\u7167\u63a5\u53e3\u89c4\u8303\u7684\u8bf7\u6c42\u53c2\u6570\u8c03\u7528\u5fae\u670d\u52a1\u3002", (String)"SccBillService_4", (String)"scm-scc-mservice", (Object[])new Object[0]));
        }
        Long orderBillId = (Long)parameter.get("pkId");
        if (orderBillId == null) {
            return this.buildFailureResult(ResManager.loadKDString((String)"\u91c7\u8d2d\u5408\u540cID\u53c2\u6570\u5fc5\u586b\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SccBillService_5", (String)"scm-scc-mservice", (Object[])new Object[0]));
        }
        Map fileInfo = (Map)parameter.get("fileInfo");
        if (null == fileInfo || fileInfo.size() == 0) {
            return this.buildFailureResult(ResManager.loadKDString((String)"\u540c\u6b65\u7b7e\u7ae0\u9644\u4ef6\uff0c\u9644\u4ef6\u5217\u8868fileInfo\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SccBillService_6", (String)"scm-scc-mservice", (Object[])new Object[0]));
        }
        List attachInfoSet = (List)fileInfo.get("attachs");
        if (attachInfoSet == null || attachInfoSet.size() == 0) {
            return this.buildFailureResult(ResManager.loadKDString((String)"\u540c\u6b65\u7b7e\u7ae0\u9644\u4ef6\uff0c\u9644\u4ef6\u5217\u8868attachs\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SccBillService_7", (String)"scm-scc-mservice", (Object[])new Object[0]));
        }
        String type = (String)parameter.get("optype");
        if (!"add".equals(type) && !"remove".equals(type)) {
            return this.buildFailureResult(ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u5728\u65b0\u589e\u548c\u5220\u9664\u7c7b\u578b\u4e2d\uff0c\u8bf7\u68c0\u6d4btpye\u7684\u679a\u4e3e\u8303\u56f4\u3002", (String)"SccBillService_8", (String)"scm-scc-mservice", (Object[])new Object[0]));
        }
        return this.buildSuccessResult();
    }

    private HashMap<String, Object> buildSuccessResult() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", "true");
        return map;
    }

    private HashMap<String, Object> buildFailureResult(String errMsg) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("success", "false");
        map.put("errmsg", errMsg);
        return map;
    }
}

