/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scc.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.scc.common.SccAttachMentUtil;
import kd.scm.scc.common.SccConsultUtil;

public class SccContractSaveOp
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(SccContractSaveOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("id");
        filds.add("billentry.srcbillentity");
        filds.add("billentry.srcbillid");
        filds.add("supplier");
        filds.add("billno");
        filds.add("bizpartner_id");
        filds.add("srcid");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List extendedDataEntities = e.getValidExtDataEntities();
        String entityName = ((ExtendedDataEntity)extendedDataEntities.get(0)).getDataEntity().getDataEntityType().getName();
        String srcEntityName = SccConsultUtil.getSrcEntityName((String)entityName);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            dataEntity.set("bizpartner_id", (Object)BizPartnerUtil.getBizPartnerBySupplier((Object)dataEntity.getLong("supplier_id")));
            long srcid = dataEntity.getLong("srcid");
            List attachList = AttachmentServiceHelper.getAttachments((String)srcEntityName, (Object)srcid, (String)"signattachment");
            if (attachList == null || attachList.size() <= 0) continue;
            dataEntity.set("signattachmentcount", (Object)attachList.size());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] contracts = e.getDataEntities();
        HashSet<String> numSet = new HashSet<String>(1024);
        for (DynamicObject con : contracts) {
            numSet.add(con.getString("billno"));
        }
        if (numSet.size() > 0) {
            QFilter qFilter;
            String dataEntity = contracts[0].getDataEntityType().getName();
            HashMap<String, DynamicObject> billno_DynMap = new HashMap<String, DynamicObject>(1024);
            DynamicObject[] tarDyn = null;
            if ("scc_purchase".equals(dataEntity)) {
                qFilter = new QFilter("billno", "in", numSet);
                tarDyn = BusinessDataServiceHelper.load((String)"conm_purcontract", (String)"id,billno", (QFilter[])qFilter.toArray());
            } else {
                qFilter = new QFilter("changebillno", "in", numSet);
                tarDyn = BusinessDataServiceHelper.load((String)"conm_xpurcontract", (String)"id,changebillno", (QFilter[])qFilter.toArray());
            }
            for (DynamicObject dyn : tarDyn) {
                if ("scc_purchase".equals(dataEntity)) {
                    billno_DynMap.put(dyn.getString("billno"), dyn);
                    continue;
                }
                billno_DynMap.put(dyn.getString("changebillno"), dyn);
            }
            for (DynamicObject con : contracts) {
                try (TXHandle h1 = TX.requiresNew();){
                    try {
                        DynamicObject tarObj = (DynamicObject)billno_DynMap.get(con.getString("billno"));
                        if (null == tarObj) continue;
                        String srcEntyity = tarObj.getDataEntityType().getName();
                        String srcid = tarObj.getString("id");
                        SccAttachMentUtil.copyAttachMent((String)srcEntyity, (String)srcid, (String)"signattachment", (String)con.getDataEntityType().getName(), (Long)con.getLong("id"), (String)"signattachment");
                    }
                    catch (Throwable e1) {
                        log.error("\u9644\u4ef6\u540c\u6b65\u5931\u8d25" + e1.getMessage());
                    }
                }
            }
        }
    }
}

