/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scc.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.scm.common.util.AttachmentUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.scc.common.SccAttachMentUtil;

public class ContractServiceUtil {
    private static Log log = LogFactory.getLog(ContractServiceUtil.class);
    static final String[] UN_CONTAIN_PROS = new String[]{"id", "billno", "seq", "srcbillid", "srcbillentryid", "srcbillentryseq", "payentrysrcid", "termentrysrcid"};

    public static void conUnpublish(DynamicObject[] objs, Map<String, Object> dataMap) {
        OperateOption option;
        HashSet<Long> idSet = new HashSet<Long>(1024);
        HashSet<Long> saveIDSet = new HashSet<Long>(1024);
        HashSet<Long> auditIDSet = new HashSet<Long>(1024);
        for (DynamicObject obj : objs) {
            idSet.add(obj.getLong("id"));
            if ("A".equals(obj.getString("billstatus"))) {
                saveIDSet.add(obj.getLong("id"));
            }
            if (!"C".equals(obj.getString("billstatus"))) continue;
            auditIDSet.add(obj.getLong("id"));
        }
        if (auditIDSet.size() > 0) {
            option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            OperationResult unauditResullt = OperationServiceHelper.executeOperate((String)"unaudit", (String)objs[0].getDataEntityType().getName(), (Object[])idSet.toArray(), (OperateOption)option);
            String errmsg = null;
            if (!unauditResullt.isSuccess()) {
                log.info(ExceptionUtil.getErrorInfoDetails((List)unauditResullt.getAllErrorOrValidateInfo()));
                errmsg = ExceptionUtil.getErrorInfoDetails((List)unauditResullt.getAllErrorOrValidateInfo());
                dataMap.put("status", "part");
                dataMap.put("errmsg", errmsg);
            } else {
                OperationResult deleteResullt = OperationServiceHelper.executeOperate((String)"delete", (String)objs[0].getDataEntityType().getName(), (Object[])idSet.toArray(), (OperateOption)option);
                if (!deleteResullt.isSuccess()) {
                    log.info(ExceptionUtil.getErrorInfoDetails((List)deleteResullt.getAllErrorOrValidateInfo()));
                    errmsg = ExceptionUtil.getErrorInfoDetails((List)deleteResullt.getAllErrorOrValidateInfo());
                    dataMap.put("status", "part");
                    dataMap.put("errmsg", errmsg);
                }
            }
        }
        if (saveIDSet.size() > 0) {
            option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            OperationResult deleteResullt = OperationServiceHelper.executeOperate((String)"delete", (String)objs[0].getDataEntityType().getName(), (Object[])idSet.toArray(), (OperateOption)option);
            String errmsg = null;
            if (!deleteResullt.isSuccess()) {
                log.info(ExceptionUtil.getErrorInfoDetails((List)deleteResullt.getAllErrorOrValidateInfo()));
                errmsg = ExceptionUtil.getErrorInfoDetails((List)deleteResullt.getAllErrorOrValidateInfo());
                dataMap.put("status", "part");
                dataMap.put("errmsg", errmsg);
            }
        }
    }

    public static void conmSignconfirm(DynamicObject[] objs, Date optime) {
        for (DynamicObject obj : objs) {
            obj.set("signstatus", (Object)"B");
            obj.set("signdate", (Object)optime);
        }
    }

    public static void conmReviewProgress(DynamicObject[] objs, Long operator, Date optime) {
        for (DynamicObject obj : objs) {
            obj.set("reviewstatus", (Object)"B");
            obj.set("reviewdate", (Object)optime);
        }
    }

    public static void conmReviewPassed(DynamicObject[] objs, Long operator, Date optime) {
        for (DynamicObject obj : objs) {
            obj.set("reviewstatus", (Object)"C");
            obj.set("reviewdate", (Object)optime);
        }
    }

    public static void conmReviewReject(DynamicObject[] objs, Long operator, Date optime) {
        for (DynamicObject obj : objs) {
            obj.set("reviewstatus", (Object)"D");
            obj.set("reviewdate", (Object)optime);
        }
    }

    public static void conmReviewReset(DynamicObject[] objs, Long operator, Date optime) {
        for (DynamicObject obj : objs) {
            obj.set("reviewstatus", (Object)"A");
            obj.set("reviewdate", (Object)optime);
        }
    }

    public static void conmSignFinish(DynamicObject[] objs, Long operator, Date optime, String srcentity, String tarentity) {
        for (DynamicObject obj : objs) {
            String srcId;
            obj.set("signstatus", (Object)"B");
            obj.set("signdate", (Object)optime);
            Long tarId = obj.getLong("id");
            AttachmentUtil.deleteAttachements((String)tarentity, (long)tarId, (String)"signattachment");
            if ("scc_purchase".equals(tarentity) || "scc_change".equals(tarentity)) {
                srcId = ((DynamicObject)obj.getDynamicObjectCollection("billentry").get(0)).getString("srcbillid");
                SccAttachMentUtil.copyAttachMent(srcentity, srcId, "signattachment", tarentity, tarId, "signattachment");
            } else {
                srcId = obj.getString("srcbillid");
                SccAttachMentUtil.copyAttachMent(srcentity, srcId, "signattachment", tarentity, tarId, "signattachment");
            }
            List signattachment = AttachmentUtil.getAttachmentFile((String)tarentity, (Object)tarId, (String)"signattachment");
            obj.set("signattachmentcount", (Object)signattachment.size());
        }
    }

    public static void conmSignPartA(DynamicObject[] objs, Long operator, Date optime) {
        for (DynamicObject obj : objs) {
            obj.set("signstatus", (Object)"E");
            obj.set("signdate", (Object)optime);
        }
    }

    public static void conmSignPartB(DynamicObject[] objs, Long operator, Date optime) {
        for (DynamicObject obj : objs) {
            obj.set("signstatus", (Object)"D");
            obj.set("signdate", (Object)optime);
        }
    }

    public static void conmSignUpload(DynamicObject[] objs, Long operator, Date optime) {
        for (DynamicObject obj : objs) {
            obj.set("signstatus", (Object)"E");
            obj.set("signdate", null);
        }
    }

    public static void conmBillStatusChange(DynamicObject[] objs, String opType) {
        block11: for (DynamicObject obj : objs) {
            switch (opType) {
                case "audit": {
                    obj.set("billstatus", (Object)"C");
                    continue block11;
                }
                case "unaudit": 
                case "unsubmit": {
                    obj.set("billstatus", (Object)"A");
                    continue block11;
                }
                case "submit": {
                    obj.set("billstatus", (Object)"B");
                    continue block11;
                }
            }
        }
    }

    public static void conmSignRevoke(DynamicObject[] objs, Long operator, Date optime) {
        for (DynamicObject obj : objs) {
            obj.set("signstatus", null);
            obj.set("signdate", null);
        }
    }

    public static void conmBizinvalid(DynamicObject[] objs, Long operator, Date optime) {
        for (DynamicObject obj : objs) {
            obj.set("validstatus", (Object)"C");
            obj.set("valider_id", (Object)operator);
            obj.set("validdate", (Object)optime);
        }
    }

    public static void conmBizterminate(DynamicObject[] objs, Long operator, Date optime, String tarentity) {
        HashSet<String> needTerminateCon = new HashSet<String>(1024);
        for (DynamicObject obj : objs) {
            obj.set("terminatestatus", (Object)"B");
            obj.set("terminator_id", (Object)operator);
            obj.set("terminatedate", (Object)optime);
            if (!"scc_termination".equals(tarentity)) continue;
            needTerminateCon.add(obj.getString("conbillno"));
        }
        if (needTerminateCon.size() > 0) {
            DynamicObject[] conObjs;
            QFilter conQfilter = new QFilter("billno", "in", needTerminateCon);
            String selectors = ContractServiceUtil.getBillSelector("scc_purchase");
            for (DynamicObject con : conObjs = BusinessDataServiceHelper.load((String)"scc_purchase", (String)selectors, (QFilter[])conQfilter.toArray())) {
                con.set("terminatestatus", (Object)"B");
                con.set("terminator_id", (Object)operator);
                con.set("terminatedate", (Object)optime);
            }
            SaveServiceHelper.save((DynamicObject[])conObjs);
        }
    }

    public static void conmBizvalid(DynamicObject[] objs, Long operator, Date optime, String tarEntity, List<Long> bills) {
        HashMap<String, DynamicObject> conBillno_ChangeMap = new HashMap<String, DynamicObject>(1024);
        for (DynamicObject obj : objs) {
            obj.set("validstatus", (Object)"B");
            obj.set("valider_id", (Object)operator);
            obj.set("validdate", (Object)optime);
            if (!"scc_change".equals(tarEntity)) continue;
            conBillno_ChangeMap.put(obj.getString("conbillno"), obj);
        }
        if (conBillno_ChangeMap.size() > 0) {
            DynamicObject contractChange = ORM.create().newDynamicObject("conm_xpurcontract");
            QFilter conQfilter = new QFilter("billno", "in", conBillno_ChangeMap.keySet());
            String selectors = ContractServiceUtil.getBillSelector("scc_purchase");
            DynamicObject[] conObjs = BusinessDataServiceHelper.load((String)"scc_purchase", (String)selectors, (QFilter[])conQfilter.toArray());
            String srcConSelectors = ContractServiceUtil.getBillSelector("conm_purcontract");
            DynamicObject[] srcConObjs = BusinessDataServiceHelper.load((String)"conm_purcontract", (String)srcConSelectors, (QFilter[])conQfilter.toArray());
            QFilter conChangeQfilter = new QFilter("id", "in", bills);
            String srcConChangeSelectors = ContractServiceUtil.getBillSelector("conm_xpurcontract");
            DynamicObject[] srcConChangeObjs = BusinessDataServiceHelper.load((String)"conm_xpurcontract", (String)srcConChangeSelectors, (QFilter[])conChangeQfilter.toArray());
            HashSet<Long> upConIdSet = new HashSet<Long>(1024);
            HashSet<Long> delConIdSet = new HashSet<Long>(1024);
            HashSet<Long> allEntryIDSet = new HashSet<Long>(1024);
            for (DynamicObject srconChnge : srcConChangeObjs) {
                ContractServiceUtil.getConEntryIdSetByChangetype(upConIdSet, delConIdSet, srconChnge, "billentry", "billentrychangetype", "billentrysrcid");
                ContractServiceUtil.getConEntryIdSetByChangetype(upConIdSet, delConIdSet, srconChnge, "payentry", "payentrychangetype", "payentrysrcid");
                ContractServiceUtil.getConEntryIdSetByChangetype(upConIdSet, delConIdSet, srconChnge, "termentry", "termentrychangetype", "termentrysrcid");
            }
            allEntryIDSet.addAll(upConIdSet);
            allEntryIDSet.addAll(delConIdSet);
            HashMap<String, Map<Long, DynamicObject>> conBillno_Entry = new HashMap<String, Map<Long, DynamicObject>>(1024);
            HashMap<String, Map<Long, DynamicObject>> conBillno_PayEntryEntry = new HashMap<String, Map<Long, DynamicObject>>(1024);
            HashMap<String, Map<Long, DynamicObject>> conBillno_TermEntry = new HashMap<String, Map<Long, DynamicObject>>(1024);
            HashMap<String, Map<Long, DynamicObject>> conBillno_AddEntry = new HashMap<String, Map<Long, DynamicObject>>(1024);
            HashMap<String, Map<Long, DynamicObject>> conBillno_AddPayEntryEntry = new HashMap<String, Map<Long, DynamicObject>>(1024);
            HashMap<String, Map<Long, DynamicObject>> conBillno_AddTermEntry = new HashMap<String, Map<Long, DynamicObject>>(1024);
            HashMap<String, DynamicObject> billno_srcCon = new HashMap<String, DynamicObject>(1024);
            for (DynamicObject srcCon : srcConObjs) {
                HashMap<Long, DynamicObject> srcBillEntryID_DynMap = new HashMap<Long, DynamicObject>(1024);
                HashMap<Long, DynamicObject> srcPayEntryID_DynMap = new HashMap<Long, DynamicObject>(1024);
                HashMap<Long, DynamicObject> srcTermEntryID_DynMap = new HashMap<Long, DynamicObject>(1024);
                HashMap<Long, DynamicObject> srcBillEntryID_AddDynMap = new HashMap<Long, DynamicObject>(1024);
                HashMap<Long, DynamicObject> srcPayEntryID_AddDynMap = new HashMap<Long, DynamicObject>(1024);
                HashMap<Long, DynamicObject> srcTermEntryID_AddDynMap = new HashMap<Long, DynamicObject>(1024);
                ContractServiceUtil.getSrcEntryIdDynMap(srcBillEntryID_DynMap, srcCon, "billentry", srcBillEntryID_AddDynMap, allEntryIDSet);
                ContractServiceUtil.getSrcEntryIdDynMap(srcPayEntryID_DynMap, srcCon, "payentry", srcPayEntryID_AddDynMap, allEntryIDSet);
                ContractServiceUtil.getSrcEntryIdDynMap(srcTermEntryID_DynMap, srcCon, "termentry", srcTermEntryID_AddDynMap, allEntryIDSet);
                conBillno_Entry.put(srcCon.getString("billno"), srcBillEntryID_DynMap);
                conBillno_PayEntryEntry.put(srcCon.getString("billno"), srcPayEntryID_DynMap);
                conBillno_TermEntry.put(srcCon.getString("billno"), srcTermEntryID_DynMap);
                conBillno_AddEntry.put(srcCon.getString("billno"), srcBillEntryID_AddDynMap);
                conBillno_AddPayEntryEntry.put(srcCon.getString("billno"), srcPayEntryID_AddDynMap);
                conBillno_AddTermEntry.put(srcCon.getString("billno"), srcTermEntryID_AddDynMap);
                billno_srcCon.put(srcCon.getString("billno"), srcCon);
            }
            String[] addBillentryArr = ContractServiceUtil.getEntryWritePrs("scc_purchase", "billentry");
            String[] addPayentryArr = ContractServiceUtil.getEntryWritePrs("scc_purchase", "payentry");
            String[] addTermentryArr = ContractServiceUtil.getEntryWritePrs("scc_purchase", "termentry");
            Map allProsMap = DynamicObjectUtil.getDifferDynamicProperties((DynamicObject)conObjs[0]);
            List allProsList = (List)allProsMap.get("allProList");
            String[] billentrySelectorsArr = ChangeModelHelper.getAllWritebackProperty((IDataEntityType)contractChange.getDataEntityType());
            for (DynamicObject con : conObjs) {
                ContractServiceUtil.doDealHead(con, billno_srcCon, billentrySelectorsArr, allProsList);
                ContractServiceUtil.doDealEntry(con, conBillno_Entry, conBillno_AddEntry, upConIdSet, delConIdSet, "billentry", addBillentryArr);
                ContractServiceUtil.doDealEntry(con, conBillno_PayEntryEntry, conBillno_AddPayEntryEntry, upConIdSet, delConIdSet, "payentry", addPayentryArr);
                ContractServiceUtil.doDealEntry(con, conBillno_TermEntry, conBillno_AddTermEntry, upConIdSet, delConIdSet, "termentry", addTermentryArr);
                con.set("changestatus", (Object)"C");
                con.set("changer", (Object)operator);
                con.set("changedate", (Object)optime);
            }
            SaveServiceHelper.save((DynamicObject[])conObjs);
        }
    }

    public static String[] getEntryWritePrs(String entity, String entryentity) {
        String pros = DynamicObjectUtil.getEntrySelectfields((String)"", (String)entity, (String)entryentity, (boolean)false);
        pros = pros.replace(entryentity + ".", "");
        return pros.split(",");
    }

    public static String getBillSelector(String entity) {
        String srcselectors = DynamicObjectUtil.getSelectfields((String)entity, (boolean)false);
        String billentrySelectors = DynamicObjectUtil.getEntrySelectfields((String)srcselectors, (String)entity, (String)"billentry", (boolean)false);
        String payentrySelectors = DynamicObjectUtil.getEntrySelectfields((String)billentrySelectors, (String)entity, (String)"payentry", (boolean)false);
        String selectors = DynamicObjectUtil.getEntrySelectfields((String)payentrySelectors, (String)entity, (String)"termentry", (boolean)false);
        return selectors;
    }

    private static void getSrcEntryIdDynMap(Map<Long, DynamicObject> srcEntryID_dynMap, DynamicObject srcCon, String billentry, Map<Long, DynamicObject> srcEntryID_AdddynMap, Set<Long> allEntryIDSet) {
        DynamicObjectCollection billEntryCol = srcCon.getDynamicObjectCollection(billentry);
        for (DynamicObject dyn : billEntryCol) {
            if (allEntryIDSet.contains(dyn.getLong("id"))) {
                srcEntryID_dynMap.put(dyn.getLong("id"), dyn);
                continue;
            }
            srcEntryID_AdddynMap.put(dyn.getLong("id"), dyn);
        }
    }

    private static void getConEntryIdSetByChangetype(Set<Long> upConIdSet, Set<Long> delConIdSet, DynamicObject srconChnge, String entryEntity, String type, String srcentryid) {
        DynamicObjectCollection billEntryCol = srconChnge.getDynamicObjectCollection(entryEntity);
        for (DynamicObject dyn : billEntryCol) {
            String changeType = dyn.getString(type);
            if (changeType.equals("A")) continue;
            if (changeType.equals("B")) {
                upConIdSet.add(dyn.getLong(srcentryid));
                continue;
            }
            delConIdSet.add(dyn.getLong(srcentryid));
        }
    }

    private static void doDealHead(DynamicObject con, Map<String, DynamicObject> billno_srcCon, String[] billSelectorsArr, List<String> allProsList) {
        String billlno = con.getString("billno");
        DynamicObject srcCon = billno_srcCon.get(billlno);
        for (String pros : billSelectorsArr) {
            if (pros.equals("changereason") || !allProsList.contains(pros)) continue;
            con.set(pros, srcCon.get(pros));
        }
    }

    private static void doDealEntry(DynamicObject con, Map<String, Map<Long, DynamicObject>> conBillno_Entry, Map<String, Map<Long, DynamicObject>> conBillno_Addentry, Set<Long> upConIdSet, Set<Long> delConIdSet, String entityentry, String[] addBillentryArr) {
        String billno = con.getString("billno");
        Map<Long, DynamicObject> srcBillEntryID_DynMap = conBillno_Entry.get(billno);
        Map<Long, DynamicObject> srcBillEntryID_AddDynMap = conBillno_Addentry.get(billno);
        DynamicObjectCollection billEntryCol = con.getDynamicObjectCollection(entityentry);
        ArrayList<DynamicObject> removeDynEntry = new ArrayList<DynamicObject>(1024);
        for (DynamicObject billEntry : billEntryCol) {
            DynamicObject srcEntry;
            Long entryId = null;
            entryId = "payentry".equals(entityentry) ? Long.valueOf(billEntry.getLong("payentrysrcid")) : ("termentry".equals(entityentry) ? Long.valueOf(billEntry.getLong("termentrysrcid")) : Long.valueOf(billEntry.getLong("srcbillentryid")));
            if (upConIdSet.contains(entryId)) {
                srcEntry = srcBillEntryID_DynMap.get(entryId);
                ContractServiceUtil.updateEntry(billEntry, srcEntry, entityentry, addBillentryArr);
                continue;
            }
            if (!delConIdSet.contains(entryId)) continue;
            srcEntry = srcBillEntryID_DynMap.get(entryId);
            removeDynEntry.add(billEntry);
        }
        billEntryCol.removeAll(removeDynEntry);
        ContractServiceUtil.addEntry(srcBillEntryID_AddDynMap, billEntryCol, entityentry, addBillentryArr);
    }

    private static void addEntry(Map<Long, DynamicObject> srcBillEntryID_addDynMap, DynamicObjectCollection billEntryCol, String entityentry, String[] addBillentryArr) {
        if (srcBillEntryID_addDynMap.size() > 0) {
            for (Map.Entry<Long, DynamicObject> entry : srcBillEntryID_addDynMap.entrySet()) {
                DynamicObject newEntry = billEntryCol.addNew();
                Map differProMap = DynamicObjectUtil.getDifferDynamicProperties((DynamicObject)entry.getValue());
                List allProsList = (List)differProMap.get("allProList");
                for (String pros : addBillentryArr) {
                    if (!allProsList.contains(pros)) continue;
                    newEntry.set(pros, entry.getValue().get(pros));
                }
                ContractServiceUtil.doDiffEntrPros(newEntry, entry.getValue(), addBillentryArr);
            }
        }
    }

    private static void updateEntry(DynamicObject billEntry, DynamicObject srcEntry, String entityentry, String[] addBillentryArr) {
        Map differProMap = DynamicObjectUtil.getDifferDynamicProperties((DynamicObject)srcEntry);
        List allProsList = (List)differProMap.get("allProList");
        for (String pros : addBillentryArr) {
            if (!allProsList.contains(pros) || !ContractServiceUtil.isUnContains(UN_CONTAIN_PROS, pros)) continue;
            billEntry.set(pros, srcEntry.get(pros));
        }
        ContractServiceUtil.doDiffEntrPros(billEntry, srcEntry, addBillentryArr);
    }

    private static void doDiffEntrPros(DynamicObject billEntry, DynamicObject srcEntry, String[] addBillentryArr) {
        if (Arrays.asList(addBillentryArr).contains("srcbillentryid")) {
            billEntry.set("srcbillentryid", srcEntry.get("id"));
            billEntry.set("srcbillentryseq", srcEntry.get("seq"));
            billEntry.set("srcbillentity", (Object)srcEntry.getDataEntityType().getParent().getName());
            billEntry.set("entrystatus", (Object)"A");
        }
        if (Arrays.asList(addBillentryArr).contains("termentrysrcid")) {
            billEntry.set("termentrysrcid", srcEntry.get("id"));
        }
        if (Arrays.asList(addBillentryArr).contains("payentrysrcid")) {
            billEntry.set("payentrysrcid", srcEntry.get("id"));
        }
    }

    private static boolean isUnContains(String[] unContainPros, String pro) {
        boolean isUnContain = true;
        for (String unContainPro : unContainPros) {
            if (!unContainPro.equals(pro)) continue;
            isUnContain = false;
            return isUnContain;
        }
        return isUnContain;
    }
}

