/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scc.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.ParamUtil;

public abstract class AbstractSendMsgCopublish
implements IEventServicePlugin {
    protected abstract String getSrcBillName();

    protected abstract String getBillName();

    protected abstract String getSrcBillNoName();

    protected abstract String getSrcIdName();

    public Map<String, List<Long>> calculateUserIds(KDBizEvent evt) {
        List businesskeys = ((EntityEvent)evt).getBusinesskeys();
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String businesskey : businesskeys) {
            idList.add(Long.parseLong(businesskey));
        }
        QFilter filter = new QFilter("id", "in", idList);
        DynamicObject[] sccBill = BusinessDataServiceHelper.load((String)this.getBillName(), (String)("billno," + this.getSrcIdName() + ",id"), (QFilter[])filter.toArray());
        ArrayList<String> billnoList = new ArrayList<String>();
        HashMap<Long, Long> idsrcIdMap = new HashMap<Long, Long>();
        for (DynamicObject dynamicObject : sccBill) {
            billnoList.add(dynamicObject.getString("billno"));
            idsrcIdMap.put(dynamicObject.getLong(this.getSrcIdName()), dynamicObject.getLong("id"));
        }
        QFilter billnoFilter = new QFilter(this.getSrcBillNoName(), "in", billnoList);
        DynamicObject[] conmBills = BusinessDataServiceHelper.load((String)this.getSrcBillName(), (String)"supplier,iscollaconsult,org", (QFilter[])billnoFilter.toArray());
        HashSet<String> orgIds = new HashSet<String>(businesskeys.size());
        for (DynamicObject conmBill : conmBills) {
            orgIds.add(String.valueOf(conmBill.getLong("org.id")));
        }
        Map map = ParamUtil.getParam((String)"2AN7+R08B0/5", (String)"sccsrm", orgIds);
        ArrayList<Map<Long, DynamicObject>> list = this.getBizpartnerMapList(conmBills, map, idsrcIdMap);
        HashMap<String, List<Long>> idsMap = new HashMap<String, List<Long>>();
        this.fillUserIdMap(list, idsMap);
        return idsMap;
    }

    private ArrayList<Map<Long, DynamicObject>> getBizpartnerMapList(DynamicObject[] conmBills, Map<String, String> enableSupMap, HashMap<Long, Long> idsrcIdMap) {
        ArrayList<Map<Long, DynamicObject>> list = new ArrayList<Map<Long, DynamicObject>>();
        for (DynamicObject conmBill : conmBills) {
            boolean iscollaconsult = conmBill.getBoolean("iscollaconsult");
            DynamicObject supplier = conmBill.getDynamicObject("supplier");
            if (!supplier.getBoolean("issuppcolla") || !iscollaconsult || !"true".equals(enableSupMap.get(String.valueOf(conmBill.getLong("org.id"))))) continue;
            HashMap<Long, DynamicObject> contractIdWithSupIdMap = new HashMap<Long, DynamicObject>();
            contractIdWithSupIdMap.put(idsrcIdMap.get(conmBill.getLong("id")), supplier);
            list.add(contractIdWithSupIdMap);
        }
        return list;
    }

    private void fillUserIdMap(ArrayList<Map<Long, DynamicObject>> list, HashMap<String, List<Long>> ids) {
        for (Map<Long, DynamicObject> contractIdWithSupIdMap : list) {
            for (Map.Entry<Long, DynamicObject> contractIdWithSupIdMapEntry : contractIdWithSupIdMap.entrySet()) {
                DynamicObject supplier = contractIdWithSupIdMapEntry.getValue();
                HashSet<Long> bizidSet = new HashSet<Long>();
                bizidSet.add(supplier.getDynamicObject("bizpartner").getLong("id"));
                List adminSupUserIdsByBizPartner = BizPartnerUtil.getEnableAdminSupUserIdsByBizPartner(bizidSet);
                ids.put(contractIdWithSupIdMapEntry.getKey().toString(), adminSupUserIdsByBizPartner);
            }
        }
    }

    public Map<String, String> buildBillUrl(KDBizEvent evt) {
        HashMap<String, String> urlMaps = new HashMap<String, String>(16);
        StringBuilder url = new StringBuilder();
        String businesskey = (String)((EntityEvent)evt).getBusinesskeys().get(0);
        if (StringUtils.isNotEmpty((CharSequence)businesskey)) {
            String domainContextUrl = UrlService.getDomainContextUrl();
            url.append(domainContextUrl).append("/index.html?formId=").append(this.getBillName());
            url.append("&pkId=").append(businesskey);
        }
        urlMaps.put(businesskey, url.toString());
        return urlMaps;
    }
}

