/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scc.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.ParamUtil;

public class SendMsgWhenContractAudit
implements IEventServicePlugin {
    public Map<String, List<Long>> calculateUserIds(KDBizEvent evt) {
        List businesskeys = ((EntityEvent)evt).getBusinesskeys();
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String businesskey : businesskeys) {
            idList.add(Long.parseLong(businesskey));
        }
        QFilter filter = new QFilter("id", "in", idList);
        DynamicObject[] conm_purcontracts = BusinessDataServiceHelper.load((String)"conm_purcontract", (String)"type,supplier,org,iscollaconsult", (QFilter[])filter.toArray());
        HashSet<String> orgIds = new HashSet<String>(businesskeys.size());
        for (DynamicObject conm_purcontract : conm_purcontracts) {
            orgIds.add(String.valueOf(conm_purcontract.getLong("org.id")));
        }
        Map enableSupMap = ParamUtil.getParam((String)"2AN7+R08B0/5", (String)"sccsrm", orgIds);
        ArrayList<Map<Long, DynamicObject>> list = this.getBizpartnerMapList(conm_purcontracts, enableSupMap);
        HashMap<String, List<Long>> idsMap = new HashMap<String, List<Long>>();
        this.fillUserIdMap(list, idsMap);
        return idsMap;
    }

    private ArrayList<Map<Long, DynamicObject>> getBizpartnerMapList(DynamicObject[] conm_purcontracts, Map<String, String> enableSupMap) {
        ArrayList<Map<Long, DynamicObject>> list = new ArrayList<Map<Long, DynamicObject>>();
        for (DynamicObject purcontract : conm_purcontracts) {
            DynamicObject type = purcontract.getDynamicObject("type");
            boolean activereview = type.getBoolean("activereview");
            boolean iscollaconsult = purcontract.getBoolean("iscollaconsult");
            DynamicObject supplier = purcontract.getDynamicObject("supplier");
            if (!supplier.getBoolean("issuppcolla") || activereview || iscollaconsult || !"true".equals(enableSupMap.get(String.valueOf(purcontract.getLong("org.id"))))) continue;
            HashMap<Long, DynamicObject> contractIdWithSupIdMap = new HashMap<Long, DynamicObject>();
            contractIdWithSupIdMap.put(purcontract.getLong("id"), supplier);
            list.add(contractIdWithSupIdMap);
        }
        return list;
    }

    private void fillUserIdMap(ArrayList<Map<Long, DynamicObject>> list, HashMap<String, List<Long>> ids) {
        for (Map<Long, DynamicObject> contractIdWithSupIdMap : list) {
            for (Map.Entry<Long, DynamicObject> contractIdWithSupIdMapEntry : contractIdWithSupIdMap.entrySet()) {
                DynamicObject supplier = contractIdWithSupIdMapEntry.getValue();
                HashSet<Long> bizidSet = new HashSet<Long>();
                bizidSet.add(supplier.getDynamicObject("bizpartner").getLong("id"));
                List adminSupUserIdsByBizPartner = BizPartnerUtil.getEnableAdminSupUserIdsByBizPartner(bizidSet);
                ids.put(contractIdWithSupIdMapEntry.getKey().toString(), adminSupUserIdsByBizPartner);
            }
        }
    }

    public String buildUrl(KDBizEvent evt) {
        String srmContractId;
        StringBuilder url = new StringBuilder();
        String businesskey = (String)((EntityEvent)evt).getBusinesskeys().get(0);
        if (StringUtils.isNotEmpty((CharSequence)businesskey) && (srmContractId = this.getSrmContractId(businesskey)) != null) {
            String domainContextUrl = UrlService.getDomainContextUrl();
            url.append(domainContextUrl).append("/index.html?formId=").append("scc_purchase");
            url.append("&pkId=").append(srmContractId);
        }
        return url.toString();
    }

    private String getSrmContractId(String businesskey) {
        QFilter idFilter = new QFilter("id", "=", (Object)Long.parseLong(businesskey));
        DynamicObject conm_purcontract = QueryServiceHelper.queryOne((String)"conm_purcontract", (String)"id", (QFilter[])idFilter.toArray());
        if (conm_purcontract != null) {
            QFilter srcidFilter = new QFilter("srcid", "=", (Object)conm_purcontract.getLong("id"));
            DynamicObject conm_purchase = QueryServiceHelper.queryOne((String)"scc_purchase", (String)"id", (QFilter[])srcidFilter.toArray());
            return conm_purchase == null ? null : conm_purchase.getString("id");
        }
        return null;
    }
}

