/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.ScmcUtil;
import kd.scm.scp.mservice.IPurSalOutStockToReceive;
import org.apache.commons.lang.StringUtils;

public final class PurSalOutStockToReceive
implements IPurSalOutStockToReceive {
    private static final Log log = LogFactory.getLog((String)PurSalOutStockToReceive.class.getName());
    private static final String IM_PURRECEIVEBILL = "im_purreceivebill";
    private static final String IM_PURINBILL = "im_purinbill";

    public Map<String, Object> salOutStockToReceive(Map<String, Object> paramMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("succed", Boolean.TRUE);
        String sourceEntity = paramMap.get("sourceEntity").toString();
        String targetEntity = paramMap.get("targetEntity").toString();
        Object botpNumberObj = paramMap.get("botpNumber");
        String botpNumber = null;
        if (botpNumberObj != null) {
            botpNumber = botpNumberObj.toString();
        }
        Map pushOrderData = (Map)paramMap.get("pushOrderData");
        Set salOutEntryIds = (Set)paramMap.get("salOutEntryIds");
        Map salOutInfoMap = (Map)paramMap.get("salOutInfoMap");
        LinkedHashMap rowSalOutInfoMap = (LinkedHashMap)paramMap.get("rowSalOutInfoMap");
        Boolean needWriteBillNo = (Boolean)paramMap.getOrDefault("needWriteBillNo", Boolean.TRUE);
        return this.pushStockBill(resultMap, sourceEntity, targetEntity, pushOrderData, salOutEntryIds, salOutInfoMap, rowSalOutInfoMap, needWriteBillNo, botpNumber);
    }

    private Map<String, Object> pushStockBill(Map<String, Object> resultMap, String sourceEntity, String targetEntity, Map<Long, Collection<Long>> pushOrderData, Set<String> salOutEntryIds, Map<String, String> salOutInfoMap, LinkedHashMap<String, List<Map<String, String>>> rowSalOutInfoMap, Boolean needWriteBillNo, String ruleId) {
        ConvertRuleElement convertRuleElementParam = null;
        if (StringUtils.isNotBlank((String)ruleId)) {
            convertRuleElementParam = ConvertMetaServiceHelper.loadRule((String)ruleId);
        } else {
            List ruleList = ConvertMetaServiceHelper.loadRules((String)sourceEntity, (String)targetEntity);
            if (ruleList != null && !ruleList.isEmpty()) {
                convertRuleElementParam = new ConvertRuleElement();
                convertRuleElementParam.setSourceEntityNumber(sourceEntity);
                convertRuleElementParam.setTargetEntityNumber(targetEntity);
            } else {
                String errorMessage = ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\uff0c\u81ea\u52a8\u9a8c\u6536\u5931\u8d25\u3002", (String)"PurAcceptApplyToPuracceptbillService_0", (String)"scm-pur-mservice", (Object[])new Object[0]);
                throw new KDException(new ErrorCode("SRMERRORCODE005", errorMessage), new Object[]{errorMessage});
            }
        }
        if (convertRuleElementParam != null) {
            if (salOutInfoMap != null && !salOutInfoMap.isEmpty()) {
                resultMap.putAll(ScmcUtil.pushStockBill((ConvertRuleElement)convertRuleElementParam, pushOrderData, salOutInfoMap));
            }
            if (rowSalOutInfoMap != null && !rowSalOutInfoMap.isEmpty()) {
                resultMap.putAll(ScmcUtil.pushStockBill((ConvertRuleElement)convertRuleElementParam, pushOrderData, rowSalOutInfoMap));
            }
            if (needWriteBillNo.booleanValue()) {
                HashMap<String, String> autoNoOfMap = new HashMap<String, String>(16);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"", (String)targetEntity, (String)"billno,billentry.srcsysbillentryid srcsysbillentryid", (QFilter[])new QFilter[]{new QFilter("billentry.srcsysbillentryid", "in", salOutEntryIds)}, (String)"id");){
                    while (dataSet.hasNext()) {
                        Row row2 = dataSet.next();
                        autoNoOfMap.put(row2.getString("srcsysbillentryid"), row2.getString("billno"));
                    }
                }
                if (!autoNoOfMap.isEmpty()) {
                    resultMap.put("message", ((Object)autoNoOfMap).toString());
                }
                HashSet salOutLongEntryIds = new HashSet(16);
                salOutEntryIds.forEach(row -> salOutLongEntryIds.add(Long.valueOf(row)));
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"scp_saloutstock", (String)"id,billno,materialentry.autorecbillno", (QFilter[])new QFilter[]{new QFilter("materialentry.id", "in", salOutLongEntryIds)});
                if (dynamicObjects != null && dynamicObjects.length > 0) {
                    for (DynamicObject bill : dynamicObjects) {
                        DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
                        for (DynamicObject row3 : rows) {
                            String entryId = row3.getString("id");
                            String autoBillNo = (String)autoNoOfMap.get(entryId);
                            if (autoBillNo == null || autoBillNo.isEmpty()) continue;
                            row3.set("autorecbillno", (Object)autoBillNo);
                        }
                    }
                }
                SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])dynamicObjects);
            }
        } else {
            String errorMessage = ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u8f6c\u6362\u89c4\u5219\uff0c\u81ea\u52a8\u6536\u8d27\u5931\u8d25\u3002", (String)"PurSalOutStockToReceive_0", (String)"scm-pur-mservice", (Object[])new Object[0]);
            throw new KDException(new ErrorCode("SRMERRORCODE005", errorMessage), new Object[]{errorMessage});
        }
        return resultMap;
    }

    public Map<String, Object> salOutStockDeleteReceive(Map<String, Object> paramMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.put("succed", Boolean.TRUE);
        resultMap.put("message", "");
        Set imReceiveBillIds = (Set)paramMap.get("imReceiveBillIds");
        Set numberSet = (Set)paramMap.get("imReceiveBillNo");
        if (!imReceiveBillIds.isEmpty()) {
            OperationResult operationResult = null;
            try {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
                operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)IM_PURRECEIVEBILL, (Object[])imReceiveBillIds.toArray(), (OperateOption)operateOption);
                if (operationResult != null) {
                    if (!operationResult.isSuccess() || operationResult.getSuccessPkIds().size() <= 0) {
                        resultMap.put("succed", Boolean.FALSE);
                        StringBuilder messageError = new StringBuilder();
                        messageError.append(operationResult.getMessage());
                        operationResult.getAllErrorOrValidateInfo().forEach(row -> messageError.append(row.getMessage()).append("\n\t"));
                        resultMap.put("message", messageError.toString());
                        throw new KDException(new ErrorCode("SRMERRORCODE002", messageError.toString()), new Object[]{messageError.toString()});
                    }
                    if (!numberSet.isEmpty()) {
                        DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"clearSaloutEntryAutoRecBillno", (Object[])new Object[]{numberSet});
                    }
                }
            }
            catch (Throwable throwable) {
                log.error(throwable);
                resultMap.put("succed", Boolean.FALSE);
                resultMap.put("message", ExceptionUtil.getStackTrace((Throwable)throwable));
                String errorMessage = throwable.getMessage() != null ? throwable.getMessage() : ResManager.loadKDString((String)"\u53d1\u751f\u4e86\u610f\u6599\u4e4b\u5916\u7684\u5f02\u5e38\u3002", (String)"PurSalOutStockToReceive_1", (String)"scm-pur-mservice", (Object[])new Object[0]);
                throw new KDException(new ErrorCode("SRMERRORCODE003", errorMessage), new Object[]{errorMessage});
            }
        }
        return resultMap;
    }
}

