/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.service.jointplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.scm.common.helper.multisystemjoint.MultiDataHandleResult;
import kd.scm.common.helper.multisystemjoint.business.MultiJointParamServiceProxyHelper;
import kd.scm.common.helper.multisystemjoint.entity.ScDataMultiJointChannelInfo;
import kd.scm.common.helper.multisystemjoint.param.ScMultiCosmicIscParamArgs;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.common.helper.multisystemjoint.param.plugin.AbstractCustomParamPlugin;
import kd.scm.common.service.botp.entity.BotpRule;
import kd.scm.common.service.botp.impl.EasBotpServiceImpl;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.JacksonJsonUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.scp.business.ScpAutoStockBillHelper;
import kd.scm.scp.business.ScpSalOutStockBillHelper;

public final class ScpOrderCreateStockBillForEASStdPlugin
extends AbstractCustomParamPlugin {
    protected Boolean verifyEnable(List<DynamicObject> dynamicObjects) {
        Boolean isAutoReceive = Boolean.FALSE;
        HashSet<Long> unitOrgIds = new HashSet<Long>(16);
        for (DynamicObject bill : dynamicObjects) {
            unitOrgIds.add(bill.getLong("org.id"));
        }
        Map autoReceiptNoticeBill = ScpAutoStockBillHelper.verifyAutoReceiptBill(unitOrgIds);
        isAutoReceive = autoReceiptNoticeBill.values().stream().allMatch(row -> row);
        return isAutoReceive;
    }

    public List<DynamicObject> getDynamicObjects(Long[] pkIds) {
        return super.loadDynamicObjects(pkIds);
    }

    protected ScMultiParamArgs assembleJointParam(List<DynamicObject> dynamicObjects) {
        ScMultiCosmicIscParamArgs multiCosmicIscParamArgs = new ScMultiCosmicIscParamArgs();
        HashMap<String, String> org_IdMap = new HashMap<String, String>(1024);
        HashSet<String> recOrgIdSet = new HashSet<String>(1024);
        HashSet<String> entryIdSet = new HashSet<String>(dynamicObjects.size());
        HashSet<String> billIdSet = new HashSet<String>(dynamicObjects.size());
        HashMap billMap = new HashMap(16);
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        Map autoExtEntryPro = ScpSalOutStockBillHelper.assembleAutoExtEntryPro();
        for (DynamicObject bill : dynamicObjects) {
            DynamicObject org = bill.getDynamicObject("org");
            if (org != null) {
                recOrgIdSet.add(org.getString("id"));
                org_IdMap.put(org.getString("number"), org.getString("id"));
            }
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : rows) {
                String poBillId = row.getString("pobillid");
                String poEntryId = row.getString("poentryid");
                if (poBillId.isEmpty() || poEntryId.isEmpty()) continue;
                entryIdSet.add(poEntryId);
                billIdSet.add(poBillId);
            }
        }
        HashMap<String, Object> customParam = new HashMap<String, Object>(3);
        customParam.put("srctype", "order");
        customParam.put("targetBillType", "receive");
        String botpNumber = null;
        EasBotpServiceImpl botpService = new EasBotpServiceImpl();
        customParam.put("billId", billIdSet);
        customParam.put("entryId", entryIdSet);
        customParam.put("isclinknumber", this.getScDataChannelInfo().getIscLinkNumber());
        List ruleList = botpService.getRuleList("order", "receive", customParam);
        if (ruleList != null && !ruleList.isEmpty()) {
            botpNumber = ((BotpRule)ruleList.get(0)).getId();
        }
        if (botpNumber != null && !botpNumber.isEmpty()) {
            for (DynamicObject bill : dynamicObjects) {
                String billNo = bill.getString("billno");
                String billIdStr = bill.getString("id");
                DynamicObject org = bill.getDynamicObject("org");
                if (org != null) {
                    recOrgIdSet.add(org.getString("id"));
                    org_IdMap.put(org.getString("number"), org.getString("id"));
                }
                DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
                for (DynamicObject row : rows) {
                    HashMap<String, Object> billInfoMap = new HashMap<String, Object>(16);
                    String entryId = row.getString("id");
                    String poBillId = row.getString("pobillid");
                    String poEntryId = row.getString("poentryid");
                    if (poBillId.isEmpty() || poEntryId.isEmpty()) continue;
                    billInfoMap.put("lot", row.getString("lot"));
                    billInfoMap.put("suplot", row.getString("suplot"));
                    billInfoMap.put("srcEntryId", entryId);
                    billInfoMap.put("qty", row.getBigDecimal("qty"));
                    billInfoMap.put("billid", poBillId);
                    billInfoMap.put("entryId", poEntryId);
                    billInfoMap.put("srcBillNo", billNo);
                    billInfoMap.put("srcBillId", billIdStr);
                    billInfoMap.put("proddate", row.getDate("proddate"));
                    billInfoMap.put("mfg", row.getDate("proddate"));
                    billInfoMap.put("duedate", row.getDate("duedate"));
                    billInfoMap.put("exp", row.getDate("duedate"));
                    billInfoMap.put("unit", row.getDynamicObject("unit") == null ? "" : row.getDynamicObject("unit").getString("number"));
                    billInfoMap.put("basicUnit", row.getDynamicObject("basicunit") == null ? "" : row.getDynamicObject("basicunit").getString("number"));
                    billInfoMap.put("warehouse", row.getDynamicObject("warehouse") == null ? "" : row.getDynamicObject("warehouse").getString("number"));
                    billInfoMap.put("location", "");
                    billInfoMap.put("trace", row.getDynamicObject("trace") == null ? "" : row.getDynamicObject("trace").getString("number"));
                    billInfoMap.put("supplierlot", row.getString("suplot"));
                    if (billMap.isEmpty()) {
                        billMap.putAll(ScpSalOutStockBillHelper.assembleAutoExtStockBill((DynamicObject)bill, (Map)autoExtEntryPro));
                        billInfoMap.putAll(billMap);
                    } else {
                        billInfoMap.putAll(billMap);
                    }
                    billInfoMap.putAll(ScpSalOutStockBillHelper.assembleAutoExtStockBill((DynamicObject)row, (Map)autoExtEntryPro));
                    billInfoMap.put("extFieldSet", autoExtEntryPro.values());
                    dataMap.put(entryId, billInfoMap);
                }
            }
            HashMap<String, Object> groupedData = new HashMap<String, Object>();
            dataMap.forEach((key, val) -> {
                Map data = (Map)val;
                String srcBillId = String.valueOf(data.get("srcBillId"));
                ArrayList<Map> list = (ArrayList<Map>)groupedData.get(srcBillId);
                if (list == null) {
                    list = new ArrayList<Map>();
                }
                list.add(data);
                groupedData.put(srcBillId, list);
            });
            Map paramMap = ParamUtil.getParam((String)"eae607fb000143ac", (String)"recbillstatus", recOrgIdSet);
            org_IdMap.replaceAll((k, v) -> (String)paramMap.get(v));
            groupedData.put("billstatus1", org_IdMap);
            groupedData.put("billstatus", ParamUtil.getParam((String)"eae607fb000143ac", (String)"recbillstatus"));
            groupedData.put("botpNumber", botpNumber);
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("tobilltype", "receive");
            param.put("billtype", "pur_outstock");
            param.put("data", groupedData);
            param.put("action", "receive");
            param.put("code", "200");
            ApiUtil.putUserNUmberData(param, (String)"scp_saloutstock", (DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
            multiCosmicIscParamArgs.getStdDelegate().setCloudId("isc");
            multiCosmicIscParamArgs.getStdDelegate().setAppId("iscb");
            multiCosmicIscParamArgs.setIscLinkNumber(this.getScDataChannelInfo().getIscLinkNumber());
            multiCosmicIscParamArgs.setIscSourceNumber(this.getScDataChannelInfo().getIscDataSourceNumber());
            String facdeService = "facade://com.kingdee.eas.scm.nsrm.app.BizDealFacade:doIerp2Receive";
            MultiJointParamServiceProxyHelper.modifyIscJointParamArgs((ScMultiCosmicIscParamArgs)multiCosmicIscParamArgs, (ScDataMultiJointChannelInfo)this.getScDataChannelInfo(), (String)facdeService);
            multiCosmicIscParamArgs.putCustomMap("data", param);
        }
        return multiCosmicIscParamArgs;
    }

    public void callBack(MultiDataHandleResult scDataHandleResult) {
        String messageJsonString = scDataHandleResult.getMessage();
        if (messageJsonString != null) {
            HashMap messageMap = new HashMap();
            try {
                String messageString = (String)SerializationUtils.fromJsonString((String)messageJsonString, Object.class);
                messageMap.putAll((Map)JacksonJsonUtil.fromJson((String)messageString, Map.class));
                if (!messageMap.isEmpty()) {
                    ScpAutoStockBillHelper.updateSalOutStockReceiptBillNO(messageMap);
                }
            }
            catch (Throwable throwable) {
                this.logger.error(ExceptionUtil.getStackTrace((Throwable)throwable));
            }
        }
    }
}

