/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.service.jointplugin;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.scm.common.helper.multisystemjoint.param.ScMultiCosmicStdParamArgs;
import kd.scm.common.helper.multisystemjoint.param.ScMultiParamArgs;
import kd.scm.common.helper.multisystemjoint.param.plugin.AbstractCustomParamPlugin;
import kd.scm.scp.business.ScpAutoStockBillHelper;

public final class ScpOrderDeleteReceiptNoticeForSelfCosmicStdPlugin
extends AbstractCustomParamPlugin {
    protected Collection<String> getProperty() {
        HashSet<String> propertys = new HashSet<String>(1);
        propertys.add("materialentry.autorecbillno autorecbillno");
        propertys.add("org");
        return propertys;
    }

    protected Set<String> getGroupKeys() {
        HashSet<String> groupKey = new HashSet<String>(1);
        groupKey.add("autorecbillno");
        groupKey.add("org");
        return groupKey;
    }

    protected Boolean verifyEnable(List<DynamicObject> dynamicObjects) {
        Boolean isAutoReceive = Boolean.FALSE;
        HashSet<Long> unitOrgIds = new HashSet<Long>(16);
        for (DynamicObject bill : dynamicObjects) {
            unitOrgIds.add(bill.getLong("org.id"));
        }
        Map autoReceiptNoticeBill = ScpAutoStockBillHelper.verifyAutoReceiptNoticeBill(unitOrgIds);
        isAutoReceive = autoReceiptNoticeBill.values().stream().allMatch(row -> row);
        return isAutoReceive;
    }

    public ScMultiParamArgs assembleJointParam(List<DynamicObject> dynamicObjects) {
        ScMultiCosmicStdParamArgs scMultiParamArgs = new ScMultiCosmicStdParamArgs();
        scMultiParamArgs.setCloudId("scm");
        scMultiParamArgs.setAppId("scp");
        scMultiParamArgs.setServiceName("IPurSalOutStockToReceive");
        scMultiParamArgs.setMethodName("salOutStockDeleteReceive");
        HashMap toStockParamMap = new HashMap(2);
        scMultiParamArgs.setParamMap(toStockParamMap);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ScpOrderConfirmForEasPlugin#scMultiParamArgs:{}", (Object)SerializationUtils.toJsonString((Object)scMultiParamArgs));
        }
        return scMultiParamArgs;
    }
}

