/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.service.scpsaloutstock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scm.common.helper.scdatahandle.args.AssembleHandleArgs;
import kd.scm.common.helper.scdatahandle.args.CosmicParamArgs;
import kd.scm.common.helper.scdatahandle.args.EASParamArgs;
import kd.scm.common.helper.scdatahandle.args.ScDataHandleArgs;
import kd.scm.common.helper.scdatahandle.args.XkParamArgs;
import kd.scm.common.helper.scdatahandle.handleplugin.AbstractDataHandlePlugin;
import kd.scm.common.util.OrderUtil;
import kd.scm.common.util.SaloutUtil;

public final class ScpSalOutStockUnAuditPlugin
extends AbstractDataHandlePlugin {
    private String entityType = "scp_saloutstock";
    protected Log logger = LogFactory.getLog(ScpSalOutStockUnAuditPlugin.class);
    protected final String filed = "billno,billstatus,logstatus,srctype,cfmstatus,materialentry.qty,materialentry.srcentryid,materialentry.srcbillid,materialentry.suminstockretqty,materialentry.sumrecretqty,materialentry.poentryid,materialentry.sumoutstockqty,materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.suminstockqty,materialentry.entrystatus,materialentry.pobillid,materialentry.rowlogstatus";

    public void assembleCosmicHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        Set poBillIdSet = SaloutUtil.getPoBillIds((DynamicObject[])assembleHandleArgs.getDynamicObjects());
        HashMap<String, HashSet<Long>> statusMap = new HashMap<String, HashSet<Long>>(3);
        DynamicObject[] orderBills = OrderUtil.getOrdersByPoBillIdS((String)"billno,billstatus,logstatus,srctype,cfmstatus,materialentry.qty,materialentry.srcentryid,materialentry.srcbillid,materialentry.suminstockretqty,materialentry.sumrecretqty,materialentry.poentryid,materialentry.sumoutstockqty,materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.suminstockqty,materialentry.entrystatus,materialentry.pobillid,materialentry.rowlogstatus", (Set)poBillIdSet);
        for (DynamicObject bill : orderBills) {
            String currentLogStatus = bill.getString("logstatus");
            DynamicObjectCollection materialentry = bill.getDynamicObjectCollection("materialentry");
            for (DynamicObject row : materialentry) {
                String poId = row.getString("pobillid");
                if (poId == null) continue;
                HashSet<Long> logisticsIds = (HashSet<Long>)statusMap.get(currentLogStatus);
                if (logisticsIds == null) {
                    logisticsIds = new HashSet<Long>();
                }
                logisticsIds.add(Long.parseLong(poId));
                statusMap.put(currentLogStatus, logisticsIds);
            }
        }
        for (Map.Entry entry : statusMap.entrySet()) {
            HashMap<String, Object> confirmMap = new HashMap<String, Object>(2);
            confirmMap.put("status", entry.getKey());
            confirmMap.put("ids", new ArrayList((Collection)entry.getValue()));
            CosmicParamArgs cosmicParamArgs = new CosmicParamArgs();
            cosmicParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
            cosmicParamArgs.setCloudId("scmc");
            cosmicParamArgs.setAppId("pm");
            cosmicParamArgs.setServiceName("PmSupColService");
            cosmicParamArgs.setMethodName("upLogisticsStatus");
            cosmicParamArgs.setParamMap(confirmMap);
            cosmicParamArgs.setDynamicObjects(orderBills);
            this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)cosmicParamArgs, (String)entry.getKey());
        }
    }

    public void assembleXKHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        DynamicObject[] dynamicObjects = this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects();
        Set poBillIdSet = SaloutUtil.getPoBillIds((DynamicObject[])assembleHandleArgs.getDynamicObjects());
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Map> dataMap = new HashMap<String, Map>();
        DynamicObject[] orderBills = OrderUtil.getOrdersByPoBillIdS((String)"billno,billstatus,logstatus,srctype,cfmstatus,materialentry.qty,materialentry.srcentryid,materialentry.srcbillid,materialentry.suminstockretqty,materialentry.sumrecretqty,materialentry.poentryid,materialentry.sumoutstockqty,materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.suminstockqty,materialentry.entrystatus,materialentry.pobillid,materialentry.rowlogstatus", (Set)poBillIdSet);
        Map poEntryId_qtyMap = SaloutUtil.getPoEntryIdQtyMap((DynamicObject[])dynamicObjects);
        Map pkValMap = OrderUtil.getPKValueStr((DynamicObject[])orderBills);
        dataMap.put("billid", pkValMap);
        dataMap.put("saloutqty", poEntryId_qtyMap);
        param.put("billtype", this.entityType);
        param.put("action", "unaudit");
        param.put("data", dataMap);
        XkParamArgs xkParamArgs = new XkParamArgs();
        xkParamArgs.setFacade("facade://com.kingdee.eas.scm.nsrm.app.BizDealFacade");
        xkParamArgs.setMethod("doSaloutStockUnAudit");
        xkParamArgs.setParamMap(param);
        xkParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        xkParamArgs.setDynamicObjects(orderBills);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)xkParamArgs);
    }

    public void assembleEASHandleArgs(AssembleHandleArgs assembleHandleArgs) {
        DynamicObject[] dynamicObjects = this.getScHandleParamProxy().getMajorDataParamArgs().getDynamicObjects();
        Set poBillIdSet = SaloutUtil.getPoBillIds((DynamicObject[])assembleHandleArgs.getDynamicObjects());
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, Map> dataMap = new HashMap<String, Map>();
        DynamicObject[] orderBills = OrderUtil.getOrdersByPoBillIdS((String)"billno,billstatus,logstatus,srctype,cfmstatus,materialentry.qty,materialentry.srcentryid,materialentry.srcbillid,materialentry.suminstockretqty,materialentry.sumrecretqty,materialentry.poentryid,materialentry.sumoutstockqty,materialentry.sumreceiptqty,materialentry.suminstockqty,materialentry.suminstockqty,materialentry.entrystatus,materialentry.pobillid,materialentry.rowlogstatus", (Set)poBillIdSet);
        Map poEntryId_qtyMap = SaloutUtil.getPoEntryIdQtyMap((DynamicObject[])dynamicObjects);
        Map pkValMap = OrderUtil.getPKValueStr((DynamicObject[])orderBills);
        dataMap.put("billid", pkValMap);
        dataMap.put("saloutqty", poEntryId_qtyMap);
        param.put("billtype", this.entityType);
        param.put("action", "unaudit");
        param.put("data", dataMap);
        EASParamArgs easParamArgs = new EASParamArgs();
        easParamArgs.setFacade("facade://com.kingdee.eas.scm.nsrm.app.BizDealFacade");
        easParamArgs.setMethod("doSaloutStockUnAudit");
        easParamArgs.setParamMap(param);
        easParamArgs.setDataServiceId(this.getScHandleParamProxy().getMajorDataParamArgs().getDataServiceId());
        easParamArgs.setDynamicObjects(orderBills);
        this.getScHandleParamProxy().putDataHandleArgs((ScDataHandleArgs)easParamArgs);
    }
}

