/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.report;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.systemjoint.SystemJointChannelHelper;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.scp.business.ScpJointChannelHelper;
import org.apache.commons.lang.StringUtils;

public class ScpConsumeReportPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit executechannel;
        super.registerListener(e);
        TextEdit invorg = (TextEdit)this.getView().getControl("orgfilter");
        TextEdit purorg = (TextEdit)this.getView().getControl("purorgfilter");
        if (Objects.nonNull(invorg)) {
            invorg.addButtonClickListener((ClickListener)this);
        }
        if (Objects.nonNull(purorg)) {
            purorg.addButtonClickListener((ClickListener)this);
        }
        if ((executechannel = (BasedataEdit)this.getView().getControl("executechannel")) != null) {
            executechannel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Date today = TimeServiceHelper.today();
        Calendar instance = Calendar.getInstance();
        instance.setTime(today);
        instance.add(2, -3);
        Date datefrom = instance.getTime();
        this.getModel().setValue("datefrom", (Object)datefrom);
        this.getModel().setValue("dateto", (Object)today);
        this.getModel().setValue("executechannel", (Object)SystemJointChannelHelper.getDefaultJointChannelId());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setJointChannelDataVisibleAndEnable();
    }

    private void setJointChannelDataVisibleAndEnable() {
        ArrayList<String> verifyEntityNumbers = new ArrayList<String>(16);
        verifyEntityNumbers.add("pur_order");
        verifyEntityNumbers.add("pur_instock");
        verifyEntityNumbers.add("pur_receipt");
        boolean isEnable = ScpJointChannelHelper.checkMultiJointSystem(verifyEntityNumbers);
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"executechannel"});
        this.getView().setVisible(Boolean.valueOf(isEnable), new String[]{"executechannel"});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("executechannel".equals(name)) {
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("jointchanneltype.jointsystemtype", "in", (Object)new String[]{"self", "xkcloud"}));
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String fieldKey = ((TextEdit)evt.getSource()).getFieldKey();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
        String orgfilter = (String)this.getModel().getValue(fieldKey);
        ArrayList selectedOrgs = new ArrayList();
        if (!orgfilter.isEmpty()) {
            String[] split = orgfilter.split(",");
            Collections.addAll(selectedOrgs, split);
        }
        if (!selectedOrgs.isEmpty()) {
            paramMap.put("selectdOrgs", selectedOrgs);
        }
        this.fillParamMap(paramMap, fieldKey);
        switch (fieldKey) {
            case "orgfilter": {
                OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"scp_orgs", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "orgclose"));
                break;
            }
            case "purorgfilter": {
                OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"scp_orgs", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "purorgclose"));
                break;
            }
        }
    }

    private void fillParamMap(Map<String, Object> paramMap, String fieldKey) {
        switch (fieldKey) {
            case "orgfilter": {
                paramMap.put("orgType", "purorg");
                break;
            }
            case "purorgfilter": {
                paramMap.put("orgType", "invorg");
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if (!actionId.equals("orgclose") && !actionId.equals("purorgclose") || returnData == null) {
            return;
        }
        StringBuilder purorg = new StringBuilder();
        List orgNameList = (List)returnData.get("orgNameList");
        if (orgNameList != null) {
            for (String orgname : orgNameList) {
                if (StringUtils.isEmpty((String)purorg.toString())) {
                    purorg.append(orgname);
                    continue;
                }
                purorg.append(",").append(orgname);
            }
        }
        switch (actionId) {
            case "orgclose": {
                this.getModel().setValue("orgfilter", (Object)purorg);
                break;
            }
            case "purorgclose": {
                this.getModel().setValue("purorgfilter", (Object)purorg);
                break;
            }
        }
    }
}

