/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.report.delivery;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.scm.common.util.DateUtil;
import kd.scm.scp.report.delivery.ScpDeliveryRptParam;

public class ScpDeliveryColMapFunction
extends MapFunction {
    private static final long serialVersionUID = -4393833589892510565L;
    private RowMeta rowMeta;
    private ScpDeliveryRptParam param;
    private Map<String, Integer> idxs;
    private int delLastIndex = 0;

    public ScpDeliveryColMapFunction(ScpDeliveryRptParam param, RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.param = param;
        this.buildIdxs();
    }

    private void buildIdxs() {
        this.idxs = new HashMap<String, Integer>(1024);
        List<String> proClums = this.param.getProClums();
        this.idxs.put("promiseqty", this.rowMeta.getFieldIndex("promiseqty"));
        this.idxs.put("deliverydate", this.rowMeta.getFieldIndex("deliverydate"));
        this.idxs.put("promisedate", this.rowMeta.getFieldIndex("promisedate"));
        this.idxs.put("qty", this.rowMeta.getFieldIndex("qty"));
        this.idxs.put("promisestatus", this.rowMeta.getFieldIndex("promisestatus"));
        for (String field : proClums) {
            if (field.contains("~_0")) continue;
            this.idxs.put(field, this.rowMeta.getFieldIndex(field));
        }
        List<String> addClums = this.param.getDivClums();
        for (String field : addClums) {
            if (field.contains("~_")) {
                this.delLastIndex = this.rowMeta.getFieldIndex(field);
                continue;
            }
            this.idxs.put(field, this.rowMeta.getFieldIndex(field));
        }
    }

    public RowX map(RowX rowX) {
        this.handleInDataDay(rowX);
        return rowX;
    }

    private void handleInDataDay(RowX rowX) {
        Date deliverydate = rowX.getDate(this.idxs.get("deliverydate").intValue());
        Date promisedate = rowX.getDate(this.idxs.get("promisedate").intValue());
        if (null != deliverydate) {
            this.handleDelivertDate(rowX);
        }
        if (null != promisedate) {
            this.handleProDate(rowX);
        }
    }

    private void handleProDate(RowX rowX) {
        String promisestatus = rowX.getString(this.idxs.get("promisestatus").intValue());
        if (!"B".equals(promisestatus)) {
            return;
        }
        Date startdate = this.param.getStartdate();
        BigDecimal promiseqty = rowX.getBigDecimal(this.idxs.get("promiseqty").intValue());
        Date promisedate = rowX.getDate(this.idxs.get("promisedate").intValue());
        int prodiff = 0;
        int diffnumber = 0;
        int delIndex = -1;
        if (null != this.param.getGroup() && "4".equals(this.param.getDatetype())) {
            List<Map> group = this.getSortGroup();
            prodiff = ScpDeliveryColMapFunction.daysBetween(startdate, promisedate, ChronoUnit.DAYS);
            this.delLastIndex = (group.size() - 1) * 2 + 2;
            for (int i = 0; i < group.size(); ++i) {
                Map obj = group.get(i);
                int endDay = 0;
                endDay = null != obj.get("endDay") ? Integer.parseInt(String.valueOf(obj.get("endDay"))) : -1;
                int beginDay = Integer.parseInt(String.valueOf(obj.get("beginDay")));
                if ((prodiff < beginDay || prodiff > endDay) && (prodiff < beginDay || endDay != -1)) continue;
                delIndex = (i + 1) * 2;
            }
        } else {
            if ("1".equals(this.param.getDatetype())) {
                prodiff = ScpDeliveryColMapFunction.daysBetween(startdate, promisedate, ChronoUnit.DAYS);
                diffnumber = 15;
                this.delLastIndex = 32;
            }
            if ("2".equals(this.param.getDatetype())) {
                prodiff = ScpDeliveryColMapFunction.daysBetween(startdate, promisedate, ChronoUnit.WEEKS);
                diffnumber = 12;
                this.delLastIndex = 26;
            }
            if ("3".equals(this.param.getDatetype())) {
                prodiff = ScpDeliveryColMapFunction.daysBetween(startdate, promisedate, ChronoUnit.MONTHS);
                diffnumber = 3;
                this.delLastIndex = 8;
            }
            if (prodiff <= diffnumber) {
                delIndex = prodiff * 2 + 2;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("field");
        if (delIndex == -1) {
            stringBuilder.append(this.delLastIndex);
        } else {
            stringBuilder.append(delIndex);
        }
        int fieldIndex = this.rowMeta.getFieldIndex(stringBuilder.toString());
        rowX.set(fieldIndex, (Object)promiseqty);
    }

    private List<Map> getSortGroup() {
        List group = (List)SerializationUtils.fromJsonString((String)this.param.getGroup(), List.class);
        for (int i = 0; i < group.size() - 1; ++i) {
            for (int j = 0; j < group.size() - 1 - i; ++j) {
                int maxBeginDay;
                Map min = (Map)group.get(j);
                Map max = (Map)group.get(j + 1);
                int minBeginDay = Integer.parseInt(String.valueOf(min.get("beginDay")));
                if (minBeginDay <= (maxBeginDay = Integer.parseInt(String.valueOf(max.get("beginDay"))))) continue;
                Map temp = max;
                max = min;
                min = temp;
            }
        }
        return group;
    }

    private void handleDelivertDate(RowX rowX) {
        Date startdate = this.param.getStartdate();
        BigDecimal qty = rowX.getBigDecimal(this.idxs.get("qty").intValue());
        Date deliverydate = rowX.getDate(this.idxs.get("deliverydate").intValue());
        int divdiff = 0;
        int diffnumber = 0;
        int delIndex = -1;
        if (null != this.param.getGroup()) {
            List<Map> group = this.getSortGroup();
            divdiff = ScpDeliveryColMapFunction.daysBetween(startdate, deliverydate, ChronoUnit.DAYS);
            this.delLastIndex = (group.size() - 1) * 2 + 2;
            for (int i = 0; i < group.size(); ++i) {
                Map obj = group.get(i);
                int endDay = 0;
                endDay = null != obj.get("endDay") ? Integer.parseInt(String.valueOf(obj.get("endDay"))) : -1;
                int beginDay = Integer.parseInt(String.valueOf(obj.get("beginDay")));
                if ((divdiff < beginDay || divdiff > endDay) && (divdiff < beginDay || endDay != -1)) continue;
                delIndex = i * 2 + 1;
            }
        } else {
            if ("1".equals(this.param.getDatetype())) {
                divdiff = ScpDeliveryColMapFunction.daysBetween(startdate, deliverydate, ChronoUnit.DAYS);
                diffnumber = 15;
                this.delLastIndex = 31;
            }
            if ("2".equals(this.param.getDatetype())) {
                divdiff = ScpDeliveryColMapFunction.daysBetween(startdate, deliverydate, ChronoUnit.WEEKS);
                diffnumber = 12;
                this.delLastIndex = 25;
            }
            if ("3".equals(this.param.getDatetype())) {
                divdiff = ScpDeliveryColMapFunction.daysBetween(startdate, deliverydate, ChronoUnit.MONTHS);
                diffnumber = 3;
                this.delLastIndex = 7;
            }
            if (divdiff <= diffnumber) {
                delIndex = divdiff * 2 + 1;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("field");
        if (delIndex == -1) {
            stringBuilder.append(this.delLastIndex);
        } else {
            stringBuilder.append(delIndex);
        }
        int fieldIndex = this.rowMeta.getFieldIndex(stringBuilder.toString());
        rowX.set(fieldIndex, (Object)qty);
    }

    public static String getStringDate(Date currentTime, String dateType) {
        Date startDate;
        SimpleDateFormat month = new SimpleDateFormat("MM");
        SimpleDateFormat day = new SimpleDateFormat("dd");
        String monString = Integer.valueOf(month.format(currentTime)).toString();
        String dayString = Integer.valueOf(day.format(currentTime)).toString();
        String aftermon = "";
        String afterday = "";
        if ("2".equals(dateType)) {
            startDate = DateUtil.addDays((Date)DateUtil.addWeek((Date)currentTime, (int)1), (int)-1);
            aftermon = Integer.valueOf(month.format(currentTime)).toString();
            afterday = Integer.valueOf(day.format(currentTime)).toString();
        }
        if ("3".equals(dateType)) {
            startDate = DateUtil.addDays((Date)DateUtil.addYear((Date)currentTime, (int)1), (int)-1);
            aftermon = Integer.valueOf(month.format(currentTime)).toString();
            afterday = Integer.valueOf(day.format(currentTime)).toString();
        }
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(monString).append('.').append(dayString);
        if ("2".equals(dateType) || "3".equals(dateType)) {
            strBuilder.append('-');
            strBuilder.append(aftermon).append('.').append(afterday);
        }
        return strBuilder.toString();
    }

    public static int daysBetween(Date firstDate, Date secDate, ChronoUnit type) {
        LocalDate localDate1 = ScpDeliveryColMapFunction.date2localDate(firstDate);
        LocalDate localDate2 = ScpDeliveryColMapFunction.date2localDate(secDate);
        return localDate2.isAfter(localDate1) ? (int)localDate1.until(localDate2, type) : (int)localDate2.until(localDate1, type);
    }

    private static LocalDate date2localDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

