/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.report.delivery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.scp.report.delivery.AgeGroup;
import kd.scm.scp.report.delivery.ScpDeliveryRptParam;
import org.apache.commons.lang.StringUtils;

public class ScpDeliveryForm
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private volatile boolean changed;

    public void setMergeColums(List<String> columns) {
    }

    public void loadOtherEntryFilter(DynamicObject scheme) {
        super.loadOtherEntryFilter(scheme);
        this.changed = true;
        int[] ageSegment = this.buildAgeSegment(scheme);
        this.initAgeEntry(ageSegment);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initAgeEntry();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("combodate".equals(name)) {
            Object value = this.getModel().getValue(name);
            if ("4".equals(value)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"ageconf"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"ageconf"});
            }
        }
        if ("ageval".equals(name)) {
            this.initAgeEntry();
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        Date startdate = filter.getDate("startdate");
        if (startdate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d77\u59cb\u65e5\u671f\u3002", (String)"ScpDeliveryForm_0", (String)"scm-scp-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void initAgeEntry() {
        if (!this.changed) {
            this.changed = true;
            this.initAgeEntry(this.buildAgeSegment());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object value = this.getModel().getValue("combodate");
        if ("4".equals(value)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"ageconf"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ageconf"});
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if ("ageentry".equals(name)) {
            this.delterAgeEntryRow();
        }
    }

    private void delterAgeEntryRow() {
        this.initAgeEntry();
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        List orgIdList;
        ScpDeliveryRptParam param = new ScpDeliveryRptParam();
        FilterInfo filterInfo = queryParam.getFilter();
        if (null != filterInfo.getFilterItem("mulorg").getValue() && !StringUtils.isEmpty((String)filterInfo.getFilterItem("mulorg").getValue().toString())) {
            String mulorg = this.getPageCache().get("mulorg");
            orgIdList = (List)SerializationUtils.fromJsonString((String)mulorg, List.class);
            param.setOrgs(ScpDeliveryForm.getIdList(orgIdList));
        }
        if (null != filterInfo.getFilterItem("mulrecorg").getValue() && !StringUtils.isEmpty((String)filterInfo.getFilterItem("mulrecorg").getValue().toString())) {
            String mulrecorg = this.getPageCache().get("mulrecorg");
            orgIdList = (List)SerializationUtils.fromJsonString((String)mulrecorg, List.class);
            param.setMulrecorgs(ScpDeliveryForm.getIdList(orgIdList));
        }
        if (null != filterInfo.getFilterItem("materialname").getValue().toString() && !StringUtils.isEmpty((String)filterInfo.getFilterItem("materialname").getValue().toString())) {
            param.setMulmaterials(filterInfo.getFilterItem("materialname").getValue().toString());
        }
        param.setStartdate(filterInfo.getDate("startdate"));
        param.setBillstatus(filterInfo.getString("billstatus"));
        param.setEntrystatus(filterInfo.getString("entrystatus"));
        param.setDatetype(filterInfo.getString("combodate"));
        if ("4".equals(filterInfo.getString("combodate"))) {
            String groupStr = this.getPageCache().get("groups");
            param.setGroup(groupStr);
        }
        param.setBizPartnerId(RequestContext.get().getBizPartnerId());
        queryParam.getCustomParam().put("param", param);
    }

    public static List<Long> getIdList(Collection<DynamicObject> objs) {
        if (objs == null) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> pks = new ArrayList<Long>(objs.size());
        for (DynamicObject obj : objs) {
            pks.add(obj.getLong("id"));
        }
        return pks;
    }

    public static List<Long> getIdList(List<String> objs) {
        if (objs == null) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> pks = new ArrayList<Long>(objs.size());
        for (String id : objs) {
            pks.add(Long.parseLong(id));
        }
        return pks;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
        TextEdit mulorg = (TextEdit)this.getView().getControl("mulorg");
        TextEdit mulrecorg = (TextEdit)this.getView().getControl("mulrecorg");
        if (Objects.nonNull(mulorg)) {
            mulorg.addButtonClickListener((ClickListener)this);
        }
        if (Objects.nonNull(mulrecorg)) {
            mulrecorg.addButtonClickListener((ClickListener)this);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String fieldKey = ((TextEdit)evt.getSource()).getFieldKey();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
        String orgfilter = (String)this.getModel().getValue(fieldKey);
        ArrayList selectedOrgs = new ArrayList();
        if (!orgfilter.isEmpty()) {
            String[] split = orgfilter.split(",");
            Collections.addAll(selectedOrgs, split);
        }
        if (!selectedOrgs.isEmpty()) {
            paramMap.put("selectdOrgs", selectedOrgs);
        }
        this.fillParamMap(paramMap, fieldKey);
        switch (fieldKey) {
            case "mulorg": {
                OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"scp_orgs", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "mulorg"));
                break;
            }
            case "mulrecorg": {
                OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"scp_orgs", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "mulrecorg"));
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if (!actionId.equals("mulorg") && !actionId.equals("mulrecorg") || returnData == null) {
            return;
        }
        StringBuilder purorg = new StringBuilder();
        List orgNameList = (List)returnData.get("orgNameList");
        List orgidList = (List)returnData.get("orgidList");
        if (orgNameList != null) {
            for (String orgname : orgNameList) {
                if (StringUtils.isEmpty((String)purorg.toString())) {
                    purorg.append(orgname);
                    continue;
                }
                purorg.append(",").append(orgname);
            }
        }
        switch (actionId) {
            case "mulorg": {
                this.getModel().setValue("mulorg", (Object)purorg);
                this.getPageCache().put("mulorg", SerializationUtils.toJsonString((Object)orgidList));
                break;
            }
            case "mulrecorg": {
                this.getModel().setValue("mulrecorg", (Object)purorg);
                this.getPageCache().put("mulrecorg", SerializationUtils.toJsonString((Object)orgidList));
                break;
            }
        }
    }

    private void fillParamMap(Map<String, Object> paramMap, String fieldKey) {
        switch (fieldKey) {
            case "mulorg": {
                paramMap.put("orgType", "purorg");
                break;
            }
            case "mulrecorg": {
                paramMap.put("orgType", "invorg");
                break;
            }
        }
    }

    private List<Long> getHasPermissionOrg(String type) {
        ArrayList<Long> ids = new ArrayList<Long>(1024);
        List allPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)"pur_deliveryschedule", (String)type);
        Long tempId = null;
        for (int i = 0; i < allPermissionOrgs.size(); ++i) {
            tempId = Long.valueOf((String)((Map)allPermissionOrgs.get(i)).get("id"));
            ids.add(tempId);
        }
        return ids;
    }

    private void initAgeEntry(int[] ages) {
        IDataModel model = this.getModel();
        model.deleteEntryData("ageentry");
        int[] idxs = this.getModel().batchCreateNewEntryRow("ageentry", ages.length);
        ArrayList<AgeGroup> ageList = new ArrayList<AgeGroup>(2024);
        for (int i = 0; i < ages.length; ++i) {
            AgeGroup age = new AgeGroup();
            if (i == ages.length - 1) {
                model.setValue("agename", (Object)this.buildAgeLastName(ages[i]), idxs[i]);
                model.setValue("ageval", null, idxs[i]);
                age.setBeginDay(ages[i]);
            } else {
                model.setValue("agename", (Object)this.buildAgeName(ages[i], ages[i + 1]), idxs[i]);
                model.setValue("ageval", (Object)(ages[i + 1] - ages[i]), idxs[i]);
                age.setBeginDay(ages[i]);
                age.setEndDay(ages[i + 1] - 1);
            }
            ageList.add(age);
            this.getPageCache().put("groups", SerializationUtils.toJsonString(ageList));
            this.getView().setEnable(Boolean.FALSE, idxs[i], new String[]{"agename"});
        }
    }

    public String buildAgeName(int from, int to) {
        return ResManager.loadResFormat((String)"%1\u5230%2\u5929", (String)"AgeRptUtil_0", (String)"scmc-im-report", (Object[])new Object[]{from, to - 1});
    }

    public String buildAgeLastName(int from) {
        return ResManager.loadResFormat((String)"%1\u5929\u53ca\u4ee5\u4e0a", (String)"AgeRptUtil_1", (String)"scmc-im-report", (Object[])new Object[]{from});
    }

    private int[] buildAgeSegment() {
        return this.buildAgeSegment(this.getModel().getDataEntity(true));
    }

    private int[] buildAgeSegment(DynamicObject data) {
        DynamicObjectCollection ageSetting = data.getDynamicObjectCollection("ageentry");
        ArrayList<Integer> ages = new ArrayList<Integer>(ageSetting.size());
        ages.add(0);
        int age = 0;
        for (int i = 0; i < ageSetting.size(); ++i) {
            age = ((DynamicObject)ageSetting.get(i)).getInt("ageval");
            if (age <= 0) continue;
            ages.add(age);
        }
        if (ages.size() < 2) {
            return new int[]{0, 7};
        }
        int[] ageSegment = new int[ages.size()];
        for (int i = 0; i < ageSegment.length; ++i) {
            ageSegment[i] = i == 0 ? 0 : ageSegment[i - 1] + (Integer)ages.get(i);
        }
        return ageSegment;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }
}

