/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.report.delivery;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.datatype.DateType;
import kd.bos.algox.DataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.scm.scp.report.delivery.ScpDeliveryColMapFunction;
import kd.scm.scp.report.delivery.ScpDeliveryRptParam;

public class ScpDeliveryRptCols
implements IDataXTransform {
    private ReportDataCtx ctx;
    private ScpDeliveryRptParam rptParam;

    public ScpDeliveryRptCols(ScpDeliveryRptParam rptParam, ReportDataCtx ctx) {
        this.ctx = ctx;
        this.rptParam = rptParam;
        rptParam.setProClums(new ArrayList<String>());
        rptParam.setDivClums(new ArrayList<String>());
    }

    public DataSetX doTransform(DataSetX srcData) {
        Field[] fs = new Field[]{new Field("type", (DataType)DataType.StringType)};
        Object[] vals = new Object[]{"type"};
        srcData = srcData.addFields(fs, vals);
        srcData = this.fillAgeCols(srcData);
        srcData = srcData.map((MapFunction)new ScpDeliveryColMapFunction(this.rptParam, srcData.getRowMeta()));
        HashSet<String> sumQtyKey = new HashSet<String>(1024);
        sumQtyKey.addAll(this.rptParam.getDivClums());
        sumQtyKey.addAll(this.rptParam.getProClums());
        this.ctx.setSumQtyCols4Count(sumQtyKey);
        this.ctx.getShowKeyCols().add("type");
        return srcData;
    }

    private DataSetX fillAgeCols(DataSetX srcData) {
        Date startDate = this.rptParam.getStartdate();
        Field[] fs = null;
        Object[] vals = null;
        String dateType = this.rptParam.getDatetype();
        if (this.rptParam.getGroup() != null && "4".equals(dateType)) {
            List group = (List)SerializationUtils.fromJsonString((String)this.rptParam.getGroup(), List.class);
            fs = new Field[group.size() * 2];
            vals = new Object[group.size() * 2];
            this.setFields(fs, vals);
        } else {
            if ("1".equals(dateType)) {
                fs = new Field[32];
                vals = new Object[32];
                this.setFields(fs, vals);
            }
            if ("2".equals(dateType)) {
                fs = new Field[26];
                vals = new Object[26];
                this.setFields(fs, vals);
            }
            if ("3".equals(dateType)) {
                fs = new Field[8];
                vals = new Object[8];
                this.setFields(fs, vals);
            }
            if ("4".equals(dateType) && this.rptParam.getGroup() != null) {
                List group = (List)SerializationUtils.fromJsonString((String)this.rptParam.getGroup(), List.class);
                fs = new Field[group.size() * 2];
                vals = new Object[group.size() * 2];
                this.setFields(fs, vals);
            }
        }
        return srcData.addFields(fs, vals);
    }

    private void setFields(Field[] fs, Object[] vals) {
        StringBuilder strBuilder = new StringBuilder();
        for (int i = 0; i < fs.length; ++i) {
            strBuilder.setLength(0);
            String deliverStr = strBuilder.append("field").append(i + 1).toString();
            if ((i + 1) % 2 == 0) {
                this.rptParam.getProClums().add(deliverStr);
            } else {
                this.rptParam.getDivClums().add(deliverStr);
            }
            fs[i] = new Field(deliverStr, (DataType)DateType.BigDecimalType);
            vals[i] = BigDecimal.ZERO;
        }
    }
}

