/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.report.deliveryrate;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.scp.common.util.ScpBillOfBizPersonFilter;
import kd.scm.scp.report.common.ScpOrderBaseForm;
import kd.scm.scp.report.deliveryrate.ScpOrderDeliveryParam;

public class ScpOrderDeliveryForm
extends ScpOrderBaseForm
implements ItemClickListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getRptForm().register(this, "purbillno", "bdmaterial");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean flag = super.verifyQuery(queryParam);
        if (!flag) {
            return false;
        }
        FilterInfo filter = queryParam.getFilter();
        String entitytype = filter.getString("entitytype");
        if (StringUtils.isEmpty((CharSequence)entitytype)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u4f9d\u636e\u3002", (String)"ScpOrderDeliveryForm_0", (String)"scm-scp-report", (Object[])new Object[0]));
            return false;
        }
        ReportQueryParam param = this.getQueryParam();
        ScpOrderDeliveryParam orderParam = this.buildReportParms();
        if (!this.verifyMaterial(orderParam)) {
            return false;
        }
        if ("scp_receipt".equals(entitytype)) {
            orderParam.setReceiptFilter(ScpBillOfBizPersonFilter.receiptFilter());
        } else {
            orderParam.setInStockFilter(ScpBillOfBizPersonFilter.inStockFilter());
        }
        param.getCustomParam().put(ScpOrderDeliveryParam.class.getName(), orderParam);
        return true;
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        ReportList reportList = (ReportList)evt.getSource();
        int rowIndex = evt.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        IDataModel model = this.getModel();
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        paramMap.put("fromdate", DateUtil.date2str((Date)((Date)model.getValue("startdate")), (String)"yyyy-MM-dd"));
        paramMap.put("todate", DateUtil.date2str((Date)DateUtil.addYear((Date)((Date)model.getValue("enddate")), (int)1), (String)"yyyy-MM-dd"));
        switch (fieldName = evt.getFieldName()) {
            case "orderqty": {
                String billsattus = (String)model.getValue("billstatus");
                ArrayList<String> statusList = new ArrayList<String>(4);
                if (StringUtils.isEmpty((CharSequence)billsattus) || "A".equals(billsattus)) {
                    statusList.add("C");
                    statusList.add("D");
                    statusList.add("Z");
                    statusList.add("E");
                } else {
                    statusList.add(billsattus);
                }
                paramMap.put("billstatus", StringUtils.join((Object[])statusList.toArray(new String[statusList.size()]), (String)","));
                OpenFormUtil.openListPage((IFormView)this.getView(), (String)"scp_order", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter(rowData), null);
                break;
            }
            case "ontimeqty": {
                OpenFormUtil.openListPage((IFormView)this.getView(), (String)((String)this.getModel().getValue("entitytype")), (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter(rowData, false), null);
                break;
            }
            case "delayqty": {
                OpenFormUtil.openListPage((IFormView)this.getView(), (String)((String)this.getModel().getValue("entitytype")), (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter(rowData, true), null);
                break;
            }
        }
    }

    private ScpOrderDeliveryParam buildReportParms() {
        ScpOrderDeliveryParam param = new ScpOrderDeliveryParam();
        this.getRptForm().buildRptParam(param);
        param.setEntitytype((String)this.getModel().getValue("entitytype"));
        return param;
    }

    private QFilter getQFilter(DynamicObject rowData, boolean delayFlag) {
        QFilter qFilter = this.getHyperLinkQFilter(rowData);
        DynamicObjectCollection dynList = QueryServiceHelper.query((String)"scp_order", (String)"id,materialentry.poentryid poentryid,materialentry.entrydelidate entrydelidate", (QFilter[])qFilter.toArray());
        HashMap poentryIdMap = new HashMap(10);
        dynList.forEach(t -> poentryIdMap.put(t.getString("poentryid"), t));
        String billNumber = (String)this.getModel().getValue("entitytype");
        DynamicObjectCollection instockList = QueryServiceHelper.query((String)billNumber, (String)"id,billdate,materialentry.poentryid poentryid", (QFilter[])new QFilter("materialentry.poentryid", "in", poentryIdMap.keySet()).toArray());
        HashSet poentryIds = new HashSet(poentryIdMap.size());
        instockList.forEach(t -> {
            String poentryid = t.getString("poentryid");
            Date billdate = t.getDate("billdate");
            Date entrydelidate = ((DynamicObject)poentryIdMap.get(poentryid)).getDate("entrydelidate");
            if (billdate != null && entrydelidate != null) {
                billdate = DateUtil.string2date((String)DateUtil.date2str((Date)billdate, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                entrydelidate = DateUtil.string2date((String)DateUtil.date2str((Date)entrydelidate, (String)"yyyy-MM-dd"), (String)"yyyy-MM-dd");
                if (delayFlag) {
                    if (billdate.compareTo(entrydelidate) > 0) {
                        poentryIds.add(poentryid);
                    }
                } else if (billdate.compareTo(entrydelidate) <= 0) {
                    poentryIds.add(poentryid);
                }
            }
        });
        QFilter qFilters = new QFilter("materialentry.poentryid", "in", poentryIds);
        DynamicObject supplier = rowData.getDynamicObject("supplier");
        qFilters.and("supplier", "=", (Object)supplier.getLong("id"));
        Object material = rowData.get("material");
        if (material != null) {
            if (material instanceof DynamicObject) {
                Long materialId = ((DynamicObject)material).getLong("material");
                qFilters.and("materialentry.material", "=", (Object)materialId);
            } else if (material instanceof String) {
                Long materialId = Long.parseLong(material.toString());
                qFilters.and("materialentry.material", "=", (Object)materialId);
            }
        } else {
            qFilters.and("materialentry.material", "=", (Object)0L);
        }
        if ("scp_receipt".equals((String)this.getModel().getValue("entitytype"))) {
            qFilters.and(new QFilter("isreturn", "=", (Object)Boolean.FALSE));
        }
        this.log.info("\u91c7\u8d2d\u6536\u8d27/\u5165\u5e93\u8df3\u8f6c\u6761\u4ef6\uff1a" + qFilters);
        return qFilters;
    }

    private QFilter getQFilter(DynamicObject rowData) {
        return this.getHyperLinkQFilter(rowData);
    }

    private QFilter getHyperLinkQFilter(DynamicObject rowData) {
        String billstatus;
        DynamicObject org = rowData.getDynamicObject("org");
        DynamicObject supplier = rowData.getDynamicObject("supplier");
        QFilter qFilters = new QFilter("org", "=", (Object)org.getLong("id"));
        qFilters.and("supplier", "=", (Object)supplier.getLong("id"));
        Object material = rowData.get("material");
        if (material != null) {
            Long materialId;
            if (material instanceof DynamicObject) {
                materialId = ((DynamicObject)material).getLong("material");
                qFilters.and("materialentry.material", "=", (Object)materialId);
            } else if (material instanceof String) {
                materialId = Long.parseLong(material.toString());
                qFilters.and("materialentry.material", "=", (Object)materialId);
            }
        } else {
            qFilters.and("materialentry.material", "=", (Object)0L);
        }
        IDataModel model = this.getView().getModel();
        Date startDate = (Date)model.getValue("startDate");
        Date endDate = (Date)model.getValue("endDate");
        if (startDate != null) {
            qFilters.and(new QFilter("materialentry.entrydelidate", ">=", (Object)startDate));
        }
        if (endDate != null) {
            qFilters.and(new QFilter("materialentry.entrydelidate", "<=", (Object)DateUtil.formatEndDate((Date)endDate)));
        }
        if (StringUtils.isEmpty((CharSequence)(billstatus = (String)model.getValue("billstatus"))) || "A".equals(billstatus)) {
            ArrayList<String> statusList = new ArrayList<String>(4);
            statusList.add("C");
            statusList.add("D");
            statusList.add("Z");
            statusList.add("E");
            qFilters.and(new QFilter("billstatus", "in", statusList));
        } else {
            qFilters.and(new QFilter("billstatus", "=", (Object)billstatus));
        }
        this.log.info("\u91c7\u8d2d\u8ba2\u5355\u6761\u4ef6\uff1a" + qFilters);
        return qFilters;
    }
}

