/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.report.deliveryrate.trans;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.Input;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.scm.common.algox.SupplierDeliverQtyMapFunc;
import kd.scm.scp.report.util.RptParam;

public class ScpDeliverQtyTransform
implements IDataXTransform {
    private ReportDataCtx ctx;
    private RptParam reportParam;
    private static final String[] GROUP_COLS = new String[]{"org", "supplier", "material", "materialnametext", "materialmodel", "orderqty", "poentryid"};

    public ScpDeliverQtyTransform(ReportDataCtx ctx, RptParam reportParam) {
        this.ctx = ctx;
        this.reportParam = reportParam;
    }

    public DataSetX doTransform(DataSetX srcData) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(5);
        List<QFilter> bizPartnerFilter = this.reportParam.getBizPartnerFilter();
        if (bizPartnerFilter != null && !bizPartnerFilter.isEmpty()) {
            qFilters.addAll(bizPartnerFilter);
        }
        qFilters.add(new QFilter("org", "in", this.reportParam.getOrgs()));
        if ("scp_receipt".equals(this.reportParam.getEntitytype())) {
            qFilters.add(new QFilter("isreturn", "=", (Object)Boolean.FALSE));
            qFilters.addAll(this.reportParam.getReceiptFilter());
        } else {
            qFilters.addAll(this.reportParam.getInStockFilter());
        }
        String selectFields = "billdate,materialentry.poentryid poentryid_right,materialentry.basicqty basicqty";
        OrmInput input = new OrmInput("ScpDeliverQtyTransform", this.reportParam.getEntitytype(), selectFields, qFilters.toArray(new QFilter[qFilters.size()]));
        String joinRightField = "poentryid_right";
        DataSetX subData = this.ctx.getCurrentJob().fromInput((Input)input);
        srcData = srcData.leftJoin(subData).on("poentryid", joinRightField).removeFields(new String[]{joinRightField});
        srcData = srcData.groupBy(GROUP_COLS).reduceGroup((GroupReduceFunction)new SupplierDeliverQtyMapFunc(srcData.getRowMeta()));
        return srcData;
    }
}

