/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.report.execute;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scm.common.util.DateUtil;
import kd.scm.scp.report.execute.ScpOrderExecuteParam;
import kd.scm.scp.report.execute.trans.ScpOrderCheckQtyTransform;
import kd.scm.scp.report.execute.trans.ScpOrderSortTransform;

public class ScpOrderExecuteHandle
implements IReportDataHandle {
    private ScpOrderExecuteParam reportParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.reportParam = (ScpOrderExecuteParam)ctx.getParam(ScpOrderExecuteParam.class.getName());
        this.setPageFs(ctx);
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        for (SrcBlockConf blockConf : blockCollector) {
            Map colMap = blockConf.getRepoColSrcColMap();
            colMap.put("id", "id");
            colMap = blockConf.getRepoColFullSrcColMap();
            colMap.put("id", "id");
        }
    }

    private void setPageFs(ReportDataCtx ctx) {
        ArrayList<QFilter> pageFs = ctx.getPageFs();
        if (pageFs == null) {
            pageFs = new ArrayList<QFilter>();
            ctx.setPageFs(pageFs);
        }
        pageFs.addAll(this.getPageFilter());
    }

    private List<QFilter> getPageFilter() {
        String billsattus;
        List<Long> billids;
        Date endDate;
        String orgnames;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        List<QFilter> bizPartnerFilter = this.reportParam.getBizPartnerFilter();
        if (bizPartnerFilter != null && !bizPartnerFilter.isEmpty()) {
            qFilters.addAll(bizPartnerFilter);
        }
        if ((orgnames = this.reportParam.getOrgnames()) != null && !StringUtils.isEmpty((CharSequence)orgnames)) {
            String[] orglist = orgnames.split(",");
            qFilters.add(new QFilter("org.name", "in", (Object)orglist));
        } else {
            qFilters.add(new QFilter("org", "in", this.reportParam.getOrgs()));
        }
        Date startDate = this.reportParam.getStartdate();
        if (startDate != null) {
            qFilters.add(new QFilter("billdate", ">=", (Object)startDate));
        }
        if ((endDate = this.reportParam.getEnddate()) != null) {
            qFilters.add(new QFilter("billdate", "<=", (Object)DateUtil.formatEndDate((Date)endDate)));
        }
        if ((billids = this.reportParam.getBillIds()) != null && !billids.isEmpty()) {
            qFilters.add(new QFilter("id", "in", billids));
        }
        if (StringUtils.isEmpty((CharSequence)(billsattus = this.reportParam.getBillstatus())) || "A".equals(billsattus)) {
            ArrayList<String> statusList = new ArrayList<String>(4);
            statusList.add("C");
            statusList.add("D");
            statusList.add("Z");
            statusList.add("E");
            qFilters.add(new QFilter("billstatus", "in", statusList));
        } else {
            qFilters.add(new QFilter("billstatus", "=", (Object)billsattus));
        }
        Set<Long> materialIds = this.reportParam.getMaterialIds();
        if (materialIds != null && !materialIds.isEmpty()) {
            qFilters.add(new QFilter("material", "in", materialIds));
        }
        return qFilters;
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new ScpOrderCheckQtyTransform());
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new ScpOrderSortTransform());
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> columns, ReportDataCtx ctx) {
        for (AbstractReportColumn col : columns) {
            ReportColumn reportCol = (ReportColumn)col;
            String field = reportCol.getFieldKey();
            if ("billno".equals(field) || "sumoutstockqty".equals(field) || "sumreceiptqty".equals(field) || "suminstockqty".equals(field) || "sumrecretqty".equals(field) || "suminstockretqty".equals(field) || "payableqty".equals(field) || "invoiceqty".equals(field)) {
                reportCol.setHyperlink(true);
            }
            if (!"id".equals(field) && !"material".equals(field) && !"curr".equals(field)) continue;
            reportCol.setHide(true);
        }
        return columns;
    }
}

