/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.report.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.IReportListModel;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.scp.common.helper.ScpCoreListFilterHelper;
import kd.scm.scp.report.util.RptParam;
import kd.scm.scp.report.util.RptUtil;

public class RptForm {
    private IReportView view;
    private static final String PUR_ORG = "purorg";
    private static final String BD_SUPPLIER = "bdsupplier";
    private static final String PUR_BILLNO = "purbillno";
    private static final String BD_MATERIAL = "bdmaterial";
    public static final String PERMISSION_PUR_ORG = "hasPermissionPurOrg";
    public static final String ID = "id";

    public RptForm(IReportView view) {
        this.view = view;
    }

    public void register(BeforeF7SelectListener selectListener, String ... f7Name) {
        AbstractFormPlugin loaclForm = (AbstractFormPlugin)selectListener;
        FieldEdit f7 = null;
        int len = f7Name.length;
        for (int i = 0; i < len; ++i) {
            f7 = (FieldEdit)loaclForm.getControl(f7Name[i]);
            if (!(f7 instanceof BasedataEdit)) continue;
            BasedataEdit dataEdit = (BasedataEdit)f7;
            dataEdit.addBeforeF7SelectListener(selectListener);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        ReportList reportList = (ReportList)evt.getSource();
        int rowIndex = evt.getRowIndex();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        String billIdStr = rowData.getString(ID);
        String billno = rowData.getString("billno");
        if (billIdStr == null || StringUtils.isEmpty((CharSequence)billIdStr)) {
            return;
        }
        Object material = rowData.get("material");
        Long materialId = null;
        if (material != null) {
            if (material instanceof DynamicObject) {
                materialId = ((DynamicObject)material).getLong("material");
            } else if (material instanceof String) {
                materialId = Long.parseLong(material.toString());
            }
        }
        Long billid = Long.valueOf(billIdStr);
        String fieldName = evt.getFieldName();
        IDataModel model = this.view.getModel();
        HashMap<String, String> paramMap = new HashMap<String, String>(2);
        paramMap.put("fromdate", DateUtil.date2str((Date)((Date)model.getValue("startdate")), (String)"yyyy-MM-dd"));
        paramMap.put("todate", DateUtil.date2str((Date)DateUtil.addYear((Date)((Date)model.getValue("enddate")), (int)1), (String)"yyyy-MM-dd"));
        switch (fieldName) {
            case "billno": {
                OpenFormUtil.openBillPage((IFormView)this.view, (String)"scp_order", (Object)billid, (BillOperationStatus)BillOperationStatus.VIEW, (ShowType)ShowType.MainNewTabPage, null, null);
                break;
            }
            case "sumoutstockqty": {
                OpenFormUtil.openListPage((IFormView)this.view, (String)"scp_saloutstock", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter("materialentry.pobillno", billno, "materialentry.material", materialId), null);
                break;
            }
            case "sumreceiptqty": {
                OpenFormUtil.openListPage((IFormView)this.view, (String)"scp_receipt", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter("materialentry.pobillno", billno, "materialentry.material", materialId), null);
                break;
            }
            case "suminstockqty": {
                OpenFormUtil.openListPage((IFormView)this.view, (String)"scp_instock", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter("materialentry.pobillno", billno, "materialentry.material", materialId), null);
                break;
            }
            case "sumrecretqty": {
                OpenFormUtil.openListPage((IFormView)this.view, (String)"scp_return_receipt", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter("materialentry.pobillno", billno, "materialentry.material", materialId), null);
                break;
            }
            case "suminstockretqty": {
                OpenFormUtil.openListPage((IFormView)this.view, (String)"scp_return", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter("materialentry.pobillno", billno, "materialentry.material", materialId), null);
                break;
            }
            case "payableqty": {
                OpenFormUtil.openListPage((IFormView)this.view, (String)"scp_check", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter("entryentity1.pobillno1", billno, "entryentity1.material1", materialId), null);
                break;
            }
            case "invoiceqty": {
                OpenFormUtil.openListPage((IFormView)this.view, (String)"scp_invoice", (ShowType)ShowType.MainNewTabPage, paramMap, (QFilter)this.getQFilter("entryentity1.pobillno1", billno, "entryentity1.material1", materialId), null);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e, IDataModel model) {
        String fieldKey = e.getProperty().getName();
        List<Long> orgIds = this.getOrgIds();
        ListFilterParameter showParameter = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter();
        switch (fieldKey) {
            case "purorg": {
                showParameter.setFilter(new QFilter(ID, "in", this.getHasPermissionOrg()));
                break;
            }
            case "bdsupplier": 
            case "bdmaterial": {
                showParameter.getQFilters().add(new QFilter("createorg", "in", orgIds));
                break;
            }
            case "purbillno": {
                Date endDate;
                showParameter.getQFilters().add(new QFilter("org", "in", orgIds));
                showParameter.getQFilters().add(BizPartnerUtil.assembleQFilterBizPartner());
                Date startDate = (Date)model.getValue("startdate");
                if (startDate != null) {
                    showParameter.getQFilters().add(new QFilter("billdate", ">=", (Object)startDate));
                }
                if ((endDate = (Date)model.getValue("enddate")) == null) break;
                showParameter.getQFilters().add(new QFilter("billdate", "<=", (Object)DateUtil.formatEndDate((Date)endDate)));
                break;
            }
        }
    }

    public void initPage() {
        IDataModel model = this.view.getModel();
        Object startdate = model.getValue("startdate");
        Object enddate = model.getValue("enddate");
        if (startdate == null && enddate == null) {
            Date today = TimeServiceHelper.today();
            today = DateUtil.formatEndDate((Date)today);
            model.setValue("enddate", (Object)today);
            today = DateUtil.formatStartDate((Date)DateUtil.addMonth((Date)today, (int)-6));
            model.setValue("startdate", (Object)today);
        }
    }

    public List<Long> getOrgIds() {
        List purOrgIds = null;
        String idStr = this.view.getPageCache().get(PUR_ORG);
        purOrgIds = StringUtils.isEmpty((CharSequence)idStr) ? this.getHasPermissionOrg() : SerializationUtils.fromJsonStringToList((String)idStr, Long.class);
        return purOrgIds;
    }

    public List<Long> getBillIds() {
        return RptUtil.getBaseDataLongIds(this.view, PUR_BILLNO);
    }

    public List<Long> getHasPermissionOrg() {
        List purOrgIds = null;
        String idStr = this.view.getPageCache().get(PERMISSION_PUR_ORG);
        if (StringUtils.isEmpty((CharSequence)idStr)) {
            purOrgIds = OrgUtil.getUserHasAllPurPermissionOrgs();
            this.view.getPageCache().put(PERMISSION_PUR_ORG, SerializationUtils.toJsonString((Object)purOrgIds));
        } else {
            purOrgIds = SerializationUtils.fromJsonStringToList((String)idStr, Long.class);
        }
        return purOrgIds;
    }

    private QFilter getQFilter(String billnoKey, String billnoValue, String materialKey, Long materialId) {
        QFilter qFilter = new QFilter(billnoKey, "=", (Object)billnoValue);
        if (materialId != null) {
            qFilter.and(materialKey, "=", (Object)materialId);
        }
        qFilter.and("billstatus", "=", (Object)"C");
        return qFilter;
    }

    public void buildRptParam(RptParam reportParam) {
        reportParam.setOrgs(this.getHasPermissionOrg());
        IDataModel model = this.view.getModel();
        reportParam.setOrgnames((String)model.getValue(PUR_ORG));
        reportParam.setStartdate((Date)model.getValue("startDate"));
        reportParam.setEnddate((Date)model.getValue("endDate"));
        reportParam.setBillstatus((String)model.getValue("billstatus"));
        reportParam.setMaterial((String)model.getValue("material"));
        ArrayList<QFilter> bizPartnerFilter = new ArrayList<QFilter>(2);
        ScpCoreListFilterHelper.setFilter(bizPartnerFilter);
        reportParam.setBizPartnerFilter(bizPartnerFilter);
    }
}

