/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.mobile.inquiry;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.SupplierDataPermHelper;
import kd.scm.scp.common.utils.MetaUtils;
import kd.scm.scp.helper.PermissionHelper;

public class ScpInquiryMobEdit
extends AbstractMobFormPlugin {
    private static final Log LOG = LogFactory.getLog(ScpInquiryMobEdit.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.preOpenFormByLink(e);
    }

    private void preOpenFormByLink(PreOpenFormEventArgs e) {
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if (!(formShowParameter instanceof MobileBillShowParameter)) {
            return;
        }
        MobileBillShowParameter mobFormShowParameter = (MobileBillShowParameter)formShowParameter;
        Object pkId = mobFormShowParameter.getPkId();
        String formKey = mobFormShowParameter.getFormId();
        if (StringUtils.isEmpty((CharSequence)formKey)) {
            e.setCancel(true);
            String errMsg = ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355\u6807\u8bc6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScpInquiryMobEdit_3", (String)"scm-mobsp-form", (Object[])new Object[0]);
            e.setCancelMessage(errMsg);
            return;
        }
        if (pkId == null || "".equals(pkId.toString())) {
            e.setCancel(true);
            String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u4e0d\u5b58\u5728\u6216\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScpInquiryMobEdit_2", (String)"scm-mobsp-form", (Object[])new Object[0]);
            e.setCancelMessage(errMsg);
            return;
        }
        DynamicObject pcEntityDy = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"quo_inquiry");
        DynamicObject mainOrg = pcEntityDy.getDynamicObject("org");
        String billNo = pcEntityDy.getString("billno");
        if (mainOrg == null) {
            e.setCancel(true);
            String errMsg = MessageFormat.format(ResManager.loadKDString((String)"PC\u7aef\u5355\u636e\u201c{0}-{1}\u201d\u7684\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScpInquiryMobEdit_0", (String)"scm-mobsp-form", (Object[])new Object[0]), "quo_inquiry", billNo);
            e.setCancelMessage(errMsg);
            return;
        }
        String pcAppId = MetaUtils.getPcAppId("quo_inquiry");
        Long orgId = mainOrg.getLong("id");
        boolean hasViewPerm = PermissionHelper.checkPermission(orgId, pcAppId, "quo_inquiry", "47150e89000000ac");
        if (hasViewPerm) {
            Map resultMap = SupplierDataPermHelper.verifySupplierEntryDataPerm((String)"quo_inquiry", (Object)pkId);
            LOG.info("The result of kd.scm.common.util.SupplierDataPermHelper.verifySupplierEntryDataPerm is:{}", (Object)resultMap);
            Boolean isSucceed = (Boolean)resultMap.get("succed");
            if (!isSucceed.booleanValue()) {
                Object message = resultMap.get("message");
                e.setCancel(true);
                e.setCancelMessage(message.toString());
            }
        } else {
            LocaleString displayName = pcEntityDy.getDataEntityType().getDisplayName();
            String billName = displayName == null ? "" : displayName.getLocaleValue();
            String errMsg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u67e5\u8be2\u6743\u9650\uff0c \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ScpInquiryMobEdit_1", (String)"scm-mobsp-form", (Object[])new Object[0]), billName);
            e.setCancel(true);
            e.setCancelMessage(errMsg);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"up", "down"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(false), new String[]{"up", "downflex"});
        view.setVisible(Boolean.valueOf(true), new String[]{"down"});
    }

    public void click(EventObject e) {
        String opKey;
        super.click(e);
        IFormView view = this.getView();
        Control source = (Control)e.getSource();
        switch (opKey = source.getKey()) {
            case "up": {
                this.upOp(view);
                break;
            }
            case "down": {
                this.downOp(view);
                break;
            }
        }
    }

    private void downOp(IFormView view) {
        view.setVisible(Boolean.valueOf(false), new String[]{"down"});
        view.setVisible(Boolean.valueOf(true), new String[]{"up", "downflex"});
    }

    private void upOp(IFormView view) {
        view.setVisible(Boolean.valueOf(false), new String[]{"up", "downflex"});
        view.setVisible(Boolean.valueOf(true), new String[]{"down"});
    }
}

