/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.mobile.inquiry;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.scm.scp.common.enums.SupplierStatusEnum;
import kd.scm.scp.helper.InquiryBizHelper;

public class ScpInquiryMobList
extends AbstractMobListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"quo", (String)"IQuoInquiryService", (String)"getInquiryTodoInfos", (Object[])new Object[0]);
        Set toQuoInquiryIds = (Set)resultMap.get("ids1");
        QFilter idQFilter = new QFilter("id", "in", (Object)toQuoInquiryIds);
        qFilters.add(idQFilter);
    }

    private static Set<Long> getInqMyStatusIds(DynamicObjectCollection rows) {
        HashSet<Long> ids = new HashSet<Long>();
        if (rows == null || rows.size() == 0) {
            return ids;
        }
        for (DynamicObject row : rows) {
            String bizStatus = row.getString("bizstatus");
            String supplierProStatus = row.getString("supplierprostatus");
            String supStatus = row.getString("supplierstatus");
            if (!StringUtils.equals((CharSequence)bizStatus, (CharSequence)"A") || !StringUtils.equals((CharSequence)supStatus, (CharSequence)SupplierStatusEnum.PENDING_QUOTE.getVal()) || !StringUtils.equals((CharSequence)supplierProStatus, (CharSequence)"A")) continue;
            ids.add(row.getLong("id"));
        }
        return ids;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        IFormView view = this.getView();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        if (opResult == null || !opResult.isSuccess()) {
            return;
        }
        DynamicObject inquiryBill = null;
        if (this.isQueryInquiry(operateKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            Object id = billList.getSelectedRows().get(0).getPrimaryKeyValue();
            inquiryBill = BusinessDataServiceHelper.loadSingle((Object)id, (String)"quo_inquiry");
        }
        if (inquiryBill == null) {
            return;
        }
        switch (operateKey) {
            case "quote": {
                Map<String, Object> checkMap = InquiryBizHelper.verifyQuote(inquiryBill);
                if ("false".equals(checkMap.get("succed"))) {
                    view.showErrorNotification(checkMap.get("message").toString());
                    return;
                }
                if (!"true".equals(checkMap.get("succed"))) break;
                this.doQuote(inquiryBill);
                break;
            }
            case "unquote": {
                this.doUnquote(inquiryBill);
                break;
            }
        }
    }

    private boolean isQueryInquiry(String operateKey) {
        return "quote".equals(operateKey) || "unquote".equals(operateKey);
    }

    private void doQuote(DynamicObject inquiryBill) {
        IFormView view = this.getView();
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        Map<String, Object> baseInfo = ScpInquiryMobList.getBaseInfo(inquiryBill);
        List<Long> quotationInfo = ScpInquiryMobList.getQuotersInfo(inquiryBill);
        List<Map<String, Object>> itemDetails = this.getMaterialEntriesInfo(inquiryBill);
        customParams.put("baseinfocustparams", baseInfo);
        customParams.put("quoterinfocustparams", quotationInfo);
        customParams.put("itemdetailscustparams", itemDetails);
        customParams.put("custom_material_entry_enable", this.getMaterialEntriesEnable(inquiryBill));
        showParameter.setCustomParams(customParams);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "quotetoolpagecbkey"));
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setFormId("scp_mobquotetool");
        view.showForm((FormShowParameter)showParameter);
    }

    private static Map<String, Object> getBaseInfo(DynamicObject inquiryBill) {
        HashMap<String, Object> baseInfo = new HashMap<String, Object>(16);
        String quoteTitle = inquiryBill.getString("quotetitle");
        String billNo = inquiryBill.getString("billno");
        DynamicObject org = inquiryBill.getDynamicObject("org");
        Long orgId = org == null ? 0L : org.getLong("id");
        Date billDate = inquiryBill.getDate("billdate");
        Date endDate = inquiryBill.getDate("enddate");
        String openType = inquiryBill.getString("opentype");
        boolean isTotalInquiry = inquiryBill.getBoolean("totalinquiry");
        DynamicObject person = inquiryBill.getDynamicObject("person");
        Long personId = person == null ? 0L : person.getLong("id");
        DynamicObject curr = inquiryBill.getDynamicObject("curr");
        Long currId = curr == null ? 0L : curr.getLong("id");
        String supscope = inquiryBill.getString("supscope");
        baseInfo.put("quotetitle", quoteTitle);
        baseInfo.put("billno", billNo);
        baseInfo.put("org", orgId);
        baseInfo.put("billdate", billDate);
        baseInfo.put("enddate", endDate);
        baseInfo.put("opentype", openType);
        baseInfo.put("totalinquiry", isTotalInquiry);
        baseInfo.put("person", personId);
        baseInfo.put("curr", currId);
        baseInfo.put("supscope", supscope);
        return baseInfo;
    }

    private static List<Long> getQuotersInfo(DynamicObject inquiryBill) {
        DynamicObjectCollection entryEntity = inquiryBill.getDynamicObjectCollection("entryentity");
        ArrayList<Long> quoters = new ArrayList<Long>(10);
        for (DynamicObject entry : entryEntity) {
            DynamicObject supplier = entry.getDynamicObject("supplier");
            if (supplier == null) continue;
            quoters.add(supplier.getLong("id"));
        }
        return quoters;
    }

    private List<Map<String, Object>> getMaterialEntriesInfo(DynamicObject inquiryBill) {
        DynamicObjectCollection materialEntry = inquiryBill.getDynamicObjectCollection("materialentry");
        ArrayList<Map<String, Object>> itemDetails = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject materialInfo : materialEntry) {
            DynamicObject material = materialInfo.getDynamicObject("material");
            if (material == null) continue;
            DynamicObject unit = materialInfo.getDynamicObject("unit");
            HashMap<String, Object> itemMap = new HashMap<String, Object>(16);
            Long entryId = materialInfo.getLong("id");
            String materialDesc = materialInfo.getString("materialdesc");
            DynamicObject baseUnit = materialInfo.getDynamicObject("basicunit");
            Long baseUnitId = baseUnit == null ? 0L : baseUnit.getLong("id");
            BigDecimal basicQty = materialInfo.getBigDecimal("basicqty");
            String goodsDesc = materialInfo.getString("goodsdesc");
            Date deliDate = materialInfo.getDate("entrydelidate");
            String deliAddr = materialInfo.getString("entrydeliaddr");
            itemMap.put("entryid", entryId);
            itemMap.put("material", material.getLong("id"));
            itemMap.put("materialdesc", materialDesc);
            itemMap.put("unit", unit.getLong("id"));
            itemMap.put("qty", materialInfo.getBigDecimal("qty"));
            itemMap.put("basicunit", baseUnitId);
            itemMap.put("basicqty", basicQty);
            itemMap.put("goodsdesc", goodsDesc);
            itemMap.put("entrydelidate", deliDate);
            itemMap.put("entrydeliaddr", deliAddr);
            itemDetails.add(itemMap);
        }
        return itemDetails;
    }

    private Map<String, Boolean> getMaterialEntriesEnable(DynamicObject inquiryBill) {
        DynamicObjectCollection materialEntries = inquiryBill.getDynamicObjectCollection("materialentry");
        String turns = inquiryBill.getString("turns");
        HashMap<String, Boolean> entryEnableMap = new HashMap<String, Boolean>(materialEntries.size());
        materialEntries.forEach(entry -> entryEnableMap.put(entry.getString("id"), Objects.equals(entry.getString("newestturns"), "") || turns.equals(entry.getString("newestturns"))));
        return entryEnableMap;
    }

    private void doUnquote(DynamicObject inquiryBill) {
        IFormView view = this.getView();
        Object pkValue = inquiryBill.getPkValue();
        Map checkMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"quo", (String)"IQuoInquiryService", (String)"verifyUnQuote", (Object[])new Object[]{pkValue});
        if ("false".equals(checkMap.get("succed"))) {
            view.showErrorNotification(checkMap.get("message").toString());
            return;
        }
        if ("true".equals(checkMap.get("succed"))) {
            this.getPageCache().put("confirmUnquote", String.valueOf(pkValue));
            view.showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u4ee3\u8868\u4e0d\u53c2\u4e0e\u9879\u76ee\uff0c\u5982\u5df2\u6709\u62a5\u4ef7\u5c06\u4f5c\u5e9f\uff0c\u8bf7\u8c28\u614e\u5904\u7406\u3002", (String)"ScpInquiryMobList_0", (String)"scm-scp-mobile", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmUnquote"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("confirmUnquote".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            Long pkValue = Long.valueOf(this.getPageCache().get("confirmUnquote"));
            this.confirmUnquote(pkValue);
        }
    }

    private void confirmUnquote(Long pkValue) {
        IFormView view = this.getView();
        boolean isConfirm = (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"quo", (String)"IQuoInquiryService", (String)"confirmUnquote", (Object[])new Object[]{pkValue});
        if (!isConfirm) {
            return;
        }
        view.showSuccessNotification(ResManager.loadKDString((String)"\u4e0d\u62a5\u4ef7\u6210\u529f\u3002", (String)"ScpInquiryMobList_1", (String)"scm-scp-mobile", (Object[])new Object[0]));
        view.invokeOperation("refresh");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "quotetoolpagecbkey": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }
}

