/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.mobile.inquiry;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.scp.common.pojo.PushBillResultInfo;
import kd.scm.scp.helper.QuoteBizHandleHelper;
import kd.scm.scp.helper.QuoteMaterialHelper;

public class ScpInquiryQuoToolEdit
extends AbstractMobBillPlugIn {
    public static final String CUSTOM_MATERIAL_ENTRY_ENABLE_CACHE = "custom_material_entry_enable_cache";
    private static final Log logger = LogFactory.getLog(ScpInquiryQuoToolEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"up", "down", "enter", "submit", "back"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        view.setVisible(Boolean.valueOf(true), new String[]{"down"});
        view.setVisible(Boolean.valueOf(false), new String[]{"up", "downflex"});
        this.initQuoteToolData(view);
    }

    private void initQuoteToolData(IFormView view) {
        Map customMaterialEntryEnable = (Map)this.getView().getFormShowParameter().getCustomParam("custom_material_entry_enable");
        this.getPageCache().put(CUSTOM_MATERIAL_ENTRY_ENABLE_CACHE, SerializationUtils.toJsonString((Object)customMaterialEntryEnable));
        try {
            IDataModel model = this.getModel();
            FormShowParameter formShowParameter = view.getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            Map baseInfo = (Map)customParams.get("baseinfocustparams");
            List itemDetails = (List)customParams.get("itemdetailscustparams");
            List quoters = (List)customParams.get("quoterinfocustparams");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            SimpleDateFormat billDateTmpFormat = new SimpleDateFormat("yyyy-MM-dd");
            String billNo = (String)baseInfo.get("billno");
            Object billDateImp = baseInfo.get("billdate");
            Object endDateImp = baseInfo.get("enddate");
            Long org = Long.valueOf(baseInfo.get("org").toString());
            String openType = (String)baseInfo.get("opentype");
            String quoteTitle = (String)baseInfo.get("quotetitle");
            Long person = Long.valueOf(baseInfo.get("person").toString());
            Boolean isTotalInquiry = (Boolean)baseInfo.get("totalinquiry");
            Long curr = Long.valueOf(baseInfo.get("curr").toString());
            Date billDate = billDateImp == null ? null : dateFormat.parse(billDateImp.toString());
            String billDateView = billDateImp == null ? "" : billDateTmpFormat.format(billDate);
            Date endDate = endDateImp == null || endDateImp.toString().equals("") ? null : dateFormat.parse(endDateImp.toString());
            String supscope = (String)baseInfo.get("supscope");
            model.setValue("org", (Object)org);
            model.setValue("billno", (Object)billNo);
            model.setValue("billdate", (Object)billDate);
            model.setValue("enddate", (Object)endDate);
            model.setValue("person", (Object)person);
            model.setValue("curr", (Object)curr);
            model.setValue("opentype", (Object)openType);
            model.setValue("quotetitle", (Object)quoteTitle);
            model.setValue("totalinquiry", (Object)isTotalInquiry);
            model.setValue("billdateview", (Object)billDateView);
            model.setValue("supscope", (Object)supscope);
            for (Long quoter : quoters) {
                int newIndex = model.createNewEntryRow("quoinfoentry");
                model.setValue("supplier", (Object)quoter, newIndex);
            }
            CardEntry cardEntry = (CardEntry)view.getControl("entryentity");
            for (int i = 0; i < itemDetails.size(); ++i) {
                Map item = (Map)itemDetails.get(i);
                int newIndex = model.createNewEntryRow("entryentity");
                Long entryId = Long.valueOf(item.get("entryid").toString());
                Long materialId = Long.valueOf(item.get("material").toString());
                Long unitId = Long.valueOf(item.get("unit").toString());
                BigDecimal qty = new BigDecimal(item.get("qty").toString());
                String materialDesc = (String)item.get("materialdesc");
                Long baseUnitId = Long.valueOf(item.get("basicunit").toString());
                BigDecimal baseQty = new BigDecimal(item.get("basicqty").toString());
                String goodsDesc = (String)item.get("goodsdesc");
                Object deliDateObj = item.get("entrydelidate");
                Date deliDate = deliDateObj == null || deliDateObj.toString().equals("") ? null : billDateTmpFormat.parse(deliDateObj.toString());
                String deliAddr = (String)item.get("entrydeliaddr");
                model.setValue("qty", (Object)qty, newIndex);
                model.setValue("entryid", (Object)entryId, newIndex);
                model.setValue("material", (Object)materialId, newIndex);
                model.setValue("unit", (Object)unitId, newIndex);
                model.setValue("materialdesc", (Object)materialDesc, newIndex);
                model.setValue("basicunit", (Object)baseUnitId, newIndex);
                model.setValue("basicqty", (Object)baseQty, newIndex);
                model.setValue("goodsdesc", (Object)goodsDesc, newIndex);
                model.setValue("entrydelidate", (Object)deliDate, newIndex);
                model.setValue("entrydeliaddr", (Object)deliAddr, newIndex);
                Map<String, Map<String, Object>> priceInfoMap = QuoteMaterialHelper.getPriceInfoMap(billNo, null);
                logger.info("\u83b7\u53d6\u4e0a\u4e00\u8f6e\u62a5\u4ef7\u7684\u4ef7\u683c\u4fe1\u606f\uff1a" + priceInfoMap.toString());
                Boolean isEnabled = (Boolean)customMaterialEntryEnable.get(entryId.toString());
                Object srcEntryId = item.get("entryid");
                if (!isEnabled.booleanValue() && srcEntryId != null) {
                    Map<String, Object> priceInfo = priceInfoMap.get(srcEntryId.toString());
                    model.setValue("taxrateid", priceInfo != null ? priceInfo.get("taxrateid") : null, newIndex);
                    model.setValue("taxprice", priceInfo != null ? priceInfo.get("taxprice") : null, newIndex);
                }
                this.setVisible(cardEntry, i, null, BigDecimal.ZERO, null);
                cardEntry.setChildVisible(false, i, new String[]{"errtipsentryflex"});
            }
        }
        catch (ParseException e) {
            logger.error(String.format("\u65e5\u671f\u89e3\u6790\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a%s\u3002", e.getMessage()));
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a{0}\u3002", (String)"ScpInquiryQuoToolEdit_0", (String)"scm-scp-mobile", (Object[])new Object[0]), e.getMessage()));
        }
    }

    public void click(EventObject e) {
        String opKey;
        super.click(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Control source = (Control)e.getSource();
        switch (opKey = source.getKey()) {
            case "up": {
                this.upOp(view);
                break;
            }
            case "down": {
                this.downOp(view);
                break;
            }
            case "enter": {
                this.enterOp();
                break;
            }
            case "submit": {
                CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
                if (!this.validateQuoteInfo(view, model, cardEntry, true)) {
                    return;
                }
                view.showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u63d0\u4ea4\u62a5\u4ef7\u7ed9\u7532\u65b9\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u63d0\u4ea4\uff1f", (String)"ScpInquiryQuoToolEdit_6", (String)"scm-scp-mobile", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmsubmitopcbkey"));
                break;
            }
            case "back": {
                view.showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u610f\u5473\u7740\u5c06\u653e\u5f03\u5f53\u524d\u9875\u5df2\u7ef4\u62a4\u7684\u6570\u636e\uff0c\u786e\u8ba4\u662f\u5426\u76f4\u63a5\u8fd4\u56de\u8be2\u4ef7\u5217\u8868\uff1f", (String)"ScpInquiryQuoToolEdit_5", (String)"scm-scp-mobile", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("confirmbackopcbkey"));
                break;
            }
        }
    }

    private void submitOp() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObjectCollection itemInfos = model.getEntryEntity("entryentity");
        DynamicObjectCollection quoInfos = model.getEntryEntity("quoinfoentry");
        String billNo = (String)model.getValue("billno");
        try (TXHandle tx = TX.requiresNew((String)"quo_quote");){
            PushBillResultInfo pushBillResult = QuoteBizHandleHelper.pushToQuoBill(model, billNo, itemInfos, quoInfos);
            String errorMsg = pushBillResult.getErrorMsg();
            if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                tx.markRollback();
                view.showTipNotification(errorMsg);
                return;
            }
            Map<String, Object> pushResultMap = pushBillResult.getPushResultMap();
            if (null != pushResultMap && !pushResultMap.isEmpty()) {
                Object result = pushResultMap.get(billNo);
                if (result == null) {
                    logger.info("\u751f\u6210\u62a5\u4ef7\u5355\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002\u9519\u8bef\u4e3a\uff1aunknown error");
                    tx.markRollback();
                    view.showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u62a5\u4ef7\u5355\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002\u9519\u8bef\u4e3a\uff1aunknown error", (String)"QuoteBizHandleHelper_2", (String)"scm-scp-mobile", (Object[])new Object[0]));
                    return;
                }
                if (!(result instanceof Long)) {
                    logger.info("\u751f\u6210\u62a5\u4ef7\u5355\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002\u9519\u8bef\u4e3a\uff1a" + result.toString());
                    tx.markRollback();
                    view.showTipNotification(String.format(ResManager.loadKDString((String)"\u751f\u6210\u62a5\u4ef7\u5355\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002\u9519\u8bef\u4e3a\uff1a%s", (String)"ScpInquiryQuoToolEdit_7", (String)"scm-scp-mobile", (Object[])new Object[0]), result.toString()));
                    return;
                }
                Long quoteBillId = (Long)result;
                this.calcQuoPriceInfo(pushBillResult, quoteBillId);
                List<Long> quoteBillIds = Collections.singletonList(quoteBillId);
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("mobopvartaxrate", "allowemptytaxrate");
                OperationResult submit = OperationServiceHelper.executeOperate((String)"submit", (String)"quo_quote", (Object[])quoteBillIds.toArray(), (OperateOption)operateOption);
                if (!submit.isSuccess()) {
                    tx.markRollback();
                    view.showOperationResult(submit, "");
                    return;
                }
                OperationResult audit = OperationServiceHelper.executeOperate((String)"audit", (String)"quo_quote", (Object[])quoteBillIds.toArray(), (OperateOption)operateOption);
                if (!audit.isSuccess()) {
                    tx.markRollback();
                    view.showOperationResult(audit, "");
                    return;
                }
                view.showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"ScpInquiryQuoToolEdit_1", (String)"scm-scp-mobile", (Object[])new Object[0]));
                view.close();
                return;
            }
            tx.markRollback();
            view.showTipNotification(ResManager.loadKDString((String)"\u751f\u6210\u62a5\u4ef7\u5355\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ScpInquiryQuoToolEdit_2", (String)"scm-scp-mobile", (Object[])new Object[0]));
        }
    }

    private Map<String, Boolean> getMaterialEntryEnable() {
        String customMaterialEntryEnableCache = this.getPageCache().get(CUSTOM_MATERIAL_ENTRY_ENABLE_CACHE);
        return (Map)SerializationUtils.fromJsonString((String)customMaterialEntryEnableCache, Map.class);
    }

    private void calcQuoPriceInfo(PushBillResultInfo pushBillResult, Long quoteBillId) {
        DynamicObject quoteBill = BusinessDataServiceHelper.loadSingle((Object)quoteBillId, (String)"sou_quote");
        DynamicObjectCollection materialEntry = quoteBill.getDynamicObjectCollection("materialentry");
        Map<Long, Map<String, Object>> priceMaps = pushBillResult.getPriceMaps();
        boolean isUpdate = false;
        for (DynamicObject materialInfo : materialEntry) {
            Map<String, Object> priceMap;
            Long inqryEId;
            String inqryEntryId = materialInfo.getString("srcentryid");
            if (StringUtils.isEmpty((CharSequence)inqryEntryId)) continue;
            try {
                inqryEId = Long.valueOf(inqryEntryId);
            }
            catch (NumberFormatException e) {
                inqryEId = 0L;
                logger.warn(e.getMessage());
            }
            if (inqryEId == null || inqryEId.equals(0L) || (priceMap = priceMaps.get(inqryEId)) == null) continue;
            BigDecimal price = (BigDecimal)priceMap.get("price");
            BigDecimal taxPrice = (BigDecimal)priceMap.get("taxprice");
            BigDecimal taxRate = (BigDecimal)priceMap.get("taxrate");
            Long taxRateId = (Long)priceMap.get("taxrateid");
            BigDecimal quoteQty = (BigDecimal)priceMap.get("qty");
            BigDecimal toPrice = materialInfo.getBigDecimal("price");
            BigDecimal toTaxPrice = materialInfo.getBigDecimal("taxprice");
            BigDecimal toTaxRate = materialInfo.getBigDecimal("taxrate");
            DynamicObject taxRateDy = materialInfo.getDynamicObject("taxrateid");
            Long toTaxRateId = taxRateDy == null ? 0L : taxRateDy.getLong("id");
            BigDecimal toQuoteQty = materialInfo.getBigDecimal("qty");
            if (price != null && BigDecimal.ZERO.compareTo(price) != 0 && (toPrice == null || toPrice.compareTo(price) != 0)) {
                materialInfo.set("price", (Object)price);
                isUpdate = true;
            }
            if (taxPrice != null && BigDecimal.ZERO.compareTo(taxPrice) != 0 && (toTaxPrice == null || toTaxPrice.compareTo(taxPrice) != 0)) {
                materialInfo.set("taxprice", (Object)taxPrice);
                isUpdate = true;
            }
            if (!(taxRateId == null || taxRateId.equals(0L) || toTaxRateId != null && toTaxRateId.equals(taxRateId))) {
                materialInfo.set("taxrateid", (Object)taxRateId);
                isUpdate = true;
            }
            if (taxRate != null && (toTaxRate == null || toTaxRate.compareTo(taxRate) != 0)) {
                materialInfo.set("taxrate", (Object)taxRate);
                isUpdate = true;
            }
            if (quoteQty == null || BigDecimal.ZERO.compareTo(quoteQty) == 0 || toQuoteQty != null && toQuoteQty.compareTo(quoteQty) == 0) continue;
            materialInfo.set("qty", (Object)quoteQty);
            isUpdate = true;
        }
        if (isUpdate) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{quoteBill});
        }
    }

    private boolean validateQuoteInfo(IFormView view, IDataModel model, CardEntry cardEntry, boolean isShowTipNotify) {
        DynamicObject[] itemDetails = cardEntry.getEntryData().getDataEntitys();
        ArrayList<Integer> notEmptyTaxAmts = new ArrayList<Integer>(10);
        for (DynamicObject item : itemDetails) {
            BigDecimal taxAmount = item.getBigDecimal("taxamount");
            if (taxAmount == null || taxAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            int index = item.getInt("seq") - 1;
            notEmptyTaxAmts.add(index);
        }
        int notEmptyTaxAmtSize = notEmptyTaxAmts.size();
        boolean isTotalInquiry = (Boolean)model.getValue("totalinquiry");
        if (isTotalInquiry) {
            return this.validateTotalInquiry(view, cardEntry, itemDetails, notEmptyTaxAmts, isShowTipNotify);
        }
        if (isShowTipNotify && notEmptyTaxAmtSize == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u5bf9\u4e00\u4e2a\u5546\u54c1\u8fdb\u884c\u6709\u6548\u62a5\u4ef7\u3002", (String)"ScpInquiryQuoToolEdit_3", (String)"scm-scp-mobile", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateTotalInquiry(IFormView view, CardEntry cardEntry, DynamicObject[] itemDetails, List<Integer> notEmptyTaxAmts, boolean isShowTipNotify) {
        for (DynamicObject item : itemDetails) {
            int index = item.getInt("seq") - 1;
            if (notEmptyTaxAmts.contains(index)) {
                cardEntry.setChildVisible(false, index, new String[]{"errtipsentryflex"});
                continue;
            }
            cardEntry.setChildVisible(true, index, new String[]{"errtipsentryflex"});
        }
        int entryRows = itemDetails.length;
        int notEmptyTaxAmtSize = notEmptyTaxAmts.size();
        if (isShowTipNotify && entryRows > notEmptyTaxAmtSize) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be2\u4ef7\u5355\u662f\u6574\u5355\u8be2\u4ef7\uff0c\u8bf7\u5bf9\u5168\u90e8\u5546\u54c1\u8fdb\u884c\u62a5\u4ef7\u3002", (String)"ScpInquiryQuoToolEdit_4", (String)"scm-scp-mobile", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void enterOp() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        DynamicObject curr = (DynamicObject)model.getValue("curr");
        Long currId = curr == null ? 0L : curr.getLong("id");
        int selectedIndex = model.getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection itemDetails = model.getEntryEntity("entryentity");
        DynamicObject org = (DynamicObject)model.getValue("org");
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        LinkedHashMap rowIndexToQuoteInfo = new LinkedHashMap(16);
        for (int i = 0; i < itemDetails.size(); ++i) {
            HashMap<String, Object> quoteInfo = new HashMap<String, Object>(16);
            DynamicObject item = (DynamicObject)itemDetails.get(i);
            Long entryId = item.getLong("entryid");
            BigDecimal qty = item.getBigDecimal("qty");
            DynamicObject unit = item.getDynamicObject("unit");
            DynamicObject taxRateDy = item.getDynamicObject("taxrateid");
            Long taxRateId = taxRateDy == null ? 0L : taxRateDy.getLong("id");
            BigDecimal taxRate = taxRateDy == null ? BigDecimal.ZERO : taxRateDy.getBigDecimal("taxrate");
            BigDecimal taxPrice = item.getBigDecimal("taxprice");
            DynamicObject material = item.getDynamicObject("material");
            Long unitId = unit == null ? 0L : unit.getLong("id");
            Long materialId = material == null ? 0L : material.getLong("id");
            Long orgId = org == null ? 0L : org.getLong("id");
            String materialDesc = item.getString("materialdesc");
            DynamicObject baseUnit = item.getDynamicObject("basicunit");
            Long baseUnitId = baseUnit == null ? 0L : baseUnit.getLong("id");
            BigDecimal basicQty = item.getBigDecimal("basicqty");
            String goodsDesc = item.getString("goodsdesc");
            Date deliDate = item.getDate("entrydelidate");
            String deliAddr = item.getString("entrydeliaddr");
            quoteInfo.put("materialdesc", materialDesc);
            quoteInfo.put("basicunit", baseUnitId);
            quoteInfo.put("basicqty", basicQty);
            quoteInfo.put("goodsdesc", goodsDesc);
            quoteInfo.put("entrydelidate", deliDate);
            quoteInfo.put("entrydeliaddr", deliAddr);
            quoteInfo.put("org", orgId);
            quoteInfo.put("entryid", entryId);
            quoteInfo.put("material", materialId);
            quoteInfo.put("unit", unitId);
            quoteInfo.put("qty", qty);
            quoteInfo.put("taxrateid", taxRateId);
            quoteInfo.put("taxrate", taxRate);
            quoteInfo.put("curr", currId);
            quoteInfo.put("taxprice", taxPrice);
            rowIndexToQuoteInfo.put(String.valueOf(i), quoteInfo);
        }
        customParams.put("currentryrowindex", selectedIndex);
        customParams.put("customparamsquoteinfo", rowIndexToQuoteInfo);
        customParams.put("custom_material_entry_enable", this.getMaterialEntryEnable());
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "enterquoteinputpageCB"));
        showParameter.setFormId("scp_mobquoteinput");
        view.showForm((FormShowParameter)showParameter);
    }

    private void downOp(IFormView view) {
        view.setVisible(Boolean.valueOf(false), new String[]{"down"});
        view.setVisible(Boolean.valueOf(true), new String[]{"up", "downflex"});
    }

    private void upOp(IFormView view) {
        view.setVisible(Boolean.valueOf(false), new String[]{"up", "downflex"});
        view.setVisible(Boolean.valueOf(true), new String[]{"down"});
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("confirmbackopcbkey".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.getView().close();
        } else if ("confirmsubmitopcbkey".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.submitOp();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        switch (actionId) {
            case "enterquoteinputpageCB": {
                Map entryIdToQuoteInfo = (Map)returnData;
                this.quoInputPageCloseBack(entryIdToQuoteInfo);
                break;
            }
        }
    }

    private void quoInputPageCloseBack(Map<Long, Map<String, Object>> entryIdToQuoteInfo) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        CardEntry cardEntry = (CardEntry)view.getControl("entryentity");
        DynamicObject[] itemDetails = cardEntry.getEntryData().getDataEntitys();
        BigDecimal sumTaxAmount = BigDecimal.ZERO;
        for (DynamicObject item : itemDetails) {
            int index = item.getInt("seq") - 1;
            Long entryId = item.getLong("entryid");
            Map<String, Object> quoteMap = entryIdToQuoteInfo.get(entryId);
            Object qtyObj = quoteMap.get("qty");
            Object taxRateObj = quoteMap.get("taxrate");
            Object taxPriceObj = quoteMap.get("taxprice");
            BigDecimal qty = this.castToBigDecimal(qtyObj);
            Long taxRateId = quoteMap.get("taxrateid") == null ? null : Long.valueOf(quoteMap.get("taxrateid").toString());
            BigDecimal taxRate = this.castToBigDecimal(taxRateObj);
            BigDecimal taxPrice = this.castToBigDecimal(taxPriceObj);
            BigDecimal taxAmount = qty != null && taxPrice != null ? qty.multiply(taxPrice) : BigDecimal.ZERO;
            sumTaxAmount = sumTaxAmount.add(taxAmount);
            this.updQuoteInfo(cardEntry, model, index, qty, taxRateId, taxPrice, taxAmount);
            this.setVisible(cardEntry, index, qty, taxRate, taxPrice);
        }
        model.setValue("sumtaxamount", (Object)sumTaxAmount);
        this.validateQuoteInfo(view, model, cardEntry, false);
    }

    private void updQuoteInfo(CardEntry cardEntry, IDataModel model, int index, BigDecimal qty, Long taxRateId, BigDecimal taxPrice, BigDecimal taxAmount) {
        model.setValue("qty", (Object)qty, index);
        model.setValue("taxrateid", (Object)taxRateId, index);
        model.setValue("taxprice", (Object)taxPrice, index);
        model.setValue("taxamount", (Object)taxAmount, index);
        HashMap keyToQty = new HashMap(16);
        HashMap keyToUnit = new HashMap(16);
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, String> unitMap = new HashMap<String, String>(16);
        DynamicObject unit = (DynamicObject)model.getValue("unit", index);
        String unitName = unit == null ? "" : unit.getString("name");
        qtyMap.put("text", qty);
        unitMap.put("text", unitName);
        keyToQty.put("qtylabel", qtyMap);
        keyToUnit.put("unitlabel", unitMap);
        cardEntry.setCustomProperties("qtylabel", index, keyToQty);
        cardEntry.setCustomProperties("unitlabel", index, keyToUnit);
    }

    private BigDecimal castToBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        BigDecimal fieldValue = BigDecimal.ZERO;
        fieldValue = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
        return fieldValue.compareTo(BigDecimal.ZERO) == 0 ? null : fieldValue;
    }

    private void setVisible(CardEntry cardEntry, int rowIndex, BigDecimal qty, BigDecimal taxRate, BigDecimal taxPrice) {
        if (taxRate == null || BigDecimal.ZERO.compareTo(taxRate) == 0) {
            cardEntry.setChildVisible(false, rowIndex, new String[]{"precent", "taxrate"});
        } else {
            cardEntry.setChildVisible(true, rowIndex, new String[]{"precent", "taxrate"});
        }
        if (qty == null || qty.compareTo(BigDecimal.ZERO) == 0) {
            cardEntry.setChildVisible(false, rowIndex, new String[]{"unitlabel"});
        } else {
            cardEntry.setChildVisible(true, rowIndex, new String[]{"unitlabel"});
        }
        if (this.isHideItemEntryRow(taxRate, taxPrice)) {
            cardEntry.setChildVisible(false, rowIndex, new String[]{"amtorqtycardentry", "taxamountcardentry"});
        } else {
            cardEntry.setChildVisible(true, rowIndex, new String[]{"amtorqtycardentry", "taxamountcardentry"});
        }
    }

    private boolean isHideItemEntryRow(BigDecimal taxRate, BigDecimal taxPrice) {
        boolean taxRateIsEmpty = taxRate == null || BigDecimal.ZERO.compareTo(taxRate) == 0;
        boolean taxPriceIsEmpty = taxPrice == null || BigDecimal.ZERO.compareTo(taxPrice) == 0;
        return taxRateIsEmpty && taxPriceIsEmpty;
    }
}

