/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.formplugin.mobile.quote;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Label;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.util.StringUtils;
import kd.scm.scp.common.enums.QuoteBizStatusEnum;
import kd.scm.scp.common.utils.BigDecimalUtils;
import kd.scm.scp.common.utils.MobileControlUtils;

public class ScpQuoteMobEdit
extends AbstractMobListPlugin {
    private static final Map<String, String> bizStatusMap = new HashMap<String, String>(16);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        this.initPriceInfo();
        String bizStatus = (String)model.getValue("bizstatus");
        this.setVisibleAndValue(bizStatus);
    }

    private void initPriceInfo() {
        IDataModel model = this.getModel();
        CardEntry cardEntry = (CardEntry)this.getControl("materialentry");
        DynamicObject curr = (DynamicObject)model.getValue("curr");
        String currSign = curr == null ? "" : curr.getString("sign");
        int rows = cardEntry.getEntryData().getDataEntitys().length;
        for (int i = 0; i < rows; ++i) {
            BigDecimal taxPrice = (BigDecimal)model.getValue("taxPrice", i);
            BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", i);
            if (taxPrice != null && BigDecimal.ZERO.compareTo(taxPrice) != 0) {
                MobileControlUtils.setCardEntryRowProperty(cardEntry, i, "text", currSign, "taxpricecsgn");
                MobileControlUtils.setCardEntryRowProperty(cardEntry, i, "text", BigDecimalUtils.getMicquartBigDecimal(taxPrice, false), "taxpricelabel2");
            }
            if (taxAmount == null || BigDecimal.ZERO.compareTo(taxAmount) == 0) continue;
            MobileControlUtils.setCardEntryRowProperty(cardEntry, i, "text", currSign, "taxamtcsgn");
        }
    }

    private void setVisibleAndValue(String bizStatus) {
        IFormView view = this.getView();
        Label bizStatusGreen = (Label)this.getControl("bizstatusgreen");
        Label bizStatusYellow = (Label)this.getControl("bizstatusyellow");
        if (StringUtils.isEmpty((String)bizStatus)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"bizstatusgreen", "bizstatusyellow"});
        } else if (QuoteBizStatusEnum.NOT_ACCEPTED.getVal().equals(bizStatus)) {
            bizStatusYellow.setText(bizStatusMap.get(bizStatus));
            view.setVisible(Boolean.valueOf(false), new String[]{"bizstatusgreen"});
            view.setVisible(Boolean.valueOf(true), new String[]{"bizstatusyellow"});
        } else {
            bizStatusGreen.setText(bizStatusMap.get(bizStatus));
            view.setVisible(Boolean.valueOf(false), new String[]{"bizstatusyellow"});
            view.setVisible(Boolean.valueOf(true), new String[]{"bizstatusgreen"});
        }
    }

    static {
        bizStatusMap.put(QuoteBizStatusEnum.QUOTED.getVal(), QuoteBizStatusEnum.QUOTED.getText());
        bizStatusMap.put(QuoteBizStatusEnum.OPENED.getVal(), QuoteBizStatusEnum.OPENED.getText());
        bizStatusMap.put(QuoteBizStatusEnum.ACCEPTED.getVal(), QuoteBizStatusEnum.ACCEPTED.getText());
        bizStatusMap.put(QuoteBizStatusEnum.PARTIAL_ADOPTION.getVal(), QuoteBizStatusEnum.PARTIAL_ADOPTION.getText());
        bizStatusMap.put(QuoteBizStatusEnum.NOT_ACCEPTED.getVal(), QuoteBizStatusEnum.NOT_ACCEPTED.getText());
    }
}

