/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.scm.common.ORMUtil;
import kd.scm.common.enums.LogisticsStatusEnum;
import kd.scm.common.util.ApiUtil;
import kd.scm.common.util.MessageUtil;

public class ScpBillAuditPlugin
extends AbstractOperationServicePlugIn {
    private static final String ENTRYENTITY = "materialentry";
    private static final String QTY = "qty";
    private static final String BASICQTY = "basicqty";
    private static final String POBILLID = "pobillid";
    private static final String POENTRYID = "poentryid";
    private static final String PERSON = "person";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add("materialentry.qty");
        filds.add("materialentry.basicqty");
        filds.add("materialentry.pobillid");
        filds.add("materialentry.poentryid");
        filds.add(PERSON);
        filds.add("supplier");
        filds.add("billno");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String key = e.getOperationKey();
        DynamicObject[] objs = e.getDataEntities();
        String entityType = null;
        if (objs.length == 0) {
            return;
        }
        entityType = objs[0].getDataEntityType().getName();
        HashMap<String, Object> param = new HashMap<String, Object>();
        if ("audit".equalsIgnoreCase(key)) {
            switch (entityType) {
                case "scp_saloutstock": {
                    HashMap<String, Set<String>> dataMap = new HashMap<String, Set<String>>();
                    DynamicObject[] orders = this.getOrders(objs);
                    Set<String> allReciptIdSet = this.getPkValueSet(orders, true);
                    Set<String> partialReciptIdSet = this.getPkValueSet(orders, false);
                    dataMap.put("billid", allReciptIdSet);
                    dataMap.put("allReceiptBillid", allReciptIdSet);
                    dataMap.put("partialReciptBillid", partialReciptIdSet);
                    param.put("billtype", entityType);
                    param.put("action", "audit");
                    param.put("data", dataMap);
                    ApiUtil.purSaloutAudit(param);
                    this.sendYzjMessage(objs, entityType);
                    break;
                }
            }
        }
    }

    private DynamicObject[] getOrders(DynamicObject[] objs) {
        HashSet<String> poBillIdSet = new HashSet<String>();
        for (DynamicObject dynamicObject : objs) {
            DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
            if (dynamicObjects.size() == 0) continue;
            for (DynamicObject dynamicObjectinner : dynamicObjects) {
                String poBillIdStr;
                Object poBillId = dynamicObjectinner.get(POBILLID);
                if (null == poBillId || (poBillIdStr = poBillId.toString()).length() <= 0) continue;
                poBillIdSet.add(poBillIdStr);
            }
        }
        HashMap filterMap = new HashMap(2);
        HashMap<String, HashSet<String>> idMap = new HashMap<String, HashSet<String>>(1);
        idMap.put("in", poBillIdSet);
        filterMap.put("materialentry.pobillid", idMap);
        return ORMUtil.load((String)"scp_order", (String)"billno,billstatus,logstatus,materialentry.pobillid,materialentry.entrystatus,materialentry.poentryid", filterMap);
    }

    private Set<String> getPkValueSet(DynamicObject[] dynamicObjects, boolean isAllrecipt) {
        HashSet<String> orderIdSet = new HashSet<String>();
        DynamicObjectCollection entrys = null;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String logStatus = dynamicObject.getString("logstatus");
            entrys = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
            String poBillId = ((DynamicObject)entrys.get(0)).getString(POBILLID).trim();
            if (LogisticsStatusEnum.ALLOUTSTOCK.getVal().equals(logStatus)) {
                if (!isAllrecipt) continue;
                orderIdSet.add(poBillId);
                continue;
            }
            if (isAllrecipt || !LogisticsStatusEnum.PARTOUTSTOCK.getVal().equals(logStatus)) continue;
            orderIdSet.add(poBillId);
        }
        return orderIdSet;
    }

    private void sendYzjMessage(DynamicObject[] saloutObjs, String entityType) {
        for (DynamicObject saloutObj : saloutObjs) {
            DynamicObject bizPerson;
            DynamicObject person = saloutObj.getDynamicObject(PERSON);
            if (null == person || null == (bizPerson = this.getPerson(person.getPkValue())) || null == bizPerson.get("userId")) continue;
            String message = MessageUtil.buildYzjMessage((DynamicObject)saloutObj, (String)entityType);
            MessageUtil.sendYzjMessage((String)message, (String)bizPerson.getString("userId"));
        }
    }

    private DynamicObject getPerson(Object personId) {
        HashMap filterMap = new HashMap(1);
        HashMap<String, Object> idMap = new HashMap<String, Object>(1);
        idMap.put("=", personId);
        filterMap.put("id", idMap);
        String selectFields = "id,user.id userId,user.name username";
        return ORMUtil.queryDynamicObjectByUnique((String)"pur_bizperson", (String)selectFields, filterMap);
    }
}

