/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.helper.multisystemjoint.ScMultiDataHandleServiceHelper;
import kd.scm.common.helper.scdatahandle.ScDataHandleResult;
import kd.scm.common.util.BussinessTypeUtils;
import kd.scm.scp.business.ScpOrderBillHelper;
import kd.scm.scp.business.ScpSalOutStockBillHelper;
import kd.scm.scp.business.ScpSalOutStockOffsetJointHelper;
import kd.scm.scp.opplugin.validator.ScpBillUnauditValidator;

public class ScpBillUnauditPlugin
extends AbstractOperationServicePlugIn {
    private static final String ENTRYENTITY = "materialentry";
    private static final String QTY = "qty";
    private static final String BASICQTY = "basicqty";
    private static final String POBILLID = "pobillid";
    private static final String POENTRYID = "poentryid";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List filds = e.getFieldKeys();
        filds.add(QTY);
        filds.add(BASICQTY);
        filds.add(POBILLID);
        filds.add(POENTRYID);
        filds.add("logstatus");
        filds.add("rowlogstatus");
        filds.add("autorecbillno");
        filds.add("billno");
        filds.add("businesstype");
        filds.add("dsentryid");
        filds.add("materialentry.material");
        filds.add("materialentry.unit");
        filds.add("materialentry.basicunit");
        filds.add("materialentry.linetype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new ScpBillUnauditValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        ScDataHandleResult scDataHandleResult = ScpSalOutStockOffsetJointHelper.executeUnAuditAutoDeleteBill((DynamicObject[])objs);
        if (!scDataHandleResult.isSuccess()) {
            e.setCancel(true);
            e.setCancelMessage(scDataHandleResult.getMessage());
        }
        for (DynamicObject bill : objs) {
            bill.set("logstatus", (Object)" ");
            DynamicObjectCollection dynamicObjectCollection = bill.getDynamicObjectCollection(ENTRYENTITY);
            for (DynamicObject row : dynamicObjectCollection) {
                row.set("rowlogstatus", (Object)" ");
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        Map poEntryBasicQtyMap = ScpSalOutStockBillHelper.getPoEntryIdBasicQtyMap((DynamicObject[])e.getDataEntities(), (BillStatusEnum)BillStatusEnum.AUDIT);
        ScpOrderBillHelper.updateSrcOrderData((Map)poEntryBasicQtyMap, (BillStatusEnum)BillStatusEnum.AUDIT);
        String consumeMoment = ScpSalOutStockBillHelper.getConsumeMoment();
        if ("saloutstock".equals(consumeMoment)) {
            ArrayList<DynamicObject> dys = new ArrayList<DynamicObject>(8);
            for (DynamicObject bill : e.getDataEntities()) {
                DynamicObject businesstype = bill.getDynamicObject("businesstype");
                if (!BussinessTypeUtils.checkIsCpOmBussinessType((DynamicObject)businesstype)) continue;
                dys.add(bill);
            }
            if (!CollectionUtils.isEmpty(dys)) {
                HashMap customParam = new HashMap(1);
                List dynamicObjects = ScpSalOutStockBillHelper.buildDynamicObjectData((DynamicObject[])dys.toArray(new DynamicObject[0]));
                ScMultiDataHandleServiceHelper.executeManualSceneHandle((String)"manualdeletemoduleconsume", (List)dynamicObjects, customParam);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        ScpSalOutStockOffsetJointHelper.executeSalOutUnAudit((DynamicObject[])objs);
    }
}

