/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.scp.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.scm.common.ORMUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.invoice.RelateInvoiceWriteBackUtil;

public class ScpInvoiceDeleteOp
extends AbstractOperationServicePlugIn {
    private static final String SALES_ENTRY = "materialentry";
    private static final String SALES_ENTRY_SUFFIX = "";
    private static final String INSTOCK_ENTRY = "entryentity1";
    private static final String INSTOCK_ENTRY_SUFFIX = "1";
    private static final String INVOICE_ENTRY = "entryentity2";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("checkbillno");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("cfmstatus");
        e.getFieldKeys().add("invoiceid");
        e.getFieldKeys().add("entryentity1.qty1");
        e.getFieldKeys().add("entryentity1.srcbilltype1");
        e.getFieldKeys().add("entryentity1.srcentryid1");
        e.getFieldKeys().add("entryentity1.srcbillid1");
        e.getFieldKeys().add("entryentity1.actchecktaxamount");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] invoiceObjects = e.getDataEntities();
        switch (operationKey) {
            case "delete": {
                DynamicObject[] checkcheckObjs;
                ArrayList<String> checkBillNoList = new ArrayList<String>();
                for (DynamicObject invoiceBillObject : invoiceObjects) {
                    String checkBillNo = invoiceBillObject.getString("checkbillno");
                    if (checkBillNoList.contains(checkBillNo)) continue;
                    checkBillNoList.add(checkBillNo);
                }
                for (DynamicObject checkBill : checkcheckObjs = this.getCheckBillByBillNo(checkBillNoList)) {
                    String checkBillNo = checkBill.getString("billno");
                    for (DynamicObject invoiceBill : invoiceObjects) {
                        String checkNo = invoiceBill.getString("checkbillno");
                        if (!checkBillNo.equals(checkNo)) continue;
                        String invoiceKey = invoiceBill.getString("invoiceid");
                        this.clearEntryInvoiceKey(checkBill, invoiceKey, SALES_ENTRY, SALES_ENTRY_SUFFIX);
                        this.clearEntryInvoiceKey(checkBill, invoiceKey, INSTOCK_ENTRY, INSTOCK_ENTRY_SUFFIX);
                        this.clearInvoiceEntry(checkBill, invoiceKey);
                    }
                }
                if (checkcheckObjs.length > 0) {
                    SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])checkcheckObjs);
                }
                RelateInvoiceWriteBackUtil.writeBackInvoiceAmtAndQty(Arrays.asList(invoiceObjects), (Boolean)RelateInvoiceWriteBackUtil.DEL_OP, (String)"from_invoice_op");
                break;
            }
        }
    }

    private DynamicObject[] getCheckBillByBillNo(List<String> billNoList) {
        HashMap params = new HashMap(2);
        HashMap<String, List<String>> idMap = new HashMap<String, List<String>>(1);
        idMap.put("in", billNoList);
        params.put("billno", idMap);
        String selectfields = DynamicObjectUtil.getSelectfields((String)"scp_check", (boolean)false);
        selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"scp_check", (String)SALES_ENTRY, (boolean)false);
        selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"scp_check", (String)INSTOCK_ENTRY, (boolean)false);
        selectfields = DynamicObjectUtil.getEntrySelectfields((String)selectfields, (String)"scp_check", (String)INVOICE_ENTRY, (boolean)false);
        return ORMUtil.load((String)"scp_check", (String)selectfields, params);
    }

    private void clearEntryInvoiceKey(DynamicObject checkObject, String invoiceKey, String entryKey, String suffix) {
        DynamicObjectCollection entrys = checkObject.getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : entrys) {
            String invoiceId = entry.getString("invoiceid" + suffix);
            if (!invoiceKey.equals(invoiceId)) continue;
            entry.set("invoiceid" + suffix, null);
        }
    }

    private void clearInvoiceEntry(DynamicObject checkObject, String invoiceKey) {
        DynamicObjectCollection invoiceEntrys = checkObject.getDynamicObjectCollection(INVOICE_ENTRY);
        int i = 0;
        for (DynamicObject invoiceEntry : invoiceEntrys) {
            String invoiceId = invoiceEntry.getString("invoiceid2");
            if (invoiceKey.equals(invoiceId)) {
                invoiceEntrys.remove(i);
                return;
            }
            ++i;
        }
    }
}

